/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.structure;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="ChildElementRequiredCheck")
public class ChildElementRequiredCheck
extends AbstractPageCheck {
    private static final String DEFAULT_CHILD = "";
    private static final String DEFAULT_PARENT = "";
    @RuleProperty(key="child", description="Name of the child element", defaultValue="")
    public String child = "";
    @RuleProperty(key="parent", description="Name of the parent element", defaultValue="")
    public String parent = "";

    @Override
    public void startElement(TagNode element) {
        if (element.equalsElementName(this.parent)) {
            boolean ruleOK = false;
            for (TagNode childNode : element.getChildren()) {
                if (!childNode.equalsElementName(this.child)) continue;
                ruleOK = true;
            }
            if (!ruleOK) {
                this.createViolation(element.getStartLinePosition(), "Add the missing \"" + this.child + "\" element to this \"" + this.parent + "\".");
            }
        }
    }
}

