/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.filesystem;

import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FileUtils;
import org.picocontainer.ComponentLifecycle;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.internal.DefaultTempFolder;
import org.sonar.server.platform.ServerFileSystem;

public class ComputationTempFolderProvider
extends ProviderAdapter
implements ComponentLifecycle<TempFolder> {
    private boolean started = false;
    @CheckForNull
    private DefaultTempFolder tempFolder;

    public TempFolder provide(ServerFileSystem fs) {
        if (this.tempFolder == null) {
            File tempDir = new File(fs.getTempDir(), "ce");
            try {
                FileUtils.forceMkdir((File)tempDir);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create computation temp directory " + tempDir, e);
            }
            File computationDir = new DefaultTempFolder(tempDir).newDir();
            this.tempFolder = new DefaultTempFolder(computationDir, true);
        }
        return this.tempFolder;
    }

    public void start(PicoContainer container) {
        this.started = true;
    }

    public void stop(PicoContainer container) {
        if (this.tempFolder != null) {
            this.tempFolder.stop();
        }
    }

    public void dispose(PicoContainer container) {
    }

    public boolean componentHasLifecycle() {
        return true;
    }

    public boolean isStarted() {
        return this.started;
    }
}

