/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.MergeAndTargetBranchComponentUuids;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesLoader;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.LazyInput;
import org.sonar.core.issue.tracking.LineHashSequence;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;

public class TrackerMergeOrTargetBranchInputFactory {
    private static final LineHashSequence EMPTY_LINE_HASH_SEQUENCE = new LineHashSequence(Collections.emptyList());
    private final ComponentIssuesLoader componentIssuesLoader;
    private final DbClient dbClient;
    private final MergeAndTargetBranchComponentUuids mergeAndTargetBranchComponentUuids;

    public TrackerMergeOrTargetBranchInputFactory(ComponentIssuesLoader componentIssuesLoader, MergeAndTargetBranchComponentUuids mergeAndTargetBranchComponentUuids, DbClient dbClient) {
        this.componentIssuesLoader = componentIssuesLoader;
        this.mergeAndTargetBranchComponentUuids = mergeAndTargetBranchComponentUuids;
        this.dbClient = dbClient;
    }

    public boolean hasMergeBranchAnalysis() {
        return this.mergeAndTargetBranchComponentUuids.hasMergeBranchAnalysis();
    }

    public boolean hasTargetBranchAnalysis() {
        return this.mergeAndTargetBranchComponentUuids.hasTargetBranchAnalysis();
    }

    public boolean areTargetAndMergeBranchesDifferent() {
        return this.mergeAndTargetBranchComponentUuids.areTargetAndMergeBranchesDifferent();
    }

    public Input<DefaultIssue> createForMergeBranch(Component component) {
        String mergeBranchComponentUuid = this.mergeAndTargetBranchComponentUuids.getMergeBranchComponentUuid(component.getDbKey());
        return new MergeOrTargetLazyInput(component.getType(), mergeBranchComponentUuid);
    }

    public Input<DefaultIssue> createForTargetBranch(Component component) {
        String targetBranchComponentUuid = this.mergeAndTargetBranchComponentUuids.getTargetBranchComponentUuid(component.getDbKey());
        return new MergeOrTargetLazyInput(component.getType(), targetBranchComponentUuid);
    }

    private class MergeOrTargetLazyInput
    extends LazyInput<DefaultIssue> {
        private final Component.Type type;
        private final String mergeOrTargetBranchComponentUuid;

        private MergeOrTargetLazyInput(@Nullable Component.Type type, String mergeOrTargetBranchComponentUuid) {
            this.type = type;
            this.mergeOrTargetBranchComponentUuid = mergeOrTargetBranchComponentUuid;
        }

        protected LineHashSequence loadLineHashSequence() {
            if (this.mergeOrTargetBranchComponentUuid == null || this.type != Component.Type.FILE) {
                return EMPTY_LINE_HASH_SEQUENCE;
            }
            try (DbSession session = TrackerMergeOrTargetBranchInputFactory.this.dbClient.openSession(false);){
                List hashes = TrackerMergeOrTargetBranchInputFactory.this.dbClient.fileSourceDao().selectLineHashes(session, this.mergeOrTargetBranchComponentUuid);
                if (hashes == null || hashes.isEmpty()) {
                    LineHashSequence lineHashSequence = EMPTY_LINE_HASH_SEQUENCE;
                    return lineHashSequence;
                }
                LineHashSequence lineHashSequence = new LineHashSequence(hashes);
                return lineHashSequence;
            }
        }

        protected List<DefaultIssue> loadIssues() {
            if (this.mergeOrTargetBranchComponentUuid == null) {
                return Collections.emptyList();
            }
            return TrackerMergeOrTargetBranchInputFactory.this.componentIssuesLoader.loadOpenIssuesWithChanges(this.mergeOrTargetBranchComponentUuid);
        }
    }
}

