/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue.commonrule;

import java.util.Optional;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.commonrule.CommonRule;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRulesHolder;

public class CommentDensityRule
extends CommonRule {
    private final MeasureRepository measureRepository;
    private final Metric commentDensityMetric;
    private final Metric commentLinesMetric;
    private final Metric nclocMetric;

    public CommentDensityRule(ActiveRulesHolder activeRulesHolder, MeasureRepository measureRepository, MetricRepository metricRepository) {
        super(activeRulesHolder, "InsufficientCommentDensity");
        this.measureRepository = measureRepository;
        this.commentDensityMetric = metricRepository.getByKey("comment_lines_density");
        this.commentLinesMetric = metricRepository.getByKey("comment_lines");
        this.nclocMetric = metricRepository.getByKey("ncloc");
    }

    @Override
    protected CommonRule.CommonRuleIssue doProcessFile(Component file, ActiveRule activeRule) {
        Optional<Measure> commentDensityMeasure = this.measureRepository.getRawMeasure(file, this.commentDensityMetric);
        Optional<Measure> commentLinesMeasure = this.measureRepository.getRawMeasure(file, this.commentLinesMetric);
        Optional<Measure> nclocMeasure = this.measureRepository.getRawMeasure(file, this.nclocMetric);
        if (!file.getFileAttributes().isUnitTest() && commentDensityMeasure.isPresent() && nclocMeasure.isPresent() && nclocMeasure.get().getIntValue() > 0) {
            double minCommentDensity = CommentDensityRule.getMinDensity(activeRule);
            if (commentDensityMeasure.get().getDoubleValue() < minCommentDensity) {
                return CommentDensityRule.generateIssue(commentDensityMeasure.get(), commentLinesMeasure, nclocMeasure.get(), minCommentDensity);
            }
        }
        return null;
    }

    private static double getMinDensity(ActiveRule activeRule) {
        double min = CommentDensityRule.getMinDensityParam(activeRule, "minimumCommentDensity");
        if (min >= 100.0) {
            throw new IllegalStateException("Minimum density of rule [" + activeRule.getRuleKey() + "] is incorrect. Got [100] but must be strictly less than 100.");
        }
        return min;
    }

    private static CommonRule.CommonRuleIssue generateIssue(Measure commentDensityMeasure, Optional<Measure> commentLinesMeasure, Measure nclocMeasure, double minCommentDensity) {
        int commentLines = commentLinesMeasure.map(Measure::getIntValue).orElse(0);
        int ncloc = nclocMeasure.getIntValue();
        int minExpectedCommentLines = (int)Math.ceil(minCommentDensity * (double)ncloc / (100.0 - minCommentDensity));
        int missingCommentLines = minExpectedCommentLines - commentLines;
        if (missingCommentLines <= 0) {
            throw new IllegalStateException(String.format("Bug in measures of comment lines - density=%s, comment_lines= %d, ncloc=%d, threshold=%s%%", commentDensityMeasure.getDoubleValue(), commentLines, nclocMeasure.getIntValue(), minCommentDensity));
        }
        String message = String.format("%d more comment lines need to be written to reach the minimum threshold of %s%% comment density.", missingCommentLines, minCommentDensity);
        return new CommonRule.CommonRuleIssue(missingCommentLines, message);
    }
}

