/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualitygate;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.sonar.ce.task.projectanalysis.analysis.Organization;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.qualitygate.Condition;
import org.sonar.ce.task.projectanalysis.qualitygate.QualityGate;
import org.sonar.ce.task.projectanalysis.qualitygate.QualityGateService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateDto;

public class QualityGateServiceImpl
implements QualityGateService {
    private final DbClient dbClient;
    private final MetricRepository metricRepository;

    public QualityGateServiceImpl(DbClient dbClient, MetricRepository metricRepository) {
        this.dbClient = dbClient;
        this.metricRepository = metricRepository;
    }

    @Override
    public Optional<QualityGate> findById(long id) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QualityGateDto qualityGateDto = this.dbClient.qualityGateDao().selectById(dbSession, id);
            if (qualityGateDto == null) {
                Optional<QualityGate> optional = Optional.empty();
                return optional;
            }
            Optional<QualityGate> optional = Optional.of(this.toQualityGate(dbSession, qualityGateDto));
            return optional;
        }
    }

    @Override
    public QualityGate findDefaultQualityGate(Organization organization) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QGateWithOrgDto qualityGateDto = this.dbClient.qualityGateDao().selectByOrganizationAndUuid(dbSession, organization.toDto(), organization.getDefaultQualityGateUuid());
            if (qualityGateDto == null) {
                throw new IllegalStateException("The default Quality gate is missing on organization " + organization.getKey());
            }
            QualityGate qualityGate = this.toQualityGate(dbSession, (QualityGateDto)qualityGateDto);
            return qualityGate;
        }
    }

    private QualityGate toQualityGate(DbSession dbSession, QualityGateDto qualityGateDto) {
        Collection dtos = this.dbClient.gateConditionDao().selectForQualityGate(dbSession, qualityGateDto.getId().longValue());
        Iterable conditions = (Iterable)dtos.stream().map(input -> this.metricRepository.getOptionalById(input.getMetricId()).map(metric -> new Condition((Metric)metric, input.getOperator(), input.getErrorThreshold())).orElse(null)).filter(Objects::nonNull).collect(MoreCollectors.toList((int)dtos.size()));
        return new QualityGate(qualityGateDto.getId(), qualityGateDto.getName(), conditions);
    }
}

