/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.sql.SQLException;
import org.sonar.ce.task.projectanalysis.dbmigration.ProjectAnalysisDataChange;
import org.sonar.ce.task.projectanalysis.dbmigration.ProjectAnalysisDataChanges;
import org.sonar.ce.task.step.ComputationStep;

public class DbMigrationsStep
implements ComputationStep {
    private final ProjectAnalysisDataChanges dataChanges;

    public DbMigrationsStep(ProjectAnalysisDataChanges dataChanges) {
        this.dataChanges = dataChanges;
    }

    public String getDescription() {
        return "Execute DB migrations for current project";
    }

    public void execute(ComputationStep.Context context) {
        this.dataChanges.getDataChanges().forEach(DbMigrationsStep::execute);
    }

    private static void execute(ProjectAnalysisDataChange dataChange) {
        try {
            dataChange.execute();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to perform DB migration for project", e);
        }
    }
}

