/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.ArrayList;
import org.sonar.ce.task.log.CeTaskMessages;
import org.sonar.ce.task.projectanalysis.batch.BatchReportReader;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.ScannerReport;

public class PersistAnalysisWarningsStep
implements ComputationStep {
    static final String DESCRIPTION = "Propagate analysis warnings from scanner report";
    private final BatchReportReader reportReader;
    private final CeTaskMessages ceTaskMessages;

    public PersistAnalysisWarningsStep(BatchReportReader reportReader, CeTaskMessages ceTaskMessages) {
        this.reportReader = reportReader;
        this.ceTaskMessages = ceTaskMessages;
    }

    public void execute(ComputationStep.Context context) {
        ArrayList warnings = new ArrayList();
        try (CloseableIterator<ScannerReport.AnalysisWarning> it = this.reportReader.readAnalysisWarnings();){
            it.forEachRemaining(w -> warnings.add(new CeTaskMessages.Message(w.getText(), w.getTimestamp())));
        }
        if (!warnings.isEmpty()) {
            this.ceTaskMessages.addAll(warnings);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

