/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sonar.api.utils.System2;
import org.sonar.ce.task.projectanalysis.issue.IssueCache;
import org.sonar.ce.task.projectanalysis.issue.RuleRepository;
import org.sonar.ce.task.projectanalysis.issue.UpdateConflictResolver;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.CloseableIterator;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueChangeMapper;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.issue.IssueMapper;
import org.sonar.server.issue.IssueStorage;

public class PersistIssuesStep
implements ComputationStep {
    private static final int ISSUE_BATCHING_SIZE = 500;
    private final DbClient dbClient;
    private final System2 system2;
    private final UpdateConflictResolver conflictResolver;
    private final RuleRepository ruleRepository;
    private final IssueCache issueCache;
    private final IssueStorage issueStorage;

    public PersistIssuesStep(DbClient dbClient, System2 system2, UpdateConflictResolver conflictResolver, RuleRepository ruleRepository, IssueCache issueCache, IssueStorage issueStorage) {
        this.dbClient = dbClient;
        this.system2 = system2;
        this.conflictResolver = conflictResolver;
        this.ruleRepository = ruleRepository;
        this.issueCache = issueCache;
        this.issueStorage = issueStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ComputationStep.Context context) {
        IssueStatistics statistics = new IssueStatistics();
        try (DbSession dbSession = this.dbClient.openSession(true);
             CloseableIterator issues = this.issueCache.traverse();){
            ArrayList<DefaultIssue> addedIssues = new ArrayList<DefaultIssue>(500);
            ArrayList<DefaultIssue> updatedIssues = new ArrayList<DefaultIssue>(500);
            IssueMapper mapper = (IssueMapper)dbSession.getMapper(IssueMapper.class);
            IssueChangeMapper changeMapper = (IssueChangeMapper)dbSession.getMapper(IssueChangeMapper.class);
            while (issues.hasNext()) {
                DefaultIssue issue = (DefaultIssue)issues.next();
                if (issue.isNew() || issue.isCopied()) {
                    addedIssues.add(issue);
                    if (addedIssues.size() < 500) continue;
                    this.persistNewIssues(statistics, addedIssues, mapper, changeMapper);
                    addedIssues.clear();
                    continue;
                }
                if (issue.isChanged()) {
                    updatedIssues.add(issue);
                    if (updatedIssues.size() < 500) continue;
                    this.persistUpdatedIssues(statistics, updatedIssues, mapper, changeMapper);
                    updatedIssues.clear();
                    continue;
                }
                statistics.untouched++;
            }
            this.persistNewIssues(statistics, addedIssues, mapper, changeMapper);
            this.persistUpdatedIssues(statistics, updatedIssues, mapper, changeMapper);
            PersistIssuesStep.flushSession(dbSession);
        }
        finally {
            statistics.dumpTo(context);
        }
    }

    private void persistNewIssues(IssueStatistics statistics, List<DefaultIssue> addedIssues, IssueMapper mapper, IssueChangeMapper changeMapper) {
        if (addedIssues.isEmpty()) {
            return;
        }
        long now = this.system2.now();
        addedIssues.forEach(i -> {
            int ruleId = this.ruleRepository.getByKey(i.ruleKey()).getId();
            IssueDto dto = IssueDto.toDtoForComputationInsert((DefaultIssue)i, (int)ruleId, (long)now);
            mapper.insert(dto);
            statistics.inserts++;
        });
        addedIssues.forEach(i -> this.issueStorage.insertChanges(changeMapper, i));
    }

    private void persistUpdatedIssues(IssueStatistics statistics, List<DefaultIssue> updatedIssues, IssueMapper mapper, IssueChangeMapper changeMapper) {
        if (updatedIssues.isEmpty()) {
            return;
        }
        long now = this.system2.now();
        updatedIssues.forEach(i -> {
            IssueDto dto = IssueDto.toDtoForUpdate((DefaultIssue)i, (long)now);
            mapper.updateIfBeforeSelectedDate(dto);
            statistics.updates++;
        });
        List updatedIssueKeys = (List)updatedIssues.stream().map(DefaultIssue::key).collect(MoreCollectors.toList((int)updatedIssues.size()));
        List conflictIssueKeys = mapper.selectByKeysIfNotUpdatedAt(updatedIssueKeys, now);
        if (!conflictIssueKeys.isEmpty()) {
            Map issuesByKeys = (Map)updatedIssues.stream().collect(MoreCollectors.uniqueIndex(DefaultIssue::key, (int)updatedIssues.size()));
            conflictIssueKeys.forEach(dbIssue -> {
                DefaultIssue updatedIssue = (DefaultIssue)issuesByKeys.get(dbIssue.getKey());
                this.conflictResolver.resolve(updatedIssue, (IssueDto)dbIssue, mapper);
                statistics.merged++;
            });
        }
        updatedIssues.forEach(i -> this.issueStorage.insertChanges(changeMapper, i));
    }

    private static void flushSession(DbSession dbSession) {
        dbSession.flushStatements();
        dbSession.commit();
    }

    public String getDescription() {
        return "Persist issues";
    }

    private static class IssueStatistics {
        private int inserts = 0;
        private int updates = 0;
        private int merged = 0;
        private int untouched = 0;

        private IssueStatistics() {
        }

        private void dumpTo(ComputationStep.Context context) {
            context.getStatistics().add("inserts", (Object)String.valueOf(this.inserts)).add("updates", (Object)String.valueOf(this.updates)).add("merged", (Object)String.valueOf(this.merged)).add("untouched", (Object)String.valueOf(this.untouched));
        }
    }
}

