/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S1994")
public class ForLoopConditionVariableCheck
extends Check {
    private static final String MESSAGE = "This loop's stop condition tests variable which is not incremented in update clause.";

    public ForLoopConditionVariableCheck() {
        super(UastNode.Kind.FOR);
    }

    @Override
    public void visitNode(UastNode node) {
        Optional<UastNode> optionalUpdateClause = node.getChild(UastNode.Kind.FOR_UPDATE);
        Optional<UastNode> optionalConditionClause = node.getChild(UastNode.Kind.CONDITION);
        if (optionalConditionClause.isPresent() && optionalUpdateClause.isPresent()) {
            Set<String> identifiersInCondition = ForLoopConditionVariableCheck.getIdentifierNames(optionalConditionClause.get());
            Set<String> identifiersInUpdate = ForLoopConditionVariableCheck.getIdentifierNames(optionalUpdateClause.get());
            HashSet<String> intersection = new HashSet<String>(identifiersInCondition);
            if (identifiersInCondition.isEmpty() || identifiersInCondition.size() > 2) {
                return;
            }
            intersection.retainAll(identifiersInUpdate);
            if (intersection.isEmpty()) {
                this.reportIssue(node.getChild(UastNode.Kind.KEYWORD).orElse(node), MESSAGE);
            }
        }
    }

    private static Set<String> getIdentifierNames(UastNode node) {
        HashSet<String> identifierNames = new HashSet<String>();
        node.getDescendants(UastNode.Kind.IDENTIFIER, identifier -> identifierNames.add(identifier.token.value));
        return identifierNames;
    }
}

