/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.EngineContext;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S100")
public class FunctionNameConventionCheck
extends Check {
    private static final String MESSAGE = "Rename '%s' to match the regular expression %s.";
    private static final String DEFAULT_FORMAT = "^[a-zA-Z0-9]+$";
    @RuleProperty(key="format", description="Regular expression used to check the function names against", defaultValue="^[a-zA-Z0-9]+$")
    public String format = "^[a-zA-Z0-9]+$";
    private Pattern namePattern;

    public FunctionNameConventionCheck() {
        super(UastNode.Kind.FUNCTION);
    }

    @Override
    public void initialize(EngineContext context) {
        super.initialize(context);
        this.namePattern = Pattern.compile(this.format);
    }

    @Override
    public void visitNode(UastNode node) {
        String functionName;
        if (node.is(UastNode.Kind.CONSTRUCTOR)) {
            return;
        }
        List<UastNode> nameNodes = node.getChildren(UastNode.Kind.FUNCTION_NAME);
        if (nameNodes.size() != 1) {
            return;
        }
        UastNode nameNode = nameNodes.get(0);
        UastNode.Token firstToken = nameNode.firstToken();
        if (nameNode.is(UastNode.Kind.IDENTIFIER) && firstToken != null && !this.namePattern.matcher(functionName = firstToken.value).matches()) {
            this.reportIssue(nameNode, String.format(MESSAGE, functionName, this.format));
        }
    }
}

