/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin.externalreport;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.go.plugin.externalreport.ExternalIssue;

public abstract class AbstractReportSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(AbstractReportSensor.class);
    static final long DEFAULT_REMEDIATION_COST = 5L;
    static final Severity DEFAULT_SEVERITY = Severity.MAJOR;
    static final String GENERIC_ISSUE_KEY = "issue";

    abstract String linterName();

    abstract String reportsPropertyName();

    @Nullable
    abstract ExternalIssue parse(String var1);

    public void execute(SensorContext context) {
        boolean externalIssuesSupported = context.getSonarQubeVersion().isGreaterThanOrEqual(Version.create((int)7, (int)2));
        String[] reportPaths = context.config().getStringArray(this.reportsPropertyName());
        if (reportPaths.length == 0) {
            return;
        }
        if (!externalIssuesSupported) {
            LOG.error(this.logPrefix() + "Import of external issues requires SonarQube 7.2 or greater.");
            return;
        }
        for (String reportPath : reportPaths) {
            File report = AbstractReportSensor.getIOFile(context.fileSystem().baseDir(), reportPath);
            this.importReport(context, report);
        }
    }

    protected String logPrefix() {
        return this.getClass().getSimpleName() + ": ";
    }

    private void importReport(SensorContext context, File report) {
        try {
            LOG.info(this.logPrefix() + "Importing {}", (Object)report.getPath());
            for (String line : Files.readAllLines(report.toPath(), StandardCharsets.UTF_8)) {
                ExternalIssue issue;
                if (line.isEmpty() || (issue = this.parse(line)) == null) continue;
                this.addLineIssue(context, issue);
            }
        }
        catch (IOException e) {
            LOG.error(this.logPrefix() + "No issues information will be saved as the report file '{}' can't be read.", (Object)report.getPath(), (Object)e);
        }
    }

    public void describe(SensorDescriptor sensorDescriptor) {
        sensorDescriptor.onlyOnLanguage("go").onlyWhenConfiguration(conf -> conf.hasKey(this.reportsPropertyName())).name("Import of " + this.linterName() + " issues");
    }

    static File getIOFile(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }

    InputFile getInputFile(SensorContext context, String filePath) {
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = context.fileSystem().inputFile(predicates.or(predicates.hasRelativePath(filePath), predicates.hasAbsolutePath(filePath)));
        if (inputFile == null) {
            LOG.warn(this.logPrefix() + "No input file found for {}. No {} issues will be imported on this file.", (Object)filePath, (Object)this.linterName());
            return null;
        }
        return inputFile;
    }

    void addLineIssue(SensorContext context, ExternalIssue issue) {
        InputFile inputFile = this.getInputFile(context, issue.filename);
        if (inputFile != null) {
            NewExternalIssue newExternalIssue = context.newExternalIssue();
            NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.message).on((InputComponent)inputFile).at(inputFile.selectLine(issue.lineNumber));
            newExternalIssue.at(primaryLocation).forRule(RuleKey.of((String)issue.linter, (String)issue.ruleKey)).type(issue.type).severity(DEFAULT_SEVERITY).remediationEffortMinutes(Long.valueOf(5L)).save();
        }
    }

    public static void createExternalRuleRepository(RulesDefinition.Context context, String linterId, String linterName) {
        RulesDefinition.NewRepository externalRepo = context.createExternalRepository(linterId, "go").setName(linterName);
        String pathToRulesMeta = "org/sonar/l10n/go/rules/" + linterId + "/rules.json";
        try (InputStreamReader inputStreamReader = new InputStreamReader(AbstractReportSensor.class.getClassLoader().getResourceAsStream(pathToRulesMeta), StandardCharsets.UTF_8);){
            ExternalRule[] rules;
            for (ExternalRule rule : rules = new Gson().fromJson((Reader)inputStreamReader, ExternalRule[].class)) {
                RulesDefinition.NewRule newRule = externalRepo.createRule(rule.key).setName(rule.name);
                newRule.setHtmlDescription(rule.description);
                newRule.setDebtRemediationFunction(newRule.debtRemediationFunctions().constantPerIssue("5min"));
                if (!linterId.equals("govet")) continue;
                newRule.setType(RuleType.BUG);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read resource: " + pathToRulesMeta, e);
        }
        externalRepo.done();
    }

    private static class ExternalRule {
        String key;
        String name;
        String description;

        private ExternalRule() {
        }
    }
}

