/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.AbstractGlobalProtobufFileProcessor;
import org.sonarsource.dotnet.shared.plugins.AbstractSolutionConfiguration;

public class GeneratedFileFilter
implements InputFileFilter {
    private static final Logger LOG = Loggers.get(GeneratedFileFilter.class);
    private final AbstractGlobalProtobufFileProcessor globalReportProcessor;
    private final boolean analyzeGeneratedCode;

    public GeneratedFileFilter(AbstractGlobalProtobufFileProcessor globalReportProcessor, AbstractSolutionConfiguration configuration) {
        this.globalReportProcessor = globalReportProcessor;
        this.analyzeGeneratedCode = configuration.analyzeGeneratedCode();
        if (this.analyzeGeneratedCode) {
            LOG.debug("Will analyze generated code");
        } else {
            LOG.debug("Will ignore generated code");
        }
    }

    public boolean accept(InputFile inputFile) {
        if (this.analyzeGeneratedCode) {
            return true;
        }
        boolean isGenerated = this.globalReportProcessor.getGeneratedFilePaths().contains(inputFile.path());
        if (isGenerated) {
            LOG.debug("Skipping auto generated file: {}", (Object)inputFile);
        }
        return !isGenerated;
    }
}

