/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.config;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public class Logback {
    private Logback() {
    }

    public static void configure(String classloaderPath, Map<String, String> substitutionVariables) {
        InputStream input = Logback.class.getResourceAsStream(classloaderPath);
        if (input == null) {
            throw new IllegalArgumentException("Logback configuration not found in classloader: " + classloaderPath);
        }
        Logback.configure(input, substitutionVariables);
    }

    public static void configure(File logbackFile, Map<String, String> substitutionVariables) {
        try {
            FileInputStream input = FileUtils.openInputStream(logbackFile);
            Logback.configure(input, substitutionVariables);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Fail to load the Logback configuration: " + logbackFile, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configure(InputStream input, Map<String, String> substitutionVariables) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(Logback.configureContext(lc, substitutionVariables));
            configurator.doConfigure(input);
        }
        catch (JoranException joranException) {
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings(lc);
    }

    private static LoggerContext configureContext(LoggerContext context, Map<String, String> substitutionVariables) {
        context.reset();
        for (Map.Entry<String, String> entry : substitutionVariables.entrySet()) {
            context.putProperty(entry.getKey(), entry.getValue());
        }
        return context;
    }
}

