/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import com.google.common.base.Joiner;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.repository.language.Language;
import org.sonar.scanner.repository.language.LanguagesRepository;

@ThreadSafe
public class LanguageDetection {
    private static final Logger LOG = LoggerFactory.getLogger(LanguageDetection.class);
    private final Map<String, PathPattern[]> patternsByLanguage;
    private final List<String> languagesToConsider;

    public LanguageDetection(Configuration settings, LanguagesRepository languages) {
        LinkedHashMap<String, PathPattern[]> patternsByLanguageBuilder = new LinkedHashMap<String, PathPattern[]>();
        for (Language language : languages.all()) {
            String[] filePatterns = settings.getStringArray(LanguageDetection.getFileLangPatternPropKey(language.key()));
            PathPattern[] pathPatterns = PathPattern.create(filePatterns);
            if (pathPatterns.length > 0) {
                patternsByLanguageBuilder.put(language.key(), pathPatterns);
                continue;
            }
            String[] patterns = language.fileSuffixes().toArray(new String[language.fileSuffixes().size()]);
            for (int i = 0; i < patterns.length; ++i) {
                String suffix = patterns[i];
                String extension = LanguageDetection.sanitizeExtension(suffix);
                patterns[i] = "**/*." + extension;
            }
            PathPattern[] defaultLanguagePatterns = PathPattern.create(patterns);
            patternsByLanguageBuilder.put(language.key(), defaultLanguagePatterns);
            LOG.debug("Declared extensions of language {} were converted to {}", (Object)language, (Object)LanguageDetection.getDetails(language.key(), defaultLanguagePatterns));
        }
        this.languagesToConsider = Collections.unmodifiableList(new ArrayList(patternsByLanguageBuilder.keySet()));
        this.patternsByLanguage = Collections.unmodifiableMap(patternsByLanguageBuilder);
    }

    @CheckForNull
    String language(Path absolutePath, Path relativePath) {
        String detectedLanguage = null;
        for (String languageKey : this.languagesToConsider) {
            if (!this.isCandidateForLanguage(absolutePath, relativePath, languageKey)) continue;
            if (detectedLanguage == null) {
                detectedLanguage = languageKey;
                continue;
            }
            throw MessageException.of(MessageFormat.format("Language of file ''{0}'' can not be decided as the file matches patterns of both {1} and {2}", relativePath, this.getDetails(detectedLanguage), this.getDetails(languageKey)));
        }
        return detectedLanguage;
    }

    private boolean isCandidateForLanguage(Path absolutePath, Path relativePath, String languageKey) {
        PathPattern[] patterns = this.patternsByLanguage.get(languageKey);
        if (patterns != null) {
            for (PathPattern pathPattern : patterns) {
                if (!pathPattern.match(absolutePath, relativePath, false)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getFileLangPatternPropKey(String languageKey) {
        return "sonar.lang.patterns." + languageKey;
    }

    private String getDetails(String detectedLanguage) {
        return LanguageDetection.getDetails(detectedLanguage, this.patternsByLanguage.get(detectedLanguage));
    }

    private static String getDetails(String detectedLanguage, PathPattern[] patterns) {
        return LanguageDetection.getFileLangPatternPropKey(detectedLanguage) + " : " + Joiner.on(",").join(patterns);
    }

    static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase(StringUtils.removeStart(suffix, "."));
    }
}

