/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.BlameLine;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.util.ProgressReport;

class DefaultBlameOutput
implements BlameCommand.BlameOutput {
    private static final Logger LOG = Loggers.get(DefaultBlameOutput.class);
    private final ScannerReportWriter writer;
    private final Set<InputFile> allFilesToBlame = new LinkedHashSet<InputFile>();
    private ProgressReport progressReport;
    private int count;
    private int total;

    DefaultBlameOutput(ScannerReportWriter writer, List<InputFile> filesToBlame) {
        this.writer = writer;
        this.allFilesToBlame.addAll(filesToBlame);
        this.count = 0;
        this.total = filesToBlame.size();
        this.progressReport = new ProgressReport("Report about progress of SCM blame", TimeUnit.SECONDS.toMillis(10L));
        this.progressReport.start(this.total + " files to be analyzed");
    }

    @Override
    public synchronized void blameResult(InputFile file, List<BlameLine> lines) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(lines);
        Preconditions.checkArgument(this.allFilesToBlame.contains(file), "It was not expected to blame file %s", file);
        if (lines.size() != file.lines()) {
            LOG.debug("Ignoring blame result since provider returned {} blame lines but file {} has {} lines", lines.size(), file, file.lines());
            return;
        }
        ScannerReport.Changesets.Builder scmBuilder = ScannerReport.Changesets.newBuilder();
        DefaultInputFile inputFile = (DefaultInputFile)file;
        scmBuilder.setComponentRef(inputFile.scannerId());
        HashMap<String, Integer> changesetsIdByRevision = new HashMap<String, Integer>();
        int lineId = 1;
        for (BlameLine line : lines) {
            DefaultBlameOutput.validateLine(line, lineId, file);
            Integer changesetId = (Integer)changesetsIdByRevision.get(line.revision());
            if (changesetId == null) {
                DefaultBlameOutput.addChangeset(scmBuilder, line);
                changesetId = scmBuilder.getChangesetCount() - 1;
                changesetsIdByRevision.put(line.revision(), changesetId);
            }
            scmBuilder.addChangesetIndexByLine(changesetId);
            ++lineId;
        }
        this.writer.writeComponentChangesets(scmBuilder.build());
        this.allFilesToBlame.remove(file);
        ++this.count;
        this.progressReport.message(this.count + "/" + this.total + " files analyzed");
    }

    private static void validateLine(BlameLine line, int lineId, InputFile file) {
        Preconditions.checkArgument(StringUtils.isNotBlank(line.revision()), "Blame revision is blank for file %s at line %s", file, lineId);
        Preconditions.checkArgument(line.date() != null, "Blame date is null for file %s at line %s", file, lineId);
    }

    private static void addChangeset(ScannerReport.Changesets.Builder scmBuilder, BlameLine line) {
        ScannerReport.Changesets.Changeset.Builder changesetBuilder = ScannerReport.Changesets.Changeset.newBuilder();
        changesetBuilder.setRevision(line.revision());
        changesetBuilder.setDate(line.date().getTime());
        if (StringUtils.isNotBlank(line.author())) {
            changesetBuilder.setAuthor(DefaultBlameOutput.normalizeString(line.author()));
        }
        scmBuilder.addChangeset(changesetBuilder.build());
    }

    private static String normalizeString(@Nullable String inputString) {
        if (inputString == null) {
            return "";
        }
        return inputString.toLowerCase(Locale.US);
    }

    public void finish(boolean success) {
        this.progressReport.stop(this.count + "/" + this.total + " files analyzed");
        if (success && !this.allFilesToBlame.isEmpty()) {
            LOG.warn("Missing blame information for the following files:");
            for (InputFile f : this.allFilesToBlame) {
                LOG.warn("  * " + f);
            }
            LOG.warn("This may lead to missing/broken features in SonarQube");
        }
    }
}

