/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.es.Index;

public abstract class IndexType {
    public static final String FIELD_INDEX_TYPE = "indexType";
    private static final String SEPARATOR = "/";
    private static final Splitter SEPARATOR_SPLITTER = Splitter.on((String)"/");

    public abstract IndexMainType getMainType();

    public abstract String format();

    public static SimpleIndexMainType parseMainType(String s) {
        List split = SEPARATOR_SPLITTER.splitToList((CharSequence)s);
        Preconditions.checkArgument((split.size() >= 2 ? 1 : 0) != 0, (String)"Unsupported IndexType value: %s", (Object[])new Object[]{s});
        return new SimpleIndexMainType((String)split.get(0), (String)split.get(1));
    }

    public static IndexMainType main(Index index, String type) {
        return new IndexMainType(index, type);
    }

    public static IndexRelationType relation(IndexMainType mainType, String name) {
        Preconditions.checkArgument((boolean)mainType.getIndex().acceptsRelations(), (Object)"Index must define a join field to have relations");
        return new IndexRelationType(mainType, name);
    }

    @Immutable
    public static final class IndexRelationType
    extends IndexType {
        private final IndexMainType mainType;
        private final String name;
        private final String key;

        private IndexRelationType(IndexMainType mainType, String name) {
            this.mainType = mainType;
            Preconditions.checkArgument((name != null && !name.isEmpty() ? 1 : 0) != 0, (Object)"type name can't be null nor empty");
            this.name = name;
            this.key = mainType.index.getName() + IndexType.SEPARATOR + mainType.type + IndexType.SEPARATOR + name;
        }

        @Override
        public IndexMainType getMainType() {
            return this.mainType;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String format() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexRelationType indexType = (IndexRelationType)o;
            return this.mainType.equals(indexType.mainType) && this.name.equals(indexType.name);
        }

        public int hashCode() {
            return Objects.hash(this.mainType, this.name);
        }

        public String toString() {
            return "[" + this.key + "]";
        }
    }

    @Immutable
    public static final class IndexMainType
    extends IndexType {
        private final Index index;
        private final String type;
        private final String key;

        private IndexMainType(Index index, String type) {
            this.index = Objects.requireNonNull(index);
            Preconditions.checkArgument((type != null && !type.isEmpty() ? 1 : 0) != 0, (Object)"type name can't be null nor empty");
            this.type = type;
            this.key = index.getName() + IndexType.SEPARATOR + type;
        }

        @Override
        public IndexMainType getMainType() {
            return this;
        }

        public Index getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public String format() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexMainType indexType = (IndexMainType)o;
            return this.index.equals(indexType.index) && this.type.equals(indexType.type);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.type);
        }

        public String toString() {
            return "[" + this.key + "]";
        }
    }

    @Immutable
    public static final class SimpleIndexMainType {
        private final String index;
        private final String type;

        private SimpleIndexMainType(String index, String type) {
            this.index = index;
            this.type = type;
        }

        public String getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleIndexMainType that = (SimpleIndexMainType)o;
            return this.index.equals(that.index) && this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.type);
        }

        public String toString() {
            return "[" + this.index + '/' + this.type + ']';
        }
    }
}

