/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.notifications.Notification;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.i18n.I18n;
import org.sonar.server.issue.notification.EmailMessage;
import org.sonar.server.issue.notification.EmailTemplate;
import org.sonar.server.issue.notification.NewIssuesStatistics;

public abstract class AbstractNewIssuesEmailTemplate
implements EmailTemplate {
    protected static final char NEW_LINE = '\n';
    protected static final String TAB = "    ";
    protected static final String DOT = ".";
    protected static final String COUNT = ".count";
    protected static final String LABEL = ".label";
    static final String FIELD_PROJECT_NAME = "projectName";
    static final String FIELD_PROJECT_KEY = "projectKey";
    static final String FIELD_PROJECT_DATE = "projectDate";
    static final String FIELD_PROJECT_VERSION = "projectVersion";
    static final String FIELD_ASSIGNEE = "assignee";
    static final String FIELD_BRANCH = "branch";
    static final String FIELD_PULL_REQUEST = "pullRequest";
    protected final EmailSettings settings;
    protected final I18n i18n;

    public AbstractNewIssuesEmailTemplate(EmailSettings settings, I18n i18n) {
        this.settings = settings;
        this.i18n = i18n;
    }

    public static String encode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding not supported", e);
        }
    }

    @Override
    @CheckForNull
    public EmailMessage format(Notification notification) {
        String version;
        if (this.shouldNotFormat(notification)) {
            return null;
        }
        String projectName = (String)Preconditions.checkNotNull((Object)notification.getFieldValue(FIELD_PROJECT_NAME));
        String branchName = notification.getFieldValue(FIELD_BRANCH);
        String pullRequest = notification.getFieldValue(FIELD_PULL_REQUEST);
        StringBuilder message = new StringBuilder();
        message.append("Project: ").append(projectName).append('\n');
        if (branchName != null) {
            message.append("Branch: ").append(branchName).append('\n');
        }
        if (pullRequest != null) {
            message.append("Pull request: ").append(pullRequest).append('\n');
        }
        if ((version = notification.getFieldValue(FIELD_PROJECT_VERSION)) != null) {
            message.append("Version: ").append(version).append('\n');
        }
        message.append('\n');
        this.appendRuleType(message, notification);
        this.appendAssignees(message, notification);
        this.appendRules(message, notification);
        this.appendTags(message, notification);
        this.appendComponents(message, notification);
        this.appendFooter(message, notification);
        return new EmailMessage().setMessageId(notification.getType() + "/" + notification.getFieldValue(FIELD_PROJECT_KEY)).setSubject(this.subject(notification, AbstractNewIssuesEmailTemplate.computeFullProjectName(projectName, branchName))).setPlainTextMessage(message.toString());
    }

    private static String computeFullProjectName(String projectName, @Nullable String branchName) {
        if (branchName == null || branchName.isEmpty()) {
            return projectName;
        }
        return String.format("%s (%s)", projectName, branchName);
    }

    protected abstract boolean shouldNotFormat(Notification var1);

    protected String subject(Notification notification, String fullProjectName) {
        int issueCount = Integer.parseInt(notification.getFieldValue((Object)((Object)NewIssuesStatistics.Metric.RULE_TYPE) + COUNT));
        return String.format("%s: %s new issue%s (new debt: %s)", fullProjectName, issueCount, issueCount > 1 ? "s" : "", notification.getFieldValue((Object)((Object)NewIssuesStatistics.Metric.EFFORT) + COUNT));
    }

    private static boolean doNotHaveValue(Notification notification, NewIssuesStatistics.Metric metric) {
        return notification.getFieldValue((Object)((Object)metric) + DOT + "1" + LABEL) == null;
    }

    private static void genericAppendOfMetric(NewIssuesStatistics.Metric metric, String label, StringBuilder message, Notification notification) {
        if (AbstractNewIssuesEmailTemplate.doNotHaveValue(notification, metric)) {
            return;
        }
        message.append(TAB).append(label).append('\n');
        for (int i = 1; notification.getFieldValue((Object)((Object)metric) + DOT + i + LABEL) != null && i <= 5; ++i) {
            String name = notification.getFieldValue((Object)((Object)metric) + DOT + i + LABEL);
            message.append(TAB).append(TAB).append(name).append(": ").append(notification.getFieldValue((Object)((Object)metric) + DOT + i + COUNT)).append('\n');
        }
        message.append('\n');
    }

    protected void appendAssignees(StringBuilder message, Notification notification) {
        AbstractNewIssuesEmailTemplate.genericAppendOfMetric(NewIssuesStatistics.Metric.ASSIGNEE, "Assignees", message, notification);
    }

    protected void appendComponents(StringBuilder message, Notification notification) {
        AbstractNewIssuesEmailTemplate.genericAppendOfMetric(NewIssuesStatistics.Metric.COMPONENT, "Most impacted files", message, notification);
    }

    protected void appendTags(StringBuilder message, Notification notification) {
        AbstractNewIssuesEmailTemplate.genericAppendOfMetric(NewIssuesStatistics.Metric.TAG, "Tags", message, notification);
    }

    protected void appendRules(StringBuilder message, Notification notification) {
        AbstractNewIssuesEmailTemplate.genericAppendOfMetric(NewIssuesStatistics.Metric.RULE, "Rules", message, notification);
    }

    protected void appendRuleType(StringBuilder message, Notification notification) {
        String count = notification.getFieldValue((Object)((Object)NewIssuesStatistics.Metric.RULE_TYPE) + COUNT);
        message.append(String.format("%s new issue%s (new debt: %s)", count, Integer.valueOf(count) > 1 ? "s" : "", notification.getFieldValue((Object)((Object)NewIssuesStatistics.Metric.EFFORT) + COUNT))).append('\n').append('\n').append(TAB).append("Type").append('\n').append(TAB).append(TAB);
        Iterator<RuleType> ruleTypeIterator = Arrays.asList(RuleType.BUG, RuleType.VULNERABILITY, RuleType.CODE_SMELL).iterator();
        while (ruleTypeIterator.hasNext()) {
            RuleType ruleType = ruleTypeIterator.next();
            String ruleTypeLabel = this.i18n.message(AbstractNewIssuesEmailTemplate.getLocale(), "issue.type." + ruleType, ruleType.name(), new Object[0]);
            message.append(ruleTypeLabel).append(": ").append(notification.getFieldValue((Object)((Object)NewIssuesStatistics.Metric.RULE_TYPE) + DOT + ruleType + COUNT));
            if (!ruleTypeIterator.hasNext()) continue;
            message.append(TAB);
        }
        message.append('\n').append('\n');
    }

    protected void appendFooter(StringBuilder message, Notification notification) {
        String projectKey = notification.getFieldValue(FIELD_PROJECT_KEY);
        String dateString = notification.getFieldValue(FIELD_PROJECT_DATE);
        if (projectKey != null && dateString != null) {
            String pullRequest;
            Date date = DateUtils.parseDateTime((String)dateString);
            String url = String.format("%s/project/issues?id=%s", this.settings.getServerBaseURL(), AbstractNewIssuesEmailTemplate.encode(projectKey));
            String branchName = notification.getFieldValue(FIELD_BRANCH);
            if (branchName != null) {
                url = url + "&branch=" + AbstractNewIssuesEmailTemplate.encode(branchName);
            }
            if ((pullRequest = notification.getFieldValue(FIELD_PULL_REQUEST)) != null) {
                url = url + "&pullRequest=" + AbstractNewIssuesEmailTemplate.encode(pullRequest);
            }
            url = url + "&createdAt=" + AbstractNewIssuesEmailTemplate.encode(DateUtils.formatDateTime((Date)date));
            message.append("More details at: ").append(url).append('\n');
        }
    }

    private static Locale getLocale() {
        return Locale.ENGLISH;
    }
}

