/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import java.io.IOException;
import java.util.Objects;
import org.sonar.application.AppLogging;
import org.sonar.application.AppReloader;
import org.sonar.application.AppState;
import org.sonar.application.FileSystem;
import org.sonar.application.config.AppSettings;
import org.sonar.application.config.AppSettingsLoader;
import org.sonar.application.config.ClusterSettings;
import org.sonar.process.MessageException;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;

public class AppReloaderImpl
implements AppReloader {
    private final AppSettingsLoader settingsLoader;
    private final FileSystem fileSystem;
    private final AppState appState;
    private final AppLogging logging;

    public AppReloaderImpl(AppSettingsLoader settingsLoader, FileSystem fileSystem, AppState appState, AppLogging logging) {
        this.settingsLoader = settingsLoader;
        this.fileSystem = fileSystem;
        this.appState = appState;
        this.logging = logging;
    }

    @Override
    public void reload(AppSettings settings) throws IOException {
        if (ClusterSettings.isClusterEnabled(settings)) {
            throw new IllegalStateException("Restart is not possible with cluster mode");
        }
        AppSettings reloaded = this.settingsLoader.load();
        AppReloaderImpl.ensureUnchangedConfiguration(settings.getProps(), reloaded.getProps());
        settings.reload(reloaded.getProps());
        this.fileSystem.reset();
        this.logging.configure();
        this.appState.reset();
    }

    private static void ensureUnchangedConfiguration(Props oldProps, Props newProps) {
        AppReloaderImpl.verifyUnchanged(oldProps, newProps, ProcessProperties.Property.PATH_DATA.getKey());
        AppReloaderImpl.verifyUnchanged(oldProps, newProps, ProcessProperties.Property.PATH_WEB.getKey());
        AppReloaderImpl.verifyUnchanged(oldProps, newProps, ProcessProperties.Property.PATH_LOGS.getKey());
        AppReloaderImpl.verifyUnchanged(oldProps, newProps, ProcessProperties.Property.PATH_TEMP.getKey());
        AppReloaderImpl.verifyUnchanged(oldProps, newProps, ProcessProperties.Property.CLUSTER_ENABLED.getKey());
    }

    private static void verifyUnchanged(Props initialProps, Props newProps, String propKey) {
        String newValue;
        String initialValue = initialProps.nonNullValue(propKey);
        if (!Objects.equals(initialValue, newValue = newProps.nonNullValue(propKey))) {
            throw new MessageException(String.format("Property [%s] cannot be changed on restart: [%s] => [%s]", propKey, initialValue, newValue));
        }
    }
}

