/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.cluster.health;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.cluster.health.DelegateHealthStateRefresherExecutorService;
import org.sonar.application.cluster.health.HealthStateSharing;
import org.sonar.process.cluster.health.HealthStateRefresher;
import org.sonar.process.cluster.health.HealthStateRefresherExecutorService;
import org.sonar.process.cluster.health.NodeHealthProvider;
import org.sonar.process.cluster.health.SharedHealthState;
import org.sonar.process.cluster.health.SharedHealthStateImpl;
import org.sonar.process.cluster.hz.HazelcastMember;

public class HealthStateSharingImpl
implements HealthStateSharing {
    private static final Logger LOG = LoggerFactory.getLogger(HealthStateSharingImpl.class);
    private final HazelcastMember hzMember;
    private final NodeHealthProvider nodeHealthProvider;
    private HealthStateRefresherExecutorService executorService;
    private HealthStateRefresher healthStateRefresher;

    public HealthStateSharingImpl(HazelcastMember hzMember, NodeHealthProvider nodeHealthProvider) {
        this.hzMember = hzMember;
        this.nodeHealthProvider = nodeHealthProvider;
    }

    @Override
    public void start() {
        this.executorService = new DelegateHealthStateRefresherExecutorService(Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(false).setNameFormat("health_state_refresh-%d").build()));
        this.healthStateRefresher = new HealthStateRefresher(this.executorService, this.nodeHealthProvider, (SharedHealthState)new SharedHealthStateImpl(this.hzMember));
        this.healthStateRefresher.start();
    }

    @Override
    public void stop() {
        this.healthStateRefresher.stop();
        HealthStateSharingImpl.stopExecutorService((ScheduledExecutorService)this.executorService);
    }

    private static void stopExecutorService(ScheduledExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOG.warn("Pool {} did not terminate", (Object)HealthStateSharingImpl.class.getSimpleName());
                }
            }
        }
        catch (InterruptedException ie) {
            LOG.warn("Termination of pool {} failed", (Object)HealthStateSharingImpl.class.getSimpleName(), (Object)ie);
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

