/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.api.utils.WildcardPattern;

public class WildcardPatternFileProvider {
    private static final String CURRENT_FOLDER = ".";
    private static final String PARENT_FOLDER = "..";
    private static final String RECURSIVE_PATTERN = "**";
    private static final String ZERO_OR_MORE_PATTERN = "*";
    private static final String ANY_PATTERN = "?";
    private final File baseDir;
    private final String directorySeparator;

    public WildcardPatternFileProvider(File baseDir, String directorySeparator) {
        this.baseDir = baseDir;
        this.directorySeparator = directorySeparator;
    }

    Set<File> listFiles(String pattern) {
        List<String> elements = Arrays.asList(pattern.split(Pattern.quote(this.directorySeparator)));
        List<String> elementsTillFirstWildcard = WildcardPatternFileProvider.elementsTillFirstWildcard(elements);
        String pathTillFirstWildcardElement = this.toPath(elementsTillFirstWildcard);
        File fileTillFirstWildcardElement = new File(pathTillFirstWildcardElement);
        File absoluteFileTillFirstWildcardElement = fileTillFirstWildcardElement.isAbsolute() ? fileTillFirstWildcardElement : new File(this.baseDir, pathTillFirstWildcardElement);
        List<String> wildcardElements = elements.subList(elementsTillFirstWildcard.size(), elements.size());
        if (wildcardElements.isEmpty()) {
            return absoluteFileTillFirstWildcardElement.exists() ? new HashSet<File>(Arrays.asList(absoluteFileTillFirstWildcardElement)) : Collections.emptySet();
        }
        WildcardPatternFileProvider.checkNoCurrentOrParentFolderAccess(wildcardElements);
        WildcardPattern wildcardPattern = WildcardPattern.create((String)this.toPath(wildcardElements), (String)this.directorySeparator);
        HashSet<File> result = new HashSet<File>();
        for (File file : WildcardPatternFileProvider.listFiles(absoluteFileTillFirstWildcardElement)) {
            String relativePath = WildcardPatternFileProvider.relativize(absoluteFileTillFirstWildcardElement, file);
            if (!wildcardPattern.match(relativePath)) continue;
            result.add(file);
        }
        return result;
    }

    private String toPath(List<String> elements) {
        return elements.stream().collect(Collectors.joining(this.directorySeparator));
    }

    private static List<String> elementsTillFirstWildcard(List<String> elements) {
        ArrayList<String> result = new ArrayList<String>();
        for (String element : elements) {
            if (WildcardPatternFileProvider.containsWildcard(element)) break;
            result.add(element);
        }
        return result;
    }

    private static void checkNoCurrentOrParentFolderAccess(List<String> elements) {
        for (String element : elements) {
            if (!WildcardPatternFileProvider.isCurrentOrParentFolder(element)) continue;
            throw new IllegalArgumentException("Cannot contain '.' or '..' after the first wildcard.");
        }
    }

    private static boolean containsWildcard(String element) {
        return RECURSIVE_PATTERN.equals(element) || element.contains(ZERO_OR_MORE_PATTERN) || element.contains(ANY_PATTERN);
    }

    private static boolean isCurrentOrParentFolder(String element) {
        return CURRENT_FOLDER.equals(element) || PARENT_FOLDER.equals(element);
    }

    private static Set<File> listFiles(File dir) {
        HashSet<File> result = new HashSet<File>();
        WildcardPatternFileProvider.listFiles(result, dir);
        return result;
    }

    private static void listFiles(Set<File> result, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            result.addAll(Arrays.asList(files));
            for (File file : files) {
                if (!file.isDirectory()) continue;
                WildcardPatternFileProvider.listFiles(result, file);
            }
        }
    }

    private static String relativize(File parent, File file) {
        return file.getAbsolutePath().substring(parent.getAbsolutePath().length() + 1);
    }
}

