/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.LoggerFactory;

abstract class AbstractStopperThread
extends Thread {
    private final Runnable stopCode;
    private final long terminationTimeoutMs;

    AbstractStopperThread(String threadName, Runnable stopCode, long terminationTimeoutMs) {
        super(threadName);
        this.setDaemon(true);
        this.stopCode = stopCode;
        this.terminationTimeoutMs = terminationTimeoutMs;
    }

    @Override
    public void run() {
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(false).setNameFormat(this.getName() + "-%d").build());
        try {
            Future<?> future = executor.submit(this.stopCode);
            future.get(this.terminationTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Can not stop in {}ms", (Object)this.terminationTimeoutMs);
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Can not stop in {}ms", (Object)this.terminationTimeoutMs, (Object)e);
        }
        executor.shutdownNow();
    }

    public void stopIt() {
        super.interrupt();
    }
}

