/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.slf4j.LoggerFactory;

public class Jmx {
    private Jmx() {
    }

    public static void register(String name, Object instance) {
        try {
            Class<Object> mbeanInterface = Jmx.guessMBeanInterface(instance);
            ManagementFactory.getPlatformMBeanServer().registerMBean(new StandardMBean(instance, mbeanInterface), new ObjectName(name));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new IllegalStateException("Can not register MBean [" + name + "]", e);
        }
    }

    private static Class<Object> guessMBeanInterface(Object instance) {
        Class<?>[] interfaces;
        Class<?> mbeanInterface = null;
        for (Class<?> anInterface : interfaces = instance.getClass().getInterfaces()) {
            if (!anInterface.getName().endsWith("MBean")) continue;
            mbeanInterface = anInterface;
            break;
        }
        if (mbeanInterface == null) {
            throw new IllegalArgumentException("Can not find the MBean interface of class " + instance.getClass().getName());
        }
        return mbeanInterface;
    }

    public static void unregister(String name) {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(name));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Jmx.class).warn("Can not unregister MBean [{}]", (Object)name, (Object)e);
        }
    }
}

