/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.process.FileUtils2;
import org.sonar.process.MessageException;

public class MinimumViableSystem {
    public MinimumViableSystem checkWritableTempDir() {
        this.checkWritableDir(System.getProperty("java.io.tmpdir"));
        return this;
    }

    void checkWritableDir(String tempPath) {
        try {
            File tempFile = File.createTempFile("check", "tmp", new File(tempPath));
            FileUtils2.deleteQuietly(tempFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Temp directory is not writable: %s", tempPath), e);
        }
    }

    public MinimumViableSystem checkRequiredJavaOptions(Map<String, String> requiredJavaOptions) {
        for (Map.Entry<String, String> entry : requiredJavaOptions.entrySet()) {
            String value = System.getProperty(entry.getKey());
            if (StringUtils.equals((String)value, (String)entry.getValue())) continue;
            throw new MessageException(String.format("JVM option '%s' must be set to '%s'. Got '%s'", entry.getKey(), entry.getValue(), StringUtils.defaultString((String)value)));
        }
        return this;
    }
}

