/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.io.File;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.process.AbstractStopperThread;
import org.sonar.process.ConfigurationUtils;
import org.sonar.process.Lifecycle;
import org.sonar.process.Monitored;
import org.sonar.process.Props;
import org.sonar.process.StopWatcher;
import org.sonar.process.SystemExit;
import org.sonar.process.sharedmemoryfile.DefaultProcessCommands;
import org.sonar.process.sharedmemoryfile.ProcessCommands;

public class ProcessEntryPoint {
    public static final String PROPERTY_PROCESS_KEY = "process.key";
    public static final String PROPERTY_PROCESS_INDEX = "process.index";
    public static final String PROPERTY_GRACEFUL_STOP_TIMEOUT_MS = "process.gracefulStopTimeout";
    public static final String PROPERTY_SHARED_PATH = "process.sharedDir";
    private static final long HARD_STOP_TIMEOUT_MS = 1000L;
    private final Props props;
    private final String processKey;
    private final Lifecycle lifecycle = new Lifecycle();
    private final ProcessCommands commands;
    private final SystemExit exit;
    private final StopWatcher stopWatcher;
    private final StopWatcher hardStopWatcher;
    private final Runtime runtime;
    private Monitored monitored;
    private volatile StopperThread stopperThread;

    public ProcessEntryPoint(Props props, SystemExit exit, ProcessCommands commands, Runtime runtime) {
        this.props = props;
        this.processKey = props.nonNullValue(PROPERTY_PROCESS_KEY);
        this.exit = exit;
        this.commands = commands;
        this.stopWatcher = ProcessEntryPoint.createStopWatcher(commands, this);
        this.hardStopWatcher = ProcessEntryPoint.createHardStopWatcher(commands, this);
        this.runtime = runtime;
    }

    public ProcessCommands getCommands() {
        return this.commands;
    }

    public Props getProps() {
        return this.props;
    }

    public void launch(Monitored mp) {
        if (!this.lifecycle.tryToMoveTo(Lifecycle.State.STARTING)) {
            throw new IllegalStateException("Already started");
        }
        this.monitored = mp;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        try {
            this.launch(logger);
        }
        catch (Exception e) {
            logger.warn("Fail to start {}", (Object)this.processKey, (Object)e);
            this.hardStop();
        }
    }

    private void launch(Logger logger) throws InterruptedException {
        logger.info("Starting {}", (Object)this.processKey);
        this.runtime.addShutdownHook(new Thread(() -> {
            this.exit.setInShutdownHook();
            this.stop();
        }));
        this.stopWatcher.start();
        this.hardStopWatcher.start();
        this.monitored.start();
        Monitored.Status status = this.waitForStatus(s -> s != Monitored.Status.DOWN);
        if (status == Monitored.Status.UP || status == Monitored.Status.OPERATIONAL) {
            this.commands.setUp();
            if (this.lifecycle.tryToMoveTo(Lifecycle.State.STARTED)) {
                Monitored.Status newStatus = this.waitForStatus(s -> s == Monitored.Status.OPERATIONAL || s == Monitored.Status.FAILED);
                if (newStatus == Monitored.Status.OPERATIONAL && this.lifecycle.tryToMoveTo(Lifecycle.State.OPERATIONAL)) {
                    this.commands.setOperational();
                }
                this.monitored.awaitStop();
            }
        } else {
            logger.trace("Fail to start. Hard stopping...");
            this.hardStop();
        }
    }

    private Monitored.Status waitForStatus(Predicate<Monitored.Status> statusPredicate) throws InterruptedException {
        Monitored.Status status = this.monitored.getStatus();
        while (!statusPredicate.test(status)) {
            Thread.sleep(20L);
            status = this.monitored.getStatus();
        }
        return status;
    }

    void stop() {
        this.stopAsync();
        this.monitored.awaitStop();
    }

    void hardStop() {
        this.hardStopAsync();
        this.monitored.awaitStop();
    }

    private void stopAsync() {
        if (this.lifecycle.tryToMoveTo(Lifecycle.State.STOPPING)) {
            LoggerFactory.getLogger(ProcessEntryPoint.class).info("Gracefully stopping process");
            this.stopWatcher.stopWatching();
            long terminationTimeoutMs = Long.parseLong(this.props.nonNullValue(PROPERTY_GRACEFUL_STOP_TIMEOUT_MS));
            this.stopperThread = new StopperThread(this.monitored, this::terminate, terminationTimeoutMs);
            this.stopperThread.start();
        }
    }

    private void hardStopAsync() {
        if (this.lifecycle.tryToMoveTo(Lifecycle.State.HARD_STOPPING)) {
            LoggerFactory.getLogger(ProcessEntryPoint.class).info("Hard stopping process");
            if (this.stopperThread != null) {
                this.stopperThread.stopIt();
            }
            this.hardStopWatcher.stopWatching();
            this.stopWatcher.stopWatching();
            new HardStopperThread(this.monitored, this::terminate).start();
        }
    }

    private void terminate() {
        this.lifecycle.tryToMoveTo(Lifecycle.State.STOPPED);
        this.hardStopWatcher.stopWatching();
        this.stopWatcher.stopWatching();
        this.commands.endWatch();
    }

    public static ProcessEntryPoint createForArguments(String[] args) {
        Props props = ConfigurationUtils.loadPropsFromCommandLineArgs(args);
        File sharedDir = ProcessEntryPoint.getSharedDir(props);
        int processNumber = ProcessEntryPoint.getProcessNumber(props);
        DefaultProcessCommands commands = DefaultProcessCommands.main(sharedDir, processNumber);
        return new ProcessEntryPoint(props, new SystemExit(), commands, Runtime.getRuntime());
    }

    private static int getProcessNumber(Props props) {
        return Integer.parseInt(props.nonNullValue(PROPERTY_PROCESS_INDEX));
    }

    private static File getSharedDir(Props props) {
        return props.nonNullValueAsFile(PROPERTY_SHARED_PATH);
    }

    private static StopWatcher createHardStopWatcher(ProcessCommands commands, ProcessEntryPoint processEntryPoint) {
        return new StopWatcher("HardStop Watcher", processEntryPoint::hardStopAsync, commands::askedForHardStop);
    }

    private static StopWatcher createStopWatcher(ProcessCommands commands, ProcessEntryPoint processEntryPoint) {
        return new StopWatcher("Stop Watcher", processEntryPoint::stopAsync, commands::askedForStop);
    }

    private static class HardStopperThread
    extends AbstractStopperThread {
        private HardStopperThread(Monitored monitored, Runnable postAction) {
            super("HardStopper", () -> {
                monitored.hardStop();
                postAction.run();
            }, 1000L);
        }
    }

    private static class StopperThread
    extends AbstractStopperThread {
        private StopperThread(Monitored monitored, Runnable postAction, long terminationTimeoutMs) {
            super("Stopper", () -> {
                monitored.stop();
                postAction.run();
            }, terminationTimeoutMs);
        }
    }
}

