/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.sql;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.dialect.Dialect;

public class DropColumnsBuilder {
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private final Dialect dialect;
    private final String tableName;
    private final String[] columns;

    public DropColumnsBuilder(Dialect dialect, String tableName, String ... columns) {
        this.tableName = tableName;
        this.dialect = dialect;
        this.columns = columns;
    }

    public List<String> build() {
        switch (this.dialect.getId()) {
            case "postgresql": 
            case "mysql": {
                StringBuilder sql = new StringBuilder().append(ALTER_TABLE).append(this.tableName).append(" ");
                DropColumnsBuilder.dropColumns(sql, "DROP COLUMN ", this.columns);
                return Collections.singletonList(sql.toString());
            }
            case "mssql": {
                return Collections.singletonList(this.getMsSQLStatement(this.columns));
            }
            case "oracle": {
                return Collections.singletonList(this.getOracleStatement());
            }
            case "h2": {
                return (List)Arrays.stream(this.columns).map(xva$0 -> this.getMsSQLStatement((String)xva$0)).collect(MoreCollectors.toList((int)this.columns.length));
            }
        }
        throw new IllegalStateException(String.format("Unsupported database '%s'", this.dialect.getId()));
    }

    private String getOracleStatement() {
        StringBuilder sql = new StringBuilder().append(ALTER_TABLE).append(this.tableName).append(" ");
        sql.append("SET UNUSED (");
        DropColumnsBuilder.dropColumns(sql, "", this.columns);
        sql.append(")");
        return sql.toString();
    }

    private String getMsSQLStatement(String ... columnNames) {
        StringBuilder sql = new StringBuilder().append(ALTER_TABLE).append(this.tableName).append(" ");
        sql.append("DROP COLUMN ");
        DropColumnsBuilder.dropColumns(sql, "", columnNames);
        return sql.toString();
    }

    private static void dropColumns(StringBuilder sql, String columnPrefix, String ... columnNames) {
        Iterator columnNamesIterator = Arrays.stream(columnNames).iterator();
        while (columnNamesIterator.hasNext()) {
            sql.append(columnPrefix);
            sql.append((String)columnNamesIterator.next());
            if (!columnNamesIterator.hasNext()) continue;
            sql.append(", ");
        }
    }
}

