/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.step;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.db.Database;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.step.MigrationStep;

public abstract class DdlChange
implements MigrationStep {
    private final Database db;

    public DdlChange(Database db) {
        this.db = db;
    }

    @Override
    public final void execute() throws SQLException {
        try (Connection writeConnection = this.createDdlConnection();){
            Context context = new Context(writeConnection);
            this.execute(context);
        }
    }

    private Connection createDdlConnection() throws SQLException {
        Connection writeConnection = this.db.getDataSource().getConnection();
        writeConnection.setAutoCommit(false);
        return writeConnection;
    }

    public abstract void execute(Context var1) throws SQLException;

    protected Database getDatabase() {
        return this.db;
    }

    protected Dialect getDialect() {
        return this.db.getDialect();
    }

    public static class Context {
        private static final int ERROR_HANDLING_THRESHOLD = 10;
        private final Pattern nullPattern = Pattern.compile("\\h?(?<!NOT )NULL");
        private final Pattern notNullPattern = Pattern.compile("\\h?NOT NULL");
        private final Connection writeConnection;

        public Context(Connection writeConnection) {
            this.writeConnection = writeConnection;
        }

        public void execute(String sql) throws SQLException {
            this.execute(sql, sql, 0);
        }

        public void execute(String original, String sql, int errorCount) throws SQLException {
            try (Statement stmt = this.writeConnection.createStatement();){
                stmt.execute(sql);
                this.writeConnection.commit();
            }
            catch (SQLException e) {
                if (errorCount < 10) {
                    String message = e.getMessage();
                    if (message.contains("ORA-01451")) {
                        String newSql = this.nullPattern.matcher(sql).replaceFirst("");
                        this.execute(original, newSql, errorCount + 1);
                        return;
                    }
                    if (message.contains("ORA-01442")) {
                        String newSql = this.notNullPattern.matcher(sql).replaceFirst("");
                        this.execute(original, newSql, errorCount + 1);
                        return;
                    }
                }
                throw new IllegalStateException(Context.messageForIseOf(original, sql, errorCount), e);
            }
            catch (Exception e) {
                throw new IllegalStateException(Context.messageForIseOf(original, sql, errorCount), e);
            }
        }

        private static String messageForIseOf(String original, String sql, int errorCount) {
            if (!original.equals(sql) || errorCount > 0) {
                return String.format("Fail to execute %s %n (caught %s error, original was %s)", sql, errorCount, original);
            }
            return String.format("Fail to execute %s", sql);
        }

        public void execute(String ... sqls) throws SQLException {
            this.execute(Arrays.asList(sqls));
        }

        public void execute(List<String> sqls) throws SQLException {
            for (String sql : sqls) {
                this.execute(sql);
            }
        }
    }
}

