/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v56;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.def.BigIntegerColumnDef;
import org.sonar.server.platform.db.migration.def.BlobColumnDef;
import org.sonar.server.platform.db.migration.def.BooleanColumnDef;
import org.sonar.server.platform.db.migration.def.ClobColumnDef;
import org.sonar.server.platform.db.migration.def.ColumnDef;
import org.sonar.server.platform.db.migration.def.DecimalColumnDef;
import org.sonar.server.platform.db.migration.def.IntegerColumnDef;
import org.sonar.server.platform.db.migration.def.TimestampColumnDef;
import org.sonar.server.platform.db.migration.def.TinyIntColumnDef;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

public class CreateInitialSchema
extends DdlChange {
    public CreateInitialSchema(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        this.createActiveDashboards(context);
        this.createActiveRuleParameters(context);
        this.createActiveRules(context);
        this.createActivities(context);
        this.createAuthors(context);
        this.createCeActivity(context);
        this.createCeQueue(context);
        this.createDashboards(context);
        this.createDuplicationsIndex(context);
        this.createEvents(context);
        this.createFileSources(context);
        this.createGroupRoles(context);
        this.createGroups(context);
        this.createGroupsUsers(context);
        this.createIssueChanges(context);
        this.createIssueFilterFavourites(context);
        this.createIssueFilters(context);
        this.createIssues(context);
        this.createLoadedTemplates(context);
        this.createManualMeasures(context);
        this.createMeasureFilterFavourites(context);
        this.createMeasureFilters(context);
        this.createMetrics(context);
        this.createNotifications(context);
        this.createPermissionTemplates(context);
        this.createPermTemplatesGroups(context);
        this.createPermTemplatesUsers(context);
        this.createProjectLinks(context);
        this.createProjectMeasures(context);
        this.createProjectQprofiles(context);
        this.createProjects(context);
        this.createProperties(context);
        this.createQualityGateConditions(context);
        this.createQualityGates(context);
        this.createResourceIndex(context);
        this.createRules(context);
        this.createRulesParameters(context);
        this.createRulesProfiles(context);
        this.createSnapshots(context);
        this.createUserRoles(context);
        this.createUserTokens(context);
        this.createUsers(context);
        this.createWidgetProperties(context);
        this.createWidgets(context);
    }

    private void createUserTokens(DdlChange.Context context) throws SQLException {
        VarcharColumnDef loginCol = CreateInitialSchema.newLenientVarcharBuilder("login").setLimit(255).setIsNullable(false).build();
        VarcharColumnDef nameCol = CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(100).setIsNullable(false).build();
        VarcharColumnDef tokenHashCol = CreateInitialSchema.newLenientVarcharBuilder("token_hash").setLimit(255).setIsNullable(false).build();
        context.execute(this.newTableBuilder("user_tokens").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(loginCol).addColumn(nameCol).addColumn(tokenHashCol).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build()).build());
        this.addIndex(context, "user_tokens", "user_tokens_login_name", true, loginCol, nameCol);
        this.addIndex(context, "user_tokens", "user_tokens_token_hash", true, tokenHashCol);
    }

    private void createCeActivity(DdlChange.Context context) throws SQLException {
        VarcharColumnDef uuidCol = CreateInitialSchema.newLenientVarcharBuilder("uuid").setLimit(40).setIsNullable(false).build();
        VarcharColumnDef isLastKeyCol = CreateInitialSchema.newLenientVarcharBuilder("is_last_key").setLimit(55).setIsNullable(false).build();
        BooleanColumnDef isLastCol = BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("is_last").setIsNullable(false).build();
        VarcharColumnDef statusCol = CreateInitialSchema.newLenientVarcharBuilder("status").setLimit(15).setIsNullable(false).build();
        VarcharColumnDef componentUuidCol = CreateInitialSchema.newLenientVarcharBuilder("component_uuid").setLimit(40).build();
        context.execute(this.newTableBuilder("ce_activity").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(uuidCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("task_type").setLimit(15).setIsNullable(false).build()).addColumn(componentUuidCol).addColumn(statusCol).addColumn(isLastCol).addColumn(isLastKeyCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("submitter_login").setLimit(255).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("submitted_at").setIsNullable(false).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("started_at").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("executed_at").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").setIsNullable(false).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("execution_time_ms").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("snapshot_id").build()).build());
        this.addIndex(context, "ce_activity", "ce_activity_component_uuid", false, componentUuidCol);
        this.addIndex(context, "ce_activity", "ce_activity_islast_status", false, isLastCol, statusCol);
        this.addIndex(context, "ce_activity", "ce_activity_islastkey", false, isLastKeyCol);
        this.addIndex(context, "ce_activity", "ce_activity_uuid", true, uuidCol);
    }

    private void createCeQueue(DdlChange.Context context) throws SQLException {
        VarcharColumnDef uuidCol = CreateInitialSchema.newLenientVarcharBuilder("uuid").setLimit(40).setIsNullable(false).build();
        VarcharColumnDef componentUuidCol = CreateInitialSchema.newLenientVarcharBuilder("component_uuid").setLimit(40).build();
        context.execute(this.newTableBuilder("ce_queue").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(uuidCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("task_type").setLimit(15).setIsNullable(false).build()).addColumn(componentUuidCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("status").setLimit(15).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("submitter_login").setLimit(255).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("started_at").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").setIsNullable(false).build()).build());
        this.addIndex(context, "ce_queue", "ce_queue_component_uuid", false, componentUuidCol);
        this.addIndex(context, "ce_queue", "ce_queue_uuid", true, uuidCol);
    }

    private void createFileSources(DdlChange.Context context) throws SQLException {
        VarcharColumnDef projectUuidCol = CreateInitialSchema.newLenientVarcharBuilder("project_uuid").setLimit(50).setIsNullable(false).build();
        BigIntegerColumnDef updatedAtCol = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").setIsNullable(false).build();
        VarcharColumnDef dataTypeCol = CreateInitialSchema.newLenientVarcharBuilder("data_type").setLimit(20).build();
        VarcharColumnDef fileUuidCol = CreateInitialSchema.newLenientVarcharBuilder("file_uuid").setLimit(50).setIsNullable(false).build();
        context.execute(this.newTableBuilder("file_sources").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(projectUuidCol).addColumn(fileUuidCol).addColumn(ClobColumnDef.newClobColumnDefBuilder().setColumnName("line_hashes").build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("data_hash").setLimit(50).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build()).addColumn(updatedAtCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("src_hash").setLimit(50).build()).addColumn(BlobColumnDef.newBlobColumnDefBuilder().setColumnName("binary_data").build()).addColumn(dataTypeCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("revision").setLimit(100).build()).build());
        this.addIndex(context, "file_sources", "file_sources_project_uuid", false, projectUuidCol);
        this.addIndex(context, "file_sources", "file_sources_updated_at", false, updatedAtCol);
        this.addIndex(context, "file_sources", "file_sources_uuid_type", true, fileUuidCol, dataTypeCol);
    }

    private void createActivities(DdlChange.Context context) throws SQLException {
        VarcharColumnDef keeCol = CreateInitialSchema.newLenientVarcharBuilder("log_key").setLimit(255).build();
        context.execute(this.newTableBuilder("activities").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("user_login").setLimit(255).build()).addColumn(ClobColumnDef.newClobColumnDefBuilder().setColumnName("data_field").build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("log_type").setLimit(50).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("log_action").setLimit(50).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("log_message").setLimit(4000).build()).addColumn(keeCol).build());
        this.addIndex(context, "activities", "activities_log_key", true, keeCol);
    }

    private void createPermTemplatesGroups(DdlChange.Context context) throws SQLException {
        context.execute(this.newTableBuilder("perm_templates_groups").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("group_id").build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("template_id").setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("permission_reference").setLimit(64).setIsNullable(false).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").build()).build());
    }

    private void createPermTemplatesUsers(DdlChange.Context context) throws SQLException {
        context.execute(this.newTableBuilder("perm_templates_users").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("user_id").setIsNullable(false).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("template_id").setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("permission_reference").setLimit(64).setIsNullable(false).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").build()).build());
    }

    private void createPermissionTemplates(DdlChange.Context context) throws SQLException {
        context.execute(this.newTableBuilder("permission_templates").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(100).setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("kee").setLimit(100).setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(4000).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("key_pattern").setLimit(500).build()).build());
    }

    private void createIssueFilterFavourites(DdlChange.Context context) throws SQLException {
        VarcharColumnDef loginCol = CreateInitialSchema.newLenientVarcharBuilder("user_login").setLimit(255).setIsNullable(false).build();
        context.execute(this.newTableBuilder("issue_filter_favourites").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(loginCol).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("issue_filter_id").setIsNullable(false).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).build());
        this.addIndex(context, "issue_filter_favourites", "issue_filter_favs_user", false, loginCol);
    }

    private void createIssueFilters(DdlChange.Context context) throws SQLException {
        VarcharColumnDef nameCol = CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(100).setIsNullable(false).build();
        context.execute(this.newTableBuilder("issue_filters").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(nameCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("user_login").setLimit(255).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("shared").setIsNullable(false).setDefaultValue(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(4000).build()).addColumn(ClobColumnDef.newClobColumnDefBuilder().setColumnName("data").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").build()).build());
        this.addIndex(context, "issue_filters", "issue_filters_name", false, nameCol);
    }

    private void createIssueChanges(DdlChange.Context context) throws SQLException {
        VarcharColumnDef issueKeyCol = CreateInitialSchema.newLenientVarcharBuilder("issue_key").setLimit(50).setIsNullable(false).build();
        VarcharColumnDef keeCol = CreateInitialSchema.newLenientVarcharBuilder("kee").setLimit(50).build();
        context.execute(this.newTableBuilder("issue_changes").addPkColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(keeCol).addColumn(issueKeyCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("user_login").setLimit(255).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("change_type").setLimit(20).build()).addColumn(ClobColumnDef.newClobColumnDefBuilder().setColumnName("change_data").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("issue_change_creation_date").build()).build());
        this.addIndex(context, "issue_changes", "issue_changes_issue_key", false, issueKeyCol);
        this.addIndex(context, "issue_changes", "issue_changes_kee", false, keeCol);
    }

    private void createIssues(DdlChange.Context context) throws SQLException {
        VarcharColumnDef assigneeCol = CreateInitialSchema.newLenientVarcharBuilder("assignee").setLimit(255).build();
        VarcharColumnDef componentUuidCol = CreateInitialSchema.newLenientVarcharBuilder("component_uuid").setLimit(50).build();
        BigIntegerColumnDef issueCreationDateCol = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("issue_creation_date").build();
        VarcharColumnDef keeCol = CreateInitialSchema.newLenientVarcharBuilder("kee").setLimit(50).setIsNullable(false).build();
        VarcharColumnDef projectUuidCol = CreateInitialSchema.newLenientVarcharBuilder("project_uuid").setLimit(50).build();
        VarcharColumnDef resolutionCol = CreateInitialSchema.newLenientVarcharBuilder("resolution").setLimit(20).build();
        IntegerColumnDef ruleIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("rule_id").build();
        BigIntegerColumnDef updatedAtCol = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").build();
        context.execute(this.newTableBuilder("issues").addPkColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(keeCol).addColumn(ruleIdCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("severity").setLimit(10).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("manual_severity").setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("message").setIgnoreOracleUnit(false).setLimit(4000).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("line").build()).addColumn(DecimalColumnDef.newDecimalColumnDefBuilder().setColumnName("gap").setPrecision(30).setScale(20).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("status").setLimit(20).build()).addColumn(resolutionCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("checksum").setLimit(1000).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("reporter").setLimit(255).build()).addColumn(assigneeCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("author_login").setLimit(255).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("action_plan_key").setLimit(50).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("issue_attributes").setLimit(4000).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("effort").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").build()).addColumn(updatedAtCol).addColumn(issueCreationDateCol).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("issue_update_date").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("issue_close_date").build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("tags").setLimit(4000).build()).addColumn(componentUuidCol).addColumn(projectUuidCol).addColumn(BlobColumnDef.newBlobColumnDefBuilder().setColumnName("locations").build()).addColumn(new TinyIntColumnDef.Builder().setColumnName("issue_type").build()).build());
        this.addIndex(context, "issues", "issues_assignee", false, assigneeCol);
        this.addIndex(context, "issues", "issues_component_uuid", false, componentUuidCol);
        this.addIndex(context, "issues", "issues_creation_date", false, issueCreationDateCol);
        this.addIndex(context, "issues", "issues_kee", true, keeCol);
        this.addIndex(context, "issues", "issues_project_uuid", false, projectUuidCol);
        this.addIndex(context, "issues", "issues_resolution", false, resolutionCol);
        this.addIndex(context, "issues", "issues_rule_id", false, ruleIdCol);
        this.addIndex(context, "issues", "issues_updated_at", false, updatedAtCol);
    }

    private void createMeasureFilterFavourites(DdlChange.Context context) throws SQLException {
        IntegerColumnDef userIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("user_id").setIsNullable(false).build();
        context.execute(this.newTableBuilder("measure_filter_favourites").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(userIdCol).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("measure_filter_id").setIsNullable(false).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).build());
        this.addIndex(context, "measure_filter_favourites", "measure_filter_favs_userid", false, userIdCol);
    }

    private void createMeasureFilters(DdlChange.Context context) throws SQLException {
        VarcharColumnDef nameCol = CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(100).setIsNullable(false).build();
        context.execute(this.newTableBuilder("measure_filters").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(nameCol).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("user_id").build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("shared").setDefaultValue(false).setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(4000).build()).addColumn(ClobColumnDef.newClobColumnDefBuilder().setColumnName("data").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").build()).build());
        this.addIndex(context, "measure_filters", "measure_filters_name", false, nameCol);
    }

    private void createAuthors(DdlChange.Context context) throws SQLException {
        VarcharColumnDef loginCol = CreateInitialSchema.newLenientVarcharBuilder("login").setLimit(255).build();
        context.execute(this.newTableBuilder("authors").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("person_id").setIsNullable(false).build()).addColumn(loginCol).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").build()).build());
        this.addIndex(context, "authors", "uniq_author_logins", true, loginCol);
    }

    private void createResourceIndex(DdlChange.Context context) throws SQLException {
        VarcharColumnDef keeCol = CreateInitialSchema.newLenientVarcharBuilder("kee").setLimit(400).setIsNullable(false).build();
        IntegerColumnDef resourceIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("resource_id").setIsNullable(false).build();
        context.execute(this.newTableBuilder("resource_index").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(keeCol).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("position").setIsNullable(false).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("name_size").setIsNullable(false).build()).addColumn(resourceIdCol).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("root_project_id").setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("qualifier").setLimit(10).setIsNullable(false).build()).build());
        this.addIndex(context, "resource_index", "resource_index_key", false, keeCol);
        this.addIndex(context, "resource_index", "resource_index_rid", false, resourceIdCol);
    }

    private void createLoadedTemplates(DdlChange.Context context) throws SQLException {
        context.execute(this.newTableBuilder("loaded_templates").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(CreateInitialSchema.newLenientVarcharBuilder("kee").setLimit(200).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("template_type").setLimit(15).build()).build());
    }

    private void createMetrics(DdlChange.Context context) throws SQLException {
        VarcharColumnDef nameCol = CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(64).setIsNullable(false).build();
        context.execute(this.newTableBuilder("metrics").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(nameCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(255).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("direction").setIsNullable(false).setDefaultValue(0).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("domain").setLimit(64).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("short_name").setLimit(64).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("qualitative").setDefaultValue(false).setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("val_type").setLimit(8).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("user_managed").setDefaultValue(false).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("enabled").setDefaultValue(true).build()).addColumn(DecimalColumnDef.newDecimalColumnDefBuilder().setColumnName("worst_value").setPrecision(38).setScale(20).build()).addColumn(DecimalColumnDef.newDecimalColumnDefBuilder().setColumnName("best_value").setPrecision(38).setScale(20).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("optimized_best_value").build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("hidden").build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("delete_historical_data").build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("decimal_scale").build()).build());
        this.addIndex(context, "metrics", "metrics_unique_name", true, nameCol);
    }

    private void createDashboards(DdlChange.Context context) throws SQLException {
        context.execute(this.newTableBuilder("dashboards").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("user_id").build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(256).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(1000).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("column_layout").setLimit(20).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("shared").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("is_global").build()).build());
    }

    private void createUsers(DdlChange.Context context) throws SQLException {
        VarcharColumnDef loginCol = CreateInitialSchema.newLenientVarcharBuilder("login").setLimit(255).build();
        BigIntegerColumnDef updatedAtCol = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").build();
        context.execute(this.newTableBuilder("users").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(loginCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(200).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("email").setLimit(100).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("crypted_password").setLimit(40).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("salt").setLimit(40).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("remember_token").setLimit(500).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("remember_token_expires_at").build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("active").setDefaultValue(true).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").build()).addColumn(updatedAtCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("scm_accounts").setLimit(4000).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("external_identity").setLimit(255).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("external_identity_provider").setLimit(100).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("user_local").build()).build());
        this.addIndex(context, "users", "users_login", true, loginCol);
        this.addIndex(context, "users", "users_updated_at", false, updatedAtCol);
    }

    private void createActiveRuleParameters(DdlChange.Context context) throws SQLException {
        context.execute(this.newTableBuilder("active_rule_parameters").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("active_rule_id").setIsNullable(false).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("rules_parameter_id").setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("value").setLimit(4000).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("rules_parameter_key").setLimit(128).build()).build());
    }

    private void createActiveRules(DdlChange.Context context) throws SQLException {
        IntegerColumnDef profileIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("profile_id").setIsNullable(false).build();
        IntegerColumnDef ruleIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("rule_id").setIsNullable(false).build();
        context.execute(this.newTableBuilder("active_rules").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(profileIdCol).addColumn(ruleIdCol).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("failure_level").setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("inheritance").setLimit(10).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").build()).build());
        this.addIndex(context, "active_rules", "uniq_profile_rule_ids", true, profileIdCol, ruleIdCol);
    }

    private void createUserRoles(DdlChange.Context context) throws SQLException {
        IntegerColumnDef userIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("user_id").build();
        IntegerColumnDef resourceIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("resource_id").build();
        context.execute(this.newTableBuilder("user_roles").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(userIdCol).addColumn(resourceIdCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("role").setLimit(64).setIsNullable(false).build()).build());
        this.addIndex(context, "user_roles", "user_roles_resource", false, resourceIdCol);
        this.addIndex(context, "user_roles", "user_roles_user", false, userIdCol);
    }

    private void createActiveDashboards(DdlChange.Context context) throws SQLException {
        IntegerColumnDef dashboardIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("dashboard_id").setIsNullable(false).build();
        IntegerColumnDef userIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("user_id").build();
        context.execute(this.newTableBuilder("active_dashboards").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(dashboardIdCol).addColumn(userIdCol).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("order_index").build()).build());
        this.addIndex(context, "active_dashboards", "active_dashboards_dashboardid", false, dashboardIdCol);
        this.addIndex(context, "active_dashboards", "active_dashboards_userid", false, userIdCol);
    }

    private void createNotifications(DdlChange.Context context) throws SQLException {
        context.execute(this.newTableBuilder("notifications").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(BlobColumnDef.newBlobColumnDefBuilder().setColumnName("data").build()).build());
    }

    private void createSnapshots(DdlChange.Context context) throws SQLException {
        IntegerColumnDef projectIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("project_id").setIsNullable(false).build();
        IntegerColumnDef rootProjectIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("root_project_id").setIsNullable(true).build();
        IntegerColumnDef parentSnapshotIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("parent_snapshot_id").setIsNullable(true).build();
        VarcharColumnDef qualifierCol = CreateInitialSchema.newLenientVarcharBuilder("qualifier").setLimit(10).setIsNullable(true).build();
        IntegerColumnDef rootSnapshotIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("root_snapshot_id").setIsNullable(true).build();
        context.execute(this.newTableBuilder("snapshots").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(projectIdCol).addColumn(parentSnapshotIdCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("status").setLimit(4).setIsNullable(false).setDefaultValue("U").build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("islast").setIsNullable(false).setDefaultValue(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("scope").setLimit(3).setIsNullable(true).build()).addColumn(qualifierCol).addColumn(rootSnapshotIdCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("version").setLimit(500).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("path").setLimit(500).setIsNullable(true).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("depth").setIsNullable(true).build()).addColumn(rootProjectIdCol).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("purge_status").setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("period1_mode").setLimit(100).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("period1_param").setLimit(100).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("period2_mode").setLimit(100).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("period2_param").setLimit(100).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("period3_mode").setLimit(100).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("period3_param").setLimit(100).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("period4_mode").setLimit(100).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("period4_param").setLimit(100).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("period5_mode").setLimit(100).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("period5_param").setLimit(100).setIsNullable(true).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(true).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("build_date").setIsNullable(true).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("period1_date").setIsNullable(true).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("period2_date").setIsNullable(true).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("period3_date").setIsNullable(true).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("period4_date").setIsNullable(true).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("period5_date").setIsNullable(true).build()).build());
        this.addIndex(context, "snapshots", "snapshot_project_id", false, projectIdCol);
        this.addIndex(context, "snapshots", "snapshots_parent", false, parentSnapshotIdCol);
        this.addIndex(context, "snapshots", "snapshots_qualifier", false, qualifierCol);
        this.addIndex(context, "snapshots", "snapshots_root", false, rootSnapshotIdCol);
        this.addIndex(context, "snapshots", "snapshots_root_project_id", false, rootProjectIdCol);
    }

    private void createGroups(DdlChange.Context context) throws SQLException {
        context.execute(this.newTableBuilder("groups").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(500).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(200).setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").setIsNullable(true).build()).build());
    }

    private void createWidgets(DdlChange.Context context) throws SQLException {
        IntegerColumnDef dashboardId = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("dashboard_id").setIsNullable(false).build();
        VarcharColumnDef widgetKey = CreateInitialSchema.newLenientVarcharBuilder("widget_key").setLimit(256).setIsNullable(false).build();
        context.execute(this.newTableBuilder("widgets").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(dashboardId).addColumn(widgetKey).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(256).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(1000).setIsNullable(true).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("column_index").setIsNullable(true).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("row_index").setIsNullable(true).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("configured").setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").setIsNullable(true).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("resource_id").setIsNullable(true).build()).build());
        this.addIndex(context, "widgets", "widgets_dashboards", false, dashboardId);
        this.addIndex(context, "widgets", "widgets_widgetkey", false, widgetKey);
    }

    private void createProjectQprofiles(DdlChange.Context context) throws SQLException {
        VarcharColumnDef projectUuid = CreateInitialSchema.newLenientVarcharBuilder("project_uuid").setLimit(50).setIsNullable(false).build();
        VarcharColumnDef profileKey = CreateInitialSchema.newLenientVarcharBuilder("profile_key").setLimit(50).setIsNullable(false).build();
        context.execute(this.newTableBuilder("project_qprofiles").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(projectUuid).addColumn(profileKey).build());
        this.addIndex(context, "project_qprofiles", "uniq_project_qprofiles", true, projectUuid, profileKey);
    }

    private void createRulesProfiles(DdlChange.Context context) throws SQLException {
        VarcharColumnDef keeCol = CreateInitialSchema.newLenientVarcharBuilder("kee").setLimit(255).setIsNullable(false).build();
        context.execute(this.newTableBuilder("rules_profiles").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(100).setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("language").setLimit(20).setIsNullable(true).build()).addColumn(keeCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("parent_kee").setLimit(255).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("rules_updated_at").setLimit(100).setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").setIsNullable(true).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("is_default").setIsNullable(false).build()).build());
        this.addIndex(context, "rules_profiles", "uniq_qprof_key", true, keeCol);
    }

    private void createRulesParameters(DdlChange.Context context) throws SQLException {
        IntegerColumnDef ruleIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("rule_id").setIsNullable(false).build();
        context.execute(this.newTableBuilder("rules_parameters").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(ruleIdCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(128).setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(4000).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("param_type").setLimit(512).setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("default_value").setLimit(4000).setIsNullable(true).build()).build());
        this.addIndex(context, "rules_parameters", "rules_parameters_rule_id", false, ruleIdCol);
    }

    private void createGroupsUsers(DdlChange.Context context) throws SQLException {
        BigIntegerColumnDef userIdCol = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("user_id").setIsNullable(true).build();
        BigIntegerColumnDef groupIdCol = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("group_id").setIsNullable(true).build();
        context.execute(this.newTableBuilder("groups_users").addColumn(userIdCol).addColumn(groupIdCol).build());
        this.addIndex(context, "groups_users", "index_groups_users_on_user_id", false, userIdCol);
        this.addIndex(context, "groups_users", "index_groups_users_on_group_id", false, groupIdCol);
        this.addIndex(context, "groups_users", "groups_users_unique", true, groupIdCol, userIdCol);
    }

    private void createProjectMeasures(DdlChange.Context context) throws SQLException {
        IntegerColumnDef personIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("person_id").build();
        IntegerColumnDef metricIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("metric_id").setIsNullable(false).build();
        IntegerColumnDef snapshotIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("snapshot_id").setIsNullable(true).build();
        context.execute(this.newTableBuilder("project_measures").addPkColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(DecimalColumnDef.newDecimalColumnDefBuilder().setColumnName("value").setPrecision(38).setScale(20).build()).addColumn(metricIdCol).addColumn(snapshotIdCol).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("rule_id").setIsNullable(true).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("rules_category_id").setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("text_value").setLimit(4000).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("tendency").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("measure_date").build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("project_id").build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("alert_status").setLimit(5).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("alert_text").setLimit(4000).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("url").setLimit(2000).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(4000).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("rule_priority").build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("characteristic_id").build()).addColumn(personIdCol).addColumn(DecimalColumnDef.newDecimalColumnDefBuilder().setColumnName("variation_value_1").setPrecision(38).setScale(20).build()).addColumn(DecimalColumnDef.newDecimalColumnDefBuilder().setColumnName("variation_value_2").setPrecision(38).setScale(20).build()).addColumn(DecimalColumnDef.newDecimalColumnDefBuilder().setColumnName("variation_value_3").setPrecision(38).setScale(20).build()).addColumn(DecimalColumnDef.newDecimalColumnDefBuilder().setColumnName("variation_value_4").setPrecision(38).setScale(20).build()).addColumn(DecimalColumnDef.newDecimalColumnDefBuilder().setColumnName("variation_value_5").setPrecision(38).setScale(20).build()).addColumn(BlobColumnDef.newBlobColumnDefBuilder().setColumnName("measure_data").build()).build());
        this.addIndex(context, "project_measures", "measures_sid_metric", false, snapshotIdCol, metricIdCol);
        this.addIndex(context, "project_measures", "measures_person", false, personIdCol);
    }

    private void createManualMeasures(DdlChange.Context context) throws SQLException {
        VarcharColumnDef componentUuidCol = CreateInitialSchema.newLenientVarcharBuilder("component_uuid").setLimit(50).build();
        context.execute(this.newTableBuilder("manual_measures").addPkColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("metric_id").setIsNullable(false).build()).addColumn(DecimalColumnDef.newDecimalColumnDefBuilder().setColumnName("value").setPrecision(38).setScale(20).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("text_value").setLimit(4000).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("user_login").setLimit(255).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(4000).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").build()).addColumn(componentUuidCol).build());
        this.addIndex(context, "manual_measures", "manual_measures_component_uuid", false, componentUuidCol);
    }

    private void createProjects(DdlChange.Context context) throws SQLException {
        VarcharColumnDef keeCol = CreateInitialSchema.newLenientVarcharBuilder("kee").setLimit(400).build();
        VarcharColumnDef moduleUuidCol = CreateInitialSchema.newLenientVarcharBuilder("module_uuid").setLimit(50).build();
        VarcharColumnDef projectUuidCol = CreateInitialSchema.newLenientVarcharBuilder("project_uuid").setLimit(50).build();
        VarcharColumnDef qualifierCol = CreateInitialSchema.newLenientVarcharBuilder("qualifier").setLimit(10).build();
        IntegerColumnDef rootIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("root_id").build();
        VarcharColumnDef uuidCol = CreateInitialSchema.newLenientVarcharBuilder("uuid").setLimit(50).build();
        context.execute(this.newTableBuilder("projects").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(2000).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(2000).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("enabled").setDefaultValue(true).setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("scope").setLimit(3).build()).addColumn(qualifierCol).addColumn(keeCol).addColumn(rootIdCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("language").setLimit(20).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("copy_resource_id").build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("long_name").setLimit(2000).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("person_id").build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("path").setLimit(2000).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("deprecated_kee").setLimit(400).build()).addColumn(uuidCol).addColumn(projectUuidCol).addColumn(moduleUuidCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("module_uuid_path").setLimit(4000).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("authorization_updated_at").build()).build());
        this.addIndex(context, "projects", "projects_kee", true, keeCol);
        this.addIndex(context, "projects", "projects_module_uuid", false, moduleUuidCol);
        this.addIndex(context, "projects", "projects_project_uuid", false, projectUuidCol);
        this.addIndex(context, "projects", "projects_qualifier", false, qualifierCol);
        this.addIndex(context, "projects", "projects_root_id", false, rootIdCol);
        this.addIndex(context, "projects", "projects_uuid", true, uuidCol);
    }

    private void createGroupRoles(DdlChange.Context context) throws SQLException {
        IntegerColumnDef groupIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("group_id").setIsNullable(true).build();
        IntegerColumnDef resourceIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("resource_id").setIsNullable(true).build();
        VarcharColumnDef roleCol = CreateInitialSchema.newLenientVarcharBuilder("role").setLimit(64).setIsNullable(false).build();
        context.execute(this.newTableBuilder("group_roles").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(groupIdCol).addColumn(resourceIdCol).addColumn(roleCol).build());
        this.addIndex(context, "group_roles", "group_roles_resource", false, resourceIdCol);
        this.addIndex(context, "group_roles", "uniq_group_roles", true, groupIdCol, resourceIdCol, roleCol);
    }

    private void createRules(DdlChange.Context context) throws SQLException {
        VarcharColumnDef pluginRuleKeyCol = CreateInitialSchema.newLenientVarcharBuilder("plugin_rule_key").setLimit(200).setIsNullable(false).build();
        VarcharColumnDef pluginNameCol = CreateInitialSchema.newLenientVarcharBuilder("plugin_name").setLimit(255).setIsNullable(false).build();
        context.execute(this.newTableBuilder("rules").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(200).setIsNullable(true).build()).addColumn(pluginRuleKeyCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("plugin_config_key").setLimit(200).setIsNullable(true).build()).addColumn(pluginNameCol).addColumn(ClobColumnDef.newClobColumnDefBuilder().setColumnName("description").setIsNullable(true).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("priority").setIsNullable(true).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("template_id").setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("status").setLimit(40).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("language").setLimit(20).setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("note_created_at").setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("note_updated_at").setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("note_user_login").setLimit(255).setIsNullable(true).build()).addColumn(ClobColumnDef.newClobColumnDefBuilder().setColumnName("note_data").setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("remediation_function").setLimit(200).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("def_remediation_function").setLimit(20).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("remediation_gap_mult").setLimit(20).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("def_remediation_gap_mult").setLimit(20).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("remediation_base_effort").setLimit(20).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("def_remediation_base_effort").setLimit(20).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("gap_description").setLimit(4000).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("tags").setLimit(4000).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("system_tags").setLimit(4000).setIsNullable(true).build()).addColumn(BooleanColumnDef.newBooleanColumnDefBuilder().setColumnName("is_template").setIsNullable(false).setDefaultValue(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description_format").setLimit(20).setIsNullable(true).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(true).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").setIsNullable(true).build()).addColumn(new TinyIntColumnDef.Builder().setColumnName("rule_type").setIsNullable(true).build()).build());
        this.addIndex(context, "rules", "rules_repo_key", true, pluginRuleKeyCol, pluginNameCol);
    }

    private void createWidgetProperties(DdlChange.Context context) throws SQLException {
        IntegerColumnDef widgetIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("widget_id").setIsNullable(false).build();
        context.execute(this.newTableBuilder("widget_properties").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(widgetIdCol).addColumn(CreateInitialSchema.newLenientVarcharBuilder("kee").setLimit(100).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("text_value").setLimit(4000).setIsNullable(true).build()).build());
        this.addIndex(context, "widget_properties", "widget_properties_widgets", false, widgetIdCol);
    }

    private void createEvents(DdlChange.Context context) throws SQLException {
        VarcharColumnDef componentUuid = CreateInitialSchema.newLenientVarcharBuilder("component_uuid").setLimit(50).setIsNullable(true).build();
        IntegerColumnDef snapshotId = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("snapshot_id").setIsNullable(true).build();
        context.execute(this.newTableBuilder("events").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(400).setIsNullable(true).build()).addColumn(snapshotId).addColumn(CreateInitialSchema.newLenientVarcharBuilder("category").setLimit(50).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("description").setLimit(4000).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("event_data").setLimit(4000).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("event_date").setIsNullable(false).build()).addColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build()).addColumn(componentUuid).build());
        this.addIndex(context, "events", "events_component_uuid", false, componentUuid);
        this.addIndex(context, "events", "events_snapshot_id", false, snapshotId);
    }

    private void createQualityGates(DdlChange.Context context) throws SQLException {
        VarcharColumnDef nameCol = CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(100).setIsNullable(false).build();
        context.execute(this.newTableBuilder("quality_gates").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(nameCol).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").setIsNullable(true).build()).build());
        this.addIndex(context, "quality_gates", "uniq_quality_gates", true, nameCol);
    }

    private void createQualityGateConditions(DdlChange.Context context) throws SQLException {
        context.execute(this.newTableBuilder("quality_gate_conditions").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("qgate_id").setIsNullable(true).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("metric_id").setIsNullable(true).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("period").setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("operator").setLimit(3).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("value_error").setLimit(64).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("value_warning").setLimit(64).setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("created_at").setIsNullable(true).build()).addColumn(TimestampColumnDef.newTimestampColumnDefBuilder().setColumnName("updated_at").setIsNullable(true).build()).build());
    }

    private void createProperties(DdlChange.Context context) throws SQLException {
        VarcharColumnDef propKey = CreateInitialSchema.newLenientVarcharBuilder("prop_key").setLimit(512).setIsNullable(true).build();
        context.execute(this.newTableBuilder("properties").addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build()).addColumn(propKey).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("resource_id").setIsNullable(true).build()).addColumn(ClobColumnDef.newClobColumnDefBuilder().setColumnName("text_value").setIsNullable(true).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("user_id").setIsNullable(true).build()).build());
        this.addIndex(context, "properties", "properties_key", false, propKey);
    }

    private void createProjectLinks(DdlChange.Context context) throws SQLException {
        context.execute(this.newTableBuilder("project_links").addPkColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(CreateInitialSchema.newLenientVarcharBuilder("link_type").setLimit(20).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("name").setLimit(128).setIsNullable(true).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("href").setLimit(2048).setIsNullable(false).build()).addColumn(CreateInitialSchema.newLenientVarcharBuilder("component_uuid").setLimit(2048).setIsNullable(true).build()).build());
    }

    private void createDuplicationsIndex(DdlChange.Context context) throws SQLException {
        VarcharColumnDef hashCol = CreateInitialSchema.newLenientVarcharBuilder("hash").setLimit(50).setIsNullable(false).build();
        IntegerColumnDef snapshotIdCol = IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("snapshot_id").setIsNullable(false).build();
        context.execute(this.newTableBuilder("duplications_index").addPkColumn(BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("id").setIsNullable(false).build(), CreateTableBuilder.ColumnFlag.AUTO_INCREMENT).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("project_snapshot_id").setIsNullable(false).build()).addColumn(snapshotIdCol).addColumn(hashCol).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("index_in_file").setIsNullable(false).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("start_line").setIsNullable(false).build()).addColumn(IntegerColumnDef.newIntegerColumnDefBuilder().setColumnName("end_line").setIsNullable(false).build()).build());
        this.addIndex(context, "duplications_index", "duplications_index_hash", false, hashCol);
        this.addIndex(context, "duplications_index", "duplications_index_sid", false, snapshotIdCol);
    }

    private void addIndex(DdlChange.Context context, String table, String index, boolean unique, ColumnDef ... columns) throws SQLException {
        CreateIndexBuilder builder = new CreateIndexBuilder(this.getDialect()).setTable(table).setName(index).setUnique(unique);
        for (ColumnDef column : columns) {
            builder.addColumn(column);
        }
        context.execute(builder.build());
    }

    private static VarcharColumnDef.Builder newLenientVarcharBuilder(String column) {
        return new VarcharColumnDef.Builder().setColumnName(column).setIgnoreOracleUnit(true);
    }

    private CreateTableBuilder newTableBuilder(String tableName) {
        return new CreateTableBuilder(this.getDialect(), tableName);
    }
}

