/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v63;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.version.v63.DefaultOrganizationUuidProvider;

public class DefaultOrganizationUuidProviderImpl
implements DefaultOrganizationUuidProvider {
    private static final String INTERNAL_PROPERTY_DEFAULT_ORGANIZATION = "organization.default";

    @Override
    public String get(DataChange.Context context) throws SQLException {
        Select select = context.prepareSelect("select text_value from internal_properties where kee=?");
        select.setString(1, INTERNAL_PROPERTY_DEFAULT_ORGANIZATION);
        String uuid = select.get((Select.Row row) -> row.getString(1));
        Preconditions.checkState((uuid != null ? 1 : 0) != 0, (Object)"Default organization uuid is missing");
        return uuid;
    }

    @Override
    public String getAndCheck(DataChange.Context context) throws SQLException {
        String organizationUuid = this.get(context);
        Select select = (Select)context.prepareSelect("select uuid from organizations where uuid=?").setString(1, organizationUuid);
        Preconditions.checkState((select.get((Select.Row row) -> row.getString(1)) != null ? 1 : 0) != 0, (String)"Default organization with uuid '%s' does not exist in table ORGANIZATIONS", (Object[])new Object[]{organizationUuid});
        return organizationUuid;
    }
}

