/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v73;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.def.BigIntegerColumnDef;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

@SupportsBlueGreen
public class CreateProjectAlmBindingsTable
extends DdlChange {
    private static final String TABLE_NAME = "project_alm_bindings";
    private static final VarcharColumnDef UUID = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("uuid").setLimit(40).setIsNullable(false).build();
    private static final VarcharColumnDef ALM_ID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("alm_id").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef REPO_ID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("repo_id").setIsNullable(false).setLimit(256).build();
    private static final VarcharColumnDef PROJECT_UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("project_uuid").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef GITHUB_SLUG_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("github_slug").setIsNullable(true).setLimit(256).build();
    private static final VarcharColumnDef URL_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("url").setIsNullable(false).setLimit(2000).build();
    private static final BigIntegerColumnDef CREATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build();
    private static final BigIntegerColumnDef UPDATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").setIsNullable(false).build();

    public CreateProjectAlmBindingsTable(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        if (!this.tableExists()) {
            context.execute(new CreateTableBuilder(this.getDialect(), TABLE_NAME).addPkColumn(UUID, new CreateTableBuilder.ColumnFlag[0]).addColumn(ALM_ID_COLUMN).addColumn(REPO_ID_COLUMN).addColumn(PROJECT_UUID_COLUMN).addColumn(GITHUB_SLUG_COLUMN).addColumn(URL_COLUMN).addColumn(CREATED_AT_COLUMN).addColumn(UPDATED_AT_COLUMN).build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(ALM_ID_COLUMN).addColumn(REPO_ID_COLUMN).setUnique(true).setTable(TABLE_NAME).setName("project_alm_bindings_alm_repo").build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(PROJECT_UUID_COLUMN).setUnique(true).setTable(TABLE_NAME).setName("project_alm_bindings_project").build());
        }
    }

    private boolean tableExists() throws SQLException {
        try (Connection connection = this.getDatabase().getDataSource().getConnection();){
            boolean bl = DatabaseUtils.tableExists((String)TABLE_NAME, (Connection)connection);
            return bl;
        }
    }
}

