/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v78;

import java.sql.Connection;
import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.db.DatabaseUtils;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.def.BigIntegerColumnDef;
import org.sonar.server.platform.db.migration.def.VarcharColumnDef;
import org.sonar.server.platform.db.migration.sql.CreateIndexBuilder;
import org.sonar.server.platform.db.migration.sql.CreateTableBuilder;
import org.sonar.server.platform.db.migration.step.DdlChange;

@SupportsBlueGreen
public class CreateInternalComponentPropertiesTable
extends DdlChange {
    private static final String TABLE_NAME = "internal_component_props";
    private static final VarcharColumnDef UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("uuid").setIsNullable(false).setLimit(40).build();
    private static final VarcharColumnDef COMPONENT_UUID_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("component_uuid").setIsNullable(false).setLimit(50).build();
    private static final VarcharColumnDef KEE_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("kee").setIsNullable(false).setLimit(512).build();
    private static final VarcharColumnDef VALUE_COLUMN = VarcharColumnDef.newVarcharColumnDefBuilder().setColumnName("value").setIsNullable(true).setLimit(4000).build();
    private static final BigIntegerColumnDef UPDATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("updated_at").setIsNullable(false).build();
    private static final BigIntegerColumnDef CREATED_AT_COLUMN = BigIntegerColumnDef.newBigIntegerColumnDefBuilder().setColumnName("created_at").setIsNullable(false).build();

    public CreateInternalComponentPropertiesTable(Database db) {
        super(db);
    }

    @Override
    public void execute(DdlChange.Context context) throws SQLException {
        if (!this.tableExists()) {
            context.execute(new CreateTableBuilder(this.getDialect(), TABLE_NAME).addPkColumn(UUID_COLUMN, new CreateTableBuilder.ColumnFlag[0]).addColumn(COMPONENT_UUID_COLUMN).addColumn(KEE_COLUMN).addColumn(VALUE_COLUMN).addColumn(UPDATED_AT_COLUMN).addColumn(CREATED_AT_COLUMN).build());
            context.execute(new CreateIndexBuilder(this.getDialect()).addColumn(COMPONENT_UUID_COLUMN).addColumn(KEE_COLUMN).setUnique(true).setTable(TABLE_NAME).setName("unique_component_uuid_kee").build());
        }
    }

    private boolean tableExists() throws SQLException {
        try (Connection connection = this.getDatabase().getDataSource().getConnection();){
            boolean bl = DatabaseUtils.tableExists((String)TABLE_NAME, (Connection)connection);
            return bl;
        }
    }
}

