/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.dialect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.dialect.AbstractDialect;

public class PostgreSql
extends AbstractDialect {
    public static final String ID = "postgresql";
    static final List<String> INIT_STATEMENTS = ImmutableList.of((Object)"SET standard_conforming_strings=on", (Object)"SET backslash_quote=off");
    private static final Version MIN_SUPPORTED_VERSION = Version.create((int)9, (int)3, (int)0);
    private static final Version MIN_UPSERT_VERSION = Version.create((int)9, (int)5, (int)0);
    private boolean initialized = false;
    private boolean supportsUpsert = false;

    public PostgreSql() {
        super(ID, "org.postgresql.Driver", "true", "false", "SELECT 1");
    }

    @Override
    public boolean matchesJdbcUrl(String jdbcConnectionURL) {
        return StringUtils.startsWithIgnoreCase((String)jdbcConnectionURL, (String)"jdbc:postgresql:");
    }

    @Override
    public List<String> getConnectionInitStatements() {
        return INIT_STATEMENTS;
    }

    @Override
    public boolean supportsMigration() {
        return true;
    }

    @Override
    public boolean supportsUpsert() {
        Preconditions.checkState((boolean)this.initialized, (Object)"onInit() must be called before calling supportsUpsert()");
        return this.supportsUpsert;
    }

    @Override
    public void init(DatabaseMetaData metaData) throws SQLException {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"onInit() must be called once");
        Version version = this.checkDbVersion(metaData, MIN_SUPPORTED_VERSION);
        boolean bl = this.supportsUpsert = version.compareTo(MIN_UPSERT_VERSION) >= 0;
        if (!this.supportsUpsert) {
            Loggers.get(this.getClass()).warn("Upgrading PostgreSQL to {} or greater is recommended for better performances", (Object)MIN_UPSERT_VERSION);
        }
        this.initialized = true;
    }
}

