/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.HasKeyword;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.JumpTree;
import org.sonarsource.slang.api.ReturnTree;
import org.sonarsource.slang.api.ThrowTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S1763")
public class CodeAfterJumpCheck
implements SlangCheck {
    private static final String MESSAGE = "Refactor this piece of code to not have any dead code after this \"%s\".";

    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, (ctx, blockTree) -> CodeAfterJumpCheck.checkStatements(ctx, blockTree.statementOrExpressions()));
    }

    private static void checkStatements(CheckContext ctx, List<Tree> statementsOrExpressions) {
        if (statementsOrExpressions.size() < 2) {
            return;
        }
        statementsOrExpressions.subList(0, statementsOrExpressions.size() - 1).stream().filter(tree -> tree instanceof JumpTree || tree instanceof ReturnTree || tree instanceof ThrowTree).forEach(tree -> ctx.reportIssue((HasTextRange)tree, String.format(MESSAGE, ((HasKeyword)((Object)tree)).keyword().text())));
    }
}

