/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.posttask;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.ce.posttask.Analysis;
import org.sonar.api.ce.posttask.Branch;
import org.sonar.api.ce.posttask.CeTask;
import org.sonar.api.ce.posttask.Organization;
import org.sonar.api.ce.posttask.PostProjectAnalysisTask;
import org.sonar.api.ce.posttask.Project;
import org.sonar.api.ce.posttask.QualityGate;
import org.sonar.api.ce.posttask.ScannerContext;

public class PostProjectAnalysisTaskTester {
    private static final String DATE_CAN_NOT_BE_NULL = "date cannot be null";
    private static final String PROJECT_CAN_NOT_BE_NULL = "project cannot be null";
    private static final String CE_TASK_CAN_NOT_BE_NULL = "ceTask cannot be null";
    private static final String STATUS_CAN_NOT_BE_NULL = "status cannot be null";
    private static final String SCANNER_CONTEXT_CAN_NOT_BE_NULL = "scannerContext cannot be null";
    private static final String KEY_CAN_NOT_BE_NULL = "key cannot be null";
    private static final String NAME_CAN_NOT_BE_NULL = "name cannot be null";
    private final PostProjectAnalysisTask underTest;
    @Nullable
    private Organization organization;
    @CheckForNull
    private CeTask ceTask;
    @CheckForNull
    private Project project;
    @CheckForNull
    private Date date;
    @CheckForNull
    private QualityGate qualityGate;
    @CheckForNull
    private Branch branch;
    private ScannerContext scannerContext;
    private String analysisUuid;

    private PostProjectAnalysisTaskTester(PostProjectAnalysisTask underTest) {
        this.underTest = Objects.requireNonNull(underTest, "PostProjectAnalysisTask instance cannot be null");
    }

    public static PostProjectAnalysisTaskTester of(PostProjectAnalysisTask underTest) {
        return new PostProjectAnalysisTaskTester(underTest);
    }

    public static OrganizationBuilder newOrganizationBuilder() {
        return new OrganizationBuilder();
    }

    public static CeTaskBuilder newCeTaskBuilder() {
        return new CeTaskBuilder();
    }

    public static ProjectBuilder newProjectBuilder() {
        return new ProjectBuilder();
    }

    public static BranchBuilder newBranchBuilder() {
        return new BranchBuilder();
    }

    public static QualityGateBuilder newQualityGateBuilder() {
        return new QualityGateBuilder();
    }

    public static ConditionBuilder newConditionBuilder() {
        return new ConditionBuilder();
    }

    public static ScannerContextBuilder newScannerContextBuilder() {
        return new ScannerContextBuilder();
    }

    public PostProjectAnalysisTaskTester withOrganization(@Nullable Organization organization) {
        this.organization = organization;
        return this;
    }

    public PostProjectAnalysisTaskTester withCeTask(CeTask ceTask) {
        this.ceTask = Objects.requireNonNull(ceTask, CE_TASK_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester withProject(Project project) {
        this.project = Objects.requireNonNull(project, PROJECT_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester withScannerContext(ScannerContext scannerContext) {
        this.scannerContext = Objects.requireNonNull(scannerContext, SCANNER_CONTEXT_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester at(Date date) {
        this.date = Objects.requireNonNull(date, DATE_CAN_NOT_BE_NULL);
        return this;
    }

    public PostProjectAnalysisTaskTester withQualityGate(@Nullable QualityGate qualityGate) {
        this.qualityGate = qualityGate;
        return this;
    }

    public PostProjectAnalysisTaskTester withBranch(@Nullable Branch b) {
        this.branch = b;
        return this;
    }

    public PostProjectAnalysisTaskTester withAnalysisUuid(@Nullable String analysisUuid) {
        this.analysisUuid = analysisUuid;
        return this;
    }

    public PostProjectAnalysisTask.ProjectAnalysis execute() {
        Objects.requireNonNull(this.ceTask, CE_TASK_CAN_NOT_BE_NULL);
        Objects.requireNonNull(this.project, PROJECT_CAN_NOT_BE_NULL);
        Objects.requireNonNull(this.date, DATE_CAN_NOT_BE_NULL);
        Analysis analysis = null;
        if (this.analysisUuid != null) {
            analysis = new AnalysisBuilder().setDate(this.date).setAnalysisUuid(this.analysisUuid).build();
        }
        PostProjectAnalysisTask.ProjectAnalysis projectAnalysis = new ProjectAnalysisBuilder().setOrganization(this.organization).setCeTask(this.ceTask).setProject(this.project).setBranch(this.branch).setQualityGate(this.qualityGate).setAnalysis(analysis).setScannerContext(this.scannerContext).setDate(this.date).build();
        this.underTest.finished(projectAnalysis);
        return projectAnalysis;
    }

    public static final class AnalysisBuilder {
        private String analysisUuid;
        private Date date;
        @Nullable
        private String revision;

        private AnalysisBuilder() {
        }

        public AnalysisBuilder setAnalysisUuid(String analysisUuid) {
            this.analysisUuid = analysisUuid;
            return this;
        }

        public AnalysisBuilder setDate(Date date) {
            this.date = date;
            return this;
        }

        public AnalysisBuilder setRevision(@Nullable String s) {
            this.revision = s;
            return this;
        }

        public Analysis build() {
            return new Analysis(){

                @Override
                public String getAnalysisUuid() {
                    return analysisUuid;
                }

                @Override
                public Date getDate() {
                    return date;
                }

                @Override
                public Optional<String> getRevision() {
                    return Optional.ofNullable(revision);
                }
            };
        }
    }

    public static final class ProjectAnalysisBuilder {
        private Organization organization;
        private CeTask ceTask;
        private Project project;
        private Branch branch;
        private QualityGate qualityGate;
        private Analysis analysis;
        private ScannerContext scannerContext;
        private Date date;

        private ProjectAnalysisBuilder() {
        }

        public ProjectAnalysisBuilder setOrganization(@Nullable Organization organization) {
            this.organization = organization;
            return this;
        }

        public ProjectAnalysisBuilder setCeTask(CeTask ceTask) {
            this.ceTask = ceTask;
            return this;
        }

        public ProjectAnalysisBuilder setProject(Project project) {
            this.project = project;
            return this;
        }

        public ProjectAnalysisBuilder setBranch(@Nullable Branch branch) {
            this.branch = branch;
            return this;
        }

        public ProjectAnalysisBuilder setQualityGate(QualityGate qualityGate) {
            this.qualityGate = qualityGate;
            return this;
        }

        public ProjectAnalysisBuilder setAnalysis(@Nullable Analysis analysis) {
            this.analysis = analysis;
            return this;
        }

        public ProjectAnalysisBuilder setScannerContext(ScannerContext scannerContext) {
            this.scannerContext = scannerContext;
            return this;
        }

        public ProjectAnalysisBuilder setDate(Date date) {
            this.date = date;
            return this;
        }

        public PostProjectAnalysisTask.ProjectAnalysis build() {
            return new PostProjectAnalysisTask.ProjectAnalysis(){

                @Override
                public Optional<Organization> getOrganization() {
                    return Optional.ofNullable(organization);
                }

                @Override
                public CeTask getCeTask() {
                    return ceTask;
                }

                @Override
                public Project getProject() {
                    return project;
                }

                @Override
                public Optional<Branch> getBranch() {
                    return Optional.ofNullable(branch);
                }

                @Override
                @CheckForNull
                public QualityGate getQualityGate() {
                    return qualityGate;
                }

                @Override
                public Date getDate() {
                    return date;
                }

                @Override
                public Optional<Date> getAnalysisDate() {
                    return this.getAnalysis().map(Analysis::getDate);
                }

                @Override
                public Optional<Analysis> getAnalysis() {
                    return Optional.ofNullable(analysis);
                }

                @Override
                public ScannerContext getScannerContext() {
                    return scannerContext;
                }

                @Override
                public String getScmRevisionId() {
                    return null;
                }

                public String toString() {
                    return "ProjectAnalysis{organization=" + organization + ", ceTask=" + ceTask + ", project=" + project + ", date=" + date.getTime() + ", analysisDate=" + date.getTime() + ", qualityGate=" + qualityGate + '}';
                }
            };
        }
    }

    public static final class ScannerContextBuilder {
        private final Map<String, String> properties = new HashMap<String, String>();

        private ScannerContextBuilder() {
        }

        public ScannerContextBuilder addProperties(Map<String, String> map) {
            this.properties.putAll(map);
            return this;
        }

        public ScannerContext build() {
            return () -> this.properties;
        }
    }

    public static final class ConditionBuilder {
        private static final String METRIC_KEY_CAN_NOT_BE_NULL = "metricKey cannot be null";
        private static final String OPERATOR_CAN_NOT_BE_NULL = "operator cannot be null";
        private static final String ERROR_THRESHOLD_CAN_NOT_BE_NULL = "errorThreshold cannot be null";
        private String metricKey;
        private QualityGate.Operator operator;
        private String errorThreshold;

        private ConditionBuilder() {
        }

        public ConditionBuilder setMetricKey(String metricKey) {
            this.metricKey = Objects.requireNonNull(metricKey, METRIC_KEY_CAN_NOT_BE_NULL);
            return this;
        }

        public ConditionBuilder setOperator(QualityGate.Operator operator) {
            this.operator = Objects.requireNonNull(operator, OPERATOR_CAN_NOT_BE_NULL);
            return this;
        }

        public ConditionBuilder setErrorThreshold(String errorThreshold) {
            this.errorThreshold = Objects.requireNonNull(errorThreshold, ERROR_THRESHOLD_CAN_NOT_BE_NULL);
            return this;
        }

        @Deprecated
        public ConditionBuilder setWarningThreshold(@Nullable String warningThreshold) {
            return this;
        }

        @Deprecated
        public ConditionBuilder setOnLeakPeriod(boolean onLeakPeriod) {
            return this;
        }

        public QualityGate.Condition buildNoValue() {
            this.checkCommonProperties();
            return new QualityGate.Condition(){

                @Override
                public QualityGate.EvaluationStatus getStatus() {
                    return QualityGate.EvaluationStatus.NO_VALUE;
                }

                @Override
                public String getMetricKey() {
                    return metricKey;
                }

                @Override
                public QualityGate.Operator getOperator() {
                    return operator;
                }

                @Override
                public String getErrorThreshold() {
                    return errorThreshold;
                }

                @Override
                @Deprecated
                public String getWarningThreshold() {
                    return null;
                }

                @Override
                @Deprecated
                public boolean isOnLeakPeriod() {
                    return false;
                }

                @Override
                public String getValue() {
                    throw new IllegalStateException("There is no value when status is NO_VALUE");
                }

                public String toString() {
                    return "Condition{status=" + (Object)((Object)QualityGate.EvaluationStatus.NO_VALUE) + ", metricKey='" + metricKey + '\'' + ", operator=" + (Object)((Object)operator) + ", errorThreshold='" + errorThreshold + '\'' + '}';
                }
            };
        }

        public QualityGate.Condition build(final QualityGate.EvaluationStatus status, final String value) {
            this.checkCommonProperties();
            Objects.requireNonNull(status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            Preconditions.checkArgument((status != QualityGate.EvaluationStatus.NO_VALUE ? 1 : 0) != 0, (Object)"status cannot be NO_VALUE, use method buildNoValue() instead");
            Objects.requireNonNull(value, "value cannot be null, use method buildNoValue() instead");
            return new QualityGate.Condition(){

                @Override
                public QualityGate.EvaluationStatus getStatus() {
                    return status;
                }

                @Override
                public String getMetricKey() {
                    return metricKey;
                }

                @Override
                public QualityGate.Operator getOperator() {
                    return operator;
                }

                @Override
                public String getErrorThreshold() {
                    return errorThreshold;
                }

                @Override
                @Deprecated
                public String getWarningThreshold() {
                    return null;
                }

                @Override
                @Deprecated
                public boolean isOnLeakPeriod() {
                    return false;
                }

                @Override
                public String getValue() {
                    return value;
                }

                public String toString() {
                    return "Condition{status=" + (Object)((Object)status) + ", metricKey='" + metricKey + '\'' + ", operator=" + (Object)((Object)operator) + ", errorThreshold='" + errorThreshold + '\'' + ", value='" + value + '\'' + '}';
                }
            };
        }

        private void checkCommonProperties() {
            Objects.requireNonNull(this.metricKey, METRIC_KEY_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.operator, OPERATOR_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.errorThreshold, ERROR_THRESHOLD_CAN_NOT_BE_NULL);
        }
    }

    public static final class QualityGateBuilder {
        private static final String ID_CAN_NOT_BE_NULL = "id cannot be null";
        private static final String NAME_CAN_NOT_BE_NULL = "name cannot be null";
        private String id;
        private String name;
        private QualityGate.Status status;
        private final List<QualityGate.Condition> conditions = new ArrayList<QualityGate.Condition>();

        private QualityGateBuilder() {
        }

        public QualityGateBuilder setId(String id) {
            this.id = Objects.requireNonNull(id, ID_CAN_NOT_BE_NULL);
            return this;
        }

        public QualityGateBuilder setName(String name) {
            this.name = Objects.requireNonNull(name, "name cannot be null");
            return this;
        }

        public QualityGateBuilder setStatus(QualityGate.Status status) {
            this.status = Objects.requireNonNull(status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return this;
        }

        public QualityGateBuilder add(QualityGate.Condition condition) {
            this.conditions.add(Objects.requireNonNull(condition, "condition cannot be null"));
            return this;
        }

        public QualityGateBuilder clearConditions() {
            this.conditions.clear();
            return this;
        }

        public QualityGate build() {
            Objects.requireNonNull(this.id, ID_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.name, "name cannot be null");
            Objects.requireNonNull(this.status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return new QualityGate(){

                @Override
                public String getId() {
                    return id;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public QualityGate.Status getStatus() {
                    return status;
                }

                @Override
                public Collection<QualityGate.Condition> getConditions() {
                    return conditions;
                }

                public String toString() {
                    return "QualityGate{id='" + id + '\'' + ", name='" + name + '\'' + ", status=" + (Object)((Object)status) + ", conditions=" + conditions + '}';
                }
            };
        }
    }

    public static final class BranchBuilder {
        private boolean isMain = true;
        private String name = null;
        private Branch.Type type = Branch.Type.LONG;

        private BranchBuilder() {
        }

        public BranchBuilder setName(@Nullable String s) {
            this.name = s;
            return this;
        }

        public BranchBuilder setType(Branch.Type t) {
            this.type = Objects.requireNonNull(t);
            return this;
        }

        public BranchBuilder setIsMain(boolean b) {
            this.isMain = b;
            return this;
        }

        public Branch build() {
            return new Branch(){

                @Override
                public boolean isMain() {
                    return isMain;
                }

                @Override
                public Optional<String> getName() {
                    return Optional.ofNullable(name);
                }

                @Override
                public Branch.Type getType() {
                    return type;
                }
            };
        }
    }

    public static final class ProjectBuilder {
        private static final String UUID_CAN_NOT_BE_NULL = "uuid cannot be null";
        private String uuid;
        private String key;
        private String name;

        private ProjectBuilder() {
        }

        public ProjectBuilder setUuid(String uuid) {
            this.uuid = Objects.requireNonNull(uuid, UUID_CAN_NOT_BE_NULL);
            return this;
        }

        public ProjectBuilder setKey(String key) {
            this.key = Objects.requireNonNull(key, PostProjectAnalysisTaskTester.KEY_CAN_NOT_BE_NULL);
            return this;
        }

        public ProjectBuilder setName(String name) {
            this.name = Objects.requireNonNull(name, PostProjectAnalysisTaskTester.NAME_CAN_NOT_BE_NULL);
            return this;
        }

        public Project build() {
            Objects.requireNonNull(this.uuid, UUID_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.key, PostProjectAnalysisTaskTester.KEY_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.name, PostProjectAnalysisTaskTester.NAME_CAN_NOT_BE_NULL);
            return new Project(){

                @Override
                public String getUuid() {
                    return uuid;
                }

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public String getName() {
                    return name;
                }

                public String toString() {
                    return "Project{uuid='" + uuid + '\'' + ", key='" + key + '\'' + ", name='" + name + '\'' + '}';
                }
            };
        }
    }

    public static final class CeTaskBuilder {
        private static final String ID_CAN_NOT_BE_NULL = "id cannot be null";
        @CheckForNull
        private String id;
        @CheckForNull
        private CeTask.Status status;

        private CeTaskBuilder() {
        }

        public CeTaskBuilder setId(String id) {
            this.id = Objects.requireNonNull(id, ID_CAN_NOT_BE_NULL);
            return this;
        }

        public CeTaskBuilder setStatus(CeTask.Status status) {
            this.status = Objects.requireNonNull(status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return this;
        }

        public CeTask build() {
            Objects.requireNonNull(this.id, ID_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.status, PostProjectAnalysisTaskTester.STATUS_CAN_NOT_BE_NULL);
            return new CeTask(){

                @Override
                public String getId() {
                    return id;
                }

                @Override
                public CeTask.Status getStatus() {
                    return status;
                }

                public String toString() {
                    return "CeTask{id='" + id + '\'' + ", status=" + (Object)((Object)status) + '}';
                }
            };
        }
    }

    public static final class OrganizationBuilder {
        @CheckForNull
        private String name;
        @CheckForNull
        private String key;

        private OrganizationBuilder() {
        }

        public OrganizationBuilder setName(String name) {
            this.name = Objects.requireNonNull(name, PostProjectAnalysisTaskTester.NAME_CAN_NOT_BE_NULL);
            return this;
        }

        public OrganizationBuilder setKey(String key) {
            this.key = Objects.requireNonNull(key, PostProjectAnalysisTaskTester.KEY_CAN_NOT_BE_NULL);
            return this;
        }

        public Organization build() {
            Objects.requireNonNull(this.name, PostProjectAnalysisTaskTester.NAME_CAN_NOT_BE_NULL);
            Objects.requireNonNull(this.key, PostProjectAnalysisTaskTester.KEY_CAN_NOT_BE_NULL);
            return new Organization(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getKey() {
                    return key;
                }

                public String toString() {
                    return "Organization{name='" + name + '\'' + ", key='" + key + '\'' + '}';
                }
            };
        }
    }
}

