/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import java.util.regex.Pattern;
import org.sonar.db.WildcardPosition;

public class DaoUtils {
    private static final Pattern ESCAPE_PERCENT_AND_UNDERSCORE = Pattern.compile("[/%_]");

    private DaoUtils() {
    }

    public static String buildLikeValue(String value, WildcardPosition wildcardPosition) {
        String escapedValue = DaoUtils.escapePercentAndUnderscore(value);
        String wildcard = "%";
        switch (wildcardPosition) {
            case BEFORE: {
                escapedValue = wildcard + escapedValue;
                break;
            }
            case AFTER: {
                escapedValue = escapedValue + wildcard;
                break;
            }
            case BEFORE_AND_AFTER: {
                escapedValue = wildcard + escapedValue + wildcard;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled WildcardPosition: " + (Object)((Object)wildcardPosition));
            }
        }
        return escapedValue;
    }

    private static String escapePercentAndUnderscore(String value) {
        return ESCAPE_PERCENT_AND_UNDERSCORE.matcher(value).replaceAll("/$0");
    }
}

