/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.InputStream;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.LocalCacheScope;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Database;
import org.sonar.db.SQXMLMapperBuilder;
import org.sonar.db.dialect.Dialect;

class MyBatisConfBuilder {
    private final Configuration conf = new Configuration();

    MyBatisConfBuilder(Database database) {
        this.conf.setEnvironment(new Environment("production", (TransactionFactory)MyBatisConfBuilder.createTransactionFactory(), database.getDataSource()));
        this.conf.setUseGeneratedKeys(true);
        this.conf.setLazyLoadingEnabled(false);
        this.conf.setJdbcTypeForNull(JdbcType.NULL);
        Dialect dialect = database.getDialect();
        this.conf.setDatabaseId(dialect.getId());
        this.conf.getVariables().setProperty("_true", dialect.getTrueSqlValue());
        this.conf.getVariables().setProperty("_false", dialect.getFalseSqlValue());
        this.conf.getVariables().setProperty("_from_dual", dialect.getSqlFromDual());
        this.conf.getVariables().setProperty("_scrollFetchSize", String.valueOf(dialect.getScrollDefaultFetchSize()));
        this.conf.setLocalCacheScope(LocalCacheScope.STATEMENT);
    }

    void loadAlias(String alias, Class dtoClass) {
        this.conf.getTypeAliasRegistry().registerAlias(alias, dtoClass);
    }

    void loadMapper(Class mapperClass) {
        String configFile = MyBatisConfBuilder.configFilePath(mapperClass);
        InputStream input = null;
        try {
            input = mapperClass.getResourceAsStream(configFile);
            Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)String.format("Can not find mapper XML file %s", configFile));
            new SQXMLMapperBuilder(mapperClass, input, this.conf, this.conf.getSqlFragments()).parse();
            this.loadAndConfigureLogger(mapperClass.getName());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load mapper " + mapperClass, e);
        }
        finally {
            Closeables.closeQuietly((InputStream)input);
        }
    }

    private static String configFilePath(Class mapperClass) {
        return MyBatisConfBuilder.configFilePath(mapperClass.getName());
    }

    private static String configFilePath(String mapperName) {
        return "/" + mapperName.replace('.', '/') + ".xml";
    }

    private void loadAndConfigureLogger(String mapperName) {
        this.conf.addLoadedResource(mapperName);
        Loggers.get((String)mapperName).setLevel(LoggerLevel.INFO);
    }

    void loadMappers(Class<?> ... mapperClasses) {
        for (Class<?> mapperClass : mapperClasses) {
            this.loadMapper(mapperClass);
        }
    }

    public Configuration build() {
        return this.conf;
    }

    private static JdbcTransactionFactory createTransactionFactory() {
        return new JdbcTransactionFactory();
    }
}

