/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentQuery;
import org.sonar.db.component.ComponentTreeQuery;
import org.sonar.db.component.ComponentUpdateDto;
import org.sonar.db.component.ComponentWithModuleUuidDto;
import org.sonar.db.component.FileMoveRowDto;
import org.sonar.db.component.FilePathWithHashDto;
import org.sonar.db.component.KeyWithUuidDto;
import org.sonar.db.component.ProjectNclocDistributionDto;
import org.sonar.db.component.UuidWithProjectUuidDto;

public interface ComponentMapper {
    @CheckForNull
    public ComponentDto selectByKey(String var1);

    @CheckForNull
    public ComponentDto selectBranchByKeyAndBranchKey(@Param(value="key") String var1, @Param(value="dbKey") String var2, @Param(value="branch") String var3);

    @CheckForNull
    public ComponentDto selectPrByKeyAndBranchKey(@Param(value="key") String var1, @Param(value="dbKey") String var2, @Param(value="branch") String var3);

    @CheckForNull
    public ComponentDto selectById(long var1);

    @CheckForNull
    public ComponentDto selectByUuid(String var1);

    @CheckForNull
    public ComponentDto selectByAlmIdAndAlmRepositoryId(@Param(value="almId") String var1, @Param(value="almRepositoryId") String var2);

    public List<ComponentDto> selectSubProjectsByComponentUuids(@Param(value="uuids") Collection<String> var1);

    public List<ComponentDto> selectByKeys(@Param(value="keys") Collection<String> var1);

    public List<ComponentDto> selectByDbKeys(@Param(value="dbKeys") Collection<String> var1);

    public List<ComponentDto> selectByKeysAndBranch(@Param(value="keys") Collection<String> var1, @Param(value="branch") String var2);

    public List<ComponentDto> selectByIds(@Param(value="ids") Collection<Long> var1);

    public List<ComponentDto> selectByUuids(@Param(value="uuids") Collection<String> var1);

    public List<ComponentDto> selectByProjectUuid(@Param(value="projectUuid") String var1);

    public List<String> selectExistingUuids(@Param(value="uuids") Collection<String> var1);

    public List<ComponentDto> selectComponentsByQualifiers(@Param(value="qualifiers") Collection<String> var1);

    public int countEnabledModulesByProjectUuid(@Param(value="projectUuid") String var1);

    public int countComponentByOrganizationAndId(@Param(value="organizationUuid") String var1, @Param(value="componentId") long var2);

    public List<ComponentDto> selectByQuery(@Nullable @Param(value="organizationUuid") String var1, @Param(value="query") ComponentQuery var2, RowBounds var3);

    public int countByQuery(@Nullable @Param(value="organizationUuid") String var1, @Param(value="query") ComponentQuery var2);

    public List<ComponentDto> selectDescendants(@Param(value="query") ComponentTreeQuery var1, @Param(value="baseUuid") String var2, @Param(value="baseUuidPath") String var3);

    public List<ComponentDto> selectProjects();

    public List<ComponentDto> selectProjectsByOrganization(@Param(value="organizationUuid") String var1);

    public List<ComponentDto> selectDescendantModules(@Param(value="moduleUuid") String var1, @Param(value="scope") String var2, @Param(value="excludeDisabled") boolean var3);

    public List<FilePathWithHashDto> selectEnabledFilesFromProject(@Param(value="projectUuid") String var1);

    public List<FilePathWithHashDto> selectDescendantFiles(@Param(value="moduleUuid") String var1, @Param(value="scope") String var2, @Param(value="excludeDisabled") boolean var3);

    public List<UuidWithProjectUuidDto> selectUuidsForQualifiers(String ... var1);

    public List<ComponentDto> selectComponentsFromProjectKeyAndScope(@Param(value="projectKey") String var1, @Nullable @Param(value="scope") String var2, @Param(value="excludeDisabled") boolean var3);

    public List<KeyWithUuidDto> selectUuidsByKeyFromProjectKey(@Param(value="projectKey") String var1);

    public Set<String> selectViewKeysWithEnabledCopyOfProject(@Param(value="projectUuids") Collection<String> var1);

    public List<String> selectProjectsFromView(@Param(value="viewUuidLikeQuery") String var1, @Param(value="projectViewUuid") String var2);

    public List<ComponentDto> selectGhostProjects(@Param(value="organizationUuid") String var1, @Nullable @Param(value="query") String var2, RowBounds var3);

    public long countGhostProjects(@Param(value="organizationUuid") String var1, @Nullable @Param(value="query") String var2);

    public List<ComponentDto> selectComponentsHavingSameKeyOrderedById(String var1);

    public List<ComponentDto> selectProjectsByNameQuery(@Param(value="nameQuery") @Nullable String var1, @Param(value="includeModules") boolean var2);

    public void scrollForIndexing(@Param(value="projectUuid") @Nullable String var1, ResultHandler<ComponentDto> var2);

    public void scrollAllFilesForFileMove(@Param(value="projectUuid") String var1, ResultHandler<FileMoveRowDto> var2);

    public void insert(ComponentDto var1);

    public void update(ComponentUpdateDto var1);

    public void updateBEnabledToFalse(@Param(value="uuids") List<String> var1);

    public void applyBChangesForRootComponentUuid(@Param(value="projectUuid") String var1);

    public void resetBChangedForRootComponentUuid(@Param(value="projectUuid") String var1);

    public void setPrivateForRootComponentUuid(@Param(value="projectUuid") String var1, @Param(value="isPrivate") boolean var2);

    public void delete(long var1);

    public void updateTags(ComponentDto var1);

    public List<KeyWithUuidDto> selectAllSiblingComponentKeysHavingOpenIssues(@Param(value="referenceBranchUuid") String var1, @Param(value="currentBranchUuid") String var2);

    public List<ProjectNclocDistributionDto> selectPrivateProjectsWithNcloc(@Param(value="organizationUuid") String var1);

    public List<ComponentWithModuleUuidDto> selectEnabledComponentsWithModuleUuidFromProjectKey(String var1);
}

