/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge.period;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.db.purge.PurgeableAnalysisDto;

final class Interval {
    List<PurgeableAnalysisDto> snapshots = Lists.newArrayList();

    Interval() {
    }

    void add(PurgeableAnalysisDto snapshot) {
        this.snapshots.add(snapshot);
    }

    List<PurgeableAnalysisDto> get() {
        return this.snapshots;
    }

    int count() {
        return this.snapshots.size();
    }

    static List<Interval> group(List<PurgeableAnalysisDto> snapshots, Date start, Date end, int calendarField) {
        ArrayList intervals = Lists.newArrayList();
        GregorianCalendar calendar = new GregorianCalendar();
        int lastYear = -1;
        int lastFieldValue = -1;
        Interval currentInterval = null;
        for (PurgeableAnalysisDto snapshot : snapshots) {
            if (DateUtils.isSameDay((Date)start, (Date)snapshot.getDate()) || !snapshot.getDate().after(start) || !snapshot.getDate().before(end) && !DateUtils.isSameDay((Date)end, (Date)snapshot.getDate())) continue;
            calendar.setTime(snapshot.getDate());
            int currentFieldValue = calendar.get(calendarField);
            int currentYear = calendar.get(1);
            if (lastYear != currentYear || lastFieldValue != currentFieldValue) {
                currentInterval = new Interval();
                intervals.add(currentInterval);
            }
            lastFieldValue = currentFieldValue;
            lastYear = currentYear;
            if (currentInterval == null) continue;
            currentInterval.add(snapshot);
        }
        return intervals;
    }
}

