/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.cleaning;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.CeDistributedInformation;
import org.sonar.ce.cleaning.CeCleaningExecutorService;
import org.sonar.ce.cleaning.CeCleaningScheduler;
import org.sonar.ce.configuration.CeConfiguration;
import org.sonar.ce.queue.InternalCeQueue;

public class CeCleaningSchedulerImpl
implements CeCleaningScheduler {
    private static final Logger LOG = Loggers.get(CeCleaningSchedulerImpl.class);
    private final CeCleaningExecutorService executorService;
    private final CeConfiguration ceConfiguration;
    private final InternalCeQueue internalCeQueue;
    private final CeDistributedInformation ceDistributedInformation;

    public CeCleaningSchedulerImpl(CeCleaningExecutorService executorService, CeConfiguration ceConfiguration, InternalCeQueue internalCeQueue, CeDistributedInformation ceDistributedInformation) {
        this.executorService = executorService;
        this.internalCeQueue = internalCeQueue;
        this.ceConfiguration = ceConfiguration;
        this.ceDistributedInformation = ceDistributedInformation;
    }

    @Override
    public void startScheduling() {
        this.executorService.scheduleWithFixedDelay(this::cleanCeQueue, this.ceConfiguration.getCleanTasksInitialDelay(), this.ceConfiguration.getCleanTasksDelay(), TimeUnit.MINUTES);
    }

    private void cleanCeQueue() {
        Lock ceCleaningJobLock = this.ceDistributedInformation.acquireCleanJobLock();
        if (ceCleaningJobLock.tryLock()) {
            try {
                this.resetTasksWithUnknownWorkerUUIDs();
                this.cancelWornOuts();
            }
            finally {
                ceCleaningJobLock.unlock();
            }
        }
    }

    private void resetTasksWithUnknownWorkerUUIDs() {
        try {
            LOG.trace("Resetting state of tasks with unknown worker UUIDs");
            this.internalCeQueue.resetTasksWithUnknownWorkerUUIDs(this.ceDistributedInformation.getWorkerUUIDs());
        }
        catch (Exception e) {
            LOG.warn("Failed to reset tasks with unknown worker UUIDs", (Throwable)e);
        }
    }

    private void cancelWornOuts() {
        try {
            LOG.trace("Cancelling any worn out task");
            this.internalCeQueue.cancelWornOuts();
        }
        catch (Exception e) {
            LOG.warn("Failed to cancel worn out tasks", (Throwable)e);
        }
    }
}

