/* eslint-env jest */
/**
 * @fileoverview Enforce iframe elements have a title attribute.
 * @author Ethan Cohen
 */

// -----------------------------------------------------------------------------
// Requirements
// -----------------------------------------------------------------------------

import { RuleTester } from 'eslint';
import parserOptionsMapper from '../../__util__/parserOptionsMapper';
import rule from '../../../src/rules/iframe-has-title';

// -----------------------------------------------------------------------------
// Tests
// -----------------------------------------------------------------------------

const ruleTester = new RuleTester();

const expectedError = {
  message: '<iframe> elements must have a unique title property.',
  type: 'JSXOpeningElement',
};

ruleTester.run('html-has-lang', rule, {
  valid: [
    { code: '<div />;' },
    { code: '<iframe title="Unique title" />' },
    { code: '<iframe title={foo} />' },
    { code: '<FooComponent />' },
  ].map(parserOptionsMapper),
  invalid: [
    { code: '<iframe />', errors: [expectedError] },
    { code: '<iframe {...props} />', errors: [expectedError] },
    { code: '<iframe title={undefined} />', errors: [expectedError] },
    { code: '<iframe title="" />', errors: [expectedError] },
    { code: '<iframe title={false} />', errors: [expectedError] },
    { code: '<iframe title={true} />', errors: [expectedError] },
    { code: "<iframe title={''} />", errors: [expectedError] },
    { code: '<iframe title={``} />', errors: [expectedError] },
    { code: '<iframe title={""} />', errors: [expectedError] },
    { code: '<iframe title={42} />', errors: [expectedError] },
  ].map(parserOptionsMapper),
});
