; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -force-streaming-compatible-sve < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; SDIV
;

define <4 x i8> @sdiv_v4i8(<4 x i8> %op1, <4 x i8> %op2) #0 {
; CHECK-LABEL: sdiv_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    lsl z1.h, p0/m, z1.h, #8
; CHECK-NEXT:    lsl z0.h, p0/m, z0.h, #8
; CHECK-NEXT:    asr z1.h, p0/m, z1.h, #8
; CHECK-NEXT:    asr z0.h, p0/m, z0.h, #8
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <4 x i8> %op1, %op2
  ret <4 x i8> %res
}

define <8 x i8> @sdiv_v8i8(<8 x i8> %op1, <8 x i8> %op2) #0 {
; CHECK-LABEL: sdiv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sunpklo z1.h, z1.b
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    sunpklo z2.s, z1.h
; CHECK-NEXT:    sunpklo z3.s, z0.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sdivr z2.s, p0/m, z2.s, z3.s
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    splice z2.h, p0, z2.h, z0.h
; CHECK-NEXT:    uzp1 z0.b, z2.b, z2.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <8 x i8> %op1, %op2
  ret <8 x i8> %res
}

define <16 x i8> @sdiv_v16i8(<16 x i8> %op1, <16 x i8> %op2) #0 {
; CHECK-LABEL: sdiv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z2.d, z1.d
; CHECK-NEXT:    mov z3.d, z0.d
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    sunpklo z2.h, z2.b
; CHECK-NEXT:    sunpklo z3.h, z3.b
; CHECK-NEXT:    sunpklo z4.s, z2.h
; CHECK-NEXT:    sunpklo z5.s, z3.h
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sunpklo z1.h, z1.b
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    sunpklo z2.s, z2.h
; CHECK-NEXT:    sunpklo z3.s, z3.h
; CHECK-NEXT:    sdivr z4.s, p0/m, z4.s, z5.s
; CHECK-NEXT:    sunpklo z5.s, z1.h
; CHECK-NEXT:    sdivr z2.s, p0/m, z2.s, z3.s
; CHECK-NEXT:    sunpklo z3.s, z0.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    splice z4.h, p1, z4.h, z2.h
; CHECK-NEXT:    movprfx z2, z3
; CHECK-NEXT:    sdiv z2.s, p0/m, z2.s, z5.s
; CHECK-NEXT:    uzp1 z1.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z2.b, z4.b, z4.b
; CHECK-NEXT:    splice z1.h, p1, z1.h, z0.h
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    uzp1 z0.b, z1.b, z1.b
; CHECK-NEXT:    splice z0.b, p0, z0.b, z2.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <16 x i8> %op1, %op2
  ret <16 x i8> %res
}

define void @sdiv_v32i8(ptr %a, ptr %b) #0 {
; CHECK-LABEL: sdiv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    ptrue p2.b, vl8
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    mov z5.d, z2.d
; CHECK-NEXT:    sunpklo z2.h, z2.b
; CHECK-NEXT:    ext z5.b, z5.b, z5.b, #8
; CHECK-NEXT:    sunpklo z5.h, z5.b
; CHECK-NEXT:    sunpklo z7.s, z5.h
; CHECK-NEXT:    ext z5.b, z5.b, z5.b, #8
; CHECK-NEXT:    sunpklo z5.s, z5.h
; CHECK-NEXT:    mov z4.d, z3.d
; CHECK-NEXT:    sunpklo z3.h, z3.b
; CHECK-NEXT:    ext z4.b, z4.b, z4.b, #8
; CHECK-NEXT:    sunpklo z4.h, z4.b
; CHECK-NEXT:    sunpklo z6.s, z4.h
; CHECK-NEXT:    ext z4.b, z4.b, z4.b, #8
; CHECK-NEXT:    sunpklo z4.s, z4.h
; CHECK-NEXT:    sdivr z6.s, p0/m, z6.s, z7.s
; CHECK-NEXT:    sdivr z4.s, p0/m, z4.s, z5.s
; CHECK-NEXT:    sunpklo z7.s, z3.h
; CHECK-NEXT:    sunpklo z5.s, z2.h
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    uzp1 z6.h, z6.h, z6.h
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    sunpklo z3.s, z3.h
; CHECK-NEXT:    splice z6.h, p1, z6.h, z4.h
; CHECK-NEXT:    sunpklo z2.s, z2.h
; CHECK-NEXT:    uzp1 z4.b, z6.b, z6.b
; CHECK-NEXT:    sdiv z5.s, p0/m, z5.s, z7.s
; CHECK-NEXT:    sdiv z2.s, p0/m, z2.s, z3.s
; CHECK-NEXT:    sunpklo z3.h, z1.b
; CHECK-NEXT:    sunpklo z6.h, z0.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uzp1 z5.h, z5.h, z5.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    sunpklo z1.h, z1.b
; CHECK-NEXT:    sunpklo z0.h, z0.b
; CHECK-NEXT:    splice z5.h, p1, z5.h, z2.h
; CHECK-NEXT:    sunpklo z2.s, z1.h
; CHECK-NEXT:    sunpklo z7.s, z0.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sdivr z2.s, p0/m, z2.s, z7.s
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uzp1 z1.h, z2.h, z2.h
; CHECK-NEXT:    sunpklo z2.s, z3.h
; CHECK-NEXT:    sunpklo z7.s, z6.h
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    ext z6.b, z6.b, z6.b, #8
; CHECK-NEXT:    sunpklo z3.s, z3.h
; CHECK-NEXT:    sunpklo z6.s, z6.h
; CHECK-NEXT:    sdivr z2.s, p0/m, z2.s, z7.s
; CHECK-NEXT:    sdivr z3.s, p0/m, z3.s, z6.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    splice z1.h, p1, z1.h, z0.h
; CHECK-NEXT:    splice z2.h, p1, z2.h, z3.h
; CHECK-NEXT:    uzp1 z0.b, z1.b, z1.b
; CHECK-NEXT:    uzp1 z1.b, z2.b, z2.b
; CHECK-NEXT:    uzp1 z2.b, z5.b, z5.b
; CHECK-NEXT:    splice z1.b, p2, z1.b, z0.b
; CHECK-NEXT:    splice z2.b, p2, z2.b, z4.b
; CHECK-NEXT:    stp q1, q2, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = sdiv <32 x i8> %op1, %op2
  store <32 x i8> %res, ptr %a
  ret void
}

define <2 x i16> @sdiv_v2i16(<2 x i16> %op1, <2 x i16> %op2) #0 {
; CHECK-LABEL: sdiv_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    lsl z1.s, p0/m, z1.s, #16
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, #16
; CHECK-NEXT:    asr z1.s, p0/m, z1.s, #16
; CHECK-NEXT:    asr z0.s, p0/m, z0.s, #16
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <2 x i16> %op1, %op2
  ret <2 x i16> %res
}

define <4 x i16> @sdiv_v4i16(<4 x i16> %op1, <4 x i16> %op2) #0 {
; CHECK-LABEL: sdiv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <4 x i16> %op1, %op2
  ret <4 x i16> %res
}

define <8 x i16> @sdiv_v8i16(<8 x i16> %op1, <8 x i16> %op2) #0 {
; CHECK-LABEL: sdiv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z2.d, z1.d
; CHECK-NEXT:    mov z3.d, z0.d
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    ext z3.b, z3.b, z0.b, #8
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z2.s, z2.h
; CHECK-NEXT:    sunpklo z3.s, z3.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sdivr z2.s, p0/m, z2.s, z3.s
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uzp1 z1.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <8 x i16> %op1, %op2
  ret <8 x i16> %res
}

define void @sdiv_v16i16(ptr %a, ptr %b) #0 {
; CHECK-LABEL: sdiv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q3, q0, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    sunpklo z6.s, z3.h
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    sunpklo z4.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z7.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z5.s, z2.h
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    sunpklo z2.s, z2.h
; CHECK-NEXT:    sdivr z4.s, p0/m, z4.s, z5.s
; CHECK-NEXT:    sdivr z0.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    sunpklo z2.s, z3.h
; CHECK-NEXT:    sdiv z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    movprfx z2, z7
; CHECK-NEXT:    sdiv z2.s, p0/m, z2.s, z6.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z3.h, z4.h, z4.h
; CHECK-NEXT:    splice z2.h, p1, z2.h, z1.h
; CHECK-NEXT:    splice z3.h, p1, z3.h, z0.h
; CHECK-NEXT:    stp q2, q3, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = sdiv <16 x i16> %op1, %op2
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @sdiv_v2i32(<2 x i32> %op1, <2 x i32> %op2) #0 {
; CHECK-LABEL: sdiv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <2 x i32> %op1, %op2
  ret <2 x i32> %res
}

define <4 x i32> @sdiv_v4i32(<4 x i32> %op1, <4 x i32> %op2) #0 {
; CHECK-LABEL: sdiv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <4 x i32> %op1, %op2
  ret <4 x i32> %res
}

define void @sdiv_v8i32(ptr %a, ptr %b)  #0 {
; CHECK-LABEL: sdiv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    sdiv z0.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    sdiv z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = sdiv <8 x i32> %op1, %op2
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @sdiv_v1i64(<1 x i64> %op1, <1 x i64> %op2) #0 {
; CHECK-LABEL: sdiv_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    sdiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <1 x i64> %op1, %op2
  ret <1 x i64> %res
}

define <2 x i64> @sdiv_v2i64(<2 x i64> %op1, <2 x i64> %op2) #0 {
; CHECK-LABEL: sdiv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    sdiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <2 x i64> %op1, %op2
  ret <2 x i64> %res
}

define void @sdiv_v4i64(ptr %a, ptr %b)  #0 {
; CHECK-LABEL: sdiv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    sdiv z0.d, p0/m, z0.d, z2.d
; CHECK-NEXT:    sdiv z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = sdiv <4 x i64> %op1, %op2
  store <4 x i64> %res, ptr %a
  ret void
}

;
; UDIV
;

define <4 x i8> @udiv_v4i8(<4 x i8> %op1, <4 x i8> %op2) #0 {
; CHECK-LABEL: udiv_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    and z0.h, z0.h, #0xff
; CHECK-NEXT:    and z1.h, z1.h, #0xff
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = udiv <4 x i8> %op1, %op2
  ret <4 x i8> %res
}

define <8 x i8> @udiv_v8i8(<8 x i8> %op1, <8 x i8> %op2) #0 {
; CHECK-LABEL: udiv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z1.h, z1.b
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z2.s, z1.h
; CHECK-NEXT:    uunpklo z3.s, z0.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    udivr z2.s, p0/m, z2.s, z3.s
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    splice z2.h, p0, z2.h, z0.h
; CHECK-NEXT:    uzp1 z0.b, z2.b, z2.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = udiv <8 x i8> %op1, %op2
  ret <8 x i8> %res
}

define <16 x i8> @udiv_v16i8(<16 x i8> %op1, <16 x i8> %op2) #0 {
; CHECK-LABEL: udiv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z2.d, z1.d
; CHECK-NEXT:    mov z3.d, z0.d
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    uunpklo z2.h, z2.b
; CHECK-NEXT:    uunpklo z3.h, z3.b
; CHECK-NEXT:    uunpklo z4.s, z2.h
; CHECK-NEXT:    uunpklo z5.s, z3.h
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z1.h, z1.b
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    uunpklo z2.s, z2.h
; CHECK-NEXT:    uunpklo z3.s, z3.h
; CHECK-NEXT:    udivr z4.s, p0/m, z4.s, z5.s
; CHECK-NEXT:    uunpklo z5.s, z1.h
; CHECK-NEXT:    udivr z2.s, p0/m, z2.s, z3.s
; CHECK-NEXT:    uunpklo z3.s, z0.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    splice z4.h, p1, z4.h, z2.h
; CHECK-NEXT:    movprfx z2, z3
; CHECK-NEXT:    udiv z2.s, p0/m, z2.s, z5.s
; CHECK-NEXT:    uzp1 z1.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z2.b, z4.b, z4.b
; CHECK-NEXT:    splice z1.h, p1, z1.h, z0.h
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    uzp1 z0.b, z1.b, z1.b
; CHECK-NEXT:    splice z0.b, p0, z0.b, z2.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = udiv <16 x i8> %op1, %op2
  ret <16 x i8> %res
}

define void @udiv_v32i8(ptr %a, ptr %b) #0 {
; CHECK-LABEL: udiv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    ptrue p2.b, vl8
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    mov z5.d, z2.d
; CHECK-NEXT:    uunpklo z2.h, z2.b
; CHECK-NEXT:    ext z5.b, z5.b, z5.b, #8
; CHECK-NEXT:    uunpklo z5.h, z5.b
; CHECK-NEXT:    uunpklo z7.s, z5.h
; CHECK-NEXT:    ext z5.b, z5.b, z5.b, #8
; CHECK-NEXT:    uunpklo z5.s, z5.h
; CHECK-NEXT:    mov z4.d, z3.d
; CHECK-NEXT:    uunpklo z3.h, z3.b
; CHECK-NEXT:    ext z4.b, z4.b, z4.b, #8
; CHECK-NEXT:    uunpklo z4.h, z4.b
; CHECK-NEXT:    uunpklo z6.s, z4.h
; CHECK-NEXT:    ext z4.b, z4.b, z4.b, #8
; CHECK-NEXT:    uunpklo z4.s, z4.h
; CHECK-NEXT:    udivr z6.s, p0/m, z6.s, z7.s
; CHECK-NEXT:    udivr z4.s, p0/m, z4.s, z5.s
; CHECK-NEXT:    uunpklo z7.s, z3.h
; CHECK-NEXT:    uunpklo z5.s, z2.h
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    uzp1 z6.h, z6.h, z6.h
; CHECK-NEXT:    uzp1 z4.h, z4.h, z4.h
; CHECK-NEXT:    uunpklo z3.s, z3.h
; CHECK-NEXT:    splice z6.h, p1, z6.h, z4.h
; CHECK-NEXT:    uunpklo z2.s, z2.h
; CHECK-NEXT:    uzp1 z4.b, z6.b, z6.b
; CHECK-NEXT:    udiv z5.s, p0/m, z5.s, z7.s
; CHECK-NEXT:    udiv z2.s, p0/m, z2.s, z3.s
; CHECK-NEXT:    uunpklo z3.h, z1.b
; CHECK-NEXT:    uunpklo z6.h, z0.b
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uzp1 z5.h, z5.h, z5.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uunpklo z1.h, z1.b
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    splice z5.h, p1, z5.h, z2.h
; CHECK-NEXT:    uunpklo z2.s, z1.h
; CHECK-NEXT:    uunpklo z7.s, z0.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    udivr z2.s, p0/m, z2.s, z7.s
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uzp1 z1.h, z2.h, z2.h
; CHECK-NEXT:    uunpklo z2.s, z3.h
; CHECK-NEXT:    uunpklo z7.s, z6.h
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    ext z6.b, z6.b, z6.b, #8
; CHECK-NEXT:    uunpklo z3.s, z3.h
; CHECK-NEXT:    uunpklo z6.s, z6.h
; CHECK-NEXT:    udivr z2.s, p0/m, z2.s, z7.s
; CHECK-NEXT:    udivr z3.s, p0/m, z3.s, z6.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    splice z1.h, p1, z1.h, z0.h
; CHECK-NEXT:    splice z2.h, p1, z2.h, z3.h
; CHECK-NEXT:    uzp1 z0.b, z1.b, z1.b
; CHECK-NEXT:    uzp1 z1.b, z2.b, z2.b
; CHECK-NEXT:    uzp1 z2.b, z5.b, z5.b
; CHECK-NEXT:    splice z1.b, p2, z1.b, z0.b
; CHECK-NEXT:    splice z2.b, p2, z2.b, z4.b
; CHECK-NEXT:    stp q1, q2, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = udiv <32 x i8> %op1, %op2
  store <32 x i8> %res, ptr %a
  ret void
}

define <2 x i16> @udiv_v2i16(<2 x i16> %op1, <2 x i16> %op2) #0 {
; CHECK-LABEL: udiv_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    and z1.s, z1.s, #0xffff
; CHECK-NEXT:    and z0.s, z0.s, #0xffff
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = udiv <2 x i16> %op1, %op2
  ret <2 x i16> %res
}

define <4 x i16> @udiv_v4i16(<4 x i16> %op1, <4 x i16> %op2) #0 {
; CHECK-LABEL: udiv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = udiv <4 x i16> %op1, %op2
  ret <4 x i16> %res
}

define <8 x i16> @udiv_v8i16(<8 x i16> %op1, <8 x i16> %op2) #0 {
; CHECK-LABEL: udiv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z2.d, z1.d
; CHECK-NEXT:    mov z3.d, z0.d
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    ext z3.b, z3.b, z0.b, #8
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z2.s, z2.h
; CHECK-NEXT:    uunpklo z3.s, z3.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    udivr z2.s, p0/m, z2.s, z3.s
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    uzp1 z1.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    splice z0.h, p0, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = udiv <8 x i16> %op1, %op2
  ret <8 x i16> %res
}

define void @udiv_v16i16(ptr %a, ptr %b) #0 {
; CHECK-LABEL: udiv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q3, q0, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    uunpklo z6.s, z3.h
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    uunpklo z4.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z7.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z5.s, z2.h
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    uunpklo z2.s, z2.h
; CHECK-NEXT:    udivr z4.s, p0/m, z4.s, z5.s
; CHECK-NEXT:    udivr z0.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    uunpklo z2.s, z3.h
; CHECK-NEXT:    udiv z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    movprfx z2, z7
; CHECK-NEXT:    udiv z2.s, p0/m, z2.s, z6.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    uzp1 z3.h, z4.h, z4.h
; CHECK-NEXT:    splice z2.h, p1, z2.h, z1.h
; CHECK-NEXT:    splice z3.h, p1, z3.h, z0.h
; CHECK-NEXT:    stp q2, q3, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = udiv <16 x i16> %op1, %op2
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @udiv_v2i32(<2 x i32> %op1, <2 x i32> %op2) #0 {
; CHECK-LABEL: udiv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = udiv <2 x i32> %op1, %op2
  ret <2 x i32> %res
}

define <4 x i32> @udiv_v4i32(<4 x i32> %op1, <4 x i32> %op2) #0 {
; CHECK-LABEL: udiv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = udiv <4 x i32> %op1, %op2
  ret <4 x i32> %res
}

define void @udiv_v8i32(ptr %a, ptr %b)  #0 {
; CHECK-LABEL: udiv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    udiv z0.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    udiv z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = udiv <8 x i32> %op1, %op2
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @udiv_v1i64(<1 x i64> %op1, <1 x i64> %op2) #0 {
; CHECK-LABEL: udiv_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    udiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = udiv <1 x i64> %op1, %op2
  ret <1 x i64> %res
}

define <2 x i64> @udiv_v2i64(<2 x i64> %op1, <2 x i64> %op2) #0 {
; CHECK-LABEL: udiv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    udiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = udiv <2 x i64> %op1, %op2
  ret <2 x i64> %res
}

define void @udiv_v4i64(ptr %a, ptr %b)  #0 {
; CHECK-LABEL: udiv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    udiv z0.d, p0/m, z0.d, z2.d
; CHECK-NEXT:    udiv z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = udiv <4 x i64> %op1, %op2
  store <4 x i64> %res, ptr %a
  ret void
}

define void @udiv_constantsplat_v8i32(ptr %a)  #0 {
; CHECK-LABEL: udiv_constantsplat_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov w8, #8969
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    movk w8, #22765, lsl #16
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    movprfx z3, z0
; CHECK-NEXT:    umulh z3.s, p0/m, z3.s, z2.s
; CHECK-NEXT:    umulh z2.s, p0/m, z2.s, z1.s
; CHECK-NEXT:    sub z0.s, z0.s, z3.s
; CHECK-NEXT:    sub z1.s, z1.s, z2.s
; CHECK-NEXT:    lsr z0.s, p0/m, z0.s, #1
; CHECK-NEXT:    lsr z1.s, p0/m, z1.s, #1
; CHECK-NEXT:    add z0.s, z0.s, z3.s
; CHECK-NEXT:    add z1.s, z1.s, z2.s
; CHECK-NEXT:    lsr z0.s, p0/m, z0.s, #6
; CHECK-NEXT:    lsr z1.s, p0/m, z1.s, #6
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = udiv <8 x i32> %op1, <i32 95, i32 95, i32 95, i32 95, i32 95, i32 95, i32 95, i32 95>
  store <8 x i32> %res, ptr %a
  ret void
}

attributes #0 = { "target-features"="+sve" }
