; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=+sse2     | FileCheck %s --check-prefix=X86-SSE2
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=+sse4.2   | FileCheck %s --check-prefix=X86-SSE42
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=+avx      | FileCheck %s --check-prefixes=X86-AVX,X86-AVX1
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=+avx2     | FileCheck %s --check-prefixes=X86-AVX,X86-AVX2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+sse2   | FileCheck %s --check-prefix=X64-SSE2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+sse4.2 | FileCheck %s --check-prefix=X64-SSE42
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx    | FileCheck %s --check-prefixes=X64-AVX,X64-AVX1
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx2   | FileCheck %s --check-prefixes=X64-AVX,X64-AVX2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx512f,+avx512bw,+avx512dq,+avx512vl | FileCheck %s --check-prefixes=X64-AVX,X64-AVX512

;
; 128-bit Vectors
;

define i64 @test_reduce_v2i64(<2 x i64> %a0) {
; X86-SSE2-LABEL: test_reduce_v2i64:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X86-SSE2-NEXT:    pxor %xmm2, %xmm3
; X86-SSE2-NEXT:    pxor %xmm1, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm3, %xmm4
; X86-SSE2-NEXT:    pcmpgtd %xmm2, %xmm4
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; X86-SSE2-NEXT:    pcmpeqd %xmm3, %xmm2
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; X86-SSE2-NEXT:    pand %xmm5, %xmm2
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; X86-SSE2-NEXT:    por %xmm2, %xmm3
; X86-SSE2-NEXT:    pand %xmm3, %xmm0
; X86-SSE2-NEXT:    pandn %xmm1, %xmm3
; X86-SSE2-NEXT:    por %xmm0, %xmm3
; X86-SSE2-NEXT:    movd %xmm3, %eax
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[1,1,1,1]
; X86-SSE2-NEXT:    movd %xmm0, %edx
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v2i64:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; X86-SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [0,2147483648,0,2147483648]
; X86-SSE42-NEXT:    pxor %xmm3, %xmm0
; X86-SSE42-NEXT:    pxor %xmm2, %xmm3
; X86-SSE42-NEXT:    pcmpgtq %xmm3, %xmm0
; X86-SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; X86-SSE42-NEXT:    movd %xmm2, %eax
; X86-SSE42-NEXT:    pextrd $1, %xmm2, %edx
; X86-SSE42-NEXT:    retl
;
; X86-AVX1-LABEL: test_reduce_v2i64:
; X86-AVX1:       ## %bb.0:
; X86-AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX1-NEXT:    vmovddup {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; X86-AVX1-NEXT:    ## xmm2 = mem[0,0]
; X86-AVX1-NEXT:    vxorps %xmm2, %xmm0, %xmm3
; X86-AVX1-NEXT:    vxorps %xmm2, %xmm1, %xmm2
; X86-AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X86-AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X86-AVX1-NEXT:    vmovd %xmm0, %eax
; X86-AVX1-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: test_reduce_v2i64:
; X86-AVX2:       ## %bb.0:
; X86-AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; X86-AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm3
; X86-AVX2-NEXT:    vpxor %xmm2, %xmm1, %xmm2
; X86-AVX2-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X86-AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X86-AVX2-NEXT:    vmovd %xmm0, %eax
; X86-AVX2-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX2-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v2i64:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [9223372039002259456,9223372039002259456]
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE2-NEXT:    pxor %xmm2, %xmm3
; X64-SSE2-NEXT:    pxor %xmm1, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm3, %xmm4
; X64-SSE2-NEXT:    pcmpgtd %xmm2, %xmm4
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; X64-SSE2-NEXT:    pcmpeqd %xmm3, %xmm2
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; X64-SSE2-NEXT:    pand %xmm5, %xmm2
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; X64-SSE2-NEXT:    por %xmm2, %xmm3
; X64-SSE2-NEXT:    pand %xmm3, %xmm0
; X64-SSE2-NEXT:    pandn %xmm1, %xmm3
; X64-SSE2-NEXT:    por %xmm0, %xmm3
; X64-SSE2-NEXT:    movq %xmm3, %rax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v2i64:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; X64-SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; X64-SSE42-NEXT:    pxor %xmm3, %xmm0
; X64-SSE42-NEXT:    pxor %xmm2, %xmm3
; X64-SSE42-NEXT:    pcmpgtq %xmm3, %xmm0
; X64-SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; X64-SSE42-NEXT:    movq %xmm2, %rax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v2i64:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; X64-AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm3
; X64-AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm2
; X64-AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X64-AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X64-AVX1-NEXT:    vmovq %xmm0, %rax
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v2i64:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; X64-AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm3
; X64-AVX2-NEXT:    vpxor %xmm2, %xmm1, %xmm2
; X64-AVX2-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X64-AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X64-AVX2-NEXT:    vmovq %xmm0, %rax
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v2i64:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX512-NEXT:    vpmaxuq %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovq %xmm0, %rax
; X64-AVX512-NEXT:    retq
  %1 = shufflevector <2 x i64> %a0, <2 x i64> undef, <2 x i32> <i32 1, i32 undef>
  %2 = icmp ugt <2 x i64> %a0, %1
  %3 = select <2 x i1> %2, <2 x i64> %a0, <2 x i64> %1
  %4 = extractelement <2 x i64> %3, i32 0
  ret i64 %4
}

define i32 @test_reduce_v4i32(<4 x i32> %a0) {
; X86-SSE2-LABEL: test_reduce_v4i32:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    pxor %xmm2, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm3, %xmm4
; X86-SSE2-NEXT:    pxor %xmm2, %xmm4
; X86-SSE2-NEXT:    pcmpgtd %xmm4, %xmm1
; X86-SSE2-NEXT:    pand %xmm1, %xmm0
; X86-SSE2-NEXT:    pandn %xmm3, %xmm1
; X86-SSE2-NEXT:    por %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm3
; X86-SSE2-NEXT:    pxor %xmm2, %xmm3
; X86-SSE2-NEXT:    pxor %xmm0, %xmm2
; X86-SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; X86-SSE2-NEXT:    pand %xmm3, %xmm1
; X86-SSE2-NEXT:    pandn %xmm0, %xmm3
; X86-SSE2-NEXT:    por %xmm1, %xmm3
; X86-SSE2-NEXT:    movd %xmm3, %eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v4i32:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE42-NEXT:    pmaxud %xmm0, %xmm1
; X86-SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE42-NEXT:    pmaxud %xmm1, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX-LABEL: test_reduce_v4i32:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-AVX-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vmovd %xmm0, %eax
; X86-AVX-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v4i32:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE2-NEXT:    pxor %xmm2, %xmm3
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm4
; X64-SSE2-NEXT:    pxor %xmm2, %xmm4
; X64-SSE2-NEXT:    pcmpgtd %xmm4, %xmm3
; X64-SSE2-NEXT:    pand %xmm3, %xmm0
; X64-SSE2-NEXT:    pandn %xmm1, %xmm3
; X64-SSE2-NEXT:    por %xmm0, %xmm3
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[1,1,1,1]
; X64-SSE2-NEXT:    movdqa %xmm3, %xmm1
; X64-SSE2-NEXT:    pxor %xmm2, %xmm1
; X64-SSE2-NEXT:    pxor %xmm0, %xmm2
; X64-SSE2-NEXT:    pcmpgtd %xmm2, %xmm1
; X64-SSE2-NEXT:    pand %xmm1, %xmm3
; X64-SSE2-NEXT:    pandn %xmm0, %xmm1
; X64-SSE2-NEXT:    por %xmm3, %xmm1
; X64-SSE2-NEXT:    movd %xmm1, %eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v4i32:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE42-NEXT:    pmaxud %xmm0, %xmm1
; X64-SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE42-NEXT:    pmaxud %xmm1, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX-LABEL: test_reduce_v4i32:
; X64-AVX:       ## %bb.0:
; X64-AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X64-AVX-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX-NEXT:    vmovd %xmm0, %eax
; X64-AVX-NEXT:    retq
  %1 = shufflevector <4 x i32> %a0, <4 x i32> undef, <4 x i32> <i32 2, i32 3, i32 undef, i32 undef>
  %2 = icmp ugt <4 x i32> %a0, %1
  %3 = select <4 x i1> %2, <4 x i32> %a0, <4 x i32> %1
  %4 = shufflevector <4 x i32> %3, <4 x i32> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %5 = icmp ugt <4 x i32> %3, %4
  %6 = select <4 x i1> %5, <4 x i32> %3, <4 x i32> %4
  %7 = extractelement <4 x i32> %6, i32 0
  ret i32 %7
}

define i16 @test_reduce_v8i16(<8 x i16> %a0) {
; X86-SSE2-LABEL: test_reduce_v8i16:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X86-SSE2-NEXT:    paddw %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X86-SSE2-NEXT:    paddw %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $16, %xmm1
; X86-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X86-SSE2-NEXT:    paddw %xmm0, %xmm1
; X86-SSE2-NEXT:    movd %xmm1, %eax
; X86-SSE2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v8i16:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm1
; X86-SSE42-NEXT:    phminposuw %xmm1, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    notl %eax
; X86-SSE42-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX-LABEL: test_reduce_v8i16:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX-NEXT:    vmovd %xmm0, %eax
; X86-AVX-NEXT:    notl %eax
; X86-AVX-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-AVX-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v8i16:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X64-SSE2-NEXT:    paddw %xmm0, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X64-SSE2-NEXT:    paddw %xmm1, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    psrld $16, %xmm1
; X64-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X64-SSE2-NEXT:    paddw %xmm0, %xmm1
; X64-SSE2-NEXT:    movd %xmm1, %eax
; X64-SSE2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v8i16:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm1
; X64-SSE42-NEXT:    phminposuw %xmm1, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    notl %eax
; X64-SSE42-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v8i16:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    notl %eax
; X64-AVX1-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v8i16:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    notl %eax
; X64-AVX2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v8i16:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; X64-AVX512-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    notl %eax
; X64-AVX512-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <8 x i16> %a0, <8 x i16> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <8 x i16> %a0, %1
  %3  = select <8 x i1> %2, <8 x i16> %a0, <8 x i16> %1
  %4  = shufflevector <8 x i16> %3, <8 x i16> undef, <8 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <8 x i16> %3, %4
  %6  = select <8 x i1> %5, <8 x i16> %3, <8 x i16> %4
  %7  = shufflevector <8 x i16> %6, <8 x i16> undef, <8 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <8 x i16> %6, %7
  %9  = select <8 x i1> %8, <8 x i16> %6, <8 x i16> %7
  %10 = extractelement <8 x i16> %9, i32 0
  ret i16 %10
}

define i8 @test_reduce_v16i8(<16 x i8> %a0) {
; X86-SSE2-LABEL: test_reduce_v16i8:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $16, %xmm1
; X86-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    psrlw $8, %xmm0
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    movd %xmm0, %eax
; X86-SSE2-NEXT:    ## kill: def $al killed $al killed $eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v16i8:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm1
; X86-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE42-NEXT:    psrlw $8, %xmm0
; X86-SSE42-NEXT:    pminub %xmm1, %xmm0
; X86-SSE42-NEXT:    phminposuw %xmm0, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    notb %al
; X86-SSE42-NEXT:    ## kill: def $al killed $al killed $eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX-LABEL: test_reduce_v16i8:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X86-AVX-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX-NEXT:    vmovd %xmm0, %eax
; X86-AVX-NEXT:    notb %al
; X86-AVX-NEXT:    ## kill: def $al killed $al killed $eax
; X86-AVX-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v16i8:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    psrld $16, %xmm1
; X64-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE2-NEXT:    psrlw $8, %xmm0
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    movd %xmm0, %eax
; X64-SSE2-NEXT:    ## kill: def $al killed $al killed $eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v16i8:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm1
; X64-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE42-NEXT:    psrlw $8, %xmm0
; X64-SSE42-NEXT:    pminub %xmm1, %xmm0
; X64-SSE42-NEXT:    phminposuw %xmm0, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    notb %al
; X64-SSE42-NEXT:    ## kill: def $al killed $al killed $eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v16i8:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX1-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    notb %al
; X64-AVX1-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v16i8:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX2-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    notb %al
; X64-AVX2-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v16i8:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX512-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    notb %al
; X64-AVX512-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <16 x i8> %a0, <16 x i8> undef, <16 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <16 x i8> %a0, %1
  %3  = select <16 x i1> %2, <16 x i8> %a0, <16 x i8> %1
  %4  = shufflevector <16 x i8> %3, <16 x i8> undef, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <16 x i8> %3, %4
  %6  = select <16 x i1> %5, <16 x i8> %3, <16 x i8> %4
  %7  = shufflevector <16 x i8> %6, <16 x i8> undef, <16 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <16 x i8> %6, %7
  %9  = select <16 x i1> %8, <16 x i8> %6, <16 x i8> %7
  %10 = shufflevector <16 x i8> %9, <16 x i8> undef, <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %11 = icmp ugt <16 x i8> %9, %10
  %12 = select <16 x i1> %11, <16 x i8> %9, <16 x i8> %10
  %13 = extractelement <16 x i8> %12, i32 0
  ret i8 %13
}

;
; 256-bit Vectors
;

define i64 @test_reduce_v4i64(<4 x i64> %a0) {
; X86-SSE2-LABEL: test_reduce_v4i64:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm3
; X86-SSE2-NEXT:    pxor %xmm2, %xmm3
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm4
; X86-SSE2-NEXT:    pxor %xmm2, %xmm4
; X86-SSE2-NEXT:    movdqa %xmm4, %xmm5
; X86-SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; X86-SSE2-NEXT:    pcmpeqd %xmm3, %xmm4
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; X86-SSE2-NEXT:    pand %xmm6, %xmm4
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[1,1,3,3]
; X86-SSE2-NEXT:    por %xmm4, %xmm3
; X86-SSE2-NEXT:    pand %xmm3, %xmm0
; X86-SSE2-NEXT:    pandn %xmm1, %xmm3
; X86-SSE2-NEXT:    por %xmm0, %xmm3
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,2,3]
; X86-SSE2-NEXT:    movdqa %xmm3, %xmm1
; X86-SSE2-NEXT:    pxor %xmm2, %xmm1
; X86-SSE2-NEXT:    pxor %xmm0, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm4
; X86-SSE2-NEXT:    pcmpgtd %xmm2, %xmm4
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; X86-SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; X86-SSE2-NEXT:    pand %xmm5, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; X86-SSE2-NEXT:    por %xmm1, %xmm2
; X86-SSE2-NEXT:    pand %xmm2, %xmm3
; X86-SSE2-NEXT:    pandn %xmm0, %xmm2
; X86-SSE2-NEXT:    por %xmm3, %xmm2
; X86-SSE2-NEXT:    movd %xmm2, %eax
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,1,1]
; X86-SSE2-NEXT:    movd %xmm0, %edx
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v4i64:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [0,2147483648,0,2147483648]
; X86-SSE42-NEXT:    movdqa %xmm1, %xmm4
; X86-SSE42-NEXT:    pxor %xmm3, %xmm4
; X86-SSE42-NEXT:    pxor %xmm3, %xmm0
; X86-SSE42-NEXT:    pcmpgtq %xmm4, %xmm0
; X86-SSE42-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; X86-SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,2,3]
; X86-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE42-NEXT:    pxor %xmm3, %xmm0
; X86-SSE42-NEXT:    pxor %xmm2, %xmm3
; X86-SSE42-NEXT:    pcmpgtq %xmm3, %xmm0
; X86-SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; X86-SSE42-NEXT:    movd %xmm2, %eax
; X86-SSE42-NEXT:    pextrd $1, %xmm2, %edx
; X86-SSE42-NEXT:    retl
;
; X86-AVX1-LABEL: test_reduce_v4i64:
; X86-AVX1:       ## %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-AVX1-NEXT:    vmovddup {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; X86-AVX1-NEXT:    ## xmm2 = mem[0,0]
; X86-AVX1-NEXT:    vxorps %xmm2, %xmm1, %xmm3
; X86-AVX1-NEXT:    vxorps %xmm2, %xmm0, %xmm4
; X86-AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; X86-AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; X86-AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX1-NEXT:    vxorpd %xmm2, %xmm0, %xmm3
; X86-AVX1-NEXT:    vxorpd %xmm2, %xmm1, %xmm2
; X86-AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X86-AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X86-AVX1-NEXT:    vmovd %xmm0, %eax
; X86-AVX1-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX1-NEXT:    vzeroupper
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: test_reduce_v4i64:
; X86-AVX2:       ## %bb.0:
; X86-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-AVX2-NEXT:    vpbroadcastq {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; X86-AVX2-NEXT:    vpxor %xmm2, %xmm1, %xmm3
; X86-AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm4
; X86-AVX2-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; X86-AVX2-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; X86-AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX2-NEXT:    vxorpd %xmm2, %xmm0, %xmm3
; X86-AVX2-NEXT:    vxorpd %xmm2, %xmm1, %xmm2
; X86-AVX2-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X86-AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X86-AVX2-NEXT:    vmovd %xmm0, %eax
; X86-AVX2-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX2-NEXT:    vzeroupper
; X86-AVX2-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v4i64:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [9223372039002259456,9223372039002259456]
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm3
; X64-SSE2-NEXT:    pxor %xmm2, %xmm3
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm4
; X64-SSE2-NEXT:    pxor %xmm2, %xmm4
; X64-SSE2-NEXT:    movdqa %xmm4, %xmm5
; X64-SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; X64-SSE2-NEXT:    pcmpeqd %xmm3, %xmm4
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; X64-SSE2-NEXT:    pand %xmm6, %xmm3
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; X64-SSE2-NEXT:    por %xmm3, %xmm4
; X64-SSE2-NEXT:    pand %xmm4, %xmm0
; X64-SSE2-NEXT:    pandn %xmm1, %xmm4
; X64-SSE2-NEXT:    por %xmm0, %xmm4
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[2,3,2,3]
; X64-SSE2-NEXT:    movdqa %xmm4, %xmm1
; X64-SSE2-NEXT:    pxor %xmm2, %xmm1
; X64-SSE2-NEXT:    pxor %xmm0, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm3
; X64-SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[0,0,2,2]
; X64-SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; X64-SSE2-NEXT:    pand %xmm5, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,1,3,3]
; X64-SSE2-NEXT:    por %xmm1, %xmm2
; X64-SSE2-NEXT:    pand %xmm2, %xmm4
; X64-SSE2-NEXT:    pandn %xmm0, %xmm2
; X64-SSE2-NEXT:    por %xmm4, %xmm2
; X64-SSE2-NEXT:    movq %xmm2, %rax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v4i64:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; X64-SSE42-NEXT:    movdqa %xmm1, %xmm4
; X64-SSE42-NEXT:    pxor %xmm3, %xmm4
; X64-SSE42-NEXT:    pxor %xmm3, %xmm0
; X64-SSE42-NEXT:    pcmpgtq %xmm4, %xmm0
; X64-SSE42-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; X64-SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,2,3]
; X64-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE42-NEXT:    pxor %xmm3, %xmm0
; X64-SSE42-NEXT:    pxor %xmm2, %xmm3
; X64-SSE42-NEXT:    pcmpgtq %xmm3, %xmm0
; X64-SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm2
; X64-SSE42-NEXT:    movq %xmm2, %rax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v4i64:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; X64-AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm3
; X64-AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm4
; X64-AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; X64-AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; X64-AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX1-NEXT:    vxorpd %xmm2, %xmm0, %xmm3
; X64-AVX1-NEXT:    vxorpd %xmm2, %xmm1, %xmm2
; X64-AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X64-AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X64-AVX1-NEXT:    vmovq %xmm0, %rax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v4i64:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; X64-AVX2-NEXT:    vpxor %xmm2, %xmm1, %xmm3
; X64-AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm4
; X64-AVX2-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; X64-AVX2-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; X64-AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX2-NEXT:    vxorpd %xmm2, %xmm0, %xmm3
; X64-AVX2-NEXT:    vxorpd %xmm2, %xmm1, %xmm2
; X64-AVX2-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X64-AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X64-AVX2-NEXT:    vmovq %xmm0, %rax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v4i64:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX512-NEXT:    vpmaxuq %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX512-NEXT:    vpmaxuq %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovq %xmm0, %rax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1 = shufflevector <4 x i64> %a0, <4 x i64> undef, <4 x i32> <i32 2, i32 3, i32 undef, i32 undef>
  %2 = icmp ugt <4 x i64> %a0, %1
  %3 = select <4 x i1> %2, <4 x i64> %a0, <4 x i64> %1
  %4 = shufflevector <4 x i64> %3, <4 x i64> undef, <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  %5 = icmp ugt <4 x i64> %3, %4
  %6 = select <4 x i1> %5, <4 x i64> %3, <4 x i64> %4
  %7 = extractelement <4 x i64> %6, i32 0
  ret i64 %7
}

define i32 @test_reduce_v8i32(<8 x i32> %a0) {
; X86-SSE2-LABEL: test_reduce_v8i32:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm4
; X86-SSE2-NEXT:    pxor %xmm2, %xmm4
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X86-SSE2-NEXT:    pxor %xmm2, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm4, %xmm3
; X86-SSE2-NEXT:    pand %xmm3, %xmm0
; X86-SSE2-NEXT:    pandn %xmm1, %xmm3
; X86-SSE2-NEXT:    por %xmm0, %xmm3
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[2,3,2,3]
; X86-SSE2-NEXT:    movdqa %xmm3, %xmm0
; X86-SSE2-NEXT:    pxor %xmm2, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm4
; X86-SSE2-NEXT:    pxor %xmm2, %xmm4
; X86-SSE2-NEXT:    pcmpgtd %xmm4, %xmm0
; X86-SSE2-NEXT:    pand %xmm0, %xmm3
; X86-SSE2-NEXT:    pandn %xmm1, %xmm0
; X86-SSE2-NEXT:    por %xmm3, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X86-SSE2-NEXT:    pxor %xmm2, %xmm3
; X86-SSE2-NEXT:    pxor %xmm1, %xmm2
; X86-SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; X86-SSE2-NEXT:    pand %xmm3, %xmm0
; X86-SSE2-NEXT:    pandn %xmm1, %xmm3
; X86-SSE2-NEXT:    por %xmm0, %xmm3
; X86-SSE2-NEXT:    movd %xmm3, %eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v8i32:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pmaxud %xmm1, %xmm0
; X86-SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE42-NEXT:    pmaxud %xmm0, %xmm1
; X86-SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE42-NEXT:    pmaxud %xmm1, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX1-LABEL: test_reduce_v8i32:
; X86-AVX1:       ## %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vmovd %xmm0, %eax
; X86-AVX1-NEXT:    vzeroupper
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: test_reduce_v8i32:
; X86-AVX2:       ## %bb.0:
; X86-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vmovd %xmm0, %eax
; X86-AVX2-NEXT:    vzeroupper
; X86-AVX2-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v8i32:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm3
; X64-SSE2-NEXT:    pxor %xmm2, %xmm3
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm4
; X64-SSE2-NEXT:    pxor %xmm2, %xmm4
; X64-SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; X64-SSE2-NEXT:    pand %xmm4, %xmm0
; X64-SSE2-NEXT:    pandn %xmm1, %xmm4
; X64-SSE2-NEXT:    por %xmm0, %xmm4
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[2,3,2,3]
; X64-SSE2-NEXT:    movdqa %xmm4, %xmm1
; X64-SSE2-NEXT:    pxor %xmm2, %xmm1
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE2-NEXT:    pxor %xmm2, %xmm3
; X64-SSE2-NEXT:    pcmpgtd %xmm3, %xmm1
; X64-SSE2-NEXT:    pand %xmm1, %xmm4
; X64-SSE2-NEXT:    pandn %xmm0, %xmm1
; X64-SSE2-NEXT:    por %xmm4, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm3
; X64-SSE2-NEXT:    pxor %xmm2, %xmm3
; X64-SSE2-NEXT:    pxor %xmm0, %xmm2
; X64-SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pandn %xmm0, %xmm3
; X64-SSE2-NEXT:    por %xmm1, %xmm3
; X64-SSE2-NEXT:    movd %xmm3, %eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v8i32:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pmaxud %xmm1, %xmm0
; X64-SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE42-NEXT:    pmaxud %xmm0, %xmm1
; X64-SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE42-NEXT:    pmaxud %xmm1, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v8i32:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X64-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v8i32:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X64-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v8i32:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX512-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX512-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X64-AVX512-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <8 x i32> %a0, <8 x i32> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <8 x i32> %a0, %1
  %3  = select <8 x i1> %2, <8 x i32> %a0, <8 x i32> %1
  %4  = shufflevector <8 x i32> %3, <8 x i32> undef, <8 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <8 x i32> %3, %4
  %6  = select <8 x i1> %5, <8 x i32> %3, <8 x i32> %4
  %7  = shufflevector <8 x i32> %6, <8 x i32> undef, <8 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <8 x i32> %6, %7
  %9  = select <8 x i1> %8, <8 x i32> %6, <8 x i32> %7
  %10 = extractelement <8 x i32> %9, i32 0
  ret i32 %10
}

define i16 @test_reduce_v16i16(<16 x i16> %a0) {
; X86-SSE2-LABEL: test_reduce_v16i16:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X86-SSE2-NEXT:    paddw %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; X86-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X86-SSE2-NEXT:    paddw %xmm1, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X86-SSE2-NEXT:    paddw %xmm0, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    psrld $16, %xmm0
; X86-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X86-SSE2-NEXT:    paddw %xmm1, %xmm0
; X86-SSE2-NEXT:    movd %xmm0, %eax
; X86-SSE2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v16i16:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pmaxuw %xmm1, %xmm0
; X86-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm1
; X86-SSE42-NEXT:    phminposuw %xmm1, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    notl %eax
; X86-SSE42-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX1-LABEL: test_reduce_v16i16:
; X86-AVX1:       ## %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-AVX1-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX1-NEXT:    vmovd %xmm0, %eax
; X86-AVX1-NEXT:    notl %eax
; X86-AVX1-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-AVX1-NEXT:    vzeroupper
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: test_reduce_v16i16:
; X86-AVX2:       ## %bb.0:
; X86-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-AVX2-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX2-NEXT:    vmovd %xmm0, %eax
; X86-AVX2-NEXT:    notl %eax
; X86-AVX2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-AVX2-NEXT:    vzeroupper
; X86-AVX2-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v16i16:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X64-SSE2-NEXT:    paddw %xmm0, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; X64-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X64-SSE2-NEXT:    paddw %xmm1, %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X64-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X64-SSE2-NEXT:    paddw %xmm0, %xmm1
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE2-NEXT:    psrld $16, %xmm0
; X64-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X64-SSE2-NEXT:    paddw %xmm1, %xmm0
; X64-SSE2-NEXT:    movd %xmm0, %eax
; X64-SSE2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v16i16:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pmaxuw %xmm1, %xmm0
; X64-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm1
; X64-SSE42-NEXT:    phminposuw %xmm1, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    notl %eax
; X64-SSE42-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v16i16:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-AVX1-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    notl %eax
; X64-AVX1-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v16i16:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    notl %eax
; X64-AVX2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v16i16:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX512-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; X64-AVX512-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    notl %eax
; X64-AVX512-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <16 x i16> %a0, <16 x i16> undef, <16 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <16 x i16> %a0, %1
  %3  = select <16 x i1> %2, <16 x i16> %a0, <16 x i16> %1
  %4  = shufflevector <16 x i16> %3, <16 x i16> undef, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <16 x i16> %3, %4
  %6  = select <16 x i1> %5, <16 x i16> %3, <16 x i16> %4
  %7  = shufflevector <16 x i16> %6, <16 x i16> undef, <16 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <16 x i16> %6, %7
  %9  = select <16 x i1> %8, <16 x i16> %6, <16 x i16> %7
  %10 = shufflevector <16 x i16> %9, <16 x i16> undef, <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %11 = icmp ugt <16 x i16> %9, %10
  %12 = select <16 x i1> %11, <16 x i16> %9, <16 x i16> %10
  %13 = extractelement <16 x i16> %12, i32 0
  ret i16 %13
}

define i8 @test_reduce_v32i8(<32 x i8> %a0) {
; X86-SSE2-LABEL: test_reduce_v32i8:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $16, %xmm1
; X86-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    psrlw $8, %xmm0
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    movd %xmm0, %eax
; X86-SSE2-NEXT:    ## kill: def $al killed $al killed $eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v32i8:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm1
; X86-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE42-NEXT:    psrlw $8, %xmm0
; X86-SSE42-NEXT:    pminub %xmm1, %xmm0
; X86-SSE42-NEXT:    phminposuw %xmm0, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    notb %al
; X86-SSE42-NEXT:    ## kill: def $al killed $al killed $eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX1-LABEL: test_reduce_v32i8:
; X86-AVX1:       ## %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-AVX1-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X86-AVX1-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX1-NEXT:    vmovd %xmm0, %eax
; X86-AVX1-NEXT:    notb %al
; X86-AVX1-NEXT:    ## kill: def $al killed $al killed $eax
; X86-AVX1-NEXT:    vzeroupper
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: test_reduce_v32i8:
; X86-AVX2:       ## %bb.0:
; X86-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-AVX2-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X86-AVX2-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX2-NEXT:    vmovd %xmm0, %eax
; X86-AVX2-NEXT:    notb %al
; X86-AVX2-NEXT:    ## kill: def $al killed $al killed $eax
; X86-AVX2-NEXT:    vzeroupper
; X86-AVX2-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v32i8:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    psrld $16, %xmm1
; X64-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE2-NEXT:    psrlw $8, %xmm0
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    movd %xmm0, %eax
; X64-SSE2-NEXT:    ## kill: def $al killed $al killed $eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v32i8:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm1
; X64-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE42-NEXT:    psrlw $8, %xmm0
; X64-SSE42-NEXT:    pminub %xmm1, %xmm0
; X64-SSE42-NEXT:    phminposuw %xmm0, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    notb %al
; X64-SSE42-NEXT:    ## kill: def $al killed $al killed $eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v32i8:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-AVX1-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX1-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    notb %al
; X64-AVX1-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v32i8:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX2-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    notb %al
; X64-AVX2-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v32i8:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX512-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX512-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    notb %al
; X64-AVX512-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <32 x i8> %a0, <32 x i8> undef, <32 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <32 x i8> %a0, %1
  %3  = select <32 x i1> %2, <32 x i8> %a0, <32 x i8> %1
  %4  = shufflevector <32 x i8> %3, <32 x i8> undef, <32 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <32 x i8> %3, %4
  %6  = select <32 x i1> %5, <32 x i8> %3, <32 x i8> %4
  %7  = shufflevector <32 x i8> %6, <32 x i8> undef, <32 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <32 x i8> %6, %7
  %9  = select <32 x i1> %8, <32 x i8> %6, <32 x i8> %7
  %10 = shufflevector <32 x i8> %9, <32 x i8> undef, <32 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %11 = icmp ugt <32 x i8> %9, %10
  %12 = select <32 x i1> %11, <32 x i8> %9, <32 x i8> %10
  %13 = shufflevector <32 x i8> %12, <32 x i8> undef, <32 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %14 = icmp ugt <32 x i8> %12, %13
  %15 = select <32 x i1> %14, <32 x i8> %12, <32 x i8> %13
  %16 = extractelement <32 x i8> %15, i32 0
  ret i8 %16
}

;
; 512-bit Vectors
;

define i64 @test_reduce_v8i64(<8 x i64> %a0) {
; X86-SSE2-LABEL: test_reduce_v8i64:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; X86-SSE2-NEXT:    movdqa %xmm2, %xmm5
; X86-SSE2-NEXT:    pxor %xmm4, %xmm5
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm6
; X86-SSE2-NEXT:    pxor %xmm4, %xmm6
; X86-SSE2-NEXT:    movdqa %xmm6, %xmm7
; X86-SSE2-NEXT:    pcmpgtd %xmm5, %xmm7
; X86-SSE2-NEXT:    pcmpeqd %xmm5, %xmm6
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[0,0,2,2]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; X86-SSE2-NEXT:    pand %xmm5, %xmm6
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; X86-SSE2-NEXT:    por %xmm6, %xmm5
; X86-SSE2-NEXT:    pand %xmm5, %xmm0
; X86-SSE2-NEXT:    pandn %xmm2, %xmm5
; X86-SSE2-NEXT:    por %xmm0, %xmm5
; X86-SSE2-NEXT:    movdqa %xmm3, %xmm0
; X86-SSE2-NEXT:    pxor %xmm4, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm2
; X86-SSE2-NEXT:    pxor %xmm4, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm2, %xmm6
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm6
; X86-SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm2[1,1,3,3]
; X86-SSE2-NEXT:    pand %xmm0, %xmm7
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[1,1,3,3]
; X86-SSE2-NEXT:    por %xmm7, %xmm2
; X86-SSE2-NEXT:    pand %xmm2, %xmm1
; X86-SSE2-NEXT:    pandn %xmm3, %xmm2
; X86-SSE2-NEXT:    por %xmm1, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm2, %xmm0
; X86-SSE2-NEXT:    pxor %xmm4, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm5, %xmm1
; X86-SSE2-NEXT:    pxor %xmm4, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; X86-SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[1,1,3,3]
; X86-SSE2-NEXT:    por %xmm1, %xmm0
; X86-SSE2-NEXT:    pand %xmm0, %xmm5
; X86-SSE2-NEXT:    pandn %xmm2, %xmm0
; X86-SSE2-NEXT:    por %xmm5, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    pxor %xmm4, %xmm2
; X86-SSE2-NEXT:    pxor %xmm1, %xmm4
; X86-SSE2-NEXT:    movdqa %xmm2, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm4, %xmm3
; X86-SSE2-NEXT:    pcmpeqd %xmm2, %xmm4
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,0,2,2]
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; X86-SSE2-NEXT:    pand %xmm2, %xmm4
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,1,3,3]
; X86-SSE2-NEXT:    por %xmm4, %xmm2
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pandn %xmm1, %xmm2
; X86-SSE2-NEXT:    por %xmm0, %xmm2
; X86-SSE2-NEXT:    movd %xmm2, %eax
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,1,1]
; X86-SSE2-NEXT:    movd %xmm0, %edx
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v8i64:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    movdqa %xmm0, %xmm4
; X86-SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [0,2147483648,0,2147483648]
; X86-SSE42-NEXT:    movdqa %xmm2, %xmm6
; X86-SSE42-NEXT:    pxor %xmm5, %xmm6
; X86-SSE42-NEXT:    pxor %xmm5, %xmm0
; X86-SSE42-NEXT:    pcmpgtq %xmm6, %xmm0
; X86-SSE42-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; X86-SSE42-NEXT:    movdqa %xmm3, %xmm4
; X86-SSE42-NEXT:    pxor %xmm5, %xmm4
; X86-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE42-NEXT:    pxor %xmm5, %xmm0
; X86-SSE42-NEXT:    pcmpgtq %xmm4, %xmm0
; X86-SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm3
; X86-SSE42-NEXT:    movapd %xmm3, %xmm1
; X86-SSE42-NEXT:    xorpd %xmm5, %xmm1
; X86-SSE42-NEXT:    movapd %xmm2, %xmm0
; X86-SSE42-NEXT:    xorpd %xmm5, %xmm0
; X86-SSE42-NEXT:    pcmpgtq %xmm1, %xmm0
; X86-SSE42-NEXT:    blendvpd %xmm0, %xmm2, %xmm3
; X86-SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[2,3,2,3]
; X86-SSE42-NEXT:    movdqa %xmm3, %xmm0
; X86-SSE42-NEXT:    pxor %xmm5, %xmm0
; X86-SSE42-NEXT:    pxor %xmm1, %xmm5
; X86-SSE42-NEXT:    pcmpgtq %xmm5, %xmm0
; X86-SSE42-NEXT:    blendvpd %xmm0, %xmm3, %xmm1
; X86-SSE42-NEXT:    movd %xmm1, %eax
; X86-SSE42-NEXT:    pextrd $1, %xmm1, %edx
; X86-SSE42-NEXT:    retl
;
; X86-AVX1-LABEL: test_reduce_v8i64:
; X86-AVX1:       ## %bb.0:
; X86-AVX1-NEXT:    vmovddup {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; X86-AVX1-NEXT:    ## xmm2 = mem[0,0]
; X86-AVX1-NEXT:    vxorps %xmm2, %xmm1, %xmm3
; X86-AVX1-NEXT:    vxorps %xmm2, %xmm0, %xmm4
; X86-AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; X86-AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm3
; X86-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; X86-AVX1-NEXT:    vxorps %xmm2, %xmm1, %xmm4
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X86-AVX1-NEXT:    vxorps %xmm2, %xmm0, %xmm5
; X86-AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm4
; X86-AVX1-NEXT:    vblendvpd %xmm4, %xmm0, %xmm1, %xmm0
; X86-AVX1-NEXT:    vxorpd %xmm2, %xmm0, %xmm1
; X86-AVX1-NEXT:    vxorpd %xmm2, %xmm3, %xmm4
; X86-AVX1-NEXT:    vpcmpgtq %xmm1, %xmm4, %xmm1
; X86-AVX1-NEXT:    vblendvpd %xmm1, %xmm3, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX1-NEXT:    vxorpd %xmm2, %xmm0, %xmm3
; X86-AVX1-NEXT:    vxorpd %xmm2, %xmm1, %xmm2
; X86-AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X86-AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X86-AVX1-NEXT:    vmovd %xmm0, %eax
; X86-AVX1-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX1-NEXT:    vzeroupper
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: test_reduce_v8i64:
; X86-AVX2:       ## %bb.0:
; X86-AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; X86-AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm3
; X86-AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm4
; X86-AVX2-NEXT:    vpcmpgtq %ymm3, %ymm4, %ymm3
; X86-AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm1, %ymm0
; X86-AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X86-AVX2-NEXT:    vxorpd %xmm2, %xmm1, %xmm3
; X86-AVX2-NEXT:    vxorpd %xmm2, %xmm0, %xmm4
; X86-AVX2-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; X86-AVX2-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; X86-AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX2-NEXT:    vxorpd %xmm2, %xmm0, %xmm3
; X86-AVX2-NEXT:    vxorpd %xmm2, %xmm1, %xmm2
; X86-AVX2-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X86-AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X86-AVX2-NEXT:    vmovd %xmm0, %eax
; X86-AVX2-NEXT:    vpextrd $1, %xmm0, %edx
; X86-AVX2-NEXT:    vzeroupper
; X86-AVX2-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v8i64:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [9223372039002259456,9223372039002259456]
; X64-SSE2-NEXT:    movdqa %xmm2, %xmm5
; X64-SSE2-NEXT:    pxor %xmm4, %xmm5
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm6
; X64-SSE2-NEXT:    pxor %xmm4, %xmm6
; X64-SSE2-NEXT:    movdqa %xmm6, %xmm7
; X64-SSE2-NEXT:    pcmpgtd %xmm5, %xmm7
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; X64-SSE2-NEXT:    pcmpeqd %xmm5, %xmm6
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; X64-SSE2-NEXT:    pand %xmm8, %xmm6
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; X64-SSE2-NEXT:    por %xmm6, %xmm5
; X64-SSE2-NEXT:    pand %xmm5, %xmm0
; X64-SSE2-NEXT:    pandn %xmm2, %xmm5
; X64-SSE2-NEXT:    por %xmm0, %xmm5
; X64-SSE2-NEXT:    movdqa %xmm3, %xmm0
; X64-SSE2-NEXT:    pxor %xmm4, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm2
; X64-SSE2-NEXT:    pxor %xmm4, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm2, %xmm6
; X64-SSE2-NEXT:    pcmpgtd %xmm0, %xmm6
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; X64-SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; X64-SSE2-NEXT:    pand %xmm7, %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[1,1,3,3]
; X64-SSE2-NEXT:    por %xmm0, %xmm2
; X64-SSE2-NEXT:    pand %xmm2, %xmm1
; X64-SSE2-NEXT:    pandn %xmm3, %xmm2
; X64-SSE2-NEXT:    por %xmm1, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm2, %xmm0
; X64-SSE2-NEXT:    pxor %xmm4, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm5, %xmm1
; X64-SSE2-NEXT:    pxor %xmm4, %xmm1
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm3
; X64-SSE2-NEXT:    pcmpgtd %xmm0, %xmm3
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[0,0,2,2]
; X64-SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,3,3]
; X64-SSE2-NEXT:    pand %xmm6, %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[1,1,3,3]
; X64-SSE2-NEXT:    por %xmm0, %xmm1
; X64-SSE2-NEXT:    pand %xmm1, %xmm5
; X64-SSE2-NEXT:    pandn %xmm2, %xmm1
; X64-SSE2-NEXT:    por %xmm5, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm2
; X64-SSE2-NEXT:    pxor %xmm4, %xmm2
; X64-SSE2-NEXT:    pxor %xmm0, %xmm4
; X64-SSE2-NEXT:    movdqa %xmm2, %xmm3
; X64-SSE2-NEXT:    pcmpgtd %xmm4, %xmm3
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[0,0,2,2]
; X64-SSE2-NEXT:    pcmpeqd %xmm2, %xmm4
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,1,3,3]
; X64-SSE2-NEXT:    pand %xmm5, %xmm2
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; X64-SSE2-NEXT:    por %xmm2, %xmm3
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pandn %xmm0, %xmm3
; X64-SSE2-NEXT:    por %xmm1, %xmm3
; X64-SSE2-NEXT:    movq %xmm3, %rax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v8i64:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    movdqa %xmm0, %xmm4
; X64-SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [9223372036854775808,9223372036854775808]
; X64-SSE42-NEXT:    movdqa %xmm2, %xmm6
; X64-SSE42-NEXT:    pxor %xmm5, %xmm6
; X64-SSE42-NEXT:    pxor %xmm5, %xmm0
; X64-SSE42-NEXT:    pcmpgtq %xmm6, %xmm0
; X64-SSE42-NEXT:    blendvpd %xmm0, %xmm4, %xmm2
; X64-SSE42-NEXT:    movdqa %xmm3, %xmm4
; X64-SSE42-NEXT:    pxor %xmm5, %xmm4
; X64-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE42-NEXT:    pxor %xmm5, %xmm0
; X64-SSE42-NEXT:    pcmpgtq %xmm4, %xmm0
; X64-SSE42-NEXT:    blendvpd %xmm0, %xmm1, %xmm3
; X64-SSE42-NEXT:    movapd %xmm3, %xmm1
; X64-SSE42-NEXT:    xorpd %xmm5, %xmm1
; X64-SSE42-NEXT:    movapd %xmm2, %xmm0
; X64-SSE42-NEXT:    xorpd %xmm5, %xmm0
; X64-SSE42-NEXT:    pcmpgtq %xmm1, %xmm0
; X64-SSE42-NEXT:    blendvpd %xmm0, %xmm2, %xmm3
; X64-SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[2,3,2,3]
; X64-SSE42-NEXT:    movdqa %xmm3, %xmm0
; X64-SSE42-NEXT:    pxor %xmm5, %xmm0
; X64-SSE42-NEXT:    pxor %xmm1, %xmm5
; X64-SSE42-NEXT:    pcmpgtq %xmm5, %xmm0
; X64-SSE42-NEXT:    blendvpd %xmm0, %xmm3, %xmm1
; X64-SSE42-NEXT:    movq %xmm1, %rax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v8i64:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; X64-AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm3
; X64-AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm4
; X64-AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; X64-AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm3
; X64-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm4
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; X64-AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm5
; X64-AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm4
; X64-AVX1-NEXT:    vblendvpd %xmm4, %xmm0, %xmm1, %xmm0
; X64-AVX1-NEXT:    vxorpd %xmm2, %xmm0, %xmm1
; X64-AVX1-NEXT:    vxorpd %xmm2, %xmm3, %xmm4
; X64-AVX1-NEXT:    vpcmpgtq %xmm1, %xmm4, %xmm1
; X64-AVX1-NEXT:    vblendvpd %xmm1, %xmm3, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX1-NEXT:    vxorpd %xmm2, %xmm0, %xmm3
; X64-AVX1-NEXT:    vxorpd %xmm2, %xmm1, %xmm2
; X64-AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X64-AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X64-AVX1-NEXT:    vmovq %xmm0, %rax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v8i64:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; X64-AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm3
; X64-AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm4
; X64-AVX2-NEXT:    vpcmpgtq %ymm3, %ymm4, %ymm3
; X64-AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm1, %ymm0
; X64-AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vxorpd %xmm2, %xmm1, %xmm3
; X64-AVX2-NEXT:    vxorpd %xmm2, %xmm0, %xmm4
; X64-AVX2-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; X64-AVX2-NEXT:    vblendvpd %xmm3, %xmm0, %xmm1, %xmm0
; X64-AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX2-NEXT:    vxorpd %xmm2, %xmm0, %xmm3
; X64-AVX2-NEXT:    vxorpd %xmm2, %xmm1, %xmm2
; X64-AVX2-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; X64-AVX2-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; X64-AVX2-NEXT:    vmovq %xmm0, %rax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v8i64:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-AVX512-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; X64-AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX512-NEXT:    vpmaxuq %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX512-NEXT:    vpmaxuq %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovq %xmm0, %rax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <8 x i64> %a0, <8 x i64> undef, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <8 x i64> %a0, %1
  %3  = select <8 x i1> %2, <8 x i64> %a0, <8 x i64> %1
  %4  = shufflevector <8 x i64> %3, <8 x i64> undef, <8 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <8 x i64> %3, %4
  %6  = select <8 x i1> %5, <8 x i64> %3, <8 x i64> %4
  %7  = shufflevector <8 x i64> %6, <8 x i64> undef, <8 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <8 x i64> %6, %7
  %9  = select <8 x i1> %8, <8 x i64> %6, <8 x i64> %7
  %10 = extractelement <8 x i64> %9, i32 0
  ret i64 %10
}

define i32 @test_reduce_v16i32(<16 x i32> %a0) {
; X86-SSE2-LABEL: test_reduce_v16i32:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; X86-SSE2-NEXT:    movdqa %xmm2, %xmm6
; X86-SSE2-NEXT:    pxor %xmm4, %xmm6
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm5
; X86-SSE2-NEXT:    pxor %xmm4, %xmm5
; X86-SSE2-NEXT:    pcmpgtd %xmm6, %xmm5
; X86-SSE2-NEXT:    pand %xmm5, %xmm0
; X86-SSE2-NEXT:    pandn %xmm2, %xmm5
; X86-SSE2-NEXT:    por %xmm0, %xmm5
; X86-SSE2-NEXT:    movdqa %xmm3, %xmm2
; X86-SSE2-NEXT:    pxor %xmm4, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    pxor %xmm4, %xmm0
; X86-SSE2-NEXT:    pcmpgtd %xmm2, %xmm0
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pandn %xmm3, %xmm0
; X86-SSE2-NEXT:    por %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    pxor %xmm4, %xmm2
; X86-SSE2-NEXT:    movdqa %xmm5, %xmm1
; X86-SSE2-NEXT:    pxor %xmm4, %xmm1
; X86-SSE2-NEXT:    pcmpgtd %xmm2, %xmm1
; X86-SSE2-NEXT:    pand %xmm1, %xmm5
; X86-SSE2-NEXT:    pandn %xmm0, %xmm1
; X86-SSE2-NEXT:    por %xmm5, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[2,3,2,3]
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    pxor %xmm4, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm2, %xmm3
; X86-SSE2-NEXT:    pxor %xmm4, %xmm3
; X86-SSE2-NEXT:    pcmpgtd %xmm3, %xmm0
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pandn %xmm2, %xmm0
; X86-SSE2-NEXT:    por %xmm1, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    pxor %xmm4, %xmm2
; X86-SSE2-NEXT:    pxor %xmm1, %xmm4
; X86-SSE2-NEXT:    pcmpgtd %xmm4, %xmm2
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pandn %xmm1, %xmm2
; X86-SSE2-NEXT:    por %xmm0, %xmm2
; X86-SSE2-NEXT:    movd %xmm2, %eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v16i32:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pmaxud %xmm3, %xmm1
; X86-SSE42-NEXT:    pmaxud %xmm2, %xmm0
; X86-SSE42-NEXT:    pmaxud %xmm1, %xmm0
; X86-SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE42-NEXT:    pmaxud %xmm0, %xmm1
; X86-SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE42-NEXT:    pmaxud %xmm1, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX1-LABEL: test_reduce_v16i32:
; X86-AVX1:       ## %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X86-AVX1-NEXT:    vpmaxud %xmm2, %xmm3, %xmm2
; X86-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpmaxud %xmm2, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vmovd %xmm0, %eax
; X86-AVX1-NEXT:    vzeroupper
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: test_reduce_v16i32:
; X86-AVX2:       ## %bb.0:
; X86-AVX2-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vmovd %xmm0, %eax
; X86-AVX2-NEXT:    vzeroupper
; X86-AVX2-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v16i32:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; X64-SSE2-NEXT:    movdqa %xmm2, %xmm6
; X64-SSE2-NEXT:    pxor %xmm4, %xmm6
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm5
; X64-SSE2-NEXT:    pxor %xmm4, %xmm5
; X64-SSE2-NEXT:    pcmpgtd %xmm6, %xmm5
; X64-SSE2-NEXT:    pand %xmm5, %xmm0
; X64-SSE2-NEXT:    pandn %xmm2, %xmm5
; X64-SSE2-NEXT:    por %xmm0, %xmm5
; X64-SSE2-NEXT:    movdqa %xmm3, %xmm0
; X64-SSE2-NEXT:    pxor %xmm4, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm2
; X64-SSE2-NEXT:    pxor %xmm4, %xmm2
; X64-SSE2-NEXT:    pcmpgtd %xmm0, %xmm2
; X64-SSE2-NEXT:    pand %xmm2, %xmm1
; X64-SSE2-NEXT:    pandn %xmm3, %xmm2
; X64-SSE2-NEXT:    por %xmm1, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm2, %xmm0
; X64-SSE2-NEXT:    pxor %xmm4, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm5, %xmm1
; X64-SSE2-NEXT:    pxor %xmm4, %xmm1
; X64-SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; X64-SSE2-NEXT:    pand %xmm1, %xmm5
; X64-SSE2-NEXT:    pandn %xmm2, %xmm1
; X64-SSE2-NEXT:    por %xmm5, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,2,3]
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm2
; X64-SSE2-NEXT:    pxor %xmm4, %xmm2
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm3
; X64-SSE2-NEXT:    pxor %xmm4, %xmm3
; X64-SSE2-NEXT:    pcmpgtd %xmm3, %xmm2
; X64-SSE2-NEXT:    pand %xmm2, %xmm1
; X64-SSE2-NEXT:    pandn %xmm0, %xmm2
; X64-SSE2-NEXT:    por %xmm1, %xmm2
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,1,1]
; X64-SSE2-NEXT:    movdqa %xmm2, %xmm1
; X64-SSE2-NEXT:    pxor %xmm4, %xmm1
; X64-SSE2-NEXT:    pxor %xmm0, %xmm4
; X64-SSE2-NEXT:    pcmpgtd %xmm4, %xmm1
; X64-SSE2-NEXT:    pand %xmm1, %xmm2
; X64-SSE2-NEXT:    pandn %xmm0, %xmm1
; X64-SSE2-NEXT:    por %xmm2, %xmm1
; X64-SSE2-NEXT:    movd %xmm1, %eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v16i32:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pmaxud %xmm3, %xmm1
; X64-SSE42-NEXT:    pmaxud %xmm2, %xmm0
; X64-SSE42-NEXT:    pmaxud %xmm1, %xmm0
; X64-SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE42-NEXT:    pmaxud %xmm0, %xmm1
; X64-SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE42-NEXT:    pmaxud %xmm1, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v16i32:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X64-AVX1-NEXT:    vpmaxud %xmm2, %xmm3, %xmm2
; X64-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpmaxud %xmm2, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X64-AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v16i32:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X64-AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v16i32:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-AVX512-NEXT:    vpmaxud %zmm1, %zmm0, %zmm0
; X64-AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX512-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-AVX512-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X64-AVX512-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <16 x i32> %a0, <16 x i32> undef, <16 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <16 x i32> %a0, %1
  %3  = select <16 x i1> %2, <16 x i32> %a0, <16 x i32> %1
  %4  = shufflevector <16 x i32> %3, <16 x i32> undef, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <16 x i32> %3, %4
  %6  = select <16 x i1> %5, <16 x i32> %3, <16 x i32> %4
  %7  = shufflevector <16 x i32> %6, <16 x i32> undef, <16 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <16 x i32> %6, %7
  %9  = select <16 x i1> %8, <16 x i32> %6, <16 x i32> %7
  %10 = shufflevector <16 x i32> %9, <16 x i32> undef, <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %11 = icmp ugt <16 x i32> %9, %10
  %12 = select <16 x i1> %11, <16 x i32> %9, <16 x i32> %10
  %13 = extractelement <16 x i32> %12, i32 0
  ret i32 %13
}

define i16 @test_reduce_v32i16(<32 x i16> %a0) {
; X86-SSE2-LABEL: test_reduce_v32i16:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    psubusw %xmm0, %xmm2
; X86-SSE2-NEXT:    paddw %xmm0, %xmm2
; X86-SSE2-NEXT:    psubusw %xmm1, %xmm3
; X86-SSE2-NEXT:    paddw %xmm1, %xmm3
; X86-SSE2-NEXT:    psubusw %xmm2, %xmm3
; X86-SSE2-NEXT:    paddw %xmm2, %xmm3
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,2,3]
; X86-SSE2-NEXT:    psubusw %xmm3, %xmm0
; X86-SSE2-NEXT:    paddw %xmm3, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X86-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X86-SSE2-NEXT:    paddw %xmm0, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    psrld $16, %xmm0
; X86-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X86-SSE2-NEXT:    paddw %xmm1, %xmm0
; X86-SSE2-NEXT:    movd %xmm0, %eax
; X86-SSE2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v32i16:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pmaxuw %xmm3, %xmm1
; X86-SSE42-NEXT:    pmaxuw %xmm2, %xmm0
; X86-SSE42-NEXT:    pmaxuw %xmm1, %xmm0
; X86-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm1
; X86-SSE42-NEXT:    phminposuw %xmm1, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    notl %eax
; X86-SSE42-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX1-LABEL: test_reduce_v32i16:
; X86-AVX1:       ## %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X86-AVX1-NEXT:    vpmaxuw %xmm2, %xmm3, %xmm2
; X86-AVX1-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpmaxuw %xmm2, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX1-NEXT:    vmovd %xmm0, %eax
; X86-AVX1-NEXT:    notl %eax
; X86-AVX1-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-AVX1-NEXT:    vzeroupper
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: test_reduce_v32i16:
; X86-AVX2:       ## %bb.0:
; X86-AVX2-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-AVX2-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX2-NEXT:    vmovd %xmm0, %eax
; X86-AVX2-NEXT:    notl %eax
; X86-AVX2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-AVX2-NEXT:    vzeroupper
; X86-AVX2-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v32i16:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    psubusw %xmm0, %xmm2
; X64-SSE2-NEXT:    paddw %xmm0, %xmm2
; X64-SSE2-NEXT:    psubusw %xmm1, %xmm3
; X64-SSE2-NEXT:    paddw %xmm1, %xmm3
; X64-SSE2-NEXT:    psubusw %xmm2, %xmm3
; X64-SSE2-NEXT:    paddw %xmm2, %xmm3
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,2,3]
; X64-SSE2-NEXT:    psubusw %xmm3, %xmm0
; X64-SSE2-NEXT:    paddw %xmm3, %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; X64-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X64-SSE2-NEXT:    paddw %xmm0, %xmm1
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE2-NEXT:    psrld $16, %xmm0
; X64-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X64-SSE2-NEXT:    paddw %xmm1, %xmm0
; X64-SSE2-NEXT:    movd %xmm0, %eax
; X64-SSE2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v32i16:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pmaxuw %xmm3, %xmm1
; X64-SSE42-NEXT:    pmaxuw %xmm2, %xmm0
; X64-SSE42-NEXT:    pmaxuw %xmm1, %xmm0
; X64-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm1
; X64-SSE42-NEXT:    phminposuw %xmm1, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    notl %eax
; X64-SSE42-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v32i16:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X64-AVX1-NEXT:    vpmaxuw %xmm2, %xmm3, %xmm2
; X64-AVX1-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpmaxuw %xmm2, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    notl %eax
; X64-AVX1-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v32i16:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    notl %eax
; X64-AVX2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v32i16:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-AVX512-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm0
; X64-AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX512-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; X64-AVX512-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    notl %eax
; X64-AVX512-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <32 x i16> %a0, <32 x i16> undef, <32 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <32 x i16> %a0, %1
  %3  = select <32 x i1> %2, <32 x i16> %a0, <32 x i16> %1
  %4  = shufflevector <32 x i16> %3, <32 x i16> undef, <32 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <32 x i16> %3, %4
  %6  = select <32 x i1> %5, <32 x i16> %3, <32 x i16> %4
  %7  = shufflevector <32 x i16> %6, <32 x i16> undef, <32 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <32 x i16> %6, %7
  %9  = select <32 x i1> %8, <32 x i16> %6, <32 x i16> %7
  %10 = shufflevector <32 x i16> %9, <32 x i16> undef, <32 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %11 = icmp ugt <32 x i16> %9, %10
  %12 = select <32 x i1> %11, <32 x i16> %9, <32 x i16> %10
  %13 = shufflevector <32 x i16> %12, <32 x i16> undef, <32 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %14 = icmp ugt <32 x i16> %12, %13
  %15 = select <32 x i1> %14, <32 x i16> %12, <32 x i16> %13
  %16 = extractelement <32 x i16> %15, i32 0
  ret i16 %16
}

define i8 @test_reduce_v64i8(<64 x i8> %a0) {
; X86-SSE2-LABEL: test_reduce_v64i8:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    pmaxub %xmm3, %xmm1
; X86-SSE2-NEXT:    pmaxub %xmm2, %xmm0
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $16, %xmm1
; X86-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    psrlw $8, %xmm0
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    movd %xmm0, %eax
; X86-SSE2-NEXT:    ## kill: def $al killed $al killed $eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v64i8:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pmaxub %xmm3, %xmm1
; X86-SSE42-NEXT:    pmaxub %xmm2, %xmm0
; X86-SSE42-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm1
; X86-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE42-NEXT:    psrlw $8, %xmm0
; X86-SSE42-NEXT:    pminub %xmm1, %xmm0
; X86-SSE42-NEXT:    phminposuw %xmm0, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    notb %al
; X86-SSE42-NEXT:    ## kill: def $al killed $al killed $eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX1-LABEL: test_reduce_v64i8:
; X86-AVX1:       ## %bb.0:
; X86-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X86-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X86-AVX1-NEXT:    vpmaxub %xmm2, %xmm3, %xmm2
; X86-AVX1-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpmaxub %xmm2, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X86-AVX1-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X86-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX1-NEXT:    vmovd %xmm0, %eax
; X86-AVX1-NEXT:    notb %al
; X86-AVX1-NEXT:    ## kill: def $al killed $al killed $eax
; X86-AVX1-NEXT:    vzeroupper
; X86-AVX1-NEXT:    retl
;
; X86-AVX2-LABEL: test_reduce_v64i8:
; X86-AVX2:       ## %bb.0:
; X86-AVX2-NEXT:    vpmaxub %ymm1, %ymm0, %ymm0
; X86-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X86-AVX2-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X86-AVX2-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X86-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX2-NEXT:    vmovd %xmm0, %eax
; X86-AVX2-NEXT:    notb %al
; X86-AVX2-NEXT:    ## kill: def $al killed $al killed $eax
; X86-AVX2-NEXT:    vzeroupper
; X86-AVX2-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v64i8:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    pmaxub %xmm3, %xmm1
; X64-SSE2-NEXT:    pmaxub %xmm2, %xmm0
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    psrld $16, %xmm1
; X64-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE2-NEXT:    psrlw $8, %xmm0
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    movd %xmm0, %eax
; X64-SSE2-NEXT:    ## kill: def $al killed $al killed $eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v64i8:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pmaxub %xmm3, %xmm1
; X64-SSE42-NEXT:    pmaxub %xmm2, %xmm0
; X64-SSE42-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm1
; X64-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE42-NEXT:    psrlw $8, %xmm0
; X64-SSE42-NEXT:    pminub %xmm1, %xmm0
; X64-SSE42-NEXT:    phminposuw %xmm0, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    notb %al
; X64-SSE42-NEXT:    ## kill: def $al killed $al killed $eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v64i8:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; X64-AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; X64-AVX1-NEXT:    vpmaxub %xmm2, %xmm3, %xmm2
; X64-AVX1-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpmaxub %xmm2, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX1-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    notb %al
; X64-AVX1-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v64i8:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpmaxub %ymm1, %ymm0, %ymm0
; X64-AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX2-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX2-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    notb %al
; X64-AVX2-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v64i8:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; X64-AVX512-NEXT:    vpmaxub %ymm1, %ymm0, %ymm0
; X64-AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; X64-AVX512-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX512-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    notb %al
; X64-AVX512-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <64 x i8> %a0, <64 x i8> undef, <64 x i32> <i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <64 x i8> %a0, %1
  %3  = select <64 x i1> %2, <64 x i8> %a0, <64 x i8> %1
  %4  = shufflevector <64 x i8> %3, <64 x i8> undef, <64 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <64 x i8> %3, %4
  %6  = select <64 x i1> %5, <64 x i8> %3, <64 x i8> %4
  %7  = shufflevector <64 x i8> %6, <64 x i8> undef, <64 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <64 x i8> %6, %7
  %9  = select <64 x i1> %8, <64 x i8> %6, <64 x i8> %7
  %10 = shufflevector <64 x i8> %9, <64 x i8> undef, <64 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %11 = icmp ugt <64 x i8> %9, %10
  %12 = select <64 x i1> %11, <64 x i8> %9, <64 x i8> %10
  %13 = shufflevector <64 x i8> %12, <64 x i8> undef, <64 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %14 = icmp ugt <64 x i8> %12, %13
  %15 = select <64 x i1> %14, <64 x i8> %12, <64 x i8> %13
  %16 = shufflevector <64 x i8> %15, <64 x i8> undef, <64 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %17 = icmp ugt <64 x i8> %15, %16
  %18 = select <64 x i1> %17, <64 x i8> %15, <64 x i8> %16
  %19 = extractelement <64 x i8> %18, i32 0
  ret i8 %19
}

;
; Partial Vector Reductions
;

define i16 @test_reduce_v16i16_v8i16(<16 x i16> %a0) {
; X86-SSE2-LABEL: test_reduce_v16i16_v8i16:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X86-SSE2-NEXT:    paddw %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X86-SSE2-NEXT:    paddw %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $16, %xmm1
; X86-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X86-SSE2-NEXT:    paddw %xmm0, %xmm1
; X86-SSE2-NEXT:    movd %xmm1, %eax
; X86-SSE2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v16i16_v8i16:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm1
; X86-SSE42-NEXT:    phminposuw %xmm1, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    notl %eax
; X86-SSE42-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX-LABEL: test_reduce_v16i16_v8i16:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX-NEXT:    vmovd %xmm0, %eax
; X86-AVX-NEXT:    notl %eax
; X86-AVX-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-AVX-NEXT:    vzeroupper
; X86-AVX-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v16i16_v8i16:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X64-SSE2-NEXT:    paddw %xmm0, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X64-SSE2-NEXT:    paddw %xmm1, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    psrld $16, %xmm1
; X64-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X64-SSE2-NEXT:    paddw %xmm0, %xmm1
; X64-SSE2-NEXT:    movd %xmm1, %eax
; X64-SSE2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v16i16_v8i16:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm1
; X64-SSE42-NEXT:    phminposuw %xmm1, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    notl %eax
; X64-SSE42-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v16i16_v8i16:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    notl %eax
; X64-AVX1-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v16i16_v8i16:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    notl %eax
; X64-AVX2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v16i16_v8i16:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; X64-AVX512-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    notl %eax
; X64-AVX512-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <16 x i16> %a0, <16 x i16> undef, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <16 x i16> %a0, %1
  %3  = select <16 x i1> %2, <16 x i16> %a0, <16 x i16> %1
  %4  = shufflevector <16 x i16> %3, <16 x i16> undef, <16 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <16 x i16> %3, %4
  %6  = select <16 x i1> %5, <16 x i16> %3, <16 x i16> %4
  %7  = shufflevector <16 x i16> %6, <16 x i16> undef, <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <16 x i16> %6, %7
  %9  = select <16 x i1> %8, <16 x i16> %6, <16 x i16> %7
  %10 = extractelement <16 x i16> %9, i32 0
  ret i16 %10
}

define i16 @test_reduce_v32i16_v8i16(<32 x i16> %a0) {
; X86-SSE2-LABEL: test_reduce_v32i16_v8i16:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X86-SSE2-NEXT:    paddw %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X86-SSE2-NEXT:    paddw %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $16, %xmm1
; X86-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X86-SSE2-NEXT:    paddw %xmm0, %xmm1
; X86-SSE2-NEXT:    movd %xmm1, %eax
; X86-SSE2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v32i16_v8i16:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm1
; X86-SSE42-NEXT:    phminposuw %xmm1, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    notl %eax
; X86-SSE42-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX-LABEL: test_reduce_v32i16_v8i16:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX-NEXT:    vmovd %xmm0, %eax
; X86-AVX-NEXT:    notl %eax
; X86-AVX-NEXT:    ## kill: def $ax killed $ax killed $eax
; X86-AVX-NEXT:    vzeroupper
; X86-AVX-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v32i16_v8i16:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X64-SSE2-NEXT:    paddw %xmm0, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE2-NEXT:    psubusw %xmm1, %xmm0
; X64-SSE2-NEXT:    paddw %xmm1, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    psrld $16, %xmm1
; X64-SSE2-NEXT:    psubusw %xmm0, %xmm1
; X64-SSE2-NEXT:    paddw %xmm0, %xmm1
; X64-SSE2-NEXT:    movd %xmm1, %eax
; X64-SSE2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v32i16_v8i16:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm1
; X64-SSE42-NEXT:    phminposuw %xmm1, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    notl %eax
; X64-SSE42-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v32i16_v8i16:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    notl %eax
; X64-AVX1-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v32i16_v8i16:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    notl %eax
; X64-AVX2-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v32i16_v8i16:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; X64-AVX512-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    notl %eax
; X64-AVX512-NEXT:    ## kill: def $ax killed $ax killed $eax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <32 x i16> %a0, <32 x i16> undef, <32 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <32 x i16> %a0, %1
  %3  = select <32 x i1> %2, <32 x i16> %a0, <32 x i16> %1
  %4  = shufflevector <32 x i16> %3, <32 x i16> undef, <32 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <32 x i16> %3, %4
  %6  = select <32 x i1> %5, <32 x i16> %3, <32 x i16> %4
  %7  = shufflevector <32 x i16> %6, <32 x i16> undef, <32 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <32 x i16> %6, %7
  %9  = select <32 x i1> %8, <32 x i16> %6, <32 x i16> %7
  %10 = extractelement <32 x i16> %9, i32 0
  ret i16 %10
}

define i8 @test_reduce_v32i8_v16i8(<32 x i8> %a0) {
; X86-SSE2-LABEL: test_reduce_v32i8_v16i8:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $16, %xmm1
; X86-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    psrlw $8, %xmm0
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    movd %xmm0, %eax
; X86-SSE2-NEXT:    ## kill: def $al killed $al killed $eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v32i8_v16i8:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm1
; X86-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE42-NEXT:    psrlw $8, %xmm0
; X86-SSE42-NEXT:    pminub %xmm1, %xmm0
; X86-SSE42-NEXT:    phminposuw %xmm0, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    notb %al
; X86-SSE42-NEXT:    ## kill: def $al killed $al killed $eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX-LABEL: test_reduce_v32i8_v16i8:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X86-AVX-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX-NEXT:    vmovd %xmm0, %eax
; X86-AVX-NEXT:    notb %al
; X86-AVX-NEXT:    ## kill: def $al killed $al killed $eax
; X86-AVX-NEXT:    vzeroupper
; X86-AVX-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v32i8_v16i8:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    psrld $16, %xmm1
; X64-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE2-NEXT:    psrlw $8, %xmm0
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    movd %xmm0, %eax
; X64-SSE2-NEXT:    ## kill: def $al killed $al killed $eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v32i8_v16i8:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm1
; X64-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE42-NEXT:    psrlw $8, %xmm0
; X64-SSE42-NEXT:    pminub %xmm1, %xmm0
; X64-SSE42-NEXT:    phminposuw %xmm0, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    notb %al
; X64-SSE42-NEXT:    ## kill: def $al killed $al killed $eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v32i8_v16i8:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX1-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    notb %al
; X64-AVX1-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v32i8_v16i8:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX2-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    notb %al
; X64-AVX2-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v32i8_v16i8:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX512-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    notb %al
; X64-AVX512-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <32 x i8> %a0, <32 x i8> undef, <32 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <32 x i8> %a0, %1
  %3  = select <32 x i1> %2, <32 x i8> %a0, <32 x i8> %1
  %4  = shufflevector <32 x i8> %3, <32 x i8> undef, <32 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <32 x i8> %3, %4
  %6  = select <32 x i1> %5, <32 x i8> %3, <32 x i8> %4
  %7  = shufflevector <32 x i8> %6, <32 x i8> undef, <32 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <32 x i8> %6, %7
  %9  = select <32 x i1> %8, <32 x i8> %6, <32 x i8> %7
  %10 = shufflevector <32 x i8> %9, <32 x i8> undef, <32 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %11 = icmp ugt <32 x i8> %9, %10
  %12 = select <32 x i1> %11, <32 x i8> %9, <32 x i8> %10
  %13 = extractelement <32 x i8> %12, i32 0
  ret i8 %13
}

define i8 @test_reduce_v64i8_v16i8(<64 x i8> %a0) {
; X86-SSE2-LABEL: test_reduce_v64i8_v16i8:
; X86-SSE2:       ## %bb.0:
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X86-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X86-SSE2-NEXT:    psrld $16, %xmm1
; X86-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X86-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE2-NEXT:    psrlw $8, %xmm0
; X86-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X86-SSE2-NEXT:    movd %xmm0, %eax
; X86-SSE2-NEXT:    ## kill: def $al killed $al killed $eax
; X86-SSE2-NEXT:    retl
;
; X86-SSE42-LABEL: test_reduce_v64i8_v16i8:
; X86-SSE42:       ## %bb.0:
; X86-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X86-SSE42-NEXT:    pxor %xmm0, %xmm1
; X86-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X86-SSE42-NEXT:    psrlw $8, %xmm0
; X86-SSE42-NEXT:    pminub %xmm1, %xmm0
; X86-SSE42-NEXT:    phminposuw %xmm0, %xmm0
; X86-SSE42-NEXT:    movd %xmm0, %eax
; X86-SSE42-NEXT:    notb %al
; X86-SSE42-NEXT:    ## kill: def $al killed $al killed $eax
; X86-SSE42-NEXT:    retl
;
; X86-AVX-LABEL: test_reduce_v64i8_v16i8:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X86-AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X86-AVX-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X86-AVX-NEXT:    vphminposuw %xmm0, %xmm0
; X86-AVX-NEXT:    vmovd %xmm0, %eax
; X86-AVX-NEXT:    notb %al
; X86-AVX-NEXT:    ## kill: def $al killed $al killed $eax
; X86-AVX-NEXT:    vzeroupper
; X86-AVX-NEXT:    retl
;
; X64-SSE2-LABEL: test_reduce_v64i8_v16i8:
; X64-SSE2:       ## %bb.0:
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[2,3,2,3]
; X64-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,1,1]
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm1
; X64-SSE2-NEXT:    psrld $16, %xmm1
; X64-SSE2-NEXT:    pmaxub %xmm0, %xmm1
; X64-SSE2-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE2-NEXT:    psrlw $8, %xmm0
; X64-SSE2-NEXT:    pmaxub %xmm1, %xmm0
; X64-SSE2-NEXT:    movd %xmm0, %eax
; X64-SSE2-NEXT:    ## kill: def $al killed $al killed $eax
; X64-SSE2-NEXT:    retq
;
; X64-SSE42-LABEL: test_reduce_v64i8_v16i8:
; X64-SSE42:       ## %bb.0:
; X64-SSE42-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE42-NEXT:    pxor %xmm0, %xmm1
; X64-SSE42-NEXT:    movdqa %xmm1, %xmm0
; X64-SSE42-NEXT:    psrlw $8, %xmm0
; X64-SSE42-NEXT:    pminub %xmm1, %xmm0
; X64-SSE42-NEXT:    phminposuw %xmm0, %xmm0
; X64-SSE42-NEXT:    movd %xmm0, %eax
; X64-SSE42-NEXT:    notb %al
; X64-SSE42-NEXT:    ## kill: def $al killed $al killed $eax
; X64-SSE42-NEXT:    retq
;
; X64-AVX1-LABEL: test_reduce_v64i8_v16i8:
; X64-AVX1:       ## %bb.0:
; X64-AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX1-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX1-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX1-NEXT:    vmovd %xmm0, %eax
; X64-AVX1-NEXT:    notb %al
; X64-AVX1-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX1-NEXT:    vzeroupper
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_reduce_v64i8_v16i8:
; X64-AVX2:       ## %bb.0:
; X64-AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; X64-AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX2-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX2-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX2-NEXT:    vmovd %xmm0, %eax
; X64-AVX2-NEXT:    notb %al
; X64-AVX2-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX2-NEXT:    vzeroupper
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_reduce_v64i8_v16i8:
; X64-AVX512:       ## %bb.0:
; X64-AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; X64-AVX512-NEXT:    vpsrlw $8, %xmm0, %xmm1
; X64-AVX512-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; X64-AVX512-NEXT:    vphminposuw %xmm0, %xmm0
; X64-AVX512-NEXT:    vmovd %xmm0, %eax
; X64-AVX512-NEXT:    notb %al
; X64-AVX512-NEXT:    ## kill: def $al killed $al killed $eax
; X64-AVX512-NEXT:    vzeroupper
; X64-AVX512-NEXT:    retq
  %1  = shufflevector <64 x i8> %a0, <64 x i8> undef, <64 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %2  = icmp ugt <64 x i8> %a0, %1
  %3  = select <64 x i1> %2, <64 x i8> %a0, <64 x i8> %1
  %4  = shufflevector <64 x i8> %3, <64 x i8> undef, <64 x i32> <i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %5  = icmp ugt <64 x i8> %3, %4
  %6  = select <64 x i1> %5, <64 x i8> %3, <64 x i8> %4
  %7  = shufflevector <64 x i8> %6, <64 x i8> undef, <64 x i32> <i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8  = icmp ugt <64 x i8> %6, %7
  %9  = select <64 x i1> %8, <64 x i8> %6, <64 x i8> %7
  %10 = shufflevector <64 x i8> %9, <64 x i8> undef, <64 x i32> <i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %11 = icmp ugt <64 x i8> %9, %10
  %12 = select <64 x i1> %11, <64 x i8> %9, <64 x i8> %10
  %13 = extractelement <64 x i8> %12, i32 0
  ret i8 %13
}
