; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @load_i64_stride7_vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i64_stride7_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movapd 96(%rdi), %xmm0
; SSE-NEXT:    movapd 80(%rdi), %xmm1
; SSE-NEXT:    movapd 64(%rdi), %xmm2
; SSE-NEXT:    movapd (%rdi), %xmm3
; SSE-NEXT:    movapd 16(%rdi), %xmm4
; SSE-NEXT:    movapd 32(%rdi), %xmm5
; SSE-NEXT:    movapd 48(%rdi), %xmm6
; SSE-NEXT:    movapd %xmm6, %xmm7
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm3[0],xmm7[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm3 = xmm3[1],xmm2[0]
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm4[0],xmm2[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm4 = xmm4[1],xmm1[0]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm5[0],xmm1[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm0[0]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm6[0],xmm0[1]
; SSE-NEXT:    movapd %xmm7, (%rsi)
; SSE-NEXT:    movapd %xmm3, (%rdx)
; SSE-NEXT:    movapd %xmm2, (%rcx)
; SSE-NEXT:    movapd %xmm4, (%r8)
; SSE-NEXT:    movapd %xmm1, (%r9)
; SSE-NEXT:    movapd %xmm5, (%r10)
; SSE-NEXT:    movapd %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: load_i64_stride7_vf2:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovapd 16(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovapd 80(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = mem[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm2 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm5 = xmm0[0],mem[1]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm3[0],ymm0[2],ymm3[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm3 = mem[0],xmm3[1]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm6 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vmovaps %xmm4, (%rsi)
; AVX1-ONLY-NEXT:    vmovdqa %xmm2, (%rdx)
; AVX1-ONLY-NEXT:    vmovapd %xmm5, (%rcx)
; AVX1-ONLY-NEXT:    vmovapd %xmm0, (%r8)
; AVX1-ONLY-NEXT:    vmovapd %xmm3, (%r9)
; AVX1-ONLY-NEXT:    vmovdqa %xmm6, (%r10)
; AVX1-ONLY-NEXT:    vmovaps %xmm1, (%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: load_i64_stride7_vf2:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 48(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = mem[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 16(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm6
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm6 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vmovaps %xmm2, (%rsi)
; AVX2-ONLY-NEXT:    vmovdqa %xmm3, (%rdx)
; AVX2-ONLY-NEXT:    vmovaps %xmm4, (%rcx)
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm0, (%r8)
; AVX2-ONLY-NEXT:    vmovaps %xmm5, (%r9)
; AVX2-ONLY-NEXT:    vmovdqa %xmm6, (%r10)
; AVX2-ONLY-NEXT:    vmovaps %xmm1, (%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: load_i64_stride7_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX512-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],xmm3[2,3]
; AVX512-NEXT:    vmovdqa 64(%rdi), %xmm5
; AVX512-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm5 = xmm1[0,1],xmm5[2,3]
; AVX512-NEXT:    vmovdqa 80(%rdi), %xmm6
; AVX512-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm6 = xmm2[0,1],xmm6[2,3]
; AVX512-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX512-NEXT:    vpalignr {{.*#+}} xmm2 = xmm2[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX512-NEXT:    vpblendd {{.*#+}} xmm3 = xmm3[0,1],xmm7[2,3]
; AVX512-NEXT:    vmovdqa %xmm4, (%rsi)
; AVX512-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512-NEXT:    vmovdqa %xmm5, (%rcx)
; AVX512-NEXT:    vmovdqa %xmm1, (%r8)
; AVX512-NEXT:    vmovdqa %xmm6, (%r9)
; AVX512-NEXT:    vmovdqa %xmm2, (%r10)
; AVX512-NEXT:    vmovdqa %xmm3, (%rax)
; AVX512-NEXT:    retq
  %wide.vec = load <14 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <14 x i64> %wide.vec, <14 x i64> poison, <2 x i32> <i32 0, i32 7>
  %strided.vec1 = shufflevector <14 x i64> %wide.vec, <14 x i64> poison, <2 x i32> <i32 1, i32 8>
  %strided.vec2 = shufflevector <14 x i64> %wide.vec, <14 x i64> poison, <2 x i32> <i32 2, i32 9>
  %strided.vec3 = shufflevector <14 x i64> %wide.vec, <14 x i64> poison, <2 x i32> <i32 3, i32 10>
  %strided.vec4 = shufflevector <14 x i64> %wide.vec, <14 x i64> poison, <2 x i32> <i32 4, i32 11>
  %strided.vec5 = shufflevector <14 x i64> %wide.vec, <14 x i64> poison, <2 x i32> <i32 5, i32 12>
  %strided.vec6 = shufflevector <14 x i64> %wide.vec, <14 x i64> poison, <2 x i32> <i32 6, i32 13>
  store <2 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <2 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <2 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <2 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <2 x i64> %strided.vec4, ptr %out.vec4, align 64
  store <2 x i64> %strided.vec5, ptr %out.vec5, align 64
  store <2 x i64> %strided.vec6, ptr %out.vec6, align 64
  ret void
}

define void @load_i64_stride7_vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i64_stride7_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movapd 208(%rdi), %xmm1
; SSE-NEXT:    movapd 96(%rdi), %xmm0
; SSE-NEXT:    movapd 144(%rdi), %xmm2
; SSE-NEXT:    movapd 192(%rdi), %xmm4
; SSE-NEXT:    movapd 80(%rdi), %xmm3
; SSE-NEXT:    movapd 128(%rdi), %xmm5
; SSE-NEXT:    movapd 176(%rdi), %xmm8
; SSE-NEXT:    movapd 64(%rdi), %xmm7
; SSE-NEXT:    movapd (%rdi), %xmm10
; SSE-NEXT:    movapd 16(%rdi), %xmm9
; SSE-NEXT:    movapd 32(%rdi), %xmm6
; SSE-NEXT:    movapd 48(%rdi), %xmm11
; SSE-NEXT:    movapd 112(%rdi), %xmm12
; SSE-NEXT:    movapd 160(%rdi), %xmm13
; SSE-NEXT:    movapd %xmm13, %xmm14
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm12[0],xmm14[1]
; SSE-NEXT:    movapd %xmm11, %xmm15
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm10[0],xmm15[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm10 = xmm10[1],xmm7[0]
; SSE-NEXT:    shufpd {{.*#+}} xmm12 = xmm12[1],xmm8[0]
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm9[0],xmm7[1]
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm5[0],xmm8[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm9 = xmm9[1],xmm3[0]
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm4[0]
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm6[0],xmm3[1]
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm2[0],xmm4[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm6 = xmm6[1],xmm0[0]
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm11[0],xmm0[1]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm13[0],xmm1[1]
; SSE-NEXT:    movapd %xmm14, 16(%rsi)
; SSE-NEXT:    movapd %xmm15, (%rsi)
; SSE-NEXT:    movapd %xmm12, 16(%rdx)
; SSE-NEXT:    movapd %xmm10, (%rdx)
; SSE-NEXT:    movapd %xmm8, 16(%rcx)
; SSE-NEXT:    movapd %xmm7, (%rcx)
; SSE-NEXT:    movapd %xmm5, 16(%r8)
; SSE-NEXT:    movapd %xmm9, (%r8)
; SSE-NEXT:    movapd %xmm4, 16(%r9)
; SSE-NEXT:    movapd %xmm3, (%r9)
; SSE-NEXT:    movapd %xmm2, 16(%r10)
; SSE-NEXT:    movapd %xmm6, (%r10)
; SSE-NEXT:    movapd %xmm1, 16(%rax)
; SSE-NEXT:    movapd %xmm0, (%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: load_i64_stride7_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovapd 192(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovapd 128(%rdi), %ymm2
; AVX1-ONLY-NEXT:    vmovapd 160(%rdi), %ymm4
; AVX1-ONLY-NEXT:    vmovapd 96(%rdi), %ymm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rdi), %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm5[0,1,2],ymm1[3]
; AVX1-ONLY-NEXT:    vmovapd 16(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovapd 48(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vmovapd 80(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm10 = mem[0],xmm3[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm10[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm4[0],ymm5[3],ymm4[2]
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm8[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovdqa 128(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm10
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm10[0,1,2],ymm4[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm10 = xmm7[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm10[0,1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm7 = ymm7[1],ymm9[0],ymm7[2],ymm9[2]
; AVX1-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = xmm8[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm7[0,1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm2[0,1,2],ymm8[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm9 = mem[0],xmm9[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm9[0,1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[3],ymm0[2]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm9 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm9[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm3[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovapd %ymm6, (%rsi)
; AVX1-ONLY-NEXT:    vmovapd %ymm5, (%rdx)
; AVX1-ONLY-NEXT:    vmovapd %ymm4, (%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm7, (%r8)
; AVX1-ONLY-NEXT:    vmovapd %ymm8, (%r9)
; AVX1-ONLY-NEXT:    vmovapd %ymm2, (%r10)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, (%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: load_i64_stride7_vf4:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %ymm6
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %ymm7
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm7[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm8 = mem[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm8[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm7 = ymm7[8,9,10,11,12,13,14,15],ymm6[0,1,2,3,4,5,6,7],ymm7[24,25,26,27,28,29,30,31],ymm6[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq 128(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm8[1],ymm6[1],ymm8[3],ymm6[3]
; AVX2-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm8 = xmm8[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm8[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm5 = mem[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm9 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm5 = ymm5[2,3],ymm9[2,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm2[0,1,2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm9 = xmm9[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm2 = ymm2[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm9 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm9[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq %xmm1, %ymm1
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm3[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa %ymm4, (%rsi)
; AVX2-ONLY-NEXT:    vmovdqa %ymm7, (%rdx)
; AVX2-ONLY-NEXT:    vmovdqa %ymm6, (%rcx)
; AVX2-ONLY-NEXT:    vmovdqa %ymm5, (%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm8, (%r9)
; AVX2-ONLY-NEXT:    vmovdqa %ymm2, (%r10)
; AVX2-ONLY-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-SLOW-LABEL: load_i64_stride7_vf4:
; AVX512F-SLOW:       # %bb.0:
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm3
; AVX512F-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm4
; AVX512F-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512F-SLOW-NEXT:    vinserti128 $1, 160(%rdi), %ymm0, %ymm0
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <0,7,14,u>
; AVX512F-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm1
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <9,0,7,u>
; AVX512F-SLOW-NEXT:    vpermi2q %zmm5, %zmm4, %zmm1
; AVX512F-SLOW-NEXT:    vpbroadcastq 176(%rdi), %ymm2
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX512F-SLOW-NEXT:    vmovdqa 128(%rdi), %xmm6
; AVX512F-SLOW-NEXT:    vpbroadcastq %xmm6, %ymm2
; AVX512F-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512F-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm7
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1],mem[2,3]
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm7[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX512F-SLOW-NEXT:    vpalignr {{.*#+}} ymm7 = mem[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX512F-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm8
; AVX512F-SLOW-NEXT:    vpalignr {{.*#+}} xmm6 = xmm6[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512F-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm6 = ymm7[2,3],ymm6[2,3]
; AVX512F-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm7
; AVX512F-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm8
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0,1,2,3,4,5],ymm7[6,7]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = [4,11]
; AVX512F-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm9[0,1,2,3],ymm7[4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa 192(%rdi), %ymm9
; AVX512F-SLOW-NEXT:    vpalignr {{.*#+}} ymm8 = ymm8[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = [5,12]
; AVX512F-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [4,11,4,11]
; AVX512F-SLOW-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512F-SLOW-NEXT:    vpermi2q 192(%rdi), %zmm3, %zmm9
; AVX512F-SLOW-NEXT:    vmovdqa {{.*#+}} xmm3 = [6,13]
; AVX512F-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm3
; AVX512F-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm9[4,5,6,7]
; AVX512F-SLOW-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm1, (%rdx)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm6, (%r8)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm7, (%r9)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm8, (%r10)
; AVX512F-SLOW-NEXT:    vmovdqa %ymm3, (%rax)
; AVX512F-SLOW-NEXT:    vzeroupper
; AVX512F-SLOW-NEXT:    retq
;
; AVX512F-FAST-LABEL: load_i64_stride7_vf4:
; AVX512F-FAST:       # %bb.0:
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm3
; AVX512F-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm4
; AVX512F-FAST-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512F-FAST-NEXT:    vinserti128 $1, 160(%rdi), %ymm0, %ymm0
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <0,7,14,u>
; AVX512F-FAST-NEXT:    vpermi2q %zmm4, %zmm5, %zmm1
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <9,0,7,u>
; AVX512F-FAST-NEXT:    vpermi2q %zmm5, %zmm4, %zmm1
; AVX512F-FAST-NEXT:    vpbroadcastq 176(%rdi), %ymm2
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX512F-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [0,7,0,7]
; AVX512F-FAST-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512F-FAST-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512F-FAST-NEXT:    vpermi2q 160(%rdi), %ymm6, %ymm2
; AVX512F-FAST-NEXT:    vmovdqa 16(%rdi), %xmm7
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1],mem[2,3]
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm7[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-FAST-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX512F-FAST-NEXT:    vpalignr {{.*#+}} ymm7 = mem[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX512F-FAST-NEXT:    vmovdqa 192(%rdi), %xmm8
; AVX512F-FAST-NEXT:    vpalignr {{.*#+}} xmm9 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512F-FAST-NEXT:    vperm2i128 {{.*#+}} ymm7 = ymm7[2,3],ymm9[2,3]
; AVX512F-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3,4,5],ymm8[6,7]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = [4,11]
; AVX512F-FAST-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-FAST-NEXT:    vmovdqa 192(%rdi), %ymm9
; AVX512F-FAST-NEXT:    vpalignr {{.*#+}} ymm6 = ymm6[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = [5,12]
; AVX512F-FAST-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [4,11,4,11]
; AVX512F-FAST-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512F-FAST-NEXT:    vpermi2q 192(%rdi), %zmm3, %zmm9
; AVX512F-FAST-NEXT:    vmovdqa {{.*#+}} xmm3 = [6,13]
; AVX512F-FAST-NEXT:    vpermi2q %zmm4, %zmm5, %zmm3
; AVX512F-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm9[4,5,6,7]
; AVX512F-FAST-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512F-FAST-NEXT:    vmovdqa %ymm1, (%rdx)
; AVX512F-FAST-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX512F-FAST-NEXT:    vmovdqa %ymm7, (%r8)
; AVX512F-FAST-NEXT:    vmovdqa %ymm8, (%r9)
; AVX512F-FAST-NEXT:    vmovdqa %ymm6, (%r10)
; AVX512F-FAST-NEXT:    vmovdqa %ymm3, (%rax)
; AVX512F-FAST-NEXT:    vzeroupper
; AVX512F-FAST-NEXT:    retq
;
; AVX512BW-SLOW-LABEL: load_i64_stride7_vf4:
; AVX512BW-SLOW:       # %bb.0:
; AVX512BW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm3
; AVX512BW-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm4
; AVX512BW-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512BW-SLOW-NEXT:    vinserti128 $1, 160(%rdi), %ymm0, %ymm0
; AVX512BW-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <0,7,14,u>
; AVX512BW-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm1
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-SLOW-NEXT:    vmovdqa {{.*#+}} ymm1 = <9,0,7,u>
; AVX512BW-SLOW-NEXT:    vpermi2q %zmm5, %zmm4, %zmm1
; AVX512BW-SLOW-NEXT:    vpbroadcastq 176(%rdi), %ymm2
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX512BW-SLOW-NEXT:    vmovdqa 128(%rdi), %xmm6
; AVX512BW-SLOW-NEXT:    vpbroadcastq %xmm6, %ymm2
; AVX512BW-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm7
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1],mem[2,3]
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm7[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX512BW-SLOW-NEXT:    vpalignr {{.*#+}} ymm7 = mem[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX512BW-SLOW-NEXT:    vmovdqa 192(%rdi), %xmm8
; AVX512BW-SLOW-NEXT:    vpalignr {{.*#+}} xmm6 = xmm6[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm6 = ymm7[2,3],ymm6[2,3]
; AVX512BW-SLOW-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm7
; AVX512BW-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm8
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0,1,2,3,4,5],ymm7[6,7]
; AVX512BW-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = [4,11]
; AVX512BW-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm7 = ymm9[0,1,2,3],ymm7[4,5,6,7]
; AVX512BW-SLOW-NEXT:    vmovdqa 192(%rdi), %ymm9
; AVX512BW-SLOW-NEXT:    vpalignr {{.*#+}} ymm8 = ymm8[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX512BW-SLOW-NEXT:    vmovdqa {{.*#+}} xmm9 = [5,12]
; AVX512BW-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [4,11,4,11]
; AVX512BW-SLOW-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512BW-SLOW-NEXT:    vpermi2q 192(%rdi), %zmm3, %zmm9
; AVX512BW-SLOW-NEXT:    vmovdqa {{.*#+}} xmm3 = [6,13]
; AVX512BW-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm3
; AVX512BW-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm9[4,5,6,7]
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm1, (%rdx)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm6, (%r8)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm7, (%r9)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm8, (%r10)
; AVX512BW-SLOW-NEXT:    vmovdqa %ymm3, (%rax)
; AVX512BW-SLOW-NEXT:    vzeroupper
; AVX512BW-SLOW-NEXT:    retq
;
; AVX512BW-FAST-LABEL: load_i64_stride7_vf4:
; AVX512BW-FAST:       # %bb.0:
; AVX512BW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm3
; AVX512BW-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm4
; AVX512BW-FAST-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512BW-FAST-NEXT:    vinserti128 $1, 160(%rdi), %ymm0, %ymm0
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <0,7,14,u>
; AVX512BW-FAST-NEXT:    vpermi2q %zmm4, %zmm5, %zmm1
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = <9,0,7,u>
; AVX512BW-FAST-NEXT:    vpermi2q %zmm5, %zmm4, %zmm1
; AVX512BW-FAST-NEXT:    vpbroadcastq 176(%rdi), %ymm2
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX512BW-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [0,7,0,7]
; AVX512BW-FAST-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512BW-FAST-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512BW-FAST-NEXT:    vpermi2q 160(%rdi), %ymm6, %ymm2
; AVX512BW-FAST-NEXT:    vmovdqa 16(%rdi), %xmm7
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1],mem[2,3]
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm7[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-FAST-NEXT:    vmovdqa 64(%rdi), %ymm7
; AVX512BW-FAST-NEXT:    vpalignr {{.*#+}} ymm7 = mem[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX512BW-FAST-NEXT:    vmovdqa 192(%rdi), %xmm8
; AVX512BW-FAST-NEXT:    vpalignr {{.*#+}} xmm9 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX512BW-FAST-NEXT:    vperm2i128 {{.*#+}} ymm7 = ymm7[2,3],ymm9[2,3]
; AVX512BW-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3,4,5],ymm8[6,7]
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = [4,11]
; AVX512BW-FAST-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-FAST-NEXT:    vmovdqa 192(%rdi), %ymm9
; AVX512BW-FAST-NEXT:    vpalignr {{.*#+}} ymm6 = ymm6[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} xmm9 = [5,12]
; AVX512BW-FAST-NEXT:    vpermi2q %zmm4, %zmm5, %zmm9
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3],ymm6[4,5,6,7]
; AVX512BW-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [4,11,4,11]
; AVX512BW-FAST-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512BW-FAST-NEXT:    vpermi2q 192(%rdi), %zmm3, %zmm9
; AVX512BW-FAST-NEXT:    vmovdqa {{.*#+}} xmm3 = [6,13]
; AVX512BW-FAST-NEXT:    vpermi2q %zmm4, %zmm5, %zmm3
; AVX512BW-FAST-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm9[4,5,6,7]
; AVX512BW-FAST-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm1, (%rdx)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm7, (%r8)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm8, (%r9)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm6, (%r10)
; AVX512BW-FAST-NEXT:    vmovdqa %ymm3, (%rax)
; AVX512BW-FAST-NEXT:    vzeroupper
; AVX512BW-FAST-NEXT:    retq
  %wide.vec = load <28 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <28 x i64> %wide.vec, <28 x i64> poison, <4 x i32> <i32 0, i32 7, i32 14, i32 21>
  %strided.vec1 = shufflevector <28 x i64> %wide.vec, <28 x i64> poison, <4 x i32> <i32 1, i32 8, i32 15, i32 22>
  %strided.vec2 = shufflevector <28 x i64> %wide.vec, <28 x i64> poison, <4 x i32> <i32 2, i32 9, i32 16, i32 23>
  %strided.vec3 = shufflevector <28 x i64> %wide.vec, <28 x i64> poison, <4 x i32> <i32 3, i32 10, i32 17, i32 24>
  %strided.vec4 = shufflevector <28 x i64> %wide.vec, <28 x i64> poison, <4 x i32> <i32 4, i32 11, i32 18, i32 25>
  %strided.vec5 = shufflevector <28 x i64> %wide.vec, <28 x i64> poison, <4 x i32> <i32 5, i32 12, i32 19, i32 26>
  %strided.vec6 = shufflevector <28 x i64> %wide.vec, <28 x i64> poison, <4 x i32> <i32 6, i32 13, i32 20, i32 27>
  store <4 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <4 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <4 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <4 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <4 x i64> %strided.vec4, ptr %out.vec4, align 64
  store <4 x i64> %strided.vec5, ptr %out.vec5, align 64
  store <4 x i64> %strided.vec6, ptr %out.vec6, align 64
  ret void
}

define void @load_i64_stride7_vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i64_stride7_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $88, %rsp
; SSE-NEXT:    movapd 320(%rdi), %xmm0
; SSE-NEXT:    movapd 208(%rdi), %xmm1
; SSE-NEXT:    movapd 256(%rdi), %xmm2
; SSE-NEXT:    movapd 144(%rdi), %xmm3
; SSE-NEXT:    movapd 304(%rdi), %xmm4
; SSE-NEXT:    movapd 192(%rdi), %xmm5
; SSE-NEXT:    movapd 240(%rdi), %xmm6
; SSE-NEXT:    movapd 128(%rdi), %xmm7
; SSE-NEXT:    movapd 288(%rdi), %xmm8
; SSE-NEXT:    movapd 176(%rdi), %xmm9
; SSE-NEXT:    movapd 336(%rdi), %xmm10
; SSE-NEXT:    movapd 224(%rdi), %xmm11
; SSE-NEXT:    movapd 272(%rdi), %xmm14
; SSE-NEXT:    movapd 112(%rdi), %xmm13
; SSE-NEXT:    movapd 160(%rdi), %xmm15
; SSE-NEXT:    movapd %xmm15, %xmm12
; SSE-NEXT:    movsd {{.*#+}} xmm12 = xmm13[0],xmm12[1]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm13 = xmm13[1],xmm9[0]
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm7[0],xmm9[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm5[0]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm3[0],xmm5[1]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm3 = xmm3[1],xmm1[0]
; SSE-NEXT:    movapd %xmm3, (%rsp) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm15[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm14, %xmm15
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm11[0],xmm15[1]
; SSE-NEXT:    shufpd {{.*#+}} xmm11 = xmm11[1],xmm8[0]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm6[0],xmm8[1]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm6 = xmm6[1],xmm4[0]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm2[0],xmm4[1]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm0[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm14[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%rdi), %xmm5
; SSE-NEXT:    movapd %xmm5, %xmm14
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm10[0],xmm14[1]
; SSE-NEXT:    movapd 400(%rdi), %xmm7
; SSE-NEXT:    shufpd {{.*#+}} xmm10 = xmm10[1],xmm7[0]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%rdi), %xmm8
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm8[0],xmm7[1]
; SSE-NEXT:    movapd 416(%rdi), %xmm9
; SSE-NEXT:    shufpd {{.*#+}} xmm8 = xmm8[1],xmm9[0]
; SSE-NEXT:    movapd 368(%rdi), %xmm10
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm10[0],xmm9[1]
; SSE-NEXT:    movapd 432(%rdi), %xmm11
; SSE-NEXT:    shufpd {{.*#+}} xmm10 = xmm10[1],xmm11[0]
; SSE-NEXT:    movsd {{.*#+}} xmm11 = xmm5[0],xmm11[1]
; SSE-NEXT:    movapd (%rdi), %xmm5
; SSE-NEXT:    movapd 48(%rdi), %xmm12
; SSE-NEXT:    movapd %xmm12, %xmm6
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm5[0],xmm6[1]
; SSE-NEXT:    movapd 64(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm0[0]
; SSE-NEXT:    movapd 16(%rdi), %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    movapd 80(%rdi), %xmm2
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm2[0]
; SSE-NEXT:    movapd 32(%rdi), %xmm3
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm3[0],xmm2[1]
; SSE-NEXT:    movapd 96(%rdi), %xmm4
; SSE-NEXT:    shufpd {{.*#+}} xmm3 = xmm3[1],xmm4[0]
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm12[0],xmm4[1]
; SSE-NEXT:    movapd %xmm6, (%rsi)
; SSE-NEXT:    movapd %xmm14, 48(%rsi)
; SSE-NEXT:    movapd %xmm15, 32(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    movaps %xmm6, 16(%rsi)
; SSE-NEXT:    movapd %xmm5, (%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, 32(%rdx)
; SSE-NEXT:    movapd %xmm13, 16(%rdx)
; SSE-NEXT:    movapd %xmm0, (%rcx)
; SSE-NEXT:    movapd %xmm7, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movapd %xmm1, (%r8)
; SSE-NEXT:    movapd %xmm8, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movapd %xmm2, (%r9)
; SSE-NEXT:    movapd %xmm9, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm3, (%rax)
; SSE-NEXT:    movapd %xmm10, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm4, (%rax)
; SSE-NEXT:    movapd %xmm11, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    addq $88, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: load_i64_stride7_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovapd 384(%rdi), %ymm10
; AVX1-ONLY-NEXT:    vmovapd 160(%rdi), %ymm8
; AVX1-ONLY-NEXT:    vmovapd 320(%rdi), %ymm7
; AVX1-ONLY-NEXT:    vmovapd 96(%rdi), %ymm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm6[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vmovapd 48(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vmovapd 80(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm3 = mem[0],xmm1[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 384(%rdi), %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm7[0,1,2],ymm3[3]
; AVX1-ONLY-NEXT:    vmovapd 224(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vmovapd 272(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm14 = xmm13[0],xmm4[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm14[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm8[0],ymm6[3],ymm8[2]
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm12[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm14[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm7 = ymm7[0],ymm10[0],ymm7[3],ymm10[2]
; AVX1-ONLY-NEXT:    vmovdqa 288(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm13 = xmm13[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm13[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovdqa 128(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm14
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm14[0,1,2],ymm8[3]
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm12 = xmm11[0,1,2,3],xmm12[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm12[0,1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vmovdqa 352(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm14
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm10 = ymm14[0,1,2],ymm10[3]
; AVX1-ONLY-NEXT:    vmovapd 240(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm15 = xmm14[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm10 = ymm15[0,1],ymm10[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm11 = ymm11[1],ymm9[0],ymm11[2],ymm9[2]
; AVX1-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm13 = xmm13[8,9,10,11,12,13,14,15],xmm15[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm13
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm11 = ymm11[0,1],ymm13[2,3]
; AVX1-ONLY-NEXT:    vmovapd 304(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm14[1],ymm13[0],ymm14[2],ymm13[2]
; AVX1-ONLY-NEXT:    vmovdqa 416(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm12 = xmm12[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm12 = ymm14[0,1],ymm12[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm14
; AVX1-ONLY-NEXT:    vmovapd 128(%rdi), %ymm15
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm15[0,1,2],ymm14[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm9 = mem[0],xmm9[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm9 = ymm9[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovapd 352(%rdi), %ymm14
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm14[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 256(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm13 = xmm1[0],xmm13[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm13[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovapd 192(%rdi), %ymm13
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm15 = ymm15[0],ymm13[0],ymm15[3],ymm13[2]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0,1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vmovapd 416(%rdi), %ymm15
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm14[0],ymm15[0],ymm14[3],ymm15[2]
; AVX1-ONLY-NEXT:    vmovdqa 320(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm13 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm13 = mem[0,1,2],ymm13[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm14 = xmm14[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm13 = ymm14[0,1],ymm13[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1,2],ymm15[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 32(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm3, (%rsi)
; AVX1-ONLY-NEXT:    vmovapd %ymm7, 32(%rdx)
; AVX1-ONLY-NEXT:    vmovapd %ymm6, (%rdx)
; AVX1-ONLY-NEXT:    vmovapd %ymm10, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm8, (%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm12, 32(%r8)
; AVX1-ONLY-NEXT:    vmovapd %ymm11, (%r8)
; AVX1-ONLY-NEXT:    vmovapd %ymm2, 32(%r9)
; AVX1-ONLY-NEXT:    vmovapd %ymm9, (%r9)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovapd %ymm1, 32(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm5, (%rax)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm13, (%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: load_i64_stride7_vf8:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    vmovdqa 128(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 288(%rdi), %ymm10
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %ymm12
; AVX2-ONLY-NEXT:    vmovdqa 384(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %ymm9
; AVX2-ONLY-NEXT:    vmovdqa 320(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %ymm7
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = mem[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 384(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm8[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 224(%rdi), %xmm13
; AVX2-ONLY-NEXT:    vmovdqa 272(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm14 = xmm13[0,1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm7 = ymm7[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],ymm7[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm15 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm8 = ymm8[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 288(%rdi), %xmm15
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm13 = xmm13[8,9,10,11,12,13,14,15],xmm15[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm13[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq 128(%rdi), %ymm13
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm9 = ymm13[1],ymm9[1],ymm13[3],ymm9[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm13 = mem[0,1],xmm14[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm9 = ymm13[0,1,2,3],ymm9[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq 352(%rdi), %ymm13
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm11 = ymm13[1],ymm11[1],ymm13[3],ymm11[3]
; AVX2-ONLY-NEXT:    vmovdqa 240(%rdi), %xmm13
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm11 = ymm13[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm12 = mem[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm13
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm12 = ymm12[2,3],ymm14[2,3]
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm10 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 416(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm15 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm10 = ymm10[2,3],ymm15[2,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm4[0,1,2,3,4,5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm15
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm15 = xmm15[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm15[0,1,2,3],ymm13[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 352(%rdi), %ymm15
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm14 = ymm15[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 256(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm6 = xmm0[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm14[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %ymm14
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm4 = ymm4[8,9,10,11,12,13,14,15],ymm14[0,1,2,3,4,5,6,7],ymm4[24,25,26,27,28,29,30,31],ymm14[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm7[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 416(%rdi), %ymm7
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm15 = ymm15[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],ymm15[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 320(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm14 = ymm15[1],ymm14[1],ymm15[3],ymm14[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm14[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq %xmm3, %ymm3
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm3[1],ymm7[1],ymm3[3],ymm7[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm5[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 32(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, (%rsi)
; AVX2-ONLY-NEXT:    vmovdqa %ymm8, 32(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, (%rdx)
; AVX2-ONLY-NEXT:    vmovdqa %ymm11, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovdqa %ymm9, (%rcx)
; AVX2-ONLY-NEXT:    vmovdqa %ymm10, 32(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm12, (%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm6, 32(%r9)
; AVX2-ONLY-NEXT:    vmovdqa %ymm13, (%r9)
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovdqa %ymm0, 32(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm4, (%rax)
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovdqa %ymm1, 32(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm2, (%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: load_i64_stride7_vf8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa64 384(%rdi), %zmm0
; AVX512F-NEXT:    vmovdqa64 320(%rdi), %zmm1
; AVX512F-NEXT:    vmovdqa64 256(%rdi), %zmm4
; AVX512F-NEXT:    vmovdqa64 192(%rdi), %zmm6
; AVX512F-NEXT:    vmovdqa64 128(%rdi), %zmm7
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512F-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = <0,7,14,u>
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm5, %zmm3
; AVX512F-NEXT:    movb $24, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm3 {%k1} = zmm7[0,1,4,5],zmm6[4,5,0,1]
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [10,3,10,3,10,3,10,3]
; AVX512F-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm4, %zmm8
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,6,9,0,5,6,9]
; AVX512F-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm8, %zmm9
; AVX512F-NEXT:    movb $-32, %al
; AVX512F-NEXT:    kmovw %eax, %k2
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm3 {%k2}
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [11,4,11,4,11,4,11,4]
; AVX512F-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm4, %zmm8
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,6,10,0,5,6,10]
; AVX512F-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm8, %zmm9
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [13,6,13,6,13,6,13,6]
; AVX512F-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [14,0,0,7,14,0,0,7]
; AVX512F-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm6, %zmm7, %zmm10
; AVX512F-NEXT:    vmovdqa 16(%rdi), %xmm11
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm11 = xmm11[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm11, %zmm10, %zmm10
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [7,0,9,0,7,0,9,0]
; AVX512F-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm7, %zmm6, %zmm13
; AVX512F-NEXT:    vmovdqa 64(%rdi), %ymm11
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm11, %xmm14
; AVX512F-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm12
; AVX512F-NEXT:    vmovdqa 128(%rdi), %ymm11
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm12 = ymm11[0,1,2,3,4,5],ymm12[6,7]
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm15 = [4,11]
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm5, %zmm15
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm12 = ymm15[0,1,2,3],ymm12[4,5,6,7]
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm15 = [4,11,4,11]
; AVX512F-NEXT:    # ymm15 = mem[0,1,0,1]
; AVX512F-NEXT:    vpermi2q %zmm6, %zmm7, %zmm15
; AVX512F-NEXT:    vpermt2q %zmm6, %zmm8, %zmm7
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = <9,0,7,u>
; AVX512F-NEXT:    vpermi2q %zmm5, %zmm2, %zmm6
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm6 {%k2}
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [12,5,12,5,12,5,12,5]
; AVX512F-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm4, %zmm7
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,6,11,0,5,6,11]
; AVX512F-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm7, %zmm9
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm10 {%k2}
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm4, %zmm8
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,5,6,12,0,5,6,12]
; AVX512F-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm8, %zmm7
; AVX512F-NEXT:    vinserti32x4 $0, %xmm14, %zmm13, %zmm8
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,7,14,0,0,7,14,0]
; AVX512F-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm4, %zmm7
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [4,5,6,13,4,5,6,13]
; AVX512F-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm7, %zmm9
; AVX512F-NEXT:    vinserti64x4 $0, %ymm12, %zmm9, %zmm7
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,0,7,0,9,0,7,0]
; AVX512F-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm4, %zmm1, %zmm9
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [4,5,6,14,4,5,6,14]
; AVX512F-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm9, %zmm12
; AVX512F-NEXT:    vmovdqa 192(%rdi), %ymm9
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm9 = ymm11[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm11 = [5,12]
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm5, %zmm11
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm9 = ymm11[0,1,2,3],ymm9[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm9, %zmm12, %zmm9
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm11 = [2,9,2,9,2,9,2,9]
; AVX512F-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm4, %zmm11
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [4,5,8,15,4,5,8,15]
; AVX512F-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm11, %zmm1
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm0 = [6,13]
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm5, %zmm0
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm15[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm3, (%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm6, (%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm10, (%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm7, (%r9)
; AVX512F-NEXT:    vmovdqa64 %zmm9, (%r10)
; AVX512F-NEXT:    vmovdqa64 %zmm0, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_i64_stride7_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 320(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm7
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm3 = <0,7,14,u>
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm5, %zmm3
; AVX512BW-NEXT:    movb $24, %r11b
; AVX512BW-NEXT:    kmovd %r11d, %k1
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm3 {%k1} = zmm7[0,1,4,5],zmm6[4,5,0,1]
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [10,3,10,3,10,3,10,3]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm4, %zmm8
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,6,9,0,5,6,9]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm8, %zmm9
; AVX512BW-NEXT:    movb $-32, %r11b
; AVX512BW-NEXT:    kmovd %r11d, %k2
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm3 {%k2}
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [11,4,11,4,11,4,11,4]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm4, %zmm8
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,6,10,0,5,6,10]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm8, %zmm9
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [13,6,13,6,13,6,13,6]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [14,0,0,7,14,0,0,7]
; AVX512BW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm6, %zmm7, %zmm10
; AVX512BW-NEXT:    vmovdqa 16(%rdi), %xmm11
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm11 = xmm11[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm11, %zmm10, %zmm10
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [7,0,9,0,7,0,9,0]
; AVX512BW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm13
; AVX512BW-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm12
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %ymm11
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm11[0,1,2,3,4,5],ymm12[6,7]
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm14 = [4,11]
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm5, %zmm14
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm12 = ymm14[0,1,2,3],ymm12[4,5,6,7]
; AVX512BW-NEXT:    vbroadcasti128 {{.*#+}} ymm14 = [4,11,4,11]
; AVX512BW-NEXT:    # ymm14 = mem[0,1,0,1]
; AVX512BW-NEXT:    vpermi2q %zmm6, %zmm7, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm8, %zmm7
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm6 = <9,0,7,u>
; AVX512BW-NEXT:    vpermi2q %zmm5, %zmm2, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm6 {%k2}
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [12,5,12,5,12,5,12,5]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm4, %zmm7
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [0,5,6,11,0,5,6,11]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm7, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm10 {%k2}
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm4, %zmm8
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,5,6,12,0,5,6,12]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm8, %zmm7
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %ymm8
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm8 = mem[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm8, %zmm13, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,7,14,0,0,7,14,0]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm4, %zmm7
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [4,5,6,13,4,5,6,13]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm7, %zmm9
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm12, %zmm9, %zmm7
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [9,0,7,0,9,0,7,0]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm1, %zmm9
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [4,5,6,14,4,5,6,14]
; AVX512BW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm9, %zmm12
; AVX512BW-NEXT:    vmovdqa 192(%rdi), %ymm9
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm9 = ymm11[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm11 = [5,12]
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm5, %zmm11
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm11[0,1,2,3],ymm9[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm9, %zmm12, %zmm9
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm11 = [2,9,2,9,2,9,2,9]
; AVX512BW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm4, %zmm11
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [4,5,8,15,4,5,8,15]
; AVX512BW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm11, %zmm1
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm0 = [6,13]
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm5, %zmm0
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm14[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, (%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, (%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, (%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, (%r10)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %wide.vec = load <56 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <56 x i64> %wide.vec, <56 x i64> poison, <8 x i32> <i32 0, i32 7, i32 14, i32 21, i32 28, i32 35, i32 42, i32 49>
  %strided.vec1 = shufflevector <56 x i64> %wide.vec, <56 x i64> poison, <8 x i32> <i32 1, i32 8, i32 15, i32 22, i32 29, i32 36, i32 43, i32 50>
  %strided.vec2 = shufflevector <56 x i64> %wide.vec, <56 x i64> poison, <8 x i32> <i32 2, i32 9, i32 16, i32 23, i32 30, i32 37, i32 44, i32 51>
  %strided.vec3 = shufflevector <56 x i64> %wide.vec, <56 x i64> poison, <8 x i32> <i32 3, i32 10, i32 17, i32 24, i32 31, i32 38, i32 45, i32 52>
  %strided.vec4 = shufflevector <56 x i64> %wide.vec, <56 x i64> poison, <8 x i32> <i32 4, i32 11, i32 18, i32 25, i32 32, i32 39, i32 46, i32 53>
  %strided.vec5 = shufflevector <56 x i64> %wide.vec, <56 x i64> poison, <8 x i32> <i32 5, i32 12, i32 19, i32 26, i32 33, i32 40, i32 47, i32 54>
  %strided.vec6 = shufflevector <56 x i64> %wide.vec, <56 x i64> poison, <8 x i32> <i32 6, i32 13, i32 20, i32 27, i32 34, i32 41, i32 48, i32 55>
  store <8 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <8 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <8 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <8 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <8 x i64> %strided.vec4, ptr %out.vec4, align 64
  store <8 x i64> %strided.vec5, ptr %out.vec5, align 64
  store <8 x i64> %strided.vec6, ptr %out.vec6, align 64
  ret void
}

define void @load_i64_stride7_vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i64_stride7_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $536, %rsp # imm = 0x218
; SSE-NEXT:    movapd 208(%rdi), %xmm0
; SSE-NEXT:    movapd 96(%rdi), %xmm1
; SSE-NEXT:    movapd 144(%rdi), %xmm2
; SSE-NEXT:    movapd 192(%rdi), %xmm3
; SSE-NEXT:    movapd 80(%rdi), %xmm4
; SSE-NEXT:    movapd 128(%rdi), %xmm5
; SSE-NEXT:    movapd 64(%rdi), %xmm8
; SSE-NEXT:    movapd 176(%rdi), %xmm9
; SSE-NEXT:    movapd (%rdi), %xmm10
; SSE-NEXT:    movapd 16(%rdi), %xmm7
; SSE-NEXT:    movapd 32(%rdi), %xmm6
; SSE-NEXT:    movapd 48(%rdi), %xmm14
; SSE-NEXT:    movapd 224(%rdi), %xmm11
; SSE-NEXT:    movapd 112(%rdi), %xmm12
; SSE-NEXT:    movapd 160(%rdi), %xmm15
; SSE-NEXT:    movapd %xmm14, %xmm13
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm10[0],xmm13[1]
; SSE-NEXT:    movapd %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm10 = xmm10[1],xmm8[0]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm7[0],xmm8[1]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm4[0]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm6[0],xmm4[1]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm6 = xmm6[1],xmm1[0]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm14[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm15, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm12[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm12 = xmm12[1],xmm9[0]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm5[0],xmm9[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm3[0]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm2[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm0[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm15[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm11[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm11 = xmm11[1],xmm1[0]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rdi), %xmm2
; SSE-NEXT:    movapd 384(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 432(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%rdi), %xmm2
; SSE-NEXT:    movapd 496(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 512(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 464(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 528(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 480(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 544(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 560(%rdi), %xmm13
; SSE-NEXT:    movapd 608(%rdi), %xmm2
; SSE-NEXT:    movapd %xmm2, %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm13[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 624(%rdi), %xmm14
; SSE-NEXT:    shufpd {{.*#+}} xmm13 = xmm13[1],xmm14[0]
; SSE-NEXT:    movapd 576(%rdi), %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm1[0],xmm14[1]
; SSE-NEXT:    movapd 640(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm0[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 592(%rdi), %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 656(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm0[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm2[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 672(%rdi), %xmm2
; SSE-NEXT:    movapd 720(%rdi), %xmm4
; SSE-NEXT:    movapd %xmm4, %xmm8
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm2[0],xmm8[1]
; SSE-NEXT:    movapd 736(%rdi), %xmm6
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm6[0]
; SSE-NEXT:    movapd 688(%rdi), %xmm9
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm9[0],xmm6[1]
; SSE-NEXT:    movapd 752(%rdi), %xmm12
; SSE-NEXT:    shufpd {{.*#+}} xmm9 = xmm9[1],xmm12[0]
; SSE-NEXT:    movapd 704(%rdi), %xmm15
; SSE-NEXT:    movsd {{.*#+}} xmm12 = xmm15[0],xmm12[1]
; SSE-NEXT:    movapd 768(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm15 = xmm15[1],xmm0[0]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 784(%rdi), %xmm4
; SSE-NEXT:    movapd 832(%rdi), %xmm11
; SSE-NEXT:    movapd %xmm11, %xmm5
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm4[0],xmm5[1]
; SSE-NEXT:    movapd 848(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm4 = xmm4[1],xmm0[0]
; SSE-NEXT:    movapd 800(%rdi), %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    movapd 864(%rdi), %xmm3
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm3[0]
; SSE-NEXT:    movapd 816(%rdi), %xmm7
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm7[0],xmm3[1]
; SSE-NEXT:    movapd 880(%rdi), %xmm10
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm10[0]
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm11[0],xmm10[1]
; SSE-NEXT:    movapd %xmm8, 96(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    movaps %xmm8, 32(%rsi)
; SSE-NEXT:    movapd %xmm5, 112(%rsi)
; SSE-NEXT:    movaps (%rsp), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, 48(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, 64(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, (%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, 80(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; SSE-NEXT:    movaps %xmm5, 16(%rsi)
; SSE-NEXT:    movapd %xmm2, 96(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 32(%rdx)
; SSE-NEXT:    movapd %xmm4, 112(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 64(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rdx)
; SSE-NEXT:    movapd %xmm13, 80(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rdx)
; SSE-NEXT:    movapd %xmm6, 96(%rcx)
; SSE-NEXT:    movapd %xmm0, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movapd %xmm14, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movapd %xmm1, 112(%r8)
; SSE-NEXT:    movapd %xmm9, 96(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    movapd %xmm3, 112(%r9)
; SSE-NEXT:    movapd %xmm12, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm7, 112(%rax)
; SSE-NEXT:    movapd %xmm15, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm10, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $536, %rsp # imm = 0x218
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: load_i64_stride7_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $552, %rsp # imm = 0x228
; AVX1-ONLY-NEXT:    vmovapd 544(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovapd 96(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps 768(%rdi), %ymm2
; AVX1-ONLY-NEXT:    vmovaps 320(%rdi), %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, 384(%rdi), %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 272(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm5[0,1],xmm6[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm6[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 832(%rdi), %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1,2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovaps 672(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 720(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm6[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rdi), %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm1[0,1,2],ymm4[3]
; AVX1-ONLY-NEXT:    vmovapd 48(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm7 = mem[0],xmm7[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm7[0,1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 608(%rdi), %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm0[0,1,2],ymm4[3]
; AVX1-ONLY-NEXT:    vmovapd 448(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovapd 496(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vmovapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm8 = xmm7[0],xmm8[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm8[0,1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 288(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm4 = xmm5[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 384(%rdi), %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm5[0],ymm3[3],ymm5[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 736(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm6[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 832(%rdi), %ymm4
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm4[0],ymm2[3],ymm4[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 160(%rdi), %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[3],ymm2[2]
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 608(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 512(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm7[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 352(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm3[0,1,2],ymm5[3]
; AVX1-ONLY-NEXT:    vmovapd 240(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm7 = xmm3[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm7[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 800(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm5[0,1,2],ymm4[3]
; AVX1-ONLY-NEXT:    vmovapd 688(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm9 = xmm5[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm9[0,1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 128(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm9
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm9[0,1,2],ymm2[3]
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm6 = xmm9[0,1,2,3],xmm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 576(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm6[0,1,2],ymm1[3]
; AVX1-ONLY-NEXT:    vmovdqa 464(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm8 = xmm6[0,1,2,3],xmm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm8[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 752(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm8 = ymm5[1],ymm15[0],ymm5[2],ymm15[2]
; AVX1-ONLY-NEXT:    vmovdqa 864(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = xmm7[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm8[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 304(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[1],ymm7[0],ymm3[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovdqa 416(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = xmm0[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0,1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 80(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm8 = ymm9[1],ymm11[0],ymm9[2],ymm11[2]
; AVX1-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm4 = xmm4[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm8[0,1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 528(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[1],ymm4[0],ymm6[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovdqa 640(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = xmm10[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm12 = ymm6[0,1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovapd 352(%rdi), %ymm10
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm10[0,1,2],ymm1[3]
; AVX1-ONLY-NEXT:    vmovapd 256(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm7 = xmm6[0],xmm7[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm13 = ymm7[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovapd 800(%rdi), %ymm5
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm5[0,1,2],ymm1[3]
; AVX1-ONLY-NEXT:    vmovapd 704(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm7 = xmm2[0],xmm15[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm9 = ymm7[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovapd 576(%rdi), %ymm7
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm7[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 480(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm4 = xmm15[0],xmm4[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm4[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovapd 128(%rdi), %ymm4
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm4[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm3 = mem[0],xmm11[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm11 = ymm3[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovapd 416(%rdi), %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm10[0],ymm3[0],ymm10[3],ymm3[2]
; AVX1-ONLY-NEXT:    vmovdqa 320(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm6 = xmm6[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovapd 864(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm1[0],ymm5[3],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 768(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm2 = xmm2[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm2[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovdqa 544(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm2 = xmm15[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 640(%rdi), %ymm15
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm7 = ymm7[0],ymm15[0],ymm7[3],ymm15[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovapd 192(%rdi), %ymm7
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[0],ymm7[0],ymm4[3],ymm7[2]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm14[0,1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm3 = mem[0,1,2],ymm3[3]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm10 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm10 = mem[0,1,2,3],xmm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm10[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm1 = mem[0,1,2],ymm1[3]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1,2,3],xmm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm1 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm1 = mem[0,1,2],ymm7[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm7 = xmm7[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm7[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm7 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm7 = mem[0,1,2],ymm15[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm10 = xmm10[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm10[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 64(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, (%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 96(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 32(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 64(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, (%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 96(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 32(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, (%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovapd %ymm12, 64(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, (%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 32(%r8)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm10 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 96(%r8)
; AVX1-ONLY-NEXT:    vmovapd %ymm11, (%r9)
; AVX1-ONLY-NEXT:    vmovapd %ymm8, 64(%r9)
; AVX1-ONLY-NEXT:    vmovapd %ymm9, 96(%r9)
; AVX1-ONLY-NEXT:    vmovapd %ymm13, 32(%r9)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovapd %ymm4, (%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm2, 64(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm5, 96(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm6, 32(%rax)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovapd %ymm7, 64(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm1, (%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 96(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm3, 32(%rax)
; AVX1-ONLY-NEXT:    addq $552, %rsp # imm = 0x228
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: load_i64_stride7_vf16:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $504, %rsp # imm = 0x1F8
; AVX2-ONLY-NEXT:    vmovdqa 544(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa 768(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqa 320(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa 384(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 224(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vmovdqa 272(%rdi), %xmm6
; AVX2-ONLY-NEXT:    vmovdqa %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm6 = xmm5[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm6[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 832(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm2[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 672(%rdi), %xmm6
; AVX2-ONLY-NEXT:    vmovdqa 720(%rdi), %xmm13
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm6[0,1],xmm13[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm7[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm1[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = mem[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm7[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 608(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vmovdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm0[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 448(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vmovdqa 496(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vmovdqa %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm8 = xmm7[0,1],xmm8[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm8[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 288(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm4 = xmm5[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 384(%rdi), %ymm5
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm3 = ymm3[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 736(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm6[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 832(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm2 = ymm2[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm1 = ymm1[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm6 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 608(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm0[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 512(%rdi), %xmm6
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = xmm7[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 352(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm5[1],ymm0[3],ymm5[3]
; AVX2-ONLY-NEXT:    vmovdqa 240(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 800(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm4[1],ymm0[3],ymm4[3]
; AVX2-ONLY-NEXT:    vmovdqa 688(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 128(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = mem[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 576(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = mem[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 736(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 864(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm2 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 288(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 416(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm11
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm4 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 512(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 640(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm5 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm15 = ymm0[2,3],ymm5[2,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 352(%rdi), %ymm6
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 256(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm8[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 800(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 704(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm7[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm12 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 576(%rdi), %ymm9
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 480(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm4[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 128(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 416(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm6 = ymm6[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 320(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = xmm8[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm8[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 864(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm3 = ymm3[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 768(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = xmm7[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 544(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm4[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 640(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm9 = ymm9[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm9 = ymm3[0,1,2,3],ymm9[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm11 = ymm11[8,9,10,11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm11 = ymm14[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm14[1],ymm2[1],ymm14[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm0 = mem[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm14 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm8[1],ymm0[3],ymm8[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm13[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm3[1],ymm0[3],ymm3[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],ymm4[1],ymm1[3],ymm4[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 64(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, (%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 96(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 32(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 64(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, (%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 96(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 32(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 96(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovdqa %ymm15, 64(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, (%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 32(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 96(%r8)
; AVX2-ONLY-NEXT:    vmovdqa %ymm5, (%r9)
; AVX2-ONLY-NEXT:    vmovdqa %ymm10, 64(%r9)
; AVX2-ONLY-NEXT:    vmovdqa %ymm12, 96(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 32(%r9)
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovdqa %ymm11, (%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm9, 64(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm7, 96(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm6, 32(%rax)
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovdqa %ymm1, 64(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm0, (%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm13, 96(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm14, 32(%rax)
; AVX2-ONLY-NEXT:    addq $504, %rsp # imm = 0x1F8
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: load_i64_stride7_vf16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovdqa64 832(%rdi), %zmm28
; AVX512F-NEXT:    vmovdqa64 768(%rdi), %zmm30
; AVX512F-NEXT:    vmovdqa64 704(%rdi), %zmm0
; AVX512F-NEXT:    vmovdqa64 640(%rdi), %zmm25
; AVX512F-NEXT:    vmovdqa64 576(%rdi), %zmm2
; AVX512F-NEXT:    vmovdqa64 512(%rdi), %zmm24
; AVX512F-NEXT:    vmovdqa64 448(%rdi), %zmm6
; AVX512F-NEXT:    vmovdqa64 384(%rdi), %zmm14
; AVX512F-NEXT:    vmovdqa64 320(%rdi), %zmm15
; AVX512F-NEXT:    vmovdqa64 256(%rdi), %zmm9
; AVX512F-NEXT:    vmovdqa64 192(%rdi), %zmm27
; AVX512F-NEXT:    vmovdqa64 128(%rdi), %zmm10
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %zmm26
; AVX512F-NEXT:    vmovdqa64 (%rdi), %zmm1
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm7 = <0,7,14,u>
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm29
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm7, %zmm29
; AVX512F-NEXT:    movb $24, %r11b
; AVX512F-NEXT:    kmovw %r11d, %k2
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k2} = zmm10[0,1,4,5],zmm27[4,5,0,1]
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [10,3,10,3,10,3,10,3]
; AVX512F-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm17
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm16, %zmm17
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [0,5,6,9,0,5,6,9]
; AVX512F-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm18, %zmm17
; AVX512F-NEXT:    movb $-32, %r11b
; AVX512F-NEXT:    kmovw %r11d, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm29 {%k1}
; AVX512F-NEXT:    vpermi2q %zmm24, %zmm6, %zmm7
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm7 {%k2} = zmm2[0,1,4,5],zmm25[4,5,0,1]
; AVX512F-NEXT:    vpermi2q %zmm30, %zmm0, %zmm16
; AVX512F-NEXT:    vpermt2q %zmm28, %zmm18, %zmm16
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm7 {%k1}
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm18 = [11,4,11,4,11,4,11,4]
; AVX512F-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm19
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm18, %zmm19
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [0,5,6,10,0,5,6,10]
; AVX512F-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm20, %zmm19
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [13,6,13,6,13,6,13,6]
; AVX512F-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm10, %zmm21
; AVX512F-NEXT:    vpermt2q %zmm27, %zmm22, %zmm21
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} ymm16 = <9,0,7,u>
; AVX512F-NEXT:    vmovdqa64 %zmm26, %zmm17
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm16, %zmm17
; AVX512F-NEXT:    vmovdqa64 %zmm21, %zmm17 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm17 {%k1}
; AVX512F-NEXT:    vpermi2q %zmm30, %zmm0, %zmm18
; AVX512F-NEXT:    vpermt2q %zmm28, %zmm20, %zmm18
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm19
; AVX512F-NEXT:    vpermt2q %zmm25, %zmm22, %zmm19
; AVX512F-NEXT:    vpermi2q %zmm6, %zmm24, %zmm16
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm16 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm18, %zmm16 {%k1}
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm20 = [12,5,12,5,12,5,12,5]
; AVX512F-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm19
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm20, %zmm19
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [0,5,6,11,0,5,6,11]
; AVX512F-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm21, %zmm19
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [14,0,0,7,14,0,0,7]
; AVX512F-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm10, %zmm18
; AVX512F-NEXT:    vpermt2q %zmm27, %zmm23, %zmm18
; AVX512F-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm4, %zmm18, %zmm18
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm18 {%k1}
; AVX512F-NEXT:    vpermi2q %zmm30, %zmm0, %zmm20
; AVX512F-NEXT:    vpermt2q %zmm28, %zmm21, %zmm20
; AVX512F-NEXT:    vpermi2q %zmm25, %zmm2, %zmm23
; AVX512F-NEXT:    vmovdqa 464(%rdi), %xmm4
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm4, %zmm23, %zmm19
; AVX512F-NEXT:    vmovdqa64 %zmm20, %zmm19 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm22, %zmm4
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [0,5,6,12,0,5,6,12]
; AVX512F-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm21, %zmm4
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [7,0,9,0,7,0,9,0]
; AVX512F-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm27, %zmm20
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm23, %zmm20
; AVX512F-NEXT:    vmovdqa 64(%rdi), %ymm5
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm5 = mem[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512F-NEXT:    vinserti32x4 $0, %xmm5, %zmm20, %zmm20
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm20 {%k1}
; AVX512F-NEXT:    vpermi2q %zmm30, %zmm0, %zmm22
; AVX512F-NEXT:    vpermt2q %zmm28, %zmm21, %zmm22
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm25, %zmm23
; AVX512F-NEXT:    vmovdqa 512(%rdi), %ymm4
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm4 = mem[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512F-NEXT:    vinserti32x4 $0, %xmm4, %zmm23, %zmm21
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm21 {%k1}
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm4 = [0,7,14,0,0,7,14,0]
; AVX512F-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm4, %zmm5
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [4,5,6,13,4,5,6,13]
; AVX512F-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm23, %zmm5
; AVX512F-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm12
; AVX512F-NEXT:    vmovdqa 128(%rdi), %ymm13
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0,1,2,3,4,5],ymm12[6,7]
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,11]
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm3, %zmm11
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm12[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm11, %zmm5, %zmm22
; AVX512F-NEXT:    vpermi2q %zmm30, %zmm0, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm28, %zmm23, %zmm4
; AVX512F-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm5
; AVX512F-NEXT:    vmovdqa 576(%rdi), %ymm11
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm5 = ymm11[0,1,2,3,4,5],ymm5[6,7]
; AVX512F-NEXT:    vpermi2q %zmm24, %zmm6, %zmm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm5[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm3, %zmm4, %zmm23
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [9,0,7,0,9,0,7,0]
; AVX512F-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm3, %zmm4
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [4,5,6,14,4,5,6,14]
; AVX512F-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm5, %zmm4
; AVX512F-NEXT:    vmovdqa 192(%rdi), %ymm12
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm12 = ymm13[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],ymm13[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm13 = [5,12]
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm13, %zmm8
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm12[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm8, %zmm4, %zmm31
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm30, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm28, %zmm5, %zmm3
; AVX512F-NEXT:    vmovdqa 640(%rdi), %ymm5
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm5 = ymm11[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vpermi2q %zmm24, %zmm6, %zmm13
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm5 = ymm13[0,1,2,3],ymm5[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm5, %zmm3, %zmm3
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [2,9,2,9,2,9,2,9]
; AVX512F-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm15, %zmm5, %zmm9
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [4,5,8,15,4,5,8,15]
; AVX512F-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm8, %zmm9
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm11 = [4,11,4,11]
; AVX512F-NEXT:    # ymm11 = mem[0,1,0,1]
; AVX512F-NEXT:    vpermt2q %zmm27, %zmm11, %zmm10
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm12 = [6,13]
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm12, %zmm1
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm10[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm9, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm5, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm28, %zmm8, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm25, %zmm11, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm24, %zmm12, %zmm6
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm6[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm7, 64(%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm29, (%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm16, 64(%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm17, (%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm19, 64(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm21, 64(%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm23, 64(%r9)
; AVX512F-NEXT:    vmovdqa64 %zmm22, (%r9)
; AVX512F-NEXT:    vmovdqa64 %zmm3, 64(%r10)
; AVX512F-NEXT:    vmovdqa64 %zmm31, (%r10)
; AVX512F-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_i64_stride7_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa64 832(%rdi), %zmm30
; AVX512BW-NEXT:    vmovdqa64 768(%rdi), %zmm31
; AVX512BW-NEXT:    vmovdqa64 704(%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 640(%rdi), %zmm26
; AVX512BW-NEXT:    vmovdqa64 576(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 512(%rdi), %zmm24
; AVX512BW-NEXT:    vmovdqa64 448(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %zmm14
; AVX512BW-NEXT:    vmovdqa64 320(%rdi), %zmm15
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm9
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm28
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm10
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm27
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm7 = <0,7,14,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm29
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm7, %zmm29
; AVX512BW-NEXT:    movb $24, %r11b
; AVX512BW-NEXT:    kmovd %r11d, %k2
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k2} = zmm10[0,1,4,5],zmm28[4,5,0,1]
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [10,3,10,3,10,3,10,3]
; AVX512BW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm16, %zmm17
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [0,5,6,9,0,5,6,9]
; AVX512BW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm18, %zmm17
; AVX512BW-NEXT:    movb $-32, %r11b
; AVX512BW-NEXT:    kmovd %r11d, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm29 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm24, %zmm6, %zmm7
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm7 {%k2} = zmm2[0,1,4,5],zmm26[4,5,0,1]
; AVX512BW-NEXT:    vpermi2q %zmm31, %zmm0, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm18, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm7 {%k1}
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm18 = [11,4,11,4,11,4,11,4]
; AVX512BW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm18, %zmm19
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [0,5,6,10,0,5,6,10]
; AVX512BW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm20, %zmm19
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [13,6,13,6,13,6,13,6]
; AVX512BW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm28, %zmm22, %zmm21
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} ymm16 = <9,0,7,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm16, %zmm17
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm17 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm17 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm31, %zmm0, %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm20, %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm22, %zmm19
; AVX512BW-NEXT:    vpermi2q %zmm6, %zmm24, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm16 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm16 {%k1}
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm20 = [12,5,12,5,12,5,12,5]
; AVX512BW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm20, %zmm19
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [0,5,6,11,0,5,6,11]
; AVX512BW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm21, %zmm19
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [14,0,0,7,14,0,0,7]
; AVX512BW-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm28, %zmm23, %zmm18
; AVX512BW-NEXT:    vmovdqa 16(%rdi), %xmm4
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm4, %zmm18, %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm18 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm31, %zmm0, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm21, %zmm20
; AVX512BW-NEXT:    vpermi2q %zmm26, %zmm2, %zmm23
; AVX512BW-NEXT:    vmovdqa 464(%rdi), %xmm4
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm4, %zmm23, %zmm19
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm19 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm22, %zmm4
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [0,5,6,12,0,5,6,12]
; AVX512BW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm21, %zmm4
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [7,0,9,0,7,0,9,0]
; AVX512BW-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm23, %zmm20
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %ymm25
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm25 = mem[8,9,10,11,12,13,14,15],ymm25[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm25[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm25, %xmm25
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm25, %zmm20, %zmm20
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm20 {%k1}
; AVX512BW-NEXT:    vpermi2q %zmm31, %zmm0, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm21, %zmm22
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm26, %zmm23
; AVX512BW-NEXT:    vmovdqa 512(%rdi), %ymm4
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm4 = mem[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm4, %zmm23, %zmm21
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm21 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm4 = [0,7,14,0,0,7,14,0]
; AVX512BW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm4, %zmm22
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [4,5,6,13,4,5,6,13]
; AVX512BW-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm23, %zmm22
; AVX512BW-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm5
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %ymm12
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm12[0,1,2,3,4,5],ymm5[6,7]
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm13 = [4,11]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm13, %zmm11
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm11[0,1,2,3],ymm5[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm22, %zmm22
; AVX512BW-NEXT:    vpermi2q %zmm31, %zmm0, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm23, %zmm4
; AVX512BW-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm5
; AVX512BW-NEXT:    vmovdqa 576(%rdi), %ymm11
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm11[0,1,2,3,4,5],ymm5[6,7]
; AVX512BW-NEXT:    vpermi2q %zmm24, %zmm6, %zmm13
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm5 = ymm13[0,1,2,3],ymm5[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm4, %zmm23
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm4 = [9,0,7,0,9,0,7,0]
; AVX512BW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm4, %zmm5
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [4,5,6,14,4,5,6,14]
; AVX512BW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm13, %zmm5
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %ymm25
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm12 = ymm12[8,9,10,11,12,13,14,15],ymm25[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm25[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm3 = [5,12]
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm3, %zmm8
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm12[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm8, %zmm5, %zmm5
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm31, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm13, %zmm4
; AVX512BW-NEXT:    vmovdqa 640(%rdi), %ymm8
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm8 = ymm11[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vpermi2q %zmm24, %zmm6, %zmm3
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm3, %zmm4, %zmm3
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [2,9,2,9,2,9,2,9]
; AVX512BW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm4, %zmm9
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [4,5,8,15,4,5,8,15]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm8, %zmm9
; AVX512BW-NEXT:    vbroadcasti128 {{.*#+}} ymm11 = [4,11,4,11]
; AVX512BW-NEXT:    # ymm11 = mem[0,1,0,1]
; AVX512BW-NEXT:    vpermt2q %zmm28, %zmm11, %zmm10
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm12 = [6,13]
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm12, %zmm1
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm10[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm9, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm4, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm8, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm11, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm12, %zmm6
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm2 = ymm6[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 64(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 64(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, (%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 64(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, (%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm23, 64(%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, (%r9)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 64(%r10)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%r10)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %wide.vec = load <112 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <112 x i64> %wide.vec, <112 x i64> poison, <16 x i32> <i32 0, i32 7, i32 14, i32 21, i32 28, i32 35, i32 42, i32 49, i32 56, i32 63, i32 70, i32 77, i32 84, i32 91, i32 98, i32 105>
  %strided.vec1 = shufflevector <112 x i64> %wide.vec, <112 x i64> poison, <16 x i32> <i32 1, i32 8, i32 15, i32 22, i32 29, i32 36, i32 43, i32 50, i32 57, i32 64, i32 71, i32 78, i32 85, i32 92, i32 99, i32 106>
  %strided.vec2 = shufflevector <112 x i64> %wide.vec, <112 x i64> poison, <16 x i32> <i32 2, i32 9, i32 16, i32 23, i32 30, i32 37, i32 44, i32 51, i32 58, i32 65, i32 72, i32 79, i32 86, i32 93, i32 100, i32 107>
  %strided.vec3 = shufflevector <112 x i64> %wide.vec, <112 x i64> poison, <16 x i32> <i32 3, i32 10, i32 17, i32 24, i32 31, i32 38, i32 45, i32 52, i32 59, i32 66, i32 73, i32 80, i32 87, i32 94, i32 101, i32 108>
  %strided.vec4 = shufflevector <112 x i64> %wide.vec, <112 x i64> poison, <16 x i32> <i32 4, i32 11, i32 18, i32 25, i32 32, i32 39, i32 46, i32 53, i32 60, i32 67, i32 74, i32 81, i32 88, i32 95, i32 102, i32 109>
  %strided.vec5 = shufflevector <112 x i64> %wide.vec, <112 x i64> poison, <16 x i32> <i32 5, i32 12, i32 19, i32 26, i32 33, i32 40, i32 47, i32 54, i32 61, i32 68, i32 75, i32 82, i32 89, i32 96, i32 103, i32 110>
  %strided.vec6 = shufflevector <112 x i64> %wide.vec, <112 x i64> poison, <16 x i32> <i32 6, i32 13, i32 20, i32 27, i32 34, i32 41, i32 48, i32 55, i32 62, i32 69, i32 76, i32 83, i32 90, i32 97, i32 104, i32 111>
  store <16 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <16 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <16 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <16 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <16 x i64> %strided.vec4, ptr %out.vec4, align 64
  store <16 x i64> %strided.vec5, ptr %out.vec5, align 64
  store <16 x i64> %strided.vec6, ptr %out.vec6, align 64
  ret void
}

define void @load_i64_stride7_vf32(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i64_stride7_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1448, %rsp # imm = 0x5A8
; SSE-NEXT:    movapd 208(%rdi), %xmm0
; SSE-NEXT:    movapd 96(%rdi), %xmm1
; SSE-NEXT:    movapd 144(%rdi), %xmm2
; SSE-NEXT:    movapd 192(%rdi), %xmm3
; SSE-NEXT:    movapd 80(%rdi), %xmm4
; SSE-NEXT:    movapd 128(%rdi), %xmm5
; SSE-NEXT:    movapd 64(%rdi), %xmm8
; SSE-NEXT:    movapd 176(%rdi), %xmm9
; SSE-NEXT:    movapd (%rdi), %xmm10
; SSE-NEXT:    movapd 16(%rdi), %xmm7
; SSE-NEXT:    movapd 32(%rdi), %xmm6
; SSE-NEXT:    movapd 48(%rdi), %xmm14
; SSE-NEXT:    movapd 224(%rdi), %xmm11
; SSE-NEXT:    movapd 112(%rdi), %xmm12
; SSE-NEXT:    movapd 160(%rdi), %xmm15
; SSE-NEXT:    movapd %xmm14, %xmm13
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm10[0],xmm13[1]
; SSE-NEXT:    movapd %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm10 = xmm10[1],xmm8[0]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm7[0],xmm8[1]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm4[0]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm6[0],xmm4[1]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm6 = xmm6[1],xmm1[0]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm14[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm15, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm12[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm12 = xmm12[1],xmm9[0]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm5[0],xmm9[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm3[0]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm2[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm0[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm15[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm11[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm11 = xmm11[1],xmm1[0]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rdi), %xmm2
; SSE-NEXT:    movapd 384(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 432(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%rdi), %xmm2
; SSE-NEXT:    movapd 496(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 512(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 464(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 528(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 480(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 544(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 560(%rdi), %xmm2
; SSE-NEXT:    movapd 608(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 624(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 576(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 640(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 592(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 656(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 672(%rdi), %xmm2
; SSE-NEXT:    movapd 720(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 736(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 688(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 752(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 704(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 768(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 784(%rdi), %xmm2
; SSE-NEXT:    movapd 832(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 848(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 800(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 864(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 816(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 880(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 896(%rdi), %xmm2
; SSE-NEXT:    movapd 944(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 960(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 912(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 976(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 928(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 992(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1008(%rdi), %xmm2
; SSE-NEXT:    movapd 1056(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1072(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1024(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1088(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1040(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1104(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1120(%rdi), %xmm2
; SSE-NEXT:    movapd 1168(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1184(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1136(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1200(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1152(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1216(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1232(%rdi), %xmm2
; SSE-NEXT:    movapd 1280(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1296(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1248(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1312(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1264(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1328(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1344(%rdi), %xmm13
; SSE-NEXT:    movapd 1392(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm13[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1408(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm13 = xmm13[1],xmm1[0]
; SSE-NEXT:    movapd 1360(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1424(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1376(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1440(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1456(%rdi), %xmm9
; SSE-NEXT:    movapd 1504(%rdi), %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm14
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm9[0],xmm14[1]
; SSE-NEXT:    movapd 1520(%rdi), %xmm12
; SSE-NEXT:    shufpd {{.*#+}} xmm9 = xmm9[1],xmm12[0]
; SSE-NEXT:    movapd 1472(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm12 = xmm2[0],xmm12[1]
; SSE-NEXT:    movapd 1536(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm0[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1488(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm2[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1552(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm0[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1568(%rdi), %xmm5
; SSE-NEXT:    movapd 1616(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm7
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm5[0],xmm7[1]
; SSE-NEXT:    movapd 1632(%rdi), %xmm8
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm8[0]
; SSE-NEXT:    movapd 1584(%rdi), %xmm11
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm11[0],xmm8[1]
; SSE-NEXT:    movapd 1648(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm11 = xmm11[1],xmm1[0]
; SSE-NEXT:    movapd 1600(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1664(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1680(%rdi), %xmm1
; SSE-NEXT:    movapd 1728(%rdi), %xmm4
; SSE-NEXT:    movapd %xmm4, %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm1[0],xmm2[1]
; SSE-NEXT:    movapd 1744(%rdi), %xmm3
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm3[0]
; SSE-NEXT:    movapd 1696(%rdi), %xmm6
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm6[0],xmm3[1]
; SSE-NEXT:    movapd 1760(%rdi), %xmm10
; SSE-NEXT:    shufpd {{.*#+}} xmm6 = xmm6[1],xmm10[0]
; SSE-NEXT:    movapd 1712(%rdi), %xmm15
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm15[0],xmm10[1]
; SSE-NEXT:    movapd 1776(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm15 = xmm15[1],xmm0[0]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm7, 224(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, 96(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, 32(%rsi)
; SSE-NEXT:    movapd %xmm2, 240(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 112(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 48(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 128(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 64(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, (%rsi)
; SSE-NEXT:    movapd %xmm14, 208(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 144(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 80(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    movaps %xmm2, 16(%rsi)
; SSE-NEXT:    movapd %xmm5, 224(%rdx)
; SSE-NEXT:    movapd %xmm1, 240(%rdx)
; SSE-NEXT:    movapd %xmm13, 192(%rdx)
; SSE-NEXT:    movapd %xmm9, 208(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movapd %xmm3, 240(%rcx)
; SSE-NEXT:    movapd %xmm8, 224(%rcx)
; SSE-NEXT:    movapd %xmm12, 208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    movapd %xmm6, 240(%r8)
; SSE-NEXT:    movapd %xmm11, 224(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    movapd %xmm10, 240(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm15, 240(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $1448, %rsp # imm = 0x5A8
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: load_i64_stride7_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $1720, %rsp # imm = 0x6B8
; AVX1-ONLY-NEXT:    vmovaps 1216(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 768(%rdi), %ymm4
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%rdi), %ymm10
; AVX1-ONLY-NEXT:    vinsertf128 $1, 384(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm10[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 272(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm3[0,1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 832(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 672(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps 720(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm9[0,1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 1280(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 1120(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 1168(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm6[0,1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 1664(%rdi), %ymm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, 1728(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 1568(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vmovaps 1616(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm14[0,1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 96(%rdi), %ymm8
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm8[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 48(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm2 = mem[0],xmm1[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 544(%rdi), %ymm15
; AVX1-ONLY-NEXT:    vinsertf128 $1, 608(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm15[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 448(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vmovapd 496(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm2 = xmm11[0],xmm1[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 992(%rdi), %ymm12
; AVX1-ONLY-NEXT:    vinsertf128 $1, 1056(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm12[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 896(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovapd 944(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm4 = xmm2[0],xmm1[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm4[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1440(%rdi), %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, 1504(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm4[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 1344(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovapd 1392(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm13 = xmm7[0],xmm0[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm13[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 288(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm3[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 384(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm10[0],ymm0[0],ymm10[3],ymm0[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 736(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm9[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 832(%rdi), %ymm9
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm9[0],ymm3[3],ymm9[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1184(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm6[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 1280(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm1[0],ymm6[3],ymm1[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1632(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm14[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 1728(%rdi), %ymm13
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm13[0],ymm5[3],ymm13[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 160(%rdi), %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm8[0],ymm3[0],ymm8[3],ymm3[2]
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm8[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 608(%rdi), %ymm10
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm15[0],ymm10[0],ymm15[3],ymm10[2]
; AVX1-ONLY-NEXT:    vmovdqa 512(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = xmm11[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm8[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1056(%rdi), %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm8 = ymm12[0],ymm5[0],ymm12[3],ymm5[2]
; AVX1-ONLY-NEXT:    vmovdqa 960(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm2 = xmm2[8,9,10,11,12,13,14,15],xmm15[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1504(%rdi), %ymm8
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm4[0],ymm8[0],ymm4[3],ymm8[2]
; AVX1-ONLY-NEXT:    vmovdqa 1408(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = xmm7[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm7[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 240(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm2 = xmm12[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 800(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm9[3]
; AVX1-ONLY-NEXT:    vmovapd 688(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm2 = xmm11[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1248(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3]
; AVX1-ONLY-NEXT:    vmovapd 1136(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm7[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 1696(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm13[3]
; AVX1-ONLY-NEXT:    vmovapd 1584(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm13[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3]
; AVX1-ONLY-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 576(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm10[3]
; AVX1-ONLY-NEXT:    vmovdqa 464(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm1 = xmm10[0,1,2,3],xmm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1024(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm0[0,1,2],ymm5[3]
; AVX1-ONLY-NEXT:    vmovdqa 912(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm0[0,1,2,3],xmm15[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1472(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1,2],ymm8[3]
; AVX1-ONLY-NEXT:    vmovdqa 1360(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm2[0,1,2,3],xmm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 304(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm12[1],ymm8[0],ymm12[2],ymm8[2]
; AVX1-ONLY-NEXT:    vmovdqa 416(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = mem[8,9,10,11,12,13,14,15],xmm12[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 752(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm11[1],ymm5[0],ymm11[2],ymm5[2]
; AVX1-ONLY-NEXT:    vmovdqa 864(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1200(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm7[1],ymm1[0],ymm7[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 1312(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm9[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1648(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm13[1],ymm1[0],ymm13[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 1760(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1424(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm2[1],ymm9[0],ymm2[2],ymm9[2]
; AVX1-ONLY-NEXT:    vmovdqa 1536(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm2 = xmm15[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 976(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm0[1],ymm3[0],ymm0[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovdqa 1088(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm2 = xmm14[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 528(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm10[1],ymm1[0],ymm10[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 640(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm6 = xmm6[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 80(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[1],ymm2[0],ymm6[2],ymm2[2]
; AVX1-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm14 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm14 = mem[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm14
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vmovapd 128(%rdi), %ymm10
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm10[0,1,2],ymm6[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm2 = mem[0],xmm2[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vmovapd 352(%rdi), %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm2[0,1,2],ymm6[3]
; AVX1-ONLY-NEXT:    vmovapd 256(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vmovapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm8 = xmm12[0],xmm8[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm8[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vmovapd 576(%rdi), %ymm8
; AVX1-ONLY-NEXT:    vmovupd %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm8[0,1,2],ymm6[3]
; AVX1-ONLY-NEXT:    vmovapd 480(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm14[0],xmm1[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vmovapd 800(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm1[0,1,2],ymm6[3]
; AVX1-ONLY-NEXT:    vmovapd 704(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm5 = xmm13[0],xmm5[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovapd 1024(%rdi), %ymm15
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm15[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 928(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm3 = xmm11[0],xmm3[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovapd 1248(%rdi), %ymm6
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm6[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 1152(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = xmm8[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovapd 1472(%rdi), %ymm12
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm12[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 1376(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm4 = xmm0[0],xmm9[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 1696(%rdi), %ymm5
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm5[0,1,2],ymm3[3]
; AVX1-ONLY-NEXT:    vmovapd 1600(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm4 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm4 = xmm4[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 192(%rdi), %ymm9
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm10[0],ymm9[0],ymm10[3],ymm9[2]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm7[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 416(%rdi), %ymm10
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm10[0],ymm2[3],ymm10[2]
; AVX1-ONLY-NEXT:    vmovdqa 320(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 544(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm14[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 640(%rdi), %ymm4
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm2[0],ymm4[0],ymm2[3],ymm4[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm3[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 864(%rdi), %ymm14
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm14[0],ymm1[3],ymm14[2]
; AVX1-ONLY-NEXT:    vmovdqa 768(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm13 = xmm13[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm13[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 992(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm11 = xmm11[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 1088(%rdi), %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm13 = ymm15[0],ymm2[0],ymm15[3],ymm2[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm11[0,1],ymm13[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1312(%rdi), %ymm15
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm13 = ymm6[0],ymm15[0],ymm6[3],ymm15[2]
; AVX1-ONLY-NEXT:    vmovdqa 1216(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = xmm8[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm13 = ymm8[0,1],ymm13[2,3]
; AVX1-ONLY-NEXT:    vmovdqa 1440(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 1536(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm8 = ymm12[0],ymm1[0],ymm12[3],ymm1[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm0[0,1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vmovapd 1760(%rdi), %ymm12
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm12[0],ymm5[3],ymm12[2]
; AVX1-ONLY-NEXT:    vmovdqa 1664(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm11 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm11 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm11[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm9 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm9 = mem[0,1,2],ymm9[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm11 = xmm11[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm9 = ymm11[0,1],ymm9[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm10 = mem[0,1,2],ymm10[3]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm7 = mem[0,1,2,3],xmm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm7[0,1],ymm10[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm4 = mem[0,1,2],ymm4[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm10 = xmm10[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm10 = ymm10[0,1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm4 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm4 = mem[0,1,2],ymm14[3]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = mem[0,1,2,3],xmm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm3[0,1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm2 = mem[0,1,2],ymm2[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm3 = xmm3[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm2 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm2 = mem[0,1,2],ymm15[3]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm6 = mem[0,1,2,3],xmm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm1 = mem[0,1,2],ymm1[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm6 = xmm6[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm6[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm6 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm6 = mem[0,1,2],ymm12[3]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[0,1,2,3],xmm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 192(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 128(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 64(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, (%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 224(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 160(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 96(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 32(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 192(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 128(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 64(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, (%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 224(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 160(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 96(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 32(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 192(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, (%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 224(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 160(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, (%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 64(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 128(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 192(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 224(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 160(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 96(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 32(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 224(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 192(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 160(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 128(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 96(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 64(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 32(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm6, (%r9)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovapd %ymm5, 224(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm8, 192(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm13, 160(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 96(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 64(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 32(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm5, (%rax)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm1, 192(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm2, 160(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm3, 128(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm4, 96(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm10, 64(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm7, 32(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm9, (%rax)
; AVX1-ONLY-NEXT:    addq $1720, %rsp # imm = 0x6B8
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: load_i64_stride7_vf32:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $1624, %rsp # imm = 0x658
; AVX2-ONLY-NEXT:    vmovdqa 1216(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 768(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 320(%rdi), %ymm15
; AVX2-ONLY-NEXT:    vmovdqa 384(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 224(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vmovdqa 272(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 832(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 672(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vmovdqa 720(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm4[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1280(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1120(%rdi), %xmm10
; AVX2-ONLY-NEXT:    vmovdqa 1168(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm10[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1664(%rdi), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 1728(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1568(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vmovdqa 1616(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm7[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = mem[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 544(%rdi), %ymm9
; AVX2-ONLY-NEXT:    vmovdqa 608(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 448(%rdi), %xmm6
; AVX2-ONLY-NEXT:    vmovdqa 496(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm6[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 992(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vmovdqa 1056(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 896(%rdi), %xmm13
; AVX2-ONLY-NEXT:    vmovdqa 944(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm13[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1440(%rdi), %ymm14
; AVX2-ONLY-NEXT:    vmovdqa 1504(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm14[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1344(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa 1392(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, (%rsp) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm12 = xmm2[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 288(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm3[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 384(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm1 = ymm15[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm15[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 736(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm4[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 832(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm4 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm4 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1184(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm10[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1280(%rdi), %ymm15
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15, %ymm4 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm4 = mem[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1632(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm7[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1728(%rdi), %ymm12
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm4 = ymm5[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],ymm5[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm5 = ymm8[8,9,10,11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm7[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 608(%rdi), %ymm10
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm7 = ymm9[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 512(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm6 = xmm6[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1056(%rdi), %ymm9
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm7 = ymm11[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 960(%rdi), %xmm6
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = xmm13[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm7 = ymm8[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1504(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm11 = ymm14[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm14[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1408(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm2 = xmm2[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 352(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX2-ONLY-NEXT:    vmovdqa 240(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 800(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovdqa 688(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 1248(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm15[1],ymm0[3],ymm15[3]
; AVX2-ONLY-NEXT:    vmovdqa 1136(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 1696(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm12[1],ymm0[3],ymm12[3]
; AVX2-ONLY-NEXT:    vmovdqa 1584(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 128(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm3[1],ymm0[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = mem[0,1],xmm4[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 576(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm10[1],ymm0[3],ymm10[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = mem[0,1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 1024(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm9[1],ymm0[3],ymm9[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = mem[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 1472(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm8[1],ymm0[3],ymm8[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = mem[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 288(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 416(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 736(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 864(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1184(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1312(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1632(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1760(%rdi), %xmm15
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm15[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1408(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1536(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 960(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1088(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 512(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 640(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm6 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm6[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm6
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm8[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm8 = xmm8[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 352(%rdi), %ymm12
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 256(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm8[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 576(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 480(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vmovdqa 800(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm0[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 704(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm14[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vmovdqa 1024(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm11[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 928(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm7[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 1248(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1152(%rdi), %xmm13
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm13[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vmovdqa 1472(%rdi), %ymm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm10[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1376(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 1696(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm9 = ymm2[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1600(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm15 = xmm4[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm9 = ymm15[0,1,2,3],ymm9[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %ymm15
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm6 = ymm6[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm9 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 416(%rdi), %ymm9
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm12 = ymm12[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 320(%rdi), %xmm6
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = xmm8[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 544(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm8 = xmm1[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 640(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm12 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm12 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 864(%rdi), %ymm12
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],ymm0[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 768(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm14 = xmm14[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm14[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 992(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = xmm7[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1088(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm11 = ymm11[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1312(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm3 = ymm3[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1216(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm13 = xmm13[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm13[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1440(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm5 = xmm5[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1536(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm10 = ymm10[8,9,10,11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7],ymm10[24,25,26,27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm14 = ymm5[0,1,2,3],ymm10[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1760(%rdi), %ymm13
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm2 = ymm2[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1664(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm4 = xmm4[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],ymm15[1],ymm2[3],ymm15[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],ymm9[1],ymm2[3],ymm9[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm4 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm4 = mem[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm15 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm2[1],ymm1[1],ymm2[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm9 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],ymm12[1],ymm1[3],ymm12[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm2 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm2 = mem[0,1],xmm8[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm11[1],ymm0[3],ymm11[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = mem[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm3[1],ymm0[3],ymm3[3]
; AVX2-ONLY-NEXT:    vmovdqa (%rsp), %xmm1 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm13[1],ymm0[3],ymm13[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm3 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm3 = mem[0,1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 192(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 128(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 64(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, (%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 224(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 160(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 96(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 32(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 192(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 128(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 64(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, (%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 224(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 160(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 96(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 32(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 192(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 128(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 224(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 160(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 96(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, (%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 64(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 128(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 192(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 224(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 160(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 96(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 32(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 224(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 192(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 160(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 128(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 96(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 64(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 32(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, (%r9)
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovdqa %ymm10, 224(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm14, 192(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 160(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 128(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 96(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 64(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 32(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, (%rax)
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovdqa %ymm0, 224(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm1, 192(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm2, 160(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm4, 128(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm6, 96(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm9, 64(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm15, 32(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-ONLY-NEXT:    addq $1624, %rsp # imm = 0x658
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-ONLY-SLOW-LABEL: load_i64_stride7_vf32:
; AVX512F-ONLY-SLOW:       # %bb.0:
; AVX512F-ONLY-SLOW-NEXT:    subq $2152, %rsp # imm = 0x868
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1664(%rdi), %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1600(%rdi), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1216(%rdi), %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1152(%rdi), %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1088(%rdi), %zmm19
; AVX512F-ONLY-SLOW-NEXT:    vmovaps 1024(%rdi), %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 768(%rdi), %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 704(%rdi), %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 640(%rdi), %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vmovaps 576(%rdi), %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovups %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 320(%rdi), %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 256(%rdi), %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [10,3,10,3,10,3,10,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm4, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm4, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm16, %zmm4, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm17, %zmm0, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [11,4,11,4,11,4,11,4]
; AVX512F-ONLY-SLOW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm16, %zmm4, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [13,6,13,6,13,6,13,6]
; AVX512F-ONLY-SLOW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm11, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm11, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [12,5,12,5,12,5,12,5]
; AVX512F-ONLY-SLOW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm22, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm24
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm22, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm4, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm4, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,7,14,0,0,7,14,0]
; AVX512F-ONLY-SLOW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm26, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm26, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [9,0,7,0,9,0,7,0]
; AVX512F-ONLY-SLOW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm20, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [2,9,2,9,2,9,2,9]
; AVX512F-ONLY-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm1, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm20, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm1, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm19, %zmm4, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm4, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm29
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm4, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm17, %zmm0, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1536(%rdi), %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1472(%rdi), %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm13, %zmm4, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm16, %zmm22, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm17, %zmm0, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm31
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm16, %zmm4, %zmm31
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm17, %zmm0, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm16, %zmm26, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm17, %zmm0, %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm20, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm17, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm17, %zmm1, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm16, %zmm1, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 384(%rdi), %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,9,0,5,6,9]
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 832(%rdi), %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1280(%rdi), %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1728(%rdi), %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,10,0,5,6,10]
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,11,0,5,6,11]
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm24
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,12,0,5,6,12]
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm31
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,13,4,5,6,13]
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,14,4,5,6,14]
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,8,15,4,5,8,15]
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    movb $24, %al
; AVX512F-ONLY-SLOW-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 512(%rdi), %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 448(%rdi), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = <0,7,14,u>
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm15, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k1} = zmm14[0,1,4,5],zmm12[4,5,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [14,0,0,7,14,0,0,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm0, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [7,0,9,0,7,0,9,0]
; AVX512F-ONLY-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm18, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} ymm24 = [4,11,4,11]
; AVX512F-ONLY-SLOW-NEXT:    # ymm24 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm24, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm15, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm16 {%k1} = zmm1[0,1,4,5],zmm29[4,5,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm0, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm18, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm24, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 960(%rdi), %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 896(%rdi), %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm29
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm29
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1408(%rdi), %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 1344(%rdi), %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm5, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm15 {%k1} = zmm8[0,1,4,5],zmm13[4,5,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm19, %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm13, %zmm8, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm18, %zmm19
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm8, %zmm13, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm13, %zmm24, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k1} = zmm6[0,1,4,5],zmm9[4,5,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm24, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 912(%rdi), %xmm13
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm13, %zmm1, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 464(%rdi), %xmm1
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm28, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm27, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 1360(%rdi), %xmm1
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm24
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, 1088(%rdi), %ymm0, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 1024(%rdi), %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,11]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm11, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 576(%rdi), %ymm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3,4,5],ymm8[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm0, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm10, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3,4,5],ymm8[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm23, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, 1536(%rdi), %ymm0, %ymm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 1472(%rdi), %ymm9
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3,4,5],ymm6[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm5, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm26, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 1088(%rdi), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm0 = ymm1[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm26 = <9,0,7,u>
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm13, %zmm26, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [5,12]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm0, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} xmm8 = [6,13]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm8, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm26, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm8, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm26, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm5, %zmm3, %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 960(%rdi), %ymm11
; AVX512F-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 512(%rdi), %ymm13
; AVX512F-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm5, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm8, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm8, %zmm12
; AVX512F-ONLY-SLOW-NEXT:    movb $-32, %al
; AVX512F-ONLY-SLOW-NEXT:    kmovw %eax, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm16 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm17 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm29 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm15 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm23 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm23 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm7 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm7 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm26 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm26 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm30 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm28 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm27 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm24 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm11, %zmm19, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm3 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm13, %zmm22, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vpblendd $240, (%rsp), %ymm10, %ymm8 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm8 = ymm10[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm10
; AVX512F-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm10 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm10, %zmm20, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm10 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm25, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 640(%rdi), %ymm11
; AVX512F-ONLY-SLOW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 1408(%rdi), %ymm13
; AVX512F-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm13, %zmm18, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm13 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm11[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm11, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 192(%rdi), %ymm11
; AVX512F-ONLY-SLOW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm11[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm11, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 1536(%rdi), %ymm11
; AVX512F-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm9 = ymm9[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm9[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm9 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm9 = ymm9[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinsertf64x4 $0, %ymm9, %zmm11, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm11 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm11 = ymm14[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm11, %zmm14, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm5 = ymm5[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm5, %zmm14, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm12 = ymm12[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm12, %zmm14, %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, 192(%rsi)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, 128(%rsi)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, 64(%rsi)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, (%rsi)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm26, 192(%rdx)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, (%rdx)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm23, 64(%rdx)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, 128(%rdx)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm24, 192(%rcx)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm27, (%rcx)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, 64(%rcx)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, 128(%rcx)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, 192(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, 128(%r8)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm2, 192(%r9)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm2, (%r9)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm2, 64(%r9)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm2, 128(%r9)
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, 64(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, 128(%rax)
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, 128(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm9, 64(%rax)
; AVX512F-ONLY-SLOW-NEXT:    addq $2152, %rsp # imm = 0x868
; AVX512F-ONLY-SLOW-NEXT:    vzeroupper
; AVX512F-ONLY-SLOW-NEXT:    retq
;
; AVX512F-ONLY-FAST-LABEL: load_i64_stride7_vf32:
; AVX512F-ONLY-FAST:       # %bb.0:
; AVX512F-ONLY-FAST-NEXT:    subq $2152, %rsp # imm = 0x868
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1664(%rdi), %zmm17
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1600(%rdi), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1216(%rdi), %zmm16
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1152(%rdi), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1088(%rdi), %zmm19
; AVX512F-ONLY-FAST-NEXT:    vmovaps 1024(%rdi), %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 768(%rdi), %zmm21
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 704(%rdi), %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 640(%rdi), %zmm12
; AVX512F-ONLY-FAST-NEXT:    vmovaps 576(%rdi), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovups %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 320(%rdi), %zmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 256(%rdi), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [10,3,10,3,10,3,10,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm18, %zmm4, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm4, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm16, %zmm4, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm17, %zmm0, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [11,4,11,4,11,4,11,4]
; AVX512F-ONLY-FAST-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm16, %zmm4, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [13,6,13,6,13,6,13,6]
; AVX512F-ONLY-FAST-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm11, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm18, %zmm11, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [12,5,12,5,12,5,12,5]
; AVX512F-ONLY-FAST-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm22, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm24
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm18, %zmm22, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm27
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm4, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm18, %zmm4, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm30
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,7,14,0,0,7,14,0]
; AVX512F-ONLY-FAST-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm26, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm18, %zmm26, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [9,0,7,0,9,0,7,0]
; AVX512F-ONLY-FAST-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm21, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm20, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [2,9,2,9,2,9,2,9]
; AVX512F-ONLY-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm1, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm20, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm18, %zmm1, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm19, %zmm4, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm4, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm29
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm29, %zmm4, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm17, %zmm0, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1536(%rdi), %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1472(%rdi), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm4, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm16, %zmm22, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm17, %zmm0, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm31
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm16, %zmm4, %zmm31
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm17, %zmm0, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm16, %zmm26, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm17, %zmm0, %zmm26
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, %zmm25
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm20, %zmm25
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm17, %zmm20
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm1, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm16, %zmm1, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 384(%rdi), %zmm1
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,9,0,5,6,9]
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 832(%rdi), %zmm4
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1280(%rdi), %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1728(%rdi), %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,10,0,5,6,10]
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,11,0,5,6,11]
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm24
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm27
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,12,0,5,6,12]
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm31
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm30
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,13,4,5,6,13]
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm26
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,14,4,5,6,14]
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm25
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm20
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,8,15,4,5,8,15]
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm17
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    movb $24, %al
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 512(%rdi), %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 448(%rdi), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = <0,7,14,u>
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm15, %zmm17
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k1} = zmm14[0,1,4,5],zmm12[4,5,0,1]
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [14,0,0,7,14,0,0,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm0, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [7,0,9,0,7,0,9,0]
; AVX512F-ONLY-FAST-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm18, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} ymm24 = [4,11,4,11]
; AVX512F-ONLY-FAST-NEXT:    # ymm24 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm24, %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm15, %zmm16
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm16 {%k1} = zmm1[0,1,4,5],zmm29[4,5,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm27
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm29, %zmm0, %zmm27
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, %zmm20
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm18, %zmm20
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm29, %zmm24, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 960(%rdi), %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 896(%rdi), %zmm12
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm29
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm15, %zmm29
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1408(%rdi), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 1344(%rdi), %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm5, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm15 {%k1} = zmm8[0,1,4,5],zmm13[4,5,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm19, %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm13, %zmm8, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm18, %zmm19
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm8, %zmm13, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm24, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k1} = zmm6[0,1,4,5],zmm9[4,5,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm24, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 912(%rdi), %xmm13
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm13, %zmm1, %zmm30
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 464(%rdi), %xmm1
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm28, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm27, %zmm27
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 1360(%rdi), %xmm1
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm24
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, 1088(%rdi), %ymm0, %ymm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 1024(%rdi), %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,11]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm6, %zmm11, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 576(%rdi), %ymm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3,4,5],ymm8[6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm0, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm10, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3,4,5],ymm8[6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm0, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm23, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, 1536(%rdi), %ymm0, %ymm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 1472(%rdi), %ymm9
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3,4,5],ymm6[6,7]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm5, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm26, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 1088(%rdi), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm0 = ymm1[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm26 = <9,0,7,u>
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm26, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [5,12]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm0, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} xmm8 = [6,13]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm8, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm26, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm8, %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm26, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm5, %zmm3, %zmm26
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 960(%rdi), %ymm11
; AVX512F-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm11
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 512(%rdi), %ymm13
; AVX512F-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm5, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm8, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm8, %zmm12
; AVX512F-ONLY-FAST-NEXT:    movb $-32, %al
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm16 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm17 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm29 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm15 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm23 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm23 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm7 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm7 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm26 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm26 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm21, %zmm30 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm28 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm27 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm24 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm11, %zmm19, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, %zmm3 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm13, %zmm22, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vpblendd $240, (%rsp), %ymm10, %ymm8 # 32-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # ymm8 = ymm10[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 64(%rdi), %ymm10
; AVX512F-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm10 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm10, %zmm20, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm10 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm25, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 640(%rdi), %ymm11
; AVX512F-ONLY-FAST-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 1408(%rdi), %ymm13
; AVX512F-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm13, %zmm18, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm13 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm11[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm6, %zmm11, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 192(%rdi), %ymm11
; AVX512F-ONLY-FAST-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm11[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm11, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 1536(%rdi), %ymm11
; AVX512F-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm9 = ymm9[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm9[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm9 # 32-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # ymm9 = ymm9[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinsertf64x4 $0, %ymm9, %zmm11, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm11 # 32-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # ymm11 = ymm14[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm11, %zmm14, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # ymm5 = ymm5[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm14, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # ymm12 = ymm12[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm12, %zmm14, %zmm12
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm15, 192(%rsi)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, 128(%rsi)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, 64(%rsi)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, (%rsi)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm26, 192(%rdx)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, (%rdx)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, 64(%rdx)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, 128(%rdx)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm24, 192(%rcx)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm27, (%rcx)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, 64(%rcx)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, 128(%rcx)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, 192(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, 128(%r8)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm2, 192(%r9)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm2, (%r9)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm2, 64(%r9)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm2, 128(%r9)
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, 64(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, 128(%rax)
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, 128(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm9, 64(%rax)
; AVX512F-ONLY-FAST-NEXT:    addq $2152, %rsp # imm = 0x868
; AVX512F-ONLY-FAST-NEXT:    vzeroupper
; AVX512F-ONLY-FAST-NEXT:    retq
;
; AVX512DQ-SLOW-LABEL: load_i64_stride7_vf32:
; AVX512DQ-SLOW:       # %bb.0:
; AVX512DQ-SLOW-NEXT:    subq $2152, %rsp # imm = 0x868
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1664(%rdi), %zmm17
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1600(%rdi), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1216(%rdi), %zmm16
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1152(%rdi), %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1088(%rdi), %zmm19
; AVX512DQ-SLOW-NEXT:    vmovaps 1024(%rdi), %zmm1
; AVX512DQ-SLOW-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 768(%rdi), %zmm21
; AVX512DQ-SLOW-NEXT:    vmovdqa64 704(%rdi), %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqa64 640(%rdi), %zmm12
; AVX512DQ-SLOW-NEXT:    vmovaps 576(%rdi), %zmm3
; AVX512DQ-SLOW-NEXT:    vmovups %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 320(%rdi), %zmm18
; AVX512DQ-SLOW-NEXT:    vmovdqa64 256(%rdi), %zmm3
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [10,3,10,3,10,3,10,3]
; AVX512DQ-SLOW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm18, %zmm4, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm4, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm16, %zmm4, %zmm6
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm17, %zmm0, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [11,4,11,4,11,4,11,4]
; AVX512DQ-SLOW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm16, %zmm4, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm11
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [13,6,13,6,13,6,13,6]
; AVX512DQ-SLOW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm7
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm11, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm18, %zmm11, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [12,5,12,5,12,5,12,5]
; AVX512DQ-SLOW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm22, %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm24
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm18, %zmm22, %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm27
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm4, %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm28
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm18, %zmm4, %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm30
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,7,14,0,0,7,14,0]
; AVX512DQ-SLOW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm7
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm26, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm23
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm18, %zmm26, %zmm23
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [9,0,7,0,9,0,7,0]
; AVX512DQ-SLOW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm15
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm9, %zmm20, %zmm15
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [2,9,2,9,2,9,2,9]
; AVX512DQ-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm1, %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm20, %zmm8
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm18, %zmm1, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm19, %zmm4, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm3
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm4, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm29
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm29, %zmm4, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm18
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm17, %zmm0, %zmm18
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1536(%rdi), %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1472(%rdi), %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm13, %zmm4, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm21
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm16, %zmm22, %zmm21
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm17, %zmm0, %zmm22
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm31
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm16, %zmm4, %zmm31
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm17, %zmm0, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm16, %zmm26, %zmm11
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm17, %zmm0, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm25
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm20, %zmm25
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm0, %zmm17, %zmm20
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm17, %zmm1, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm16, %zmm1, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 384(%rdi), %zmm1
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,9,0,5,6,9]
; AVX512DQ-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 832(%rdi), %zmm4
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1280(%rdi), %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1728(%rdi), %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,10,0,5,6,10]
; AVX512DQ-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm18
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,11,0,5,6,11]
; AVX512DQ-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm21
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm24
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm27
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm22
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,12,0,5,6,12]
; AVX512DQ-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm31
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm28
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm30
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,13,4,5,6,13]
; AVX512DQ-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm11
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm10
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm23
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm26
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,14,4,5,6,14]
; AVX512DQ-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm25
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm15
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm20
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,8,15,4,5,8,15]
; AVX512DQ-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm17
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    movb $24, %al
; AVX512DQ-SLOW-NEXT:    kmovw %eax, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 512(%rdi), %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqa64 448(%rdi), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = <0,7,14,u>
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm7, %zmm15, %zmm17
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k1} = zmm14[0,1,4,5],zmm12[4,5,0,1]
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [14,0,0,7,14,0,0,7]
; AVX512DQ-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm28
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm0, %zmm28
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [7,0,9,0,7,0,9,0]
; AVX512DQ-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm22
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm14, %zmm18, %zmm22
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x2 {{.*#+}} ymm24 = [4,11,4,11]
; AVX512DQ-SLOW-NEXT:    # ymm24 = mem[0,1,0,1]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm24, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm15, %zmm16
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm16 {%k1} = zmm1[0,1,4,5],zmm29[4,5,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm27
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm29, %zmm0, %zmm27
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm20
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm18, %zmm20
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm29, %zmm24, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 960(%rdi), %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 896(%rdi), %zmm12
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm29
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm29
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1408(%rdi), %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 1344(%rdi), %zmm5
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm5, %zmm15
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm15 {%k1} = zmm8[0,1,4,5],zmm13[4,5,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm19, %zmm0, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm13, %zmm8, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm18, %zmm19
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm8, %zmm13, %zmm18
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm13, %zmm24, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k1} = zmm6[0,1,4,5],zmm9[4,5,0,1]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm9, %zmm24, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa 912(%rdi), %xmm13
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $0, %xmm13, %zmm1, %zmm30
; AVX512DQ-SLOW-NEXT:    vmovdqa 464(%rdi), %xmm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm28, %zmm28
; AVX512DQ-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm27, %zmm27
; AVX512DQ-SLOW-NEXT:    vmovdqa 1360(%rdi), %xmm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm24
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, 1088(%rdi), %ymm0, %ymm0
; AVX512DQ-SLOW-NEXT:    vmovdqa 1024(%rdi), %ymm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,11]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm6
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm6
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm11, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm8
; AVX512DQ-SLOW-NEXT:    vmovdqa 576(%rdi), %ymm6
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3,4,5],ymm8[6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm11
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm7, %zmm0, %zmm11
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm10, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm8
; AVX512DQ-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3,4,5],ymm8[6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm9
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm23, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, 1536(%rdi), %ymm0, %ymm6
; AVX512DQ-SLOW-NEXT:    vmovdqa 1472(%rdi), %ymm9
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3,4,5],ymm6[6,7]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm5, %zmm0
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm26, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa 1088(%rdi), %ymm0
; AVX512DQ-SLOW-NEXT:    vpalignr {{.*#+}} ymm0 = ymm1[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm26 = <9,0,7,u>
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm23
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm13, %zmm26, %zmm23
; AVX512DQ-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [5,12]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm6
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm7, %zmm0, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa {{.*#+}} xmm8 = [6,13]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm7, %zmm8, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm14, %zmm26, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm8, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm2
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm26, %zmm2
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm5, %zmm3, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqa 960(%rdi), %ymm11
; AVX512DQ-SLOW-NEXT:    vpalignr {{.*#+}} ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm11, %xmm11
; AVX512DQ-SLOW-NEXT:    vmovdqa 512(%rdi), %ymm13
; AVX512DQ-SLOW-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm10
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm10
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm5, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm8, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm8, %zmm12
; AVX512DQ-SLOW-NEXT:    movb $-32, %al
; AVX512DQ-SLOW-NEXT:    kmovw %eax, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm16 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm17 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm29 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm15 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm23 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm23 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm7 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm7 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm26 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm26 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm30 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm28 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm27 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm24 {%k2}
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $0, %xmm11, %zmm19, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm3 {%k2}
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $0, %xmm13, %zmm22, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512DQ-SLOW-NEXT:    vpblendd $240, (%rsp), %ymm10, %ymm8 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm8 = ymm10[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm10
; AVX512DQ-SLOW-NEXT:    vpalignr {{.*#+}} ymm10 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $0, %xmm10, %zmm20, %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm10 {%k2}
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm25, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa 640(%rdi), %ymm11
; AVX512DQ-SLOW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512DQ-SLOW-NEXT:    vmovdqa 1408(%rdi), %ymm13
; AVX512DQ-SLOW-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512DQ-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $0, %xmm13, %zmm18, %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm13 {%k2}
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm11[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm11, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa 192(%rdi), %ymm11
; AVX512DQ-SLOW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm11[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm11, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa 1536(%rdi), %ymm11
; AVX512DQ-SLOW-NEXT:    vpalignr {{.*#+}} ymm9 = ymm9[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm9[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm9 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm9 = ymm9[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinsertf64x4 $0, %ymm9, %zmm11, %zmm9
; AVX512DQ-SLOW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm11 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm11 = ymm14[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm11, %zmm14, %zmm11
; AVX512DQ-SLOW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm5 = ymm5[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm5, %zmm14, %zmm5
; AVX512DQ-SLOW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm12 = ymm12[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm12, %zmm14, %zmm12
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm15, 192(%rsi)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm29, 128(%rsi)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm17, 64(%rsi)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm16, (%rsi)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm26, 192(%rdx)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm7, (%rdx)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm23, 64(%rdx)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, 128(%rdx)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm24, 192(%rcx)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm27, (%rcx)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm28, 64(%rcx)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm30, 128(%rcx)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, 192(%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, 128(%r8)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm2, 192(%r9)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm2, (%r9)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm2, 64(%r9)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm2, 128(%r9)
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, 64(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, 128(%rax)
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, 128(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm9, 64(%rax)
; AVX512DQ-SLOW-NEXT:    addq $2152, %rsp # imm = 0x868
; AVX512DQ-SLOW-NEXT:    vzeroupper
; AVX512DQ-SLOW-NEXT:    retq
;
; AVX512DQ-FAST-LABEL: load_i64_stride7_vf32:
; AVX512DQ-FAST:       # %bb.0:
; AVX512DQ-FAST-NEXT:    subq $2152, %rsp # imm = 0x868
; AVX512DQ-FAST-NEXT:    vmovdqa64 1664(%rdi), %zmm17
; AVX512DQ-FAST-NEXT:    vmovdqa64 1600(%rdi), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 1216(%rdi), %zmm16
; AVX512DQ-FAST-NEXT:    vmovdqa64 1152(%rdi), %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 1088(%rdi), %zmm19
; AVX512DQ-FAST-NEXT:    vmovaps 1024(%rdi), %zmm1
; AVX512DQ-FAST-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 768(%rdi), %zmm21
; AVX512DQ-FAST-NEXT:    vmovdqa64 704(%rdi), %zmm9
; AVX512DQ-FAST-NEXT:    vmovdqa64 640(%rdi), %zmm12
; AVX512DQ-FAST-NEXT:    vmovaps 576(%rdi), %zmm3
; AVX512DQ-FAST-NEXT:    vmovups %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 320(%rdi), %zmm18
; AVX512DQ-FAST-NEXT:    vmovdqa64 256(%rdi), %zmm3
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [10,3,10,3,10,3,10,3]
; AVX512DQ-FAST-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm18, %zmm4, %zmm5
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm21, %zmm4, %zmm5
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm16, %zmm4, %zmm6
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm17, %zmm0, %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [11,4,11,4,11,4,11,4]
; AVX512DQ-FAST-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm16, %zmm4, %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm11
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm4 = [13,6,13,6,13,6,13,6]
; AVX512DQ-FAST-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, %zmm7
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm21, %zmm11, %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm18, %zmm11, %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [12,5,12,5,12,5,12,5]
; AVX512DQ-FAST-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm21, %zmm22, %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, %zmm24
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm18, %zmm22, %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, %zmm27
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm21, %zmm4, %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, %zmm28
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm18, %zmm4, %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, %zmm30
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,7,14,0,0,7,14,0]
; AVX512DQ-FAST-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, %zmm7
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm21, %zmm26, %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm23
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm18, %zmm26, %zmm23
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [9,0,7,0,9,0,7,0]
; AVX512DQ-FAST-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm21, %zmm15
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm9, %zmm20, %zmm15
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [2,9,2,9,2,9,2,9]
; AVX512DQ-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm21, %zmm1, %zmm9
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm18, %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm7
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm20, %zmm8
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm18, %zmm1, %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm19, %zmm4, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm14, %zmm3
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm12, %zmm4, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm29
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm29, %zmm4, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm11, %zmm18
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm17, %zmm0, %zmm18
; AVX512DQ-FAST-NEXT:    vmovdqa64 1536(%rdi), %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqa64 1472(%rdi), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm13, %zmm4, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm21
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm16, %zmm22, %zmm21
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm17, %zmm0, %zmm22
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm31
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm16, %zmm4, %zmm31
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm17, %zmm0, %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm16, %zmm26, %zmm11
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm17, %zmm0, %zmm26
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm16, %zmm25
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm2, %zmm20, %zmm25
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm0, %zmm17, %zmm20
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm17, %zmm1, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm16, %zmm1, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 384(%rdi), %zmm1
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,9,0,5,6,9]
; AVX512DQ-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 832(%rdi), %zmm4
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 1280(%rdi), %zmm5
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 1728(%rdi), %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,10,0,5,6,10]
; AVX512DQ-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm18
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,11,0,5,6,11]
; AVX512DQ-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm21
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm24
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm27
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm22
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,12,0,5,6,12]
; AVX512DQ-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm31
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm28
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm30
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,13,4,5,6,13]
; AVX512DQ-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm11
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm10
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm23
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm26
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,14,4,5,6,14]
; AVX512DQ-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm25
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm15
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm20
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,8,15,4,5,8,15]
; AVX512DQ-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm9
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm17
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    movb $24, %al
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k1
; AVX512DQ-FAST-NEXT:    vmovdqa64 512(%rdi), %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqa64 448(%rdi), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = <0,7,14,u>
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm7, %zmm15, %zmm17
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k1} = zmm14[0,1,4,5],zmm12[4,5,0,1]
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [14,0,0,7,14,0,0,7]
; AVX512DQ-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm14, %zmm28
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm12, %zmm0, %zmm28
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [7,0,9,0,7,0,9,0]
; AVX512DQ-FAST-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, %zmm22
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm14, %zmm18, %zmm22
; AVX512DQ-FAST-NEXT:    vbroadcasti64x2 {{.*#+}} ymm24 = [4,11,4,11]
; AVX512DQ-FAST-NEXT:    # ymm24 = mem[0,1,0,1]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm12, %zmm24, %zmm14
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdi), %zmm14
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm14, %zmm16
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm2, %zmm15, %zmm16
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm16 {%k1} = zmm1[0,1,4,5],zmm29[4,5,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm27
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm29, %zmm0, %zmm27
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm29, %zmm20
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm18, %zmm20
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm29, %zmm24, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 960(%rdi), %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 896(%rdi), %zmm12
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, %zmm29
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm15, %zmm29
; AVX512DQ-FAST-NEXT:    vmovdqa64 1408(%rdi), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 1344(%rdi), %zmm5
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm3, %zmm5, %zmm15
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm15 {%k1} = zmm8[0,1,4,5],zmm13[4,5,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm19, %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm13, %zmm8, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm18, %zmm19
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm8, %zmm13, %zmm18
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm13, %zmm24, %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k1} = zmm6[0,1,4,5],zmm9[4,5,0,1]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm9, %zmm24, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa 912(%rdi), %xmm13
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $0, %xmm13, %zmm1, %zmm30
; AVX512DQ-FAST-NEXT:    vmovdqa 464(%rdi), %xmm1
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm28, %zmm28
; AVX512DQ-FAST-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm27, %zmm27
; AVX512DQ-FAST-NEXT:    vmovdqa 1360(%rdi), %xmm1
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm24
; AVX512DQ-FAST-NEXT:    vinserti128 $1, 1088(%rdi), %ymm0, %ymm0
; AVX512DQ-FAST-NEXT:    vmovdqa 1024(%rdi), %ymm1
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,11]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, %zmm6
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm6
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm6, %zmm11, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm8
; AVX512DQ-FAST-NEXT:    vmovdqa 576(%rdi), %ymm6
; AVX512DQ-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3,4,5],ymm8[6,7]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, %zmm11
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm7, %zmm0, %zmm11
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm10, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm8
; AVX512DQ-FAST-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512DQ-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm6[0,1,2,3,4,5],ymm8[6,7]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm14, %zmm9
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm2, %zmm0, %zmm9
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm23, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vinserti128 $1, 1536(%rdi), %ymm0, %ymm6
; AVX512DQ-FAST-NEXT:    vmovdqa 1472(%rdi), %ymm9
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm9[0,1,2,3,4,5],ymm6[6,7]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm3, %zmm5, %zmm0
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm6[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm26, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa 1088(%rdi), %ymm0
; AVX512DQ-FAST-NEXT:    vpalignr {{.*#+}} ymm0 = ymm1[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX512DQ-FAST-NEXT:    vmovdqu %ymm0, (%rsp) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm26 = <9,0,7,u>
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm7, %zmm23
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm13, %zmm26, %zmm23
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [5,12]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, %zmm6
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm7, %zmm0, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} xmm8 = [6,13]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm7, %zmm8, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm14, %zmm26, %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm14, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm2, %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm2, %zmm8, %zmm14
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm12, %zmm26, %zmm2
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm5, %zmm3, %zmm26
; AVX512DQ-FAST-NEXT:    vmovdqa 960(%rdi), %ymm11
; AVX512DQ-FAST-NEXT:    vpalignr {{.*#+}} ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm11, %xmm11
; AVX512DQ-FAST-NEXT:    vmovdqa 512(%rdi), %ymm13
; AVX512DQ-FAST-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, %zmm10
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm10
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm3, %zmm5, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm8, %zmm5
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm8, %zmm12
; AVX512DQ-FAST-NEXT:    movb $-32, %al
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k2
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm16 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm17 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm29 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm15 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm23 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm23 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm7 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm7 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm26 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm26 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm21, %zmm30 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm28 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm27 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm24 {%k2}
; AVX512DQ-FAST-NEXT:    vinserti32x4 $0, %xmm11, %zmm19, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm31, %zmm3 {%k2}
; AVX512DQ-FAST-NEXT:    vinserti32x4 $0, %xmm13, %zmm22, %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512DQ-FAST-NEXT:    vpblendd $240, (%rsp), %ymm10, %ymm8 # 32-byte Folded Reload
; AVX512DQ-FAST-NEXT:    # ymm8 = ymm10[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqa 64(%rdi), %ymm10
; AVX512DQ-FAST-NEXT:    vpalignr {{.*#+}} ymm10 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512DQ-FAST-NEXT:    vinserti32x4 $0, %xmm10, %zmm20, %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm11, %zmm10 {%k2}
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm25, %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqa 640(%rdi), %ymm11
; AVX512DQ-FAST-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512DQ-FAST-NEXT:    # ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512DQ-FAST-NEXT:    vmovdqa 1408(%rdi), %ymm13
; AVX512DQ-FAST-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512DQ-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512DQ-FAST-NEXT:    vinserti32x4 $0, %xmm13, %zmm18, %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm18, %zmm13 {%k2}
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm11[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm6, %zmm11, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqa 192(%rdi), %ymm11
; AVX512DQ-FAST-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512DQ-FAST-NEXT:    # ymm11 = mem[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm11[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm11, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa 1536(%rdi), %ymm11
; AVX512DQ-FAST-NEXT:    vpalignr {{.*#+}} ymm9 = ymm9[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm9[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm9, %zmm0
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm9 # 32-byte Folded Reload
; AVX512DQ-FAST-NEXT:    # ymm9 = ymm9[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vinsertf64x4 $0, %ymm9, %zmm11, %zmm9
; AVX512DQ-FAST-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm11 # 32-byte Folded Reload
; AVX512DQ-FAST-NEXT:    # ymm11 = ymm14[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm11, %zmm14, %zmm11
; AVX512DQ-FAST-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX512DQ-FAST-NEXT:    # ymm5 = ymm5[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm14, %zmm5
; AVX512DQ-FAST-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX512DQ-FAST-NEXT:    # ymm12 = ymm12[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm12, %zmm14, %zmm12
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm15, 192(%rsi)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm29, 128(%rsi)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm17, 64(%rsi)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm16, (%rsi)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm26, 192(%rdx)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm7, (%rdx)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm23, 64(%rdx)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, 128(%rdx)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm24, 192(%rcx)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm27, (%rcx)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm28, 64(%rcx)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm30, 128(%rcx)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, 192(%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, 128(%r8)
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovaps %zmm2, 192(%r9)
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovaps %zmm2, (%r9)
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovaps %zmm2, 64(%r9)
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovaps %zmm2, 128(%r9)
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, 64(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, 128(%rax)
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, 128(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512DQ-FAST-NEXT:    vmovaps %zmm9, 64(%rax)
; AVX512DQ-FAST-NEXT:    addq $2152, %rsp # imm = 0x868
; AVX512DQ-FAST-NEXT:    vzeroupper
; AVX512DQ-FAST-NEXT:    retq
;
; AVX512BW-ONLY-SLOW-LABEL: load_i64_stride7_vf32:
; AVX512BW-ONLY-SLOW:       # %bb.0:
; AVX512BW-ONLY-SLOW-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1664(%rdi), %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1600(%rdi), %zmm31
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1216(%rdi), %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1152(%rdi), %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1088(%rdi), %zmm30
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1024(%rdi), %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 768(%rdi), %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 704(%rdi), %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 640(%rdi), %zmm12
; AVX512BW-ONLY-SLOW-NEXT:    vmovaps 576(%rdi), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovups %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 320(%rdi), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 256(%rdi), %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [10,3,10,3,10,3,10,3]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm6, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm15, %zmm31, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [11,4,11,4,11,4,11,4]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [13,6,13,6,13,6,13,6]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm8, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm8, %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [12,5,12,5,12,5,12,5]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm19, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm24
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm19, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm6, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm27
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm28
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,7,14,0,0,7,14,0]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm26, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm23
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm26, %zmm23
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [9,0,7,0,9,0,7,0]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm29, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm22
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [2,9,2,9,2,9,2,9]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm1, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm29, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm30, %zmm6, %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm6, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm6, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm15, %zmm31, %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1536(%rdi), %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1472(%rdi), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm13, %zmm6, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm19, %zmm25
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm15, %zmm31, %zmm19
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm31
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm31
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm15, %zmm4, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm15, %zmm4, %zmm26
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm15, %zmm29
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm15, %zmm1, %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 384(%rdi), %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,9,0,5,6,9]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 832(%rdi), %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1280(%rdi), %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1728(%rdi), %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,10,0,5,6,10]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,11,0,5,6,11]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm25
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm24
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm19
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,12,0,5,6,12]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm31
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm27
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm28
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,13,4,5,6,13]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm23
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm26
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,14,4,5,6,14]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm22
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm29
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm29, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,8,15,4,5,8,15]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    movb $24, %al
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 512(%rdi), %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 448(%rdi), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = <0,7,14,u>
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm15, %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k1} = zmm14[0,1,4,5],zmm12[4,5,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [14,0,0,7,14,0,0,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm28
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm0, %zmm28
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [7,0,9,0,7,0,9,0]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm19
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm16, %zmm19
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} ymm24 = [4,11,4,11]
; AVX512BW-ONLY-SLOW-NEXT:    # ymm24 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm24, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm15, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm1[0,1,4,5],zmm7[4,5,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm0, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm16, %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm24, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 960(%rdi), %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 896(%rdi), %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm29
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1408(%rdi), %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 1344(%rdi), %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm2, %zmm7, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 (%rsp), %zmm6 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm15 {%k1} = zmm6[0,1,4,5],zmm13[4,5,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm30, %zmm0, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm13, %zmm6, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm16, %zmm22
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm13, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm13, %zmm24, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k1} = zmm10[0,1,4,5],zmm30[4,5,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm30, %zmm24, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 912(%rdi), %xmm13
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm13, %zmm1, %zmm30
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 464(%rdi), %xmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm28, %zmm28
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm9, %zmm27
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 1360(%rdi), %xmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm24
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, 1088(%rdi), %ymm0, %ymm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 1024(%rdi), %ymm13
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm13[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,11]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm18, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 576(%rdi), %ymm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3,4,5],ymm1[6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm0, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm8, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3,4,5],ymm1[6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm23, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, 1536(%rdi), %ymm0, %ymm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 1472(%rdi), %ymm9
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm9[0,1,2,3,4,5],ymm1[6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm2, %zmm7, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm26, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm26 = <9,0,7,u>
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm23
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm26, %zmm23
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [5,12]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm0, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa {{.*#+}} xmm1 = [6,13]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm1, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm26, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm12
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm26, %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm2, %zmm26
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm2, %zmm7, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 1088(%rdi), %ymm1
; AVX512BW-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm1 = ymm13[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm13[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm10[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm20, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    movb $-32, %al
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %eax, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm14 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm17 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm29 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm15 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm30 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 960(%rdi), %ymm2
; AVX512BW-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm2 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm2, %zmm22, %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm2 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 512(%rdi), %ymm4
; AVX512BW-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm4 = mem[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm4, %zmm19, %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm10
; AVX512BW-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm10 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm10, %zmm21, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm10 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 1408(%rdi), %ymm13
; AVX512BW-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $0, %xmm13, %zmm16, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm13 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 640(%rdi), %ymm16
; AVX512BW-ONLY-SLOW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm16, %ymm1 # 32-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm16[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm16[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm8, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 192(%rdi), %ymm8
; AVX512BW-ONLY-SLOW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # ymm8 = mem[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm8, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 1536(%rdi), %ymm8
; AVX512BW-ONLY-SLOW-NEXT:    vpalignr {{.*#+}} ymm8 = ymm9[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm8, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # ymm8 = ymm8[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinsertf64x4 $0, %ymm8, %zmm9, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm9 # 32-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # ymm9 = ymm12[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm9, %zmm12, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd $240, (%rsp), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm7, %zmm12, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # ymm11 = ymm11[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm11, %zmm12, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, 192(%rsi)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, 128(%rsi)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, 64(%rsi)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm26, 192(%rdx)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, (%rdx)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm23, 64(%rdx)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, 128(%rdx)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm24, 192(%rcx)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm27, (%rcx)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, 64(%rcx)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, 128(%rcx)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, 192(%r8)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, 128(%r8)
; AVX512BW-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovaps %zmm2, 192(%r9)
; AVX512BW-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovaps %zmm2, (%r9)
; AVX512BW-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovaps %zmm2, 64(%r9)
; AVX512BW-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovaps %zmm2, 128(%r9)
; AVX512BW-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, 128(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, 128(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, 192(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, (%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovaps %zmm8, 64(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512BW-ONLY-SLOW-NEXT:    vzeroupper
; AVX512BW-ONLY-SLOW-NEXT:    retq
;
; AVX512BW-ONLY-FAST-LABEL: load_i64_stride7_vf32:
; AVX512BW-ONLY-FAST:       # %bb.0:
; AVX512BW-ONLY-FAST-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1664(%rdi), %zmm15
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1600(%rdi), %zmm31
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1216(%rdi), %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1152(%rdi), %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1088(%rdi), %zmm30
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1024(%rdi), %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 768(%rdi), %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 704(%rdi), %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 640(%rdi), %zmm12
; AVX512BW-ONLY-FAST-NEXT:    vmovaps 576(%rdi), %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovups %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 320(%rdi), %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 256(%rdi), %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [10,3,10,3,10,3,10,3]
; AVX512BW-ONLY-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm6, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm6, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm15, %zmm31, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [11,4,11,4,11,4,11,4]
; AVX512BW-ONLY-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [13,6,13,6,13,6,13,6]
; AVX512BW-ONLY-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm8, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm8, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [12,5,12,5,12,5,12,5]
; AVX512BW-ONLY-FAST-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm19, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm24
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm19, %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm6, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm27
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm6, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,7,14,0,0,7,14,0]
; AVX512BW-ONLY-FAST-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm26, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm23
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm26, %zmm23
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [9,0,7,0,9,0,7,0]
; AVX512BW-ONLY-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm21, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm29, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm22
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [2,9,2,9,2,9,2,9]
; AVX512BW-ONLY-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm21, %zmm1, %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm29, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm1, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm30, %zmm6, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm6, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm6, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm15, %zmm31, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1536(%rdi), %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1472(%rdi), %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm6, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm19, %zmm25
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm15, %zmm31, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm31
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm6, %zmm31
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm15, %zmm4, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm15, %zmm4, %zmm26
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm20
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm15, %zmm29
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm15, %zmm1, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 384(%rdi), %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,9,0,5,6,9]
; AVX512BW-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 832(%rdi), %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1280(%rdi), %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1728(%rdi), %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,10,0,5,6,10]
; AVX512BW-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,11,0,5,6,11]
; AVX512BW-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm25
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm24
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,12,0,5,6,12]
; AVX512BW-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm31
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm27
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,13,4,5,6,13]
; AVX512BW-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm23
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm26
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,14,4,5,6,14]
; AVX512BW-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm20
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm22
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm29
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm29, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,8,15,4,5,8,15]
; AVX512BW-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm15
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    movb $24, %al
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 512(%rdi), %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 448(%rdi), %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = <0,7,14,u>
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm15, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k1} = zmm14[0,1,4,5],zmm12[4,5,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [14,0,0,7,14,0,0,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm0, %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [7,0,9,0,7,0,9,0]
; AVX512BW-ONLY-FAST-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm16, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} ymm24 = [4,11,4,11]
; AVX512BW-ONLY-FAST-NEXT:    # ymm24 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm24, %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm15, %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm1[0,1,4,5],zmm7[4,5,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm0, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm16, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm24, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 960(%rdi), %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 896(%rdi), %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm15, %zmm29
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1408(%rdi), %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 1344(%rdi), %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm7, %zmm15
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 (%rsp), %zmm6 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm15 {%k1} = zmm6[0,1,4,5],zmm13[4,5,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm10, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm30, %zmm0, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm13, %zmm6, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm10, %zmm16, %zmm22
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm6, %zmm13, %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm24, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k1} = zmm10[0,1,4,5],zmm30[4,5,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm30, %zmm24, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 912(%rdi), %xmm13
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm13, %zmm1, %zmm30
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 464(%rdi), %xmm1
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm28, %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm9, %zmm27
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 1360(%rdi), %xmm1
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm24
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, 1088(%rdi), %ymm0, %ymm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 1024(%rdi), %ymm13
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm13[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,11]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm18, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 576(%rdi), %ymm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3,4,5],ymm1[6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm10, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm0, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm8, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3,4,5],ymm1[6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm0, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm23, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, 1536(%rdi), %ymm0, %ymm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 1472(%rdi), %ymm9
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm9[0,1,2,3,4,5],ymm1[6,7]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm7, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm26, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm26 = <9,0,7,u>
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm23
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm10, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm10, %zmm26, %zmm23
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [5,12]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm0, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} xmm1 = [6,13]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm1, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm26, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm0, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm12
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm26, %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm7, %zmm2, %zmm26
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm7, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm1, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm1, %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 1088(%rdi), %ymm1
; AVX512BW-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm1 = ymm13[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm13[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm10[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm20, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    movb $-32, %al
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm14 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm17 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm29 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm15 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm25, %zmm30 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 960(%rdi), %ymm2
; AVX512BW-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm2 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm2, %zmm22, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, %zmm2 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 512(%rdi), %ymm4
; AVX512BW-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm4 = mem[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm4, %zmm19, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 64(%rdi), %ymm10
; AVX512BW-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm10 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm10, %zmm21, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm10 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 1408(%rdi), %ymm13
; AVX512BW-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $0, %xmm13, %zmm16, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm13 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 640(%rdi), %ymm16
; AVX512BW-ONLY-FAST-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm16, %ymm1 # 32-byte Folded Reload
; AVX512BW-ONLY-FAST-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm16[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm16[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm8, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 192(%rdi), %ymm8
; AVX512BW-ONLY-FAST-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512BW-ONLY-FAST-NEXT:    # ymm8 = mem[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm6, %zmm8, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 1536(%rdi), %ymm8
; AVX512BW-ONLY-FAST-NEXT:    vpalignr {{.*#+}} ymm8 = ymm9[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm8, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512BW-ONLY-FAST-NEXT:    # ymm8 = ymm8[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vinsertf64x4 $0, %ymm8, %zmm9, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm9 # 32-byte Folded Reload
; AVX512BW-ONLY-FAST-NEXT:    # ymm9 = ymm12[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm9, %zmm12, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vpblendd $240, (%rsp), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX512BW-ONLY-FAST-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm7, %zmm12, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512BW-ONLY-FAST-NEXT:    # ymm11 = ymm11[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm11, %zmm12, %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm15, 192(%rsi)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, 128(%rsi)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, 64(%rsi)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm26, 192(%rdx)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, (%rdx)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, 64(%rdx)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, 128(%rdx)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm24, 192(%rcx)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm27, (%rcx)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, 64(%rcx)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, 128(%rcx)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, 192(%r8)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, 128(%r8)
; AVX512BW-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovaps %zmm2, 192(%r9)
; AVX512BW-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovaps %zmm2, (%r9)
; AVX512BW-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovaps %zmm2, 64(%r9)
; AVX512BW-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovaps %zmm2, 128(%r9)
; AVX512BW-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, 128(%rax)
; AVX512BW-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, 128(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, 192(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, (%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovaps %zmm8, 64(%rax)
; AVX512BW-ONLY-FAST-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512BW-ONLY-FAST-NEXT:    vzeroupper
; AVX512BW-ONLY-FAST-NEXT:    retq
;
; AVX512DQBW-SLOW-LABEL: load_i64_stride7_vf32:
; AVX512DQBW-SLOW:       # %bb.0:
; AVX512DQBW-SLOW-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1664(%rdi), %zmm15
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1600(%rdi), %zmm31
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1216(%rdi), %zmm3
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1152(%rdi), %zmm2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1088(%rdi), %zmm30
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1024(%rdi), %zmm4
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 768(%rdi), %zmm21
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 704(%rdi), %zmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 640(%rdi), %zmm12
; AVX512DQBW-SLOW-NEXT:    vmovaps 576(%rdi), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovups %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 320(%rdi), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 256(%rdi), %zmm9
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [10,3,10,3,10,3,10,3]
; AVX512DQBW-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm6, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm15, %zmm31, %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [11,4,11,4,11,4,11,4]
; AVX512DQBW-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm8
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [13,6,13,6,13,6,13,6]
; AVX512DQBW-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm7
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm8, %zmm7
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm17
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm8, %zmm17
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [12,5,12,5,12,5,12,5]
; AVX512DQBW-SLOW-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm19, %zmm13
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm24
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm19, %zmm16
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm6, %zmm13
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm27
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm13
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm28
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,7,14,0,0,7,14,0]
; AVX512DQBW-SLOW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm26, %zmm13
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm23
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm26, %zmm23
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [9,0,7,0,9,0,7,0]
; AVX512DQBW-SLOW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm13
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm11, %zmm29, %zmm13
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm22
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [2,9,2,9,2,9,2,9]
; AVX512DQBW-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm1, %zmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm9, %zmm29, %zmm10
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm9
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm30, %zmm6, %zmm4
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm12, %zmm6, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm7
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm7, %zmm6, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm4
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm21
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm15, %zmm31, %zmm21
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1536(%rdi), %zmm13
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1472(%rdi), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm13, %zmm6, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm19, %zmm25
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm15, %zmm31, %zmm19
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm31
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm31
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm15, %zmm4, %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm8
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm15, %zmm4, %zmm26
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm20
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm4, %zmm15, %zmm29
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm15, %zmm1, %zmm4
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 384(%rdi), %zmm1
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,9,0,5,6,9]
; AVX512DQBW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 832(%rdi), %zmm4
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1280(%rdi), %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1728(%rdi), %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,10,0,5,6,10]
; AVX512DQBW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm17
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm21
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,11,0,5,6,11]
; AVX512DQBW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm25
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm24
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm16
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm19
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,12,0,5,6,12]
; AVX512DQBW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm31
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm27
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm28
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm8
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,13,4,5,6,13]
; AVX512DQBW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm18
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm8
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm23
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm26
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,14,4,5,6,14]
; AVX512DQBW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm20
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm22
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm10
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm29
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm29, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,8,15,4,5,8,15]
; AVX512DQBW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm9
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm15
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm3, %zmm2
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    movb $24, %al
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 512(%rdi), %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 448(%rdi), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa {{.*#+}} ymm15 = <0,7,14,u>
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm15, %zmm17
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k1} = zmm14[0,1,4,5],zmm12[4,5,0,1]
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [14,0,0,7,14,0,0,7]
; AVX512DQBW-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm28
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm12, %zmm0, %zmm28
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [7,0,9,0,7,0,9,0]
; AVX512DQBW-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm19
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm14, %zmm16, %zmm19
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x2 {{.*#+}} ymm24 = [4,11,4,11]
; AVX512DQBW-SLOW-NEXT:    # ymm24 = mem[0,1,0,1]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm12, %zmm24, %zmm14
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm3
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm14
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm15, %zmm14
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm1[0,1,4,5],zmm7[4,5,0,1]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm7, %zmm0, %zmm9
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm21
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm16, %zmm21
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm7, %zmm24, %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 960(%rdi), %zmm4
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 896(%rdi), %zmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm29
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1408(%rdi), %zmm2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 1344(%rdi), %zmm7
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm2, %zmm7, %zmm15
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 (%rsp), %zmm6 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm15 {%k1} = zmm6[0,1,4,5],zmm13[4,5,0,1]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm1
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm30, %zmm0, %zmm1
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm13, %zmm6, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm10, %zmm16, %zmm22
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm6, %zmm13, %zmm16
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm13, %zmm24, %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k1} = zmm10[0,1,4,5],zmm30[4,5,0,1]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm30, %zmm24, %zmm10
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa 912(%rdi), %xmm13
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $0, %xmm13, %zmm1, %zmm30
; AVX512DQBW-SLOW-NEXT:    vmovdqa 464(%rdi), %xmm1
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm28, %zmm28
; AVX512DQBW-SLOW-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm9, %zmm27
; AVX512DQBW-SLOW-NEXT:    vmovdqa 1360(%rdi), %xmm1
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm24
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, 1088(%rdi), %ymm0, %ymm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa 1024(%rdi), %ymm13
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm13[0,1,2,3,4,5],ymm0[6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,11]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm6
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm6
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm18, %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa 576(%rdi), %ymm6
; AVX512DQBW-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3,4,5],ymm1[6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm6
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm0, %zmm6
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm8, %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512DQBW-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3,4,5],ymm1[6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm8
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm8
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm23, %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, 1536(%rdi), %ymm0, %ymm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa 1472(%rdi), %ymm9
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm9[0,1,2,3,4,5],ymm1[6,7]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm2, %zmm7, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm26, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} ymm26 = <9,0,7,u>
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm23
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm6
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm10, %zmm26, %zmm23
; AVX512DQBW-SLOW-NEXT:    vmovdqa {{.*#+}} xmm0 = [5,12]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm0, %zmm8
; AVX512DQBW-SLOW-NEXT:    vmovdqa {{.*#+}} xmm1 = [6,13]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm1, %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm12, %zmm26, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm6
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm6
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm12
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm11, %zmm26, %zmm3
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm7, %zmm2, %zmm26
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm10
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm10
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm2, %zmm7, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm7
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqa 1088(%rdi), %ymm1
; AVX512DQBW-SLOW-NEXT:    vpalignr {{.*#+}} ymm1 = ymm13[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm13[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm10[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm20, %zmm18
; AVX512DQBW-SLOW-NEXT:    movb $-32, %al
; AVX512DQBW-SLOW-NEXT:    kmovd %eax, %k2
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm14 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm17 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm29 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm15 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm30 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqa 960(%rdi), %ymm2
; AVX512DQBW-SLOW-NEXT:    vpalignr {{.*#+}} ymm2 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $0, %xmm2, %zmm22, %zmm2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm2 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqa 512(%rdi), %ymm4
; AVX512DQBW-SLOW-NEXT:    vpalignr {{.*#+}} ymm4 = mem[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $0, %xmm4, %zmm19, %zmm4
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqa 64(%rdi), %ymm10
; AVX512DQBW-SLOW-NEXT:    vpalignr {{.*#+}} ymm10 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $0, %xmm10, %zmm21, %zmm10
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm10 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqa 1408(%rdi), %ymm13
; AVX512DQBW-SLOW-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512DQBW-SLOW-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512DQBW-SLOW-NEXT:    vinserti32x4 $0, %xmm13, %zmm16, %zmm13
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm13 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 640(%rdi), %ymm16
; AVX512DQBW-SLOW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm16, %ymm1 # 32-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm16[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm16[16,17,18,19,20,21,22,23]
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm8, %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa 192(%rdi), %ymm8
; AVX512DQBW-SLOW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # ymm8 = mem[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm8, %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqa 1536(%rdi), %ymm8
; AVX512DQBW-SLOW-NEXT:    vpalignr {{.*#+}} ymm8 = ymm9[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm8, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # ymm8 = ymm8[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vinsertf64x4 $0, %ymm8, %zmm9, %zmm8
; AVX512DQBW-SLOW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm9 # 32-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # ymm9 = ymm12[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm9, %zmm12, %zmm9
; AVX512DQBW-SLOW-NEXT:    vpblendd $240, (%rsp), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm7, %zmm12, %zmm7
; AVX512DQBW-SLOW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # ymm11 = ymm11[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm11, %zmm12, %zmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm15, 192(%rsi)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm29, 128(%rsi)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm17, 64(%rsi)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm26, 192(%rdx)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm5, (%rdx)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm23, 64(%rdx)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm3, 128(%rdx)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm24, 192(%rcx)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm27, (%rcx)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm28, 64(%rcx)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm30, 128(%rcx)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, 192(%r8)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, 128(%r8)
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovaps %zmm2, 192(%r9)
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovaps %zmm2, (%r9)
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovaps %zmm2, 64(%r9)
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovaps %zmm2, 128(%r9)
; AVX512DQBW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm18, 128(%rax)
; AVX512DQBW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, 128(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm7, 192(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, (%rax)
; AVX512DQBW-SLOW-NEXT:    vmovaps %zmm8, 64(%rax)
; AVX512DQBW-SLOW-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512DQBW-SLOW-NEXT:    vzeroupper
; AVX512DQBW-SLOW-NEXT:    retq
;
; AVX512DQBW-FAST-LABEL: load_i64_stride7_vf32:
; AVX512DQBW-FAST:       # %bb.0:
; AVX512DQBW-FAST-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1664(%rdi), %zmm15
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1600(%rdi), %zmm31
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1216(%rdi), %zmm3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1152(%rdi), %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1088(%rdi), %zmm30
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1024(%rdi), %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 768(%rdi), %zmm21
; AVX512DQBW-FAST-NEXT:    vmovdqa64 704(%rdi), %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqa64 640(%rdi), %zmm12
; AVX512DQBW-FAST-NEXT:    vmovaps 576(%rdi), %zmm0
; AVX512DQBW-FAST-NEXT:    vmovups %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 320(%rdi), %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 256(%rdi), %zmm9
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [10,3,10,3,10,3,10,3]
; AVX512DQBW-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm9, %zmm5
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm6, %zmm5
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm5
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm21, %zmm6, %zmm5
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm15, %zmm31, %zmm6
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [11,4,11,4,11,4,11,4]
; AVX512DQBW-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm7
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm6, %zmm7
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm8
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [13,6,13,6,13,6,13,6]
; AVX512DQBW-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm7
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm21, %zmm8, %zmm7
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm9, %zmm17
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm8, %zmm17
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [12,5,12,5,12,5,12,5]
; AVX512DQBW-FAST-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm21, %zmm19, %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm13, %zmm24
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm9, %zmm16
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm19, %zmm16
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm21, %zmm6, %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm13, %zmm27
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm6, %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm13, %zmm28
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,7,14,0,0,7,14,0]
; AVX512DQBW-FAST-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm21, %zmm26, %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm9, %zmm23
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm26, %zmm23
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [9,0,7,0,9,0,7,0]
; AVX512DQBW-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm21, %zmm13
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm11, %zmm29, %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm13, %zmm22
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [2,9,2,9,2,9,2,9]
; AVX512DQBW-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm21, %zmm1, %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm9, %zmm29, %zmm10
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm1, %zmm9
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm30, %zmm6, %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm12, %zmm6, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm7
; AVX512DQBW-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm7, %zmm6, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm31, %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm21
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm15, %zmm31, %zmm21
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1536(%rdi), %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1472(%rdi), %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm13, %zmm6, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm25
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm19, %zmm25
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm15, %zmm31, %zmm19
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm31
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm6, %zmm31
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm15, %zmm4, %zmm6
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm8
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm15, %zmm4, %zmm26
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm20
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm2, %zmm29, %zmm20
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm4, %zmm15, %zmm29
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm15, %zmm1, %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm15
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 384(%rdi), %zmm1
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,9,0,5,6,9]
; AVX512DQBW-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 832(%rdi), %zmm4
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm5
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1280(%rdi), %zmm5
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1728(%rdi), %zmm6
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,10,0,5,6,10]
; AVX512DQBW-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm17
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm21
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,11,0,5,6,11]
; AVX512DQBW-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm25
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm24
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm16
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm19
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,5,6,12,0,5,6,12]
; AVX512DQBW-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm31
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm27
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm28
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm8
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,13,4,5,6,13]
; AVX512DQBW-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm18
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm8
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm23
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm26
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,6,14,4,5,6,14]
; AVX512DQBW-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm20
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm22
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm10
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm29
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm29, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [4,5,8,15,4,5,8,15]
; AVX512DQBW-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm3, %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm9
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm6, %zmm3, %zmm15
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm3, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    movb $24, %al
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 512(%rdi), %zmm5
; AVX512DQBW-FAST-NEXT:    vmovdqa64 448(%rdi), %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm15 = <0,7,14,u>
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm15, %zmm17
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k1} = zmm14[0,1,4,5],zmm12[4,5,0,1]
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [14,0,0,7,14,0,0,7]
; AVX512DQBW-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm14, %zmm28
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm12, %zmm0, %zmm28
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [7,0,9,0,7,0,9,0]
; AVX512DQBW-FAST-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm19
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm14, %zmm16, %zmm19
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x2 {{.*#+}} ymm24 = [4,11,4,11]
; AVX512DQBW-FAST-NEXT:    # ymm24 = mem[0,1,0,1]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm12, %zmm24, %zmm14
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm14
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm15, %zmm14
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm1[0,1,4,5],zmm7[4,5,0,1]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm7, %zmm0, %zmm9
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm21
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm16, %zmm21
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm7, %zmm24, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 960(%rdi), %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqa64 896(%rdi), %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm29
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm15, %zmm29
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1408(%rdi), %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 1344(%rdi), %zmm7
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm2, %zmm7, %zmm15
; AVX512DQBW-FAST-NEXT:    vmovdqu64 (%rsp), %zmm6 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm15 {%k1} = zmm6[0,1,4,5],zmm13[4,5,0,1]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm1
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm30, %zmm0, %zmm1
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm13, %zmm6, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm30, %zmm22
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm10, %zmm16, %zmm22
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm6, %zmm13, %zmm16
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm13, %zmm24, %zmm6
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm6, (%rsp) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k1} = zmm10[0,1,4,5],zmm30[4,5,0,1]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm30, %zmm24, %zmm10
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa 912(%rdi), %xmm13
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $0, %xmm13, %zmm1, %zmm30
; AVX512DQBW-FAST-NEXT:    vmovdqa 464(%rdi), %xmm1
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm28, %zmm28
; AVX512DQBW-FAST-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm9, %zmm27
; AVX512DQBW-FAST-NEXT:    vmovdqa 1360(%rdi), %xmm1
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm24
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, 1088(%rdi), %ymm0, %ymm0
; AVX512DQBW-FAST-NEXT:    vmovdqa 1024(%rdi), %ymm13
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm13[0,1,2,3,4,5],ymm0[6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [4,11]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm6
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm6
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm18, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm1
; AVX512DQBW-FAST-NEXT:    vmovdqa 576(%rdi), %ymm6
; AVX512DQBW-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3,4,5],ymm1[6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm6
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm0, %zmm6
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm8, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm1
; AVX512DQBW-FAST-NEXT:    vmovdqa 128(%rdi), %ymm6
; AVX512DQBW-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3,4,5],ymm1[6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm8
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm0, %zmm8
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm23, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, 1536(%rdi), %ymm0, %ymm1
; AVX512DQBW-FAST-NEXT:    vmovdqa 1472(%rdi), %ymm9
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm9[0,1,2,3,4,5],ymm1[6,7]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm2, %zmm7, %zmm0
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm26, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm26 = <9,0,7,u>
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm23
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm6
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm10, %zmm26, %zmm23
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} xmm0 = [5,12]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm8
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm0, %zmm8
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} xmm1 = [6,13]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm1, %zmm6
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm12, %zmm26, %zmm5
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm6
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm0, %zmm6
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm12
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm11, %zmm26, %zmm3
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm7, %zmm2, %zmm26
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm10
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm10
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm2, %zmm7, %zmm0
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm2, %zmm1, %zmm7
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm1, %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqa 1088(%rdi), %ymm1
; AVX512DQBW-FAST-NEXT:    vpalignr {{.*#+}} ymm1 = ymm13[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm13[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm10[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm20, %zmm18
; AVX512DQBW-FAST-NEXT:    movb $-32, %al
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm14 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm17 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm29 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm15 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm25, %zmm30 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqa 960(%rdi), %ymm2
; AVX512DQBW-FAST-NEXT:    vpalignr {{.*#+}} ymm2 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $0, %xmm2, %zmm22, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm31, %zmm2 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqa 512(%rdi), %ymm4
; AVX512DQBW-FAST-NEXT:    vpalignr {{.*#+}} ymm4 = mem[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $0, %xmm4, %zmm19, %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqa 64(%rdi), %ymm10
; AVX512DQBW-FAST-NEXT:    vpalignr {{.*#+}} ymm10 = mem[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $0, %xmm10, %zmm21, %zmm10
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm10 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqa 1408(%rdi), %ymm13
; AVX512DQBW-FAST-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX512DQBW-FAST-NEXT:    vextracti128 $1, %ymm13, %xmm13
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $0, %xmm13, %zmm16, %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm13 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 640(%rdi), %ymm16
; AVX512DQBW-FAST-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm16, %ymm1 # 32-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm16[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm16[16,17,18,19,20,21,22,23]
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = ymm8[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm8, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqa 192(%rdi), %ymm8
; AVX512DQBW-FAST-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    # ymm8 = mem[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm6, %zmm8, %zmm6
; AVX512DQBW-FAST-NEXT:    vmovdqa 1536(%rdi), %ymm8
; AVX512DQBW-FAST-NEXT:    vpalignr {{.*#+}} ymm8 = ymm9[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm8, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    # ymm8 = ymm8[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vinsertf64x4 $0, %ymm8, %zmm9, %zmm8
; AVX512DQBW-FAST-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm9 # 32-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    # ymm9 = ymm12[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm9, %zmm12, %zmm9
; AVX512DQBW-FAST-NEXT:    vpblendd $240, (%rsp), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    # ymm7 = ymm7[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm7, %zmm12, %zmm7
; AVX512DQBW-FAST-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11, %ymm11 # 32-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    # ymm11 = ymm11[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm11, %zmm12, %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm15, 192(%rsi)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm29, 128(%rsi)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm17, 64(%rsi)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm14, (%rsi)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm26, 192(%rdx)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, (%rdx)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm23, 64(%rdx)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm3, 128(%rdx)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm24, 192(%rcx)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm27, (%rcx)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm28, 64(%rcx)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm30, 128(%rcx)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm13, 192(%r8)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, (%r8)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, 64(%r8)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, 128(%r8)
; AVX512DQBW-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovaps %zmm2, 192(%r9)
; AVX512DQBW-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovaps %zmm2, (%r9)
; AVX512DQBW-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovaps %zmm2, 64(%r9)
; AVX512DQBW-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovaps %zmm2, 128(%r9)
; AVX512DQBW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, 192(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, 64(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm18, 128(%rax)
; AVX512DQBW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, 128(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm7, 192(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm9, (%rax)
; AVX512DQBW-FAST-NEXT:    vmovaps %zmm8, 64(%rax)
; AVX512DQBW-FAST-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512DQBW-FAST-NEXT:    vzeroupper
; AVX512DQBW-FAST-NEXT:    retq
  %wide.vec = load <224 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <224 x i64> %wide.vec, <224 x i64> poison, <32 x i32> <i32 0, i32 7, i32 14, i32 21, i32 28, i32 35, i32 42, i32 49, i32 56, i32 63, i32 70, i32 77, i32 84, i32 91, i32 98, i32 105, i32 112, i32 119, i32 126, i32 133, i32 140, i32 147, i32 154, i32 161, i32 168, i32 175, i32 182, i32 189, i32 196, i32 203, i32 210, i32 217>
  %strided.vec1 = shufflevector <224 x i64> %wide.vec, <224 x i64> poison, <32 x i32> <i32 1, i32 8, i32 15, i32 22, i32 29, i32 36, i32 43, i32 50, i32 57, i32 64, i32 71, i32 78, i32 85, i32 92, i32 99, i32 106, i32 113, i32 120, i32 127, i32 134, i32 141, i32 148, i32 155, i32 162, i32 169, i32 176, i32 183, i32 190, i32 197, i32 204, i32 211, i32 218>
  %strided.vec2 = shufflevector <224 x i64> %wide.vec, <224 x i64> poison, <32 x i32> <i32 2, i32 9, i32 16, i32 23, i32 30, i32 37, i32 44, i32 51, i32 58, i32 65, i32 72, i32 79, i32 86, i32 93, i32 100, i32 107, i32 114, i32 121, i32 128, i32 135, i32 142, i32 149, i32 156, i32 163, i32 170, i32 177, i32 184, i32 191, i32 198, i32 205, i32 212, i32 219>
  %strided.vec3 = shufflevector <224 x i64> %wide.vec, <224 x i64> poison, <32 x i32> <i32 3, i32 10, i32 17, i32 24, i32 31, i32 38, i32 45, i32 52, i32 59, i32 66, i32 73, i32 80, i32 87, i32 94, i32 101, i32 108, i32 115, i32 122, i32 129, i32 136, i32 143, i32 150, i32 157, i32 164, i32 171, i32 178, i32 185, i32 192, i32 199, i32 206, i32 213, i32 220>
  %strided.vec4 = shufflevector <224 x i64> %wide.vec, <224 x i64> poison, <32 x i32> <i32 4, i32 11, i32 18, i32 25, i32 32, i32 39, i32 46, i32 53, i32 60, i32 67, i32 74, i32 81, i32 88, i32 95, i32 102, i32 109, i32 116, i32 123, i32 130, i32 137, i32 144, i32 151, i32 158, i32 165, i32 172, i32 179, i32 186, i32 193, i32 200, i32 207, i32 214, i32 221>
  %strided.vec5 = shufflevector <224 x i64> %wide.vec, <224 x i64> poison, <32 x i32> <i32 5, i32 12, i32 19, i32 26, i32 33, i32 40, i32 47, i32 54, i32 61, i32 68, i32 75, i32 82, i32 89, i32 96, i32 103, i32 110, i32 117, i32 124, i32 131, i32 138, i32 145, i32 152, i32 159, i32 166, i32 173, i32 180, i32 187, i32 194, i32 201, i32 208, i32 215, i32 222>
  %strided.vec6 = shufflevector <224 x i64> %wide.vec, <224 x i64> poison, <32 x i32> <i32 6, i32 13, i32 20, i32 27, i32 34, i32 41, i32 48, i32 55, i32 62, i32 69, i32 76, i32 83, i32 90, i32 97, i32 104, i32 111, i32 118, i32 125, i32 132, i32 139, i32 146, i32 153, i32 160, i32 167, i32 174, i32 181, i32 188, i32 195, i32 202, i32 209, i32 216, i32 223>
  store <32 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <32 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <32 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <32 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <32 x i64> %strided.vec4, ptr %out.vec4, align 64
  store <32 x i64> %strided.vec5, ptr %out.vec5, align 64
  store <32 x i64> %strided.vec6, ptr %out.vec6, align 64
  ret void
}

define void @load_i64_stride7_vf64(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2, ptr %out.vec3, ptr %out.vec4, ptr %out.vec5, ptr %out.vec6) nounwind {
; SSE-LABEL: load_i64_stride7_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $3240, %rsp # imm = 0xCA8
; SSE-NEXT:    movapd 208(%rdi), %xmm0
; SSE-NEXT:    movapd 96(%rdi), %xmm1
; SSE-NEXT:    movapd 144(%rdi), %xmm2
; SSE-NEXT:    movapd 192(%rdi), %xmm3
; SSE-NEXT:    movapd 80(%rdi), %xmm4
; SSE-NEXT:    movapd 128(%rdi), %xmm5
; SSE-NEXT:    movapd 176(%rdi), %xmm8
; SSE-NEXT:    movapd 64(%rdi), %xmm9
; SSE-NEXT:    movapd (%rdi), %xmm10
; SSE-NEXT:    movapd 16(%rdi), %xmm7
; SSE-NEXT:    movapd 32(%rdi), %xmm6
; SSE-NEXT:    movapd 48(%rdi), %xmm14
; SSE-NEXT:    movapd 224(%rdi), %xmm11
; SSE-NEXT:    movapd 112(%rdi), %xmm12
; SSE-NEXT:    movapd 160(%rdi), %xmm15
; SSE-NEXT:    movapd %xmm14, %xmm13
; SSE-NEXT:    movsd {{.*#+}} xmm13 = xmm10[0],xmm13[1]
; SSE-NEXT:    movapd %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm10 = xmm10[1],xmm9[0]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm9 = xmm7[0],xmm9[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm7 = xmm7[1],xmm4[0]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm6[0],xmm4[1]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm6 = xmm6[1],xmm1[0]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm14[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm15, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm12[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm12 = xmm12[1],xmm8[0]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm5[0],xmm8[1]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm3[0]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm2[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm0[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm15[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm11[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm11 = xmm11[1],xmm1[0]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rdi), %xmm2
; SSE-NEXT:    movapd 384(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 432(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%rdi), %xmm2
; SSE-NEXT:    movapd 496(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 512(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 464(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 528(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 480(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 544(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 560(%rdi), %xmm2
; SSE-NEXT:    movapd 608(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 624(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 576(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 640(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 592(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 656(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 672(%rdi), %xmm2
; SSE-NEXT:    movapd 720(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 736(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 688(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 752(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 704(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 768(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 784(%rdi), %xmm2
; SSE-NEXT:    movapd 832(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 848(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 800(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 864(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 816(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 880(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 896(%rdi), %xmm2
; SSE-NEXT:    movapd 944(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 960(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 912(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 976(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 928(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 992(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1008(%rdi), %xmm2
; SSE-NEXT:    movapd 1056(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1072(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1024(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1088(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1040(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1104(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1120(%rdi), %xmm2
; SSE-NEXT:    movapd 1168(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1184(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1136(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1200(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1152(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1216(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1232(%rdi), %xmm2
; SSE-NEXT:    movapd 1280(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1296(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1248(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1312(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1264(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1328(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1344(%rdi), %xmm2
; SSE-NEXT:    movapd 1392(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1408(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1360(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1424(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1376(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1440(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1456(%rdi), %xmm2
; SSE-NEXT:    movapd 1504(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1520(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1472(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1536(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1488(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1552(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1568(%rdi), %xmm2
; SSE-NEXT:    movapd 1616(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1632(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1584(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1648(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1600(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1664(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1680(%rdi), %xmm2
; SSE-NEXT:    movapd 1728(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1744(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1696(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1760(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1712(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1776(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1792(%rdi), %xmm2
; SSE-NEXT:    movapd 1840(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1856(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1808(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1872(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1824(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1888(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1904(%rdi), %xmm2
; SSE-NEXT:    movapd 1952(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1968(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1920(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1984(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 1936(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2000(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2016(%rdi), %xmm2
; SSE-NEXT:    movapd 2064(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2080(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2032(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2096(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2048(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2112(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2128(%rdi), %xmm2
; SSE-NEXT:    movapd 2176(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2192(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2144(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2208(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2160(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2224(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2240(%rdi), %xmm2
; SSE-NEXT:    movapd 2288(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2304(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2256(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2320(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2272(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2336(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2352(%rdi), %xmm2
; SSE-NEXT:    movapd 2400(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2416(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2368(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2432(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2384(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2448(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2464(%rdi), %xmm2
; SSE-NEXT:    movapd 2512(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2528(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2480(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2544(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2496(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2560(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2576(%rdi), %xmm2
; SSE-NEXT:    movapd 2624(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2640(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2592(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2656(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2608(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2672(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2688(%rdi), %xmm2
; SSE-NEXT:    movapd 2736(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2752(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2704(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2768(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2720(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2784(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2800(%rdi), %xmm2
; SSE-NEXT:    movapd 2848(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2864(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, (%rsp) # 16-byte Spill
; SSE-NEXT:    movapd 2816(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2880(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2832(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2896(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2912(%rdi), %xmm2
; SSE-NEXT:    movapd 2960(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2976(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2928(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2992(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 2944(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3008(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3024(%rdi), %xmm1
; SSE-NEXT:    movapd 3072(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm15
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm1[0],xmm15[1]
; SSE-NEXT:    movapd 3088(%rdi), %xmm3
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm3[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3040(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm2[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3104(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3056(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3120(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3136(%rdi), %xmm12
; SSE-NEXT:    movapd 3184(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm10
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm12[0],xmm10[1]
; SSE-NEXT:    movapd 3200(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm12 = xmm12[1],xmm1[0]
; SSE-NEXT:    movapd 3152(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3216(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3168(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3232(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3248(%rdi), %xmm9
; SSE-NEXT:    movapd 3296(%rdi), %xmm0
; SSE-NEXT:    movapd %xmm0, %xmm6
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm9[0],xmm6[1]
; SSE-NEXT:    movapd 3312(%rdi), %xmm14
; SSE-NEXT:    shufpd {{.*#+}} xmm9 = xmm9[1],xmm14[0]
; SSE-NEXT:    movapd 3264(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm14 = xmm2[0],xmm14[1]
; SSE-NEXT:    movapd 3328(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3280(%rdi), %xmm2
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3344(%rdi), %xmm1
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm1[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3360(%rdi), %xmm5
; SSE-NEXT:    movapd 3408(%rdi), %xmm2
; SSE-NEXT:    movapd %xmm2, %xmm7
; SSE-NEXT:    movsd {{.*#+}} xmm7 = xmm5[0],xmm7[1]
; SSE-NEXT:    movapd 3424(%rdi), %xmm11
; SSE-NEXT:    shufpd {{.*#+}} xmm5 = xmm5[1],xmm11[0]
; SSE-NEXT:    movapd 3376(%rdi), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm11 = xmm0[0],xmm11[1]
; SSE-NEXT:    movapd 3440(%rdi), %xmm3
; SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1],xmm3[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3392(%rdi), %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm1[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3456(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm1 = xmm1[1],xmm0[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm2[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 3472(%rdi), %xmm2
; SSE-NEXT:    movapd 3520(%rdi), %xmm4
; SSE-NEXT:    movapd %xmm4, %xmm1
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE-NEXT:    movapd 3536(%rdi), %xmm8
; SSE-NEXT:    shufpd {{.*#+}} xmm2 = xmm2[1],xmm8[0]
; SSE-NEXT:    movapd 3488(%rdi), %xmm13
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm13[0],xmm8[1]
; SSE-NEXT:    movapd 3552(%rdi), %xmm0
; SSE-NEXT:    shufpd {{.*#+}} xmm13 = xmm13[1],xmm0[0]
; SSE-NEXT:    movapd 3504(%rdi), %xmm3
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm3[0],xmm0[1]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm3, %xmm0
; SSE-NEXT:    movapd 3568(%rdi), %xmm3
; SSE-NEXT:    shufpd {{.*#+}} xmm0 = xmm0[1],xmm3[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm4[0],xmm3[1]
; SSE-NEXT:    movapd %xmm1, 496(%rsi)
; SSE-NEXT:    movapd %xmm7, 480(%rsi)
; SSE-NEXT:    movapd %xmm6, 464(%rsi)
; SSE-NEXT:    movapd %xmm10, 448(%rsi)
; SSE-NEXT:    movapd %xmm15, 432(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 352(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 336(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 320(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 304(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 288(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 272(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 256(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 240(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 224(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 208(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 192(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 176(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 160(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 144(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 128(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 112(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 96(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 80(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 64(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 48(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 32(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rsi)
; SSE-NEXT:    movapd %xmm2, 496(%rdx)
; SSE-NEXT:    movapd %xmm5, 480(%rdx)
; SSE-NEXT:    movapd %xmm9, 464(%rdx)
; SSE-NEXT:    movapd %xmm12, 448(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rdx)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movapd %xmm8, 496(%rcx)
; SSE-NEXT:    movapd %xmm11, 480(%rcx)
; SSE-NEXT:    movapd %xmm14, 464(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rcx)
; SSE-NEXT:    movapd %xmm13, 496(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r8)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%r9)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%r9)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm3, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $3240, %rsp # imm = 0xCA8
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: load_i64_stride7_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $4264, %rsp # imm = 0x10A8
; AVX1-ONLY-NEXT:    vmovapd 1216(%rdi), %ymm10
; AVX1-ONLY-NEXT:    vmovaps 768(%rdi), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 320(%rdi), %ymm13
; AVX1-ONLY-NEXT:    vinsertf128 $1, 384(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm13[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 272(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm5[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 832(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 672(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vmovaps 720(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm14[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 1280(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm10[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 1120(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1168(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1664(%rdi), %ymm15
; AVX1-ONLY-NEXT:    vinsertf128 $1, 1728(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm15[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 1568(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1616(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 2112(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 2176(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 2016(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 2064(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 2560(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 2624(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 2464(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 2512(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 3008(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 3072(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 2912(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 2960(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 3456(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 3520(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 3360(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 3408(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = mem[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 544(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 608(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 448(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 496(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 992(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 1056(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 896(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 944(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 1440(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 1504(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 1344(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 1392(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 1888(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 1952(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 1792(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vmovaps 1840(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm11[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 2336(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, 2400(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 2240(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 2288(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm7[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 2784(%rdi), %ymm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, 2848(%rdi), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm6[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 2688(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vmovapd 2736(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm2 = xmm12[0],xmm2[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 3232(%rdi), %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, 3296(%rdi), %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm3[0,1,2],ymm1[3]
; AVX1-ONLY-NEXT:    vmovapd 3136(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovapd 3184(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm4 = xmm2[0],xmm4[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm4[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 288(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm5[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 384(%rdi), %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm4 = ymm13[0],ymm5[0],ymm13[3],ymm5[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 736(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm4 = xmm14[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 832(%rdi), %ymm9
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm8 = ymm8[0],ymm9[0],ymm8[3],ymm9[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0,1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1184(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm8 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm8 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 1280(%rdi), %ymm4
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm10 = ymm10[0],ymm4[0],ymm10[3],ymm4[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm8[0,1],ymm10[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1632(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm10 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm10 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 1728(%rdi), %ymm8
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm13 = ymm15[0],ymm8[0],ymm15[3],ymm8[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm10 = ymm10[0,1],ymm13[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 2080(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm13 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm13 = mem[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 2176(%rdi), %ymm10
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm15 = ymm0[0],ymm10[0],ymm0[3],ymm10[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm13 = ymm13[0,1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 2528(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 2624(%rdi), %ymm13
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm0[0],ymm13[0],ymm0[3],ymm13[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 2976(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm14 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 3072(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm15 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 3424(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm14 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 3520(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm15 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 160(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm14[0],ymm0[0],ymm14[3],ymm0[2]
; AVX1-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm15 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 608(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm14[0],ymm0[0],ymm14[3],ymm0[2]
; AVX1-ONLY-NEXT:    vmovdqa 512(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1056(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX1-ONLY-NEXT:    vmovdqa 960(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1504(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX1-ONLY-NEXT:    vmovdqa 1408(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm15[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1952(%rdi), %ymm14
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm15 = ymm0[0],ymm14[0],ymm0[3],ymm14[2]
; AVX1-ONLY-NEXT:    vmovdqa 1856(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm11 = xmm11[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm11 = ymm11[0,1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 2400(%rdi), %ymm11
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm15 = ymm0[0],ymm11[0],ymm0[3],ymm11[2]
; AVX1-ONLY-NEXT:    vmovdqa 2304(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = xmm7[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm7[0,1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 2848(%rdi), %ymm15
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm7 = ymm6[0],ymm15[0],ymm6[3],ymm15[2]
; AVX1-ONLY-NEXT:    vmovdqa 2752(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm0 = xmm12[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 3296(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm7 = ymm3[0],ymm0[0],ymm3[3],ymm0[2]
; AVX1-ONLY-NEXT:    vmovdqa 3200(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm2 = xmm2[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1,2],ymm5[3]
; AVX1-ONLY-NEXT:    vmovapd 240(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm7 = xmm5[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm7[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 800(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1,2],ymm9[3]
; AVX1-ONLY-NEXT:    vmovapd 688(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm7 = xmm7[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm7[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 1248(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1,2],ymm4[3]
; AVX1-ONLY-NEXT:    vmovapd 1136(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm4 = xmm4[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 1696(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1,2],ymm8[3]
; AVX1-ONLY-NEXT:    vmovapd 1584(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm4 = xmm4[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 2144(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1,2],ymm10[3]
; AVX1-ONLY-NEXT:    vmovapd 2032(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm4 = xmm4[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 2592(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1,2],ymm13[3]
; AVX1-ONLY-NEXT:    vmovapd 2480(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm4 = xmm4[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 3040(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendps $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 2928(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 3488(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendps $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 3376(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 3264(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovdqa 3152(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 2816(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm15[3]
; AVX1-ONLY-NEXT:    vmovdqa 2704(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 2368(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm11[3]
; AVX1-ONLY-NEXT:    vmovdqa 2256(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vpblendw {{.*#+}} xmm3 = xmm15[0,1,2,3],xmm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1920(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm0[0,1,2],ymm14[3]
; AVX1-ONLY-NEXT:    vmovapd 1808(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm4 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm4 = xmm2[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1472(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendpd $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm6 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm6 = ymm4[0,1,2],mem[3]
; AVX1-ONLY-NEXT:    vmovapd 1360(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm4, %xmm7 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm7 = xmm4[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1024(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vblendpd $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm7 = ymm7[0,1,2],mem[3]
; AVX1-ONLY-NEXT:    vmovapd 912(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm10 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm10 = xmm9[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm10[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 576(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vblendpd $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm7 = ymm7[0,1,2],mem[3]
; AVX1-ONLY-NEXT:    vmovapd 464(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm12 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm12 = xmm11[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm12[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 128(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm12
; AVX1-ONLY-NEXT:    vblendpd $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm12 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm12 = ymm12[0,1,2],mem[3]
; AVX1-ONLY-NEXT:    vmovapd 16(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm14 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm14 = xmm13[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm12 = ymm14[0,1],ymm12[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 80(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm12 = ymm13[1],ymm14[0],ymm13[2],ymm14[2]
; AVX1-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vmovdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = xmm7[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm12[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 304(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[1],ymm12[0],ymm5[2],ymm12[2]
; AVX1-ONLY-NEXT:    vmovdqa 416(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm7 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 528(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm5 = ymm11[1],ymm13[0],ymm11[2],ymm13[2]
; AVX1-ONLY-NEXT:    vmovdqa 640(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = xmm10[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0,1],ymm7[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 752(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm0[1],ymm7[0],ymm0[2],ymm7[2]
; AVX1-ONLY-NEXT:    vmovdqa 864(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovdqa %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm5 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm5 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 976(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm9[1],ymm10[0],ymm9[2],ymm10[2]
; AVX1-ONLY-NEXT:    vmovdqa 1088(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm5 = xmm6[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1200(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],ymm6[0],ymm1[2],ymm6[2]
; AVX1-ONLY-NEXT:    vmovdqa 1312(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm5 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm5 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1424(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm4[1],ymm0[0],ymm4[2],ymm0[2]
; AVX1-ONLY-NEXT:    vmovdqa 1536(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm3 = xmm3[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1648(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[1],ymm4[0],ymm1[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovdqa 1760(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1872(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm2[1],ymm3[0],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovdqa 1984(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm8[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 2096(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 2208(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 2320(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm15[1],ymm0[0],ymm15[2],ymm0[2]
; AVX1-ONLY-NEXT:    vmovdqa 2432(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 2544(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm0[1],ymm15[0],ymm0[2],ymm15[2]
; AVX1-ONLY-NEXT:    vmovdqa 2656(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 2768(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 2880(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 2992(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 3104(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 3216(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 3328(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 3440(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 3552(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 128(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = mem[0],xmm14[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 352(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 256(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm14[0],xmm12[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovapd 576(%rdi), %ymm11
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm11[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 480(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm12[0],xmm13[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 800(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 704(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm13[0],xmm7[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovapd 1024(%rdi), %ymm7
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm7[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 928(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm9[0],xmm10[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 1248(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 1152(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm10[0],xmm6[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 1472(%rdi), %ymm6
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm6[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 1376(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 1696(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 1600(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm1[0],xmm4[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 1920(%rdi), %ymm4
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm4[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 1824(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm1[0],xmm3[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovaps 2144(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 2048(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 2368(%rdi), %ymm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 2272(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 2592(%rdi), %ymm8
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm8[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 2496(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm1 = xmm1[0],xmm15[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 2816(%rdi), %ymm15
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm15[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 2720(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovapd 3040(%rdi), %ymm5
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm5[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 2944(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendpd $2, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovaps 3264(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 3168(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    vmovaps 3488(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 3392(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps $12, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm0[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 192(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 416(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 320(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm14[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 544(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm0 = xmm12[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 640(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm11[0],ymm1[0],ymm11[3],ymm1[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 864(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 768(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm13[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 992(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm0 = xmm9[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 1088(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm7[0],ymm1[0],ymm7[3],ymm1[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1312(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 1216(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm10[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1440(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 1536(%rdi), %ymm13
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm6[0],ymm13[0],ymm6[3],ymm13[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 1760(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1-ONLY-NEXT:    vmovdqa 1664(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 1888(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 1984(%rdi), %ymm10
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm4[0],ymm10[0],ymm4[3],ymm10[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 2208(%rdi), %ymm12
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm12[0],ymm0[3],ymm12[2]
; AVX1-ONLY-NEXT:    vmovdqa 2112(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 2336(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 2432(%rdi), %ymm7
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm3[0],ymm7[0],ymm3[3],ymm7[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 2656(%rdi), %ymm9
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm8[0],ymm9[0],ymm8[3],ymm9[2]
; AVX1-ONLY-NEXT:    vmovdqa 2560(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 2784(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 2880(%rdi), %ymm4
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm15[0],ymm4[0],ymm15[3],ymm4[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 3104(%rdi), %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm5[0],ymm6[0],ymm5[3],ymm6[2]
; AVX1-ONLY-NEXT:    vmovdqa 3008(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovdqa 3232(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 3328(%rdi), %ymm3
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm0[0],ymm3[0],ymm0[3],ymm3[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 3552(%rdi), %ymm2
; AVX1-ONLY-NEXT:    vmovupd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[3],ymm2[2]
; AVX1-ONLY-NEXT:    vmovdqa 3456(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm15[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rsp), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = mem[0,1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2],ymm13[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm13 = xmm13[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm13[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vblendps $63, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm13 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm13 = mem[0,1,2,3],xmm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm13[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2],ymm10[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm10 = xmm10[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm13 = ymm10[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2],ymm12[3]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm10 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm10 = mem[0,1,2,3],xmm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm10 = ymm10[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2],ymm7[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm7 = xmm7[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm11 = ymm7[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2],ymm9[3]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm7 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm7 = mem[0,1,2,3],xmm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm7[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2],ymm4[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm4 = xmm4[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm7 = ymm4[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2],ymm6[3]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5, %xmm4 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm4 = mem[0,1,2,3],xmm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2],ymm3[3]
; AVX1-ONLY-NEXT:    vmovapd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} xmm3 = xmm3[0],mem[1]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vblendpd $7, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = mem[0,1,2],ymm2[3]
; AVX1-ONLY-NEXT:    vpblendw $15, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = mem[0,1,2,3],xmm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 448(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 384(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 320(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 256(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 192(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 128(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 64(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 480(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 416(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 352(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 288(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 224(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 160(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 96(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 448(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 384(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 320(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 256(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 192(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 128(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 480(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 416(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 352(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 288(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 224(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 160(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 96(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 192(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 256(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 320(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 384(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 448(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 480(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 416(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 352(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 288(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 224(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 160(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 480(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 448(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 416(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 384(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 352(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 320(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 288(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 256(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 224(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 192(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 160(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 128(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 96(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 64(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%r8)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 480(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 448(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 416(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 384(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 352(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 320(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 288(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 256(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 224(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 192(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 160(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 128(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 96(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 64(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%r9)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%r9)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 480(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 448(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 416(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 384(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 352(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 320(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 256(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 192(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 160(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 96(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 64(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rax)
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 480(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm3, 448(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm4, 416(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm7, 384(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm8, 352(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm11, 320(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm10, 288(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm13, 256(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm14, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm15, 160(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    addq $4264, %rsp # imm = 0x10A8
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: load_i64_stride7_vf64:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $3976, %rsp # imm = 0xF88
; AVX2-ONLY-NEXT:    vmovdqa 1216(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 768(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 320(%rdi), %ymm6
; AVX2-ONLY-NEXT:    vmovdqa 384(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 224(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vmovdqa 272(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm5[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 832(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 672(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vmovdqa 720(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm7[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1280(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1120(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vmovdqa 1168(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm8[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1664(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vmovdqa 1728(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm11[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1568(%rdi), %xmm13
; AVX2-ONLY-NEXT:    vmovdqa 1616(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm13[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2112(%rdi), %ymm12
; AVX2-ONLY-NEXT:    vmovdqa 2176(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm12[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2016(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2064(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 2560(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 2624(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 2464(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 2512(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 3008(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 3072(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 2912(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 2960(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 3456(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 3520(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 3360(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa 3408(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm0[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 48(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = mem[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 544(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 608(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 448(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 496(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm9[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 992(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1056(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 896(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 944(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm9[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1440(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1504(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1344(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1392(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm9[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1888(%rdi), %ymm14
; AVX2-ONLY-NEXT:    vmovdqa 1952(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm14[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1792(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1840(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2336(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa 2400(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2240(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vmovdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2288(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm9[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2784(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2848(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2688(%rdi), %xmm15
; AVX2-ONLY-NEXT:    vmovdqa 2736(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm15[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 3232(%rdi), %ymm10
; AVX2-ONLY-NEXT:    vmovdqa 3296(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm10[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 3136(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vmovdqa 3184(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm9[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 288(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm5[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 384(%rdi), %ymm5
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm2 = ymm6[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],ymm6[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 736(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm7[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 832(%rdi), %ymm6
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm2 = ymm4[8,9,10,11,12,13,14,15],ymm6[0,1,2,3,4,5,6,7],ymm4[24,25,26,27,28,29,30,31],ymm6[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1184(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm8[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1280(%rdi), %ymm7
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm2 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm2 = mem[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1632(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = xmm13[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1728(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm2 = ymm11[8,9,10,11,12,13,14,15],ymm8[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm8[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2080(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2176(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm2 = ymm12[8,9,10,11,12,13,14,15],ymm11[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm11[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2528(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2624(%rdi), %ymm12
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm12, %ymm2 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm2 = mem[8,9,10,11,12,13,14,15],ymm12[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm12[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2976(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 3072(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm2 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 3424(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 3520(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 608(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 512(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1056(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 960(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1504(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1408(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1952(%rdi), %ymm13
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = ymm14[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],ymm14[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1856(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2400(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = ymm3[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 2304(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2848(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 2752(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm15 = xmm15[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 3296(%rdi), %ymm15
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = ymm10[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],ymm10[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 3200(%rdi), %xmm10
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm9 = xmm9[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 352(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm5[1],ymm0[3],ymm5[3]
; AVX2-ONLY-NEXT:    vmovdqa 240(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 800(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm6[1],ymm0[3],ymm6[3]
; AVX2-ONLY-NEXT:    vmovdqa 688(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 1248(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm7[1],ymm0[3],ymm7[3]
; AVX2-ONLY-NEXT:    vmovdqa 1136(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 1696(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm8[1],ymm0[3],ymm8[3]
; AVX2-ONLY-NEXT:    vmovdqa 1584(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 2144(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm11[1],ymm0[3],ymm11[3]
; AVX2-ONLY-NEXT:    vmovdqa 2032(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 2592(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm12[1],ymm0[3],ymm12[3]
; AVX2-ONLY-NEXT:    vmovdqa 2480(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vbroadcastsd 3040(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vmovaps 2928(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vbroadcastsd 3488(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vmovaps 3376(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 3264(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm15[1],ymm0[3],ymm15[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = mem[0,1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 2816(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = mem[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 2368(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm4[1],ymm0[3],ymm4[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = mem[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq 1920(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm13[1],ymm0[3],ymm13[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = mem[0,1],xmm14[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vbroadcastsd 1472(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = mem[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vbroadcastsd 1024(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = mem[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vbroadcastsd 576(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = mem[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vbroadcastsd 128(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = mem[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %xmm12
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm12[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 288(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 416(%rdi), %xmm11
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 512(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 640(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 736(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 864(%rdi), %xmm6
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 960(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1088(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1184(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1312(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1408(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1536(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1632(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1760(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm1 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1856(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1984(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm7 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm7[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2080(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm7 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 2208(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm9 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm9
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm7 = ymm7[2,3],ymm9[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2304(%rdi), %ymm7
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm9 = mem[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 2432(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm10 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm9 = ymm9[2,3],ymm10[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2528(%rdi), %ymm9
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm9 = mem[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 2656(%rdi), %xmm10
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm13 = mem[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm13, %ymm0, %ymm13
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm9 = ymm9[2,3],ymm13[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2752(%rdi), %ymm9
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm9[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm9[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 2880(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm9[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm13 = ymm13[2,3],ymm14[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2976(%rdi), %ymm13
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 3104(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm13 = ymm13[2,3],ymm14[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 3200(%rdi), %ymm13
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 3328(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm13 = ymm13[2,3],ymm14[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 3424(%rdi), %ymm13
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm13 = mem[8,9,10,11,12,13,14,15],ymm13[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm13[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 3552(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm14 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vperm2i128 {{.*#+}} ymm13 = ymm13[2,3],ymm14[2,3]
; AVX2-ONLY-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX2-ONLY-NEXT:    vmovdqa 128(%rdi), %ymm14
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm12 = ymm14[0,1,2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %xmm13
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm12 = ymm13[0,1,2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm12, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX2-ONLY-NEXT:    vmovdqa 352(%rdi), %ymm15
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm11 = ymm15[0,1,2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 256(%rdi), %xmm13
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm12 = xmm13[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm11 = ymm12[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 576(%rdi), %ymm12
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm12[0,1,2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 480(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm11 = xmm0[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm11[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vmovdqa 800(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm11[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 704(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm8 = xmm0[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm8[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 1024(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm0[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 928(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm6 = xmm0[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm6[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 1248(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm0[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1152(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm0[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vmovdqa 1472(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1376(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vmovdqa 1696(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1600(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm0[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vmovdqa 1920(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1824(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm2[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vmovdqa 2144(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2048(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 2368(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2272(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, (%rsp) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 2592(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2496(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm9, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovdqa 2816(%rdi), %ymm9
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2720(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vmovdqa 3040(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2944(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovdqa %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vmovdqa 3264(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 3168(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinserti128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm3 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vmovdqa 3488(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm8[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovdqa 3392(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm0[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm3 = ymm14[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm14[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm4 = mem[8,9,10,11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 416(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm3 = ymm15[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm15[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 320(%rdi), %xmm10
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm4 = xmm13[8,9,10,11,12,13,14,15],xmm10[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 544(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm3 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 640(%rdi), %ymm6
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm4 = ymm12[8,9,10,11,12,13,14,15],ymm6[0,1,2,3,4,5,6,7],ymm12[24,25,26,27,28,29,30,31],ymm6[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 864(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm3 = ymm11[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],ymm11[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 768(%rdi), %xmm11
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm4 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm4 = mem[8,9,10,11,12,13,14,15],xmm11[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 992(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm3 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1088(%rdi), %ymm5
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm4 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm4 = mem[8,9,10,11,12,13,14,15],ymm5[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm5[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1312(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm3 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm3 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1216(%rdi), %xmm12
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm4 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm4 = mem[8,9,10,11,12,13,14,15],xmm12[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1440(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm3 = mem[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1536(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm7 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm7 = mem[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1760(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm3 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm3 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 1664(%rdi), %xmm13
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm7 = mem[8,9,10,11,12,13,14,15],xmm13[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 1888(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} xmm2 = xmm2[8,9,10,11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 1984(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm7 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm7 = mem[8,9,10,11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2208(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm2 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 2112(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm7 = mem[8,9,10,11,12,13,14,15],xmm14[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2336(%rdi), %xmm2
; AVX2-ONLY-NEXT:    vpalignr $8, (%rsp), %xmm2, %xmm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm7 = mem[8,9,10,11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2432(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm15 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm15 = mem[8,9,10,11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm15[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2656(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm7 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm7 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 2560(%rdi), %xmm15
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = mem[8,9,10,11,12,13,14,15],xmm15[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 2784(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm7 = mem[8,9,10,11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 2880(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm0 = ymm9[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm9[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 3104(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 3008(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vmovdqa %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm7, %xmm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm7 = mem[8,9,10,11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 3232(%rdi), %xmm0
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm7 = mem[8,9,10,11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa 3328(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm9 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm9 = mem[8,9,10,11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm9[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa 3552(%rdi), %ymm7
; AVX2-ONLY-NEXT:    vmovdqu %ymm7, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpalignr {{.*#+}} ymm7 = ymm8[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],ymm8[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX2-ONLY-NEXT:    vmovdqa 3456(%rdi), %xmm8
; AVX2-ONLY-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm9 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm9 = mem[8,9,10,11,12,13,14,15],xmm8[0,1,2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm7 = ymm9[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm7 = ymm7[1],mem[1],ymm7[3],mem[3]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm9 = xmm9[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm7 = ymm7[1],mem[1],ymm7[3],mem[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm9 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm9 = mem[0,1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm9[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm7[1],ymm6[1],ymm7[3],ymm6[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm6 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm6 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm7 = mem[0,1],xmm11[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm11 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm6 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm5 = ymm6[1],ymm5[1],ymm6[3],ymm5[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm6 = xmm6[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm6[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm5 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm5 = ymm5[1],mem[1],ymm5[3],mem[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm12, %xmm6 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm6 = mem[0,1],xmm12[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm6[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm5 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm5[1],ymm4[1],ymm5[3],ymm4[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm6 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm4 = ymm4[1],mem[1],ymm4[3],mem[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13, %xmm5 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm5 = mem[0,1],xmm13[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm9 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm4[1],ymm3[1],ymm4[3],ymm3[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm3 = ymm3[1],mem[1],ymm3[3],mem[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm4 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm4 = mem[0,1],xmm14[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm12 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm3[1],ymm2[1],ymm3[3],ymm2[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm3[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm3 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm3 = mem[0,1],xmm15[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm2 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm2[1],ymm1[1],ymm2[3],ymm1[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-ONLY-NEXT:    vblendps $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2, %xmm2 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm2 = mem[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-ONLY-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vpunpckhqdq (%rsp), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpblendd $3, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm7 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm7 = mem[0,1],xmm8[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 448(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 384(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 320(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 256(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 192(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 128(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 64(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, (%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 480(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 416(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 352(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 288(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 224(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 160(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 96(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 32(%rsi)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 448(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 384(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 320(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 256(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 192(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 128(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 64(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, (%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 480(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 416(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 352(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 288(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 224(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 160(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 96(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 32(%rdx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, (%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 128(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 192(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 256(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 320(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 384(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 448(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 480(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 416(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 352(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 288(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 224(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 160(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 96(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 480(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 448(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 416(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 384(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 352(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 320(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 288(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 256(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 224(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 192(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 160(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 128(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 96(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 64(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 32(%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, (%r8)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 480(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 448(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 416(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 384(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 352(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 320(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 288(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 256(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 224(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 192(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 160(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 128(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 96(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 64(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 32(%r9)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, (%r9)
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 480(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 448(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 416(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 384(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 352(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 320(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 288(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 256(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 224(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 192(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 160(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 128(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 96(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 64(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 32(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm7 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm7, (%rax)
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovdqa %ymm0, 480(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm1, 448(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 416(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm3, 384(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm4, 352(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm5, 320(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm12, 288(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm13, 256(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm9, 224(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm6, 192(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm11, 96(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm10, 32(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-ONLY-NEXT:    addq $3976, %rsp # imm = 0xF88
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: load_i64_stride7_vf64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    subq $6536, %rsp # imm = 0x1988
; AVX512F-NEXT:    vmovdqa64 3328(%rdi), %zmm18
; AVX512F-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 3264(%rdi), %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 3008(%rdi), %zmm19
; AVX512F-NEXT:    vmovdqa64 2944(%rdi), %zmm20
; AVX512F-NEXT:    vmovdqa64 2880(%rdi), %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 2816(%rdi), %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 2752(%rdi), %zmm8
; AVX512F-NEXT:    vmovdqa64 2688(%rdi), %zmm15
; AVX512F-NEXT:    vmovdqa64 2432(%rdi), %zmm6
; AVX512F-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 2368(%rdi), %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 1984(%rdi), %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 1920(%rdi), %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 1536(%rdi), %zmm13
; AVX512F-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 1472(%rdi), %zmm11
; AVX512F-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 1088(%rdi), %zmm17
; AVX512F-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 1024(%rdi), %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 640(%rdi), %zmm16
; AVX512F-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 576(%rdi), %zmm12
; AVX512F-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 192(%rdi), %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 128(%rdi), %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [14,0,0,7,14,0,0,7]
; AVX512F-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm2, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqa 2704(%rdi), %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqa 464(%rdi), %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm11, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm13, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqa 1360(%rdi), %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqa 912(%rdi), %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm6, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqa 2256(%rdi), %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm10, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqa 1808(%rdi), %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2q %zmm18, %zmm4, %zmm0
; AVX512F-NEXT:    vmovdqa 3152(%rdi), %xmm1
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512F-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti128 $1, 2880(%rdi), %ymm0, %ymm1
; AVX512F-NEXT:    vmovdqa 2816(%rdi), %ymm0
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm9 = [4,11]
; AVX512F-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm8, %zmm9, %zmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm4 = [0,7,14,0,0,7,14,0]
; AVX512F-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm20, %zmm11
; AVX512F-NEXT:    vmovdqa64 %zmm20, %zmm2
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm6
; AVX512F-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm4, %zmm2
; AVX512F-NEXT:    vmovdqa64 3072(%rdi), %zmm30
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [4,5,6,13,4,5,6,13]
; AVX512F-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm16, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm2
; AVX512F-NEXT:    vmovdqa 576(%rdi), %ymm1
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX512F-NEXT:    vmovdqa64 512(%rdi), %zmm31
; AVX512F-NEXT:    vmovdqa64 448(%rdi), %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm31, %zmm9, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 768(%rdi), %zmm18
; AVX512F-NEXT:    vmovdqa64 704(%rdi), %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm4, %zmm3
; AVX512F-NEXT:    vmovdqa64 832(%rdi), %zmm26
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm16, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm3, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm2
; AVX512F-NEXT:    vmovdqa 128(%rdi), %ymm3
; AVX512F-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %zmm28
; AVX512F-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm28, %zmm9, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 320(%rdi), %zmm21
; AVX512F-NEXT:    vmovdqa64 256(%rdi), %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm4, %zmm3
; AVX512F-NEXT:    vmovdqa64 384(%rdi), %zmm23
; AVX512F-NEXT:    vpermt2q %zmm23, %zmm16, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm3, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti128 $1, 1536(%rdi), %ymm0, %ymm2
; AVX512F-NEXT:    vmovdqa 1472(%rdi), %ymm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX512F-NEXT:    vmovdqa64 1408(%rdi), %zmm7
; AVX512F-NEXT:    vmovdqa64 1344(%rdi), %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm9, %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm27
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 1664(%rdi), %zmm10
; AVX512F-NEXT:    vmovdqa64 1600(%rdi), %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm4, %zmm5
; AVX512F-NEXT:    vmovdqa64 1728(%rdi), %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm16, %zmm5
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm5, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti128 $1, 1088(%rdi), %ymm0, %ymm2
; AVX512F-NEXT:    vmovdqa 1024(%rdi), %ymm5
; AVX512F-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3,4,5],ymm2[6,7]
; AVX512F-NEXT:    vmovdqa64 960(%rdi), %zmm22
; AVX512F-NEXT:    vmovdqa64 896(%rdi), %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm9, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 1216(%rdi), %zmm17
; AVX512F-NEXT:    vmovdqa64 1152(%rdi), %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm4, %zmm5
; AVX512F-NEXT:    vmovdqa64 1280(%rdi), %zmm19
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm16, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm5, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti128 $1, 2432(%rdi), %ymm0, %ymm2
; AVX512F-NEXT:    vmovdqa 2368(%rdi), %ymm5
; AVX512F-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3,4,5],ymm2[6,7]
; AVX512F-NEXT:    vmovdqa64 2304(%rdi), %zmm20
; AVX512F-NEXT:    vmovdqa64 2240(%rdi), %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm9, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 2560(%rdi), %zmm24
; AVX512F-NEXT:    vmovdqa64 2496(%rdi), %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm24, %zmm4, %zmm5
; AVX512F-NEXT:    vmovdqa64 2624(%rdi), %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm16, %zmm5
; AVX512F-NEXT:    vinserti64x4 $0, %ymm2, %zmm5, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti128 $1, 1984(%rdi), %ymm0, %ymm2
; AVX512F-NEXT:    vmovdqa 1920(%rdi), %ymm5
; AVX512F-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3,4,5],ymm2[6,7]
; AVX512F-NEXT:    vmovdqa64 1856(%rdi), %zmm14
; AVX512F-NEXT:    vmovdqa64 1792(%rdi), %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm9, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 2112(%rdi), %zmm2
; AVX512F-NEXT:    vmovdqa64 2048(%rdi), %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm2, %zmm4, %zmm7
; AVX512F-NEXT:    vmovdqa64 2176(%rdi), %zmm13
; AVX512F-NEXT:    vpermt2q %zmm13, %zmm16, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti64x4 $0, %ymm5, %zmm7, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vinserti128 $1, 3328(%rdi), %ymm0, %ymm5
; AVX512F-NEXT:    vmovdqa 3264(%rdi), %ymm7
; AVX512F-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm5 = ymm7[0,1,2,3,4,5],ymm5[6,7]
; AVX512F-NEXT:    vmovdqa64 3200(%rdi), %zmm12
; AVX512F-NEXT:    vmovdqa64 3136(%rdi), %zmm7
; AVX512F-NEXT:    vpermi2q %zmm12, %zmm7, %zmm9
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm25
; AVX512F-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm12
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm5 = ymm9[0,1,2,3],ymm5[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 3456(%rdi), %zmm9
; AVX512F-NEXT:    vmovdqa64 3392(%rdi), %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2q %zmm9, %zmm7, %zmm4
; AVX512F-NEXT:    vmovdqa64 3520(%rdi), %zmm29
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm16, %zmm4
; AVX512F-NEXT:    vinserti64x4 $0, %ymm5, %zmm4, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 2880(%rdi), %ymm4
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm4 = ymm0[8,9,10,11,12,13,14,15],ymm4[0,1,2,3,4,5,6,7],ymm0[24,25,26,27,28,29,30,31],ymm4[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm0 = [5,12]
; AVX512F-NEXT:    vmovdqa64 %zmm15, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm8, %zmm0, %zmm5
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm7 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm4 = [9,0,7,0,9,0,7,0]
; AVX512F-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm11, %zmm4, %zmm6
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [4,5,6,14,4,5,6,14]
; AVX512F-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm5, %zmm6
; AVX512F-NEXT:    vinserti64x4 $0, %ymm7, %zmm6, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 640(%rdi), %ymm7
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm1 = ymm1[8,9,10,11,12,13,14,15],ymm7[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm7[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm31, %zmm0, %zmm7
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm7[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm18, %zmm7
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm8, %zmm4, %zmm7
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm5, %zmm7
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 192(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vmovdqu64 (%rsp), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm28, %zmm0, %zmm6
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm4, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm23, %zmm5, %zmm6
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm6, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 1536(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm1 = ymm3[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm3[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm27, %zmm0, %zmm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm28, %zmm4, %zmm3
; AVX512F-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm5, %zmm3 # 64-byte Folded Reload
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 1088(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm0, %zmm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm3
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm23 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm23, %zmm4, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm5, %zmm3
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 2432(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm20, %zmm0, %zmm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm4, %zmm3
; AVX512F-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm5, %zmm3 # 64-byte Folded Reload
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 1984(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm0, %zmm3
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm4, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm13, %zmm5, %zmm3
; AVX512F-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 3328(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vpermi2q %zmm25, %zmm12, %zmm0
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512F-NEXT:    vpermi2q %zmm31, %zmm9, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm5, %zmm4
; AVX512F-NEXT:    vinserti64x4 $0, %ymm0, %zmm4, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [10,3,10,3,10,3,10,3]
; AVX512F-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm15, %zmm26
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm20 = [11,4,11,4,11,4,11,4]
; AVX512F-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm20, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [12,5,12,5,12,5,12,5]
; AVX512F-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm25, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [13,6,13,6,13,6,13,6]
; AVX512F-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm8, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm14
; AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [2,9,2,9,2,9,2,9]
; AVX512F-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm19
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm12
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm15, %zmm12
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm20, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm25, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm8, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm0, %zmm19
; AVX512F-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm15, %zmm1
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm19
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm20, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm25, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm8, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm0, %zmm28
; AVX512F-NEXT:    vmovdqu64 %zmm28, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm15, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm20, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm25, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm8, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm0, %zmm23
; AVX512F-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm30, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm24, %zmm15, %zmm5
; AVX512F-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm24, %zmm20, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm24, %zmm25, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm24, %zmm8, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm24, %zmm0, %zmm30
; AVX512F-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm2, %zmm15, %zmm4
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm2, %zmm20, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm2, %zmm25, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm2, %zmm8, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm2, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm11, %zmm1
; AVX512F-NEXT:    vmovdqa64 %zmm11, %zmm27
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm15, %zmm27
; AVX512F-NEXT:    vpermi2q %zmm9, %zmm31, %zmm15
; AVX512F-NEXT:    vmovdqa64 %zmm11, %zmm28
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm20, %zmm28
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm2 # 64-byte Folded Reload
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm11, %zmm2
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm6, %zmm8, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm2
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm8, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm8, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm8, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm2
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm8, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm23 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm23, %zmm8, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2q %zmm9, %zmm31, %zmm20
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm8, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm25, %zmm24
; AVX512F-NEXT:    vpermi2q %zmm9, %zmm31, %zmm25
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm8, %zmm2
; AVX512F-NEXT:    vpermi2q %zmm9, %zmm31, %zmm8
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm0, %zmm31
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,6,9,0,5,6,9]
; AVX512F-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm0, %zmm12
; AVX512F-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm26
; AVX512F-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm0, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm0, %zmm19
; AVX512F-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm0, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm0, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm0, %zmm27
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm0, %zmm15
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,6,10,0,5,6,10]
; AVX512F-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm0, %zmm28
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm0, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm0, %zmm20
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,6,11,0,5,6,11]
; AVX512F-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm0, %zmm24
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm0, %zmm22
; AVX512F-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm0, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm0, %zmm25
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,6,12,0,5,6,12]
; AVX512F-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm0, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm0, %zmm8
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,5,8,15,4,5,8,15]
; AVX512F-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm9, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm19, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm29, %zmm0, %zmm31
; AVX512F-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm26, %zmm0, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    movb $24, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm9 = <0,7,14,u>
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm9, %zmm19
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm19 {%k1} = zmm11[0,1,4,5],zmm6[4,5,0,1]
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [7,0,9,0,7,0,9,0]
; AVX512F-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512F-NEXT:    vpermt2q %zmm11, %zmm2, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [4,11,4,11]
; AVX512F-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512F-NEXT:    vpermt2q %zmm6, %zmm3, %zmm11
; AVX512F-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 (%rsp), %zmm29 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm9, %zmm29
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k1} = zmm13[0,1,4,5],zmm18[4,5,0,1]
; AVX512F-NEXT:    vmovdqa64 %zmm18, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm13, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm18, %zmm3, %zmm13
; AVX512F-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm18 # 64-byte Folded Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm18 {%k1} = zmm0[0,1,4,5],zmm16[4,5,0,1]
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm16, %zmm3, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm6, %zmm9, %zmm26
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm26 {%k1} = zmm0[0,1,4,5],zmm17[4,5,0,1]
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm17, %zmm3, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm9, %zmm31
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm31 {%k1} = zmm7[0,1,4,5],zmm21[4,5,0,1]
; AVX512F-NEXT:    vmovdqa64 %zmm21, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm3, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm9, %zmm17
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k1} = zmm0[0,1,4,5],zmm23[4,5,0,1]
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm0, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm23, %zmm3, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm11, %zmm13
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm9, %zmm13
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vpermi2q %zmm14, %zmm0, %zmm9
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm9 {%k1} = zmm0[0,1,4,5],zmm30[4,5,0,1]
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm23
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm2, %zmm23
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm30, %zmm2
; AVX512F-NEXT:    vpermt2q %zmm30, %zmm3, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vshufi64x2 {{.*#+}} zmm13 {%k1} = zmm1[0,1,4,5],zmm5[4,5,0,1]
; AVX512F-NEXT:    vpermt2q %zmm5, %zmm3, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm0 = <9,0,7,u>
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm16
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} xmm30 = [6,13]
; AVX512F-NEXT:    vpermt2q %zmm12, %zmm30, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm10, %zmm12
; AVX512F-NEXT:    vmovdqu64 (%rsp), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm12
; AVX512F-NEXT:    vpermt2q %zmm10, %zmm30, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm10
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm0, %zmm10
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm30, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm0, %zmm6
; AVX512F-NEXT:    vpermt2q %zmm1, %zmm30, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm5
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm3, %zmm0, %zmm5
; AVX512F-NEXT:    vpermt2q %zmm22, %zmm30, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm21, %zmm3
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-NEXT:    vpermt2q %zmm4, %zmm0, %zmm3
; AVX512F-NEXT:    vpermt2q %zmm21, %zmm30, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm4
; AVX512F-NEXT:    vpermt2q %zmm11, %zmm0, %zmm4
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vpermi2q %zmm1, %zmm14, %zmm0
; AVX512F-NEXT:    vpermt2q %zmm14, %zmm30, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2q %zmm7, %zmm30, %zmm11
; AVX512F-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512F-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovups (%rsp), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512F-NEXT:    vmovups %zmm1, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512F-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512F-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    movb $-32, %al
; AVX512F-NEXT:    kmovw %eax, %k2
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm29 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm19 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm18 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm17 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm31 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm27, %zmm13 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm15, %zmm9 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm4 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm16 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm16 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm12 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm12 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm10 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm10 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm20, %zmm0 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm1 {%k2}
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm30 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1 {%k2}
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1 {%k2}
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm24 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm20 {%k2}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm7 {%k2}
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm14 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm14 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovdqa 2752(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-NEXT:    vinserti32x4 $0, %xmm1, %zmm23, %zmm28
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k2}
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm14, %zmm1, %zmm1
; AVX512F-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 512(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vinserti32x4 $0, %xmm1, %zmm14, %zmm21
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm21 {%k2}
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm15 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm15 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vinserti32x4 $0, %xmm1, %zmm14, %zmm22
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm22 {%k2}
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm15, %zmm1, %zmm1
; AVX512F-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 1408(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vinserti32x4 $0, %xmm1, %zmm14, %zmm23
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k2}
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm15 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm15 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovdqa 960(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vinserti32x4 $0, %xmm1, %zmm14, %zmm25
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm25 {%k2}
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm15, %zmm1, %zmm1
; AVX512F-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 2304(%rdi), %ymm15
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm15 = mem[8,9,10,11,12,13,14,15],ymm15[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm15[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm15, %xmm15
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vinserti32x4 $0, %xmm15, %zmm1, %zmm15
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm15 {%k2}
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm11 # 32-byte Folded Reload
; AVX512F-NEXT:    # ymm11 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512F-NEXT:    vmovdqa 1856(%rdi), %ymm1
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vinserti32x4 $0, %xmm1, %zmm14, %zmm1
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm14, %zmm1 {%k2}
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-NEXT:    vinsertf64x4 $0, %ymm11, %zmm14, %zmm14
; AVX512F-NEXT:    vmovups %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa 3200(%rdi), %ymm14
; AVX512F-NEXT:    vpalignr {{.*#+}} ymm14 = mem[8,9,10,11,12,13,14,15],ymm14[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm14[16,17,18,19,20,21,22,23]
; AVX512F-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX512F-NEXT:    vinserti32x4 $0, %xmm14, %zmm2, %zmm2
; AVX512F-NEXT:    vmovdqa64 %zmm8, %zmm2 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm9, 448(%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm13, 384(%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm31, 320(%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm17, 256(%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm18, 192(%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm26, 128(%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm19, 64(%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm29, (%rsi)
; AVX512F-NEXT:    vmovdqa64 %zmm0, 448(%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm3, 256(%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm5, 320(%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm6, 128(%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm10, 192(%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm12, (%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm16, 64(%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm4, 384(%rdx)
; AVX512F-NEXT:    vmovdqa64 %zmm7, 448(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm20, 256(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm24, 320(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm27, 128(%rcx)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 192(%rcx)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, (%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm30, 64(%rcx)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 384(%rcx)
; AVX512F-NEXT:    vmovdqa64 %zmm2, 448(%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm1, 256(%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm15, 320(%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm25, 128(%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm23, 192(%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm22, (%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm21, 64(%r8)
; AVX512F-NEXT:    vmovdqa64 %zmm28, 384(%r8)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 448(%r9)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 256(%r9)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 320(%r9)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 128(%r9)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 192(%r9)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, (%r9)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 64(%r9)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 384(%r9)
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 192(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, (%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 192(%rax)
; AVX512F-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, (%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512F-NEXT:    addq $6536, %rsp # imm = 0x1988
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: load_i64_stride7_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $6536, %rsp # imm = 0x1988
; AVX512BW-NEXT:    vmovdqa64 3328(%rdi), %zmm19
; AVX512BW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 3264(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 3008(%rdi), %zmm16
; AVX512BW-NEXT:    vmovdqa64 2944(%rdi), %zmm28
; AVX512BW-NEXT:    vmovdqa64 2880(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 2816(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 2752(%rdi), %zmm20
; AVX512BW-NEXT:    vmovdqa64 2688(%rdi), %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 2432(%rdi), %zmm17
; AVX512BW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 2368(%rdi), %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 1984(%rdi), %zmm18
; AVX512BW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 1920(%rdi), %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 1536(%rdi), %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 1472(%rdi), %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 1088(%rdi), %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 1024(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 640(%rdi), %zmm15
; AVX512BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 576(%rdi), %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [14,0,0,7,14,0,0,7]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqa 2704(%rdi), %xmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqa 464(%rdi), %xmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqa 1360(%rdi), %xmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqa 912(%rdi), %xmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqa 2256(%rdi), %xmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqa 1808(%rdi), %xmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm19, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqa 3152(%rdi), %xmm1
; AVX512BW-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],mem[2,3]
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti128 $1, 2880(%rdi), %ymm0, %ymm0
; AVX512BW-NEXT:    vmovdqa 2816(%rdi), %ymm1
; AVX512BW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm7 = [4,11]
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm7, %zmm1
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [0,7,14,0,0,7,14,0]
; AVX512BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm15, %zmm1
; AVX512BW-NEXT:    vmovdqa64 3072(%rdi), %zmm30
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [4,5,6,13,4,5,6,13]
; AVX512BW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm18, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti128 $1, 640(%rdi), %ymm0, %ymm0
; AVX512BW-NEXT:    vmovdqa 576(%rdi), %ymm1
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-NEXT:    vmovdqa64 512(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 448(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 768(%rdi), %zmm16
; AVX512BW-NEXT:    vmovdqa64 704(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm15, %zmm2
; AVX512BW-NEXT:    vmovdqa64 832(%rdi), %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm18, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti128 $1, 192(%rdi), %ymm0, %ymm0
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm26
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm7, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 320(%rdi), %zmm22
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm15, %zmm3
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %zmm25
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm18, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti128 $1, 1536(%rdi), %ymm0, %ymm0
; AVX512BW-NEXT:    vmovdqa 1472(%rdi), %ymm3
; AVX512BW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-NEXT:    vmovdqa64 1408(%rdi), %zmm23
; AVX512BW-NEXT:    vmovdqa64 1344(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm7, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 1664(%rdi), %zmm21
; AVX512BW-NEXT:    vmovdqa64 1600(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm15, %zmm4
; AVX512BW-NEXT:    vmovdqa64 1728(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm18, %zmm4
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm4, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti128 $1, 1088(%rdi), %ymm0, %ymm0
; AVX512BW-NEXT:    vmovdqa 1024(%rdi), %ymm3
; AVX512BW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-NEXT:    vmovdqa64 960(%rdi), %zmm20
; AVX512BW-NEXT:    vmovdqa64 896(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm7, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 1216(%rdi), %zmm12
; AVX512BW-NEXT:    vmovdqa64 1152(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm15, %zmm4
; AVX512BW-NEXT:    vmovdqa64 1280(%rdi), %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm18, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm4, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti128 $1, 2432(%rdi), %ymm0, %ymm0
; AVX512BW-NEXT:    vmovdqa 2368(%rdi), %ymm3
; AVX512BW-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-NEXT:    vmovdqa64 2304(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 2240(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm7, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm31
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 2560(%rdi), %zmm17
; AVX512BW-NEXT:    vmovdqa64 2496(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm15, %zmm5
; AVX512BW-NEXT:    vmovdqa64 2624(%rdi), %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm18, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti128 $1, 1984(%rdi), %ymm0, %ymm0
; AVX512BW-NEXT:    vmovdqa 1920(%rdi), %ymm5
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-NEXT:    vmovdqa64 1856(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 1792(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm7, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm0[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 2112(%rdi), %zmm24
; AVX512BW-NEXT:    vmovdqa64 2048(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm15, %zmm6
; AVX512BW-NEXT:    vmovdqa64 2176(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm18, %zmm6
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vinserti128 $1, 3328(%rdi), %ymm0, %ymm6
; AVX512BW-NEXT:    vmovdqa 3264(%rdi), %ymm0
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm0[0,1,2,3,4,5],ymm6[6,7]
; AVX512BW-NEXT:    vmovdqa64 3200(%rdi), %zmm14
; AVX512BW-NEXT:    vmovdqa64 3136(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm14, %zmm3, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 3456(%rdi), %zmm14
; AVX512BW-NEXT:    vmovdqa64 3392(%rdi), %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm14, %zmm7, %zmm15
; AVX512BW-NEXT:    vmovdqa64 3520(%rdi), %zmm29
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm18, %zmm15
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm15, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa 2880(%rdi), %ymm6
; AVX512BW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm6, %ymm6 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm6 = mem[8,9,10,11,12,13,14,15],ymm6[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm6[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm7 = [5,12]
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm7, %zmm11
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm6[4,5,6,7]
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [9,0,7,0,9,0,7,0]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm28, %zmm6, %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm8
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [4,5,6,14,4,5,6,14]
; AVX512BW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm13, %zmm11
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm10, %zmm11, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa 640(%rdi), %ymm10
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm1 = ymm1[8,9,10,11,12,13,14,15],ymm10[0,1,2,3,4,5,6,7],ymm1[24,25,26,27,28,29,30,31],ymm10[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm10 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm7, %zmm10 # 64-byte Folded Reload
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm10[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm10
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm28, %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm13, %zmm10
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm10, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa 192(%rdi), %ymm1
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm1 = ymm2[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm2[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm7, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm13, %zmm2
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa 1536(%rdi), %ymm1
; AVX512BW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm7, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm6, %zmm2
; AVX512BW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm13, %zmm2 # 64-byte Folded Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa 1088(%rdi), %ymm1
; AVX512BW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm7, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm6, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm19, %zmm13, %zmm2
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa 2432(%rdi), %ymm1
; AVX512BW-NEXT:    vpalignr $8, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = mem[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm31, %zmm7, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm6, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm13, %zmm2
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa 1984(%rdi), %ymm1
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm1 = ymm5[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm5[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm7, %zmm2
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm6, %zmm2
; AVX512BW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm13, %zmm2 # 64-byte Folded Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa 3328(%rdi), %ymm1
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[8,9,10,11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7],ymm0[24,25,26,27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm7
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm14, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm13, %zmm6
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm18 = [10,3,10,3,10,3,10,3]
; AVX512BW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm18, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [11,4,11,4,11,4,11,4]
; AVX512BW-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm19, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm20 = [12,5,12,5,12,5,12,5]
; AVX512BW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm20, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm9 = [13,6,13,6,13,6,13,6]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [2,9,2,9,2,9,2,9]
; AVX512BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm18, %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm19, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm20, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm9, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm3, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm18, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm19, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm20, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm9, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm3, %zmm25
; AVX512BW-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm18, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm19, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm20, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm9, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm3, %zmm26
; AVX512BW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm18, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm19, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm20, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm9, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm25
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm3, %zmm27
; AVX512BW-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm18, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm19, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm20, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm9, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm3, %zmm30
; AVX512BW-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm24
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm31
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm18, %zmm31
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm6
; AVX512BW-NEXT:    vpermi2q %zmm14, %zmm4, %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm19, %zmm4
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm5 # 64-byte Folded Reload
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm9, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm9, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm9, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm9, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm5
; AVX512BW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm5 # 64-byte Folded Reload
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm9, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm14, %zmm6, %zmm19
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm5 # 64-byte Folded Reload
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm28
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm20, %zmm28
; AVX512BW-NEXT:    vpermi2q %zmm14, %zmm6, %zmm20
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm9, %zmm5
; AVX512BW-NEXT:    vpermi2q %zmm14, %zmm6, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm3, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm3, %zmm24
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,6,9,0,5,6,9]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm0, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm0, %zmm31
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm0, %zmm18
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,6,10,0,5,6,10]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm0, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm0, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm0, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm0, %zmm19
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,6,11,0,5,6,11]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm0, %zmm28
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm0, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm0, %zmm20
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [0,5,6,12,0,5,6,12]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm0, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm0, %zmm23
; AVX512BW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm22
; AVX512BW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm0, %zmm25
; AVX512BW-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm0, %zmm9
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,5,8,15,4,5,8,15]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm0, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm0, %zmm24
; AVX512BW-NEXT:    movb $24, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm14 = <0,7,14,u>
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm27 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm14, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm27 {%k1} = zmm8[0,1,4,5],zmm26[4,5,0,1]
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [7,0,9,0,7,0,9,0]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [4,11,4,11]
; AVX512BW-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm14, %zmm29
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm29 {%k1} = zmm10[0,1,4,5],zmm16[4,5,0,1]
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm16, %zmm2, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm14, %zmm26
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm26 {%k1} = zmm13[0,1,4,5],zmm17[4,5,0,1]
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm14, %zmm17
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k1} = zmm0[0,1,4,5],zmm15[4,5,0,1]
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm14, %zmm16
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm16 {%k1} = zmm12[0,1,4,5],zmm0[4,5,0,1]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm6, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm14, %zmm15
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm15 {%k1} = zmm0[0,1,4,5],zmm21[4,5,0,1]
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm14, %zmm12
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermi2q %zmm21, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm0[0,1,4,5],zmm4[4,5,0,1]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm23
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm6, %zmm23
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm4, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm12 {%k1} = zmm1[0,1,4,5],zmm5[4,5,0,1]
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm2 = <9,0,7,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm13
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm3 = [6,13]
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm4
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm4
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm8
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm30
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm30
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm4
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm2, %zmm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm21, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm21, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    vmovups (%rsp), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vinsertf64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovups %zmm1, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vinsertf64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vinsertf64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vinsertf64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vinsertf64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vinsertf64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vblendps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vinsertf64x4 $0, %ymm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovups %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpblendd $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm1 # 32-byte Folded Reload
; AVX512BW-NEXT:    # ymm1 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm24, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    movb $-32, %al
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm12 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm14 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm2 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm31 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm28 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 2752(%rdi), %ymm18
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm18 = mem[8,9,10,11,12,13,14,15],ymm18[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm18[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm18, %xmm18
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm18, %zmm23, %zmm18
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512BW-NEXT:    vmovdqa64 512(%rdi), %ymm19
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm19 = mem[8,9,10,11,12,13,14,15],ymm19[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm19[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm19, %xmm19
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm19, %zmm0, %zmm19
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k2}
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %ymm20
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm20 = mem[8,9,10,11,12,13,14,15],ymm20[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm20[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm20, %xmm20
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm20, %zmm0, %zmm20
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512BW-NEXT:    vmovdqa64 1408(%rdi), %ymm21
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm21 = mem[8,9,10,11,12,13,14,15],ymm21[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm21[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm21, %xmm21
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm21, %zmm0, %zmm21
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k2}
; AVX512BW-NEXT:    vmovdqa64 960(%rdi), %ymm22
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm22 = mem[8,9,10,11,12,13,14,15],ymm22[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm22[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm22, %xmm22
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm22, %zmm0, %zmm22
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k2}
; AVX512BW-NEXT:    vmovdqa64 2304(%rdi), %ymm23
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm23 = mem[8,9,10,11,12,13,14,15],ymm23[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm23[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm23, %xmm23
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm23, %zmm0, %zmm23
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512BW-NEXT:    vmovdqa64 1856(%rdi), %ymm24
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm24 = mem[8,9,10,11,12,13,14,15],ymm24[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm24[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm24, %xmm24
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm24, %zmm0, %zmm24
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k2}
; AVX512BW-NEXT:    vmovdqa64 3200(%rdi), %ymm25
; AVX512BW-NEXT:    vpalignr {{.*#+}} ymm25 = mem[8,9,10,11,12,13,14,15],ymm25[0,1,2,3,4,5,6,7],mem[24,25,26,27,28,29,30,31],ymm25[16,17,18,19,20,21,22,23]
; AVX512BW-NEXT:    vextracti32x4 $1, %ymm25, %xmm25
; AVX512BW-NEXT:    vinserti32x4 $0, %xmm25, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 448(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 384(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 320(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 256(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm26, 192(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 128(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm27, 64(%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, (%rsi)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 448(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 256(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm30, 320(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 128(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 192(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, (%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 64(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 384(%rdx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 448(%rcx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 256(%rcx)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm2, 320(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 128(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 192(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm28, (%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 64(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm31, 384(%rcx)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 448(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm24, 256(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm23, 320(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, 128(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 192(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, (%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 64(%r8)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 384(%r8)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 448(%r9)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 256(%r9)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 320(%r9)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 128(%r9)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 192(%r9)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, (%r9)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 64(%r9)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 384(%r9)
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 192(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, (%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 192(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, (%rax)
; AVX512BW-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512BW-NEXT:    addq $6536, %rsp # imm = 0x1988
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %wide.vec = load <448 x i64>, ptr %in.vec, align 64
  %strided.vec0 = shufflevector <448 x i64> %wide.vec, <448 x i64> poison, <64 x i32> <i32 0, i32 7, i32 14, i32 21, i32 28, i32 35, i32 42, i32 49, i32 56, i32 63, i32 70, i32 77, i32 84, i32 91, i32 98, i32 105, i32 112, i32 119, i32 126, i32 133, i32 140, i32 147, i32 154, i32 161, i32 168, i32 175, i32 182, i32 189, i32 196, i32 203, i32 210, i32 217, i32 224, i32 231, i32 238, i32 245, i32 252, i32 259, i32 266, i32 273, i32 280, i32 287, i32 294, i32 301, i32 308, i32 315, i32 322, i32 329, i32 336, i32 343, i32 350, i32 357, i32 364, i32 371, i32 378, i32 385, i32 392, i32 399, i32 406, i32 413, i32 420, i32 427, i32 434, i32 441>
  %strided.vec1 = shufflevector <448 x i64> %wide.vec, <448 x i64> poison, <64 x i32> <i32 1, i32 8, i32 15, i32 22, i32 29, i32 36, i32 43, i32 50, i32 57, i32 64, i32 71, i32 78, i32 85, i32 92, i32 99, i32 106, i32 113, i32 120, i32 127, i32 134, i32 141, i32 148, i32 155, i32 162, i32 169, i32 176, i32 183, i32 190, i32 197, i32 204, i32 211, i32 218, i32 225, i32 232, i32 239, i32 246, i32 253, i32 260, i32 267, i32 274, i32 281, i32 288, i32 295, i32 302, i32 309, i32 316, i32 323, i32 330, i32 337, i32 344, i32 351, i32 358, i32 365, i32 372, i32 379, i32 386, i32 393, i32 400, i32 407, i32 414, i32 421, i32 428, i32 435, i32 442>
  %strided.vec2 = shufflevector <448 x i64> %wide.vec, <448 x i64> poison, <64 x i32> <i32 2, i32 9, i32 16, i32 23, i32 30, i32 37, i32 44, i32 51, i32 58, i32 65, i32 72, i32 79, i32 86, i32 93, i32 100, i32 107, i32 114, i32 121, i32 128, i32 135, i32 142, i32 149, i32 156, i32 163, i32 170, i32 177, i32 184, i32 191, i32 198, i32 205, i32 212, i32 219, i32 226, i32 233, i32 240, i32 247, i32 254, i32 261, i32 268, i32 275, i32 282, i32 289, i32 296, i32 303, i32 310, i32 317, i32 324, i32 331, i32 338, i32 345, i32 352, i32 359, i32 366, i32 373, i32 380, i32 387, i32 394, i32 401, i32 408, i32 415, i32 422, i32 429, i32 436, i32 443>
  %strided.vec3 = shufflevector <448 x i64> %wide.vec, <448 x i64> poison, <64 x i32> <i32 3, i32 10, i32 17, i32 24, i32 31, i32 38, i32 45, i32 52, i32 59, i32 66, i32 73, i32 80, i32 87, i32 94, i32 101, i32 108, i32 115, i32 122, i32 129, i32 136, i32 143, i32 150, i32 157, i32 164, i32 171, i32 178, i32 185, i32 192, i32 199, i32 206, i32 213, i32 220, i32 227, i32 234, i32 241, i32 248, i32 255, i32 262, i32 269, i32 276, i32 283, i32 290, i32 297, i32 304, i32 311, i32 318, i32 325, i32 332, i32 339, i32 346, i32 353, i32 360, i32 367, i32 374, i32 381, i32 388, i32 395, i32 402, i32 409, i32 416, i32 423, i32 430, i32 437, i32 444>
  %strided.vec4 = shufflevector <448 x i64> %wide.vec, <448 x i64> poison, <64 x i32> <i32 4, i32 11, i32 18, i32 25, i32 32, i32 39, i32 46, i32 53, i32 60, i32 67, i32 74, i32 81, i32 88, i32 95, i32 102, i32 109, i32 116, i32 123, i32 130, i32 137, i32 144, i32 151, i32 158, i32 165, i32 172, i32 179, i32 186, i32 193, i32 200, i32 207, i32 214, i32 221, i32 228, i32 235, i32 242, i32 249, i32 256, i32 263, i32 270, i32 277, i32 284, i32 291, i32 298, i32 305, i32 312, i32 319, i32 326, i32 333, i32 340, i32 347, i32 354, i32 361, i32 368, i32 375, i32 382, i32 389, i32 396, i32 403, i32 410, i32 417, i32 424, i32 431, i32 438, i32 445>
  %strided.vec5 = shufflevector <448 x i64> %wide.vec, <448 x i64> poison, <64 x i32> <i32 5, i32 12, i32 19, i32 26, i32 33, i32 40, i32 47, i32 54, i32 61, i32 68, i32 75, i32 82, i32 89, i32 96, i32 103, i32 110, i32 117, i32 124, i32 131, i32 138, i32 145, i32 152, i32 159, i32 166, i32 173, i32 180, i32 187, i32 194, i32 201, i32 208, i32 215, i32 222, i32 229, i32 236, i32 243, i32 250, i32 257, i32 264, i32 271, i32 278, i32 285, i32 292, i32 299, i32 306, i32 313, i32 320, i32 327, i32 334, i32 341, i32 348, i32 355, i32 362, i32 369, i32 376, i32 383, i32 390, i32 397, i32 404, i32 411, i32 418, i32 425, i32 432, i32 439, i32 446>
  %strided.vec6 = shufflevector <448 x i64> %wide.vec, <448 x i64> poison, <64 x i32> <i32 6, i32 13, i32 20, i32 27, i32 34, i32 41, i32 48, i32 55, i32 62, i32 69, i32 76, i32 83, i32 90, i32 97, i32 104, i32 111, i32 118, i32 125, i32 132, i32 139, i32 146, i32 153, i32 160, i32 167, i32 174, i32 181, i32 188, i32 195, i32 202, i32 209, i32 216, i32 223, i32 230, i32 237, i32 244, i32 251, i32 258, i32 265, i32 272, i32 279, i32 286, i32 293, i32 300, i32 307, i32 314, i32 321, i32 328, i32 335, i32 342, i32 349, i32 356, i32 363, i32 370, i32 377, i32 384, i32 391, i32 398, i32 405, i32 412, i32 419, i32 426, i32 433, i32 440, i32 447>
  store <64 x i64> %strided.vec0, ptr %out.vec0, align 64
  store <64 x i64> %strided.vec1, ptr %out.vec1, align 64
  store <64 x i64> %strided.vec2, ptr %out.vec2, align 64
  store <64 x i64> %strided.vec3, ptr %out.vec3, align 64
  store <64 x i64> %strided.vec4, ptr %out.vec4, align 64
  store <64 x i64> %strided.vec5, ptr %out.vec5, align 64
  store <64 x i64> %strided.vec6, ptr %out.vec6, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
; AVX1: {{.*}}
; AVX2: {{.*}}
; AVX2-FAST: {{.*}}
; AVX2-FAST-PERLANE: {{.*}}
; AVX2-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
