; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i64_stride7_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride7_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movapd (%rdi), %xmm0
; SSE-NEXT:    movapd (%rsi), %xmm1
; SSE-NEXT:    movapd (%rdx), %xmm2
; SSE-NEXT:    movapd (%rcx), %xmm3
; SSE-NEXT:    movapd (%r8), %xmm4
; SSE-NEXT:    movapd (%r9), %xmm5
; SSE-NEXT:    movapd (%r10), %xmm6
; SSE-NEXT:    movapd %xmm0, %xmm7
; SSE-NEXT:    unpcklpd {{.*#+}} xmm7 = xmm7[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    unpcklpd {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm6[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm6[0],xmm0[1]
; SSE-NEXT:    movapd %xmm2, 16(%rax)
; SSE-NEXT:    movapd %xmm4, 32(%rax)
; SSE-NEXT:    movapd %xmm0, 48(%rax)
; SSE-NEXT:    movapd %xmm3, 80(%rax)
; SSE-NEXT:    movapd %xmm5, 96(%rax)
; SSE-NEXT:    movapd %xmm1, 64(%rax)
; SSE-NEXT:    movapd %xmm7, (%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride7_vf2:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm2
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps (%r10), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm5[0],ymm1[0],ymm5[2],ymm1[2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm6, %ymm7
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm7[0],ymm0[0],ymm7[2],ymm0[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm3[1],xmm4[1]
; AVX1-ONLY-NEXT:    vmovaps %xmm2, 96(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 64(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, (%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride7_vf2:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm2
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm3
; AVX2-ONLY-NEXT:    vmovaps (%r10), %xmm4
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm0[2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,2,1]
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm4, %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm6[4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,1,3,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm3[1],xmm4[1]
; AVX2-ONLY-NEXT:    vmovaps %xmm1, 96(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 64(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 32(%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride7_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm1
; AVX512-NEXT:    vinserti32x4 $2, (%r10), %zmm1, %zmm1
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,2,4,6,8,10,12,1]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <3,5,7,9,11,13,u,u>
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vextracti32x4 $2, %zmm3, 96(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512-NEXT:    vmovdqa %ymm3, 64(%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <2 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <2 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <2 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <2 x i64>, ptr %in.vecptr6, align 64
  %1 = shufflevector <2 x i64> %in.vec0, <2 x i64> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i64> %in.vec2, <2 x i64> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <2 x i64> %in.vec4, <2 x i64> %in.vec5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <4 x i64> %1, <4 x i64> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = shufflevector <2 x i64> %in.vec6, <2 x i64> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %6 = shufflevector <4 x i64> %3, <4 x i64> %5, <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
  %7 = shufflevector <6 x i64> %6, <6 x i64> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 undef, i32 undef>
  %8 = shufflevector <8 x i64> %4, <8 x i64> %7, <14 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13>
  %interleaved.vec = shufflevector <14 x i64> %8, <14 x i64> poison, <14 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13>
  store <14 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride7_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride7_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movapd (%rdi), %xmm8
; SSE-NEXT:    movaps 16(%rdi), %xmm7
; SSE-NEXT:    movapd (%rsi), %xmm0
; SSE-NEXT:    movaps 16(%rsi), %xmm13
; SSE-NEXT:    movapd (%rdx), %xmm4
; SSE-NEXT:    movaps 16(%rdx), %xmm2
; SSE-NEXT:    movapd (%rcx), %xmm3
; SSE-NEXT:    movaps 16(%rcx), %xmm1
; SSE-NEXT:    movapd (%r8), %xmm10
; SSE-NEXT:    movaps 16(%r8), %xmm6
; SSE-NEXT:    movapd (%r9), %xmm9
; SSE-NEXT:    movaps 16(%r9), %xmm5
; SSE-NEXT:    movapd (%r10), %xmm14
; SSE-NEXT:    movaps 16(%r10), %xmm12
; SSE-NEXT:    movaps %xmm13, %xmm11
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm2[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm6[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm12[1]
; SSE-NEXT:    movapd %xmm8, %xmm15
; SSE-NEXT:    unpcklpd {{.*#+}} xmm15 = xmm15[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; SSE-NEXT:    unpcklpd {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm7[2,3]
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm13[0]
; SSE-NEXT:    unpcklpd {{.*#+}} xmm10 = xmm10[0],xmm9[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm14[1]
; SSE-NEXT:    movsd {{.*#+}} xmm8 = xmm14[0],xmm8[1]
; SSE-NEXT:    movapd %xmm10, 32(%rax)
; SSE-NEXT:    movapd %xmm8, 48(%rax)
; SSE-NEXT:    movapd %xmm9, 96(%rax)
; SSE-NEXT:    movaps %xmm7, 112(%rax)
; SSE-NEXT:    movaps %xmm12, 160(%rax)
; SSE-NEXT:    movaps %xmm11, 176(%rax)
; SSE-NEXT:    movapd %xmm15, (%rax)
; SSE-NEXT:    movapd %xmm4, 16(%rax)
; SSE-NEXT:    movapd %xmm0, 64(%rax)
; SSE-NEXT:    movapd %xmm3, 80(%rax)
; SSE-NEXT:    movaps %xmm2, 128(%rax)
; SSE-NEXT:    movaps %xmm6, 144(%rax)
; SSE-NEXT:    movaps %xmm1, 192(%rax)
; SSE-NEXT:    movaps %xmm5, 208(%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride7_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm2
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm3
; AVX1-ONLY-NEXT:    vmovaps (%r10), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 16(%r10), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm2[1],ymm5[1],ymm2[3],ymm5[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm5
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm6
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm6[0],xmm5[0]
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm8
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm7, %ymm9
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm9[2,3],ymm7[4,5],ymm9[6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm9
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm10
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm10[1],xmm9[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%rcx), %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm12[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm11[0,1,2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],mem[0],ymm3[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 16(%rcx), %xmm11
; AVX1-ONLY-NEXT:    vmovaps 16(%rdx), %xmm12
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm12 = xmm12[0],xmm11[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm12[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm5[1],xmm4[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm11[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 24(%r9), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm8[0],xmm10[0]
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm5 = xmm9[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 96(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm5, 16(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm4, (%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 128(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 192(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride7_vf4:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm5
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm6
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %ymm1
; AVX2-ONLY-NEXT:    vmovaps (%r8), %ymm2
; AVX2-ONLY-NEXT:    vmovaps (%r10), %xmm3
; AVX2-ONLY-NEXT:    vmovaps 16(%r10), %xmm0
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm4[1],ymm5[1],ymm4[3],ymm5[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm7 = ymm7[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm7[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm7
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm8
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %xmm9
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm10
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm10[1],xmm9[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%rcx), %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm11[0,1,2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm4[0],ymm5[0],ymm4[2],ymm5[2]
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm5
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm5[1],xmm3[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm11[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rcx), %ymm10, %ymm10
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm11
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm11, %ymm9
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm9[0],ymm10[0],ymm9[2],ymm10[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm2[0],mem[0],ymm2[2],mem[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm6[0],ymm1[0],ymm6[2],ymm1[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm6[2,3],ymm10[2,3]
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm7[0],xmm5[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm5, %ymm5
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm3, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%r9), %ymm2
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm2[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 128(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 192(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, (%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 96(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 64(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 32(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i64_stride7_vf4:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512F-NEXT:    vmovdqa (%r8), %ymm3
; AVX512F-NEXT:    vmovdqa (%r10), %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, (%rsi), %zmm1, %zmm4
; AVX512F-NEXT:    vinserti64x4 $1, (%rcx), %zmm2, %zmm2
; AVX512F-NEXT:    vinserti64x4 $1, (%r9), %zmm3, %zmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm1 = <15,3,7,u>
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm3, %zmm1
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [0,4,8,0,0,4,8,0]
; AVX512F-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm3, %zmm5
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <0,4,8,12,u,u,u,1>
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm4, %zmm6
; AVX512F-NEXT:    movb $112, %cl
; AVX512F-NEXT:    kmovw %ecx, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm6 {%k1}
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [5,9,0,1,5,9,0,1]
; AVX512F-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm3, %zmm5
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <5,9,13,u,u,u,2,6>
; AVX512F-NEXT:    vpermi2q %zmm2, %zmm4, %zmm7
; AVX512F-NEXT:    movb $56, %cl
; AVX512F-NEXT:    kmovw %ecx, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm7 {%k1}
; AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [10,0,2,6,10,0,2,6]
; AVX512F-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-NEXT:    vpermi2q %zmm0, %zmm3, %zmm5
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <2,6,u,u,u,11,15,3>
; AVX512F-NEXT:    vpermi2q %zmm4, %zmm2, %zmm3
; AVX512F-NEXT:    movb $28, %cl
; AVX512F-NEXT:    kmovw %ecx, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm3 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm3, 128(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512F-NEXT:    vmovdqa %ymm0, 192(%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride7_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm2
; AVX512BW-NEXT:    vmovdqa (%r8), %ymm3
; AVX512BW-NEXT:    vmovdqa (%r10), %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm1, %zmm4
; AVX512BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm2, %zmm2
; AVX512BW-NEXT:    vinserti64x4 $1, (%r9), %zmm3, %zmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm1 = <15,3,7,u>
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm1
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [0,4,8,0,0,4,8,0]
; AVX512BW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm3, %zmm5
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <0,4,8,12,u,u,u,1>
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm4, %zmm6
; AVX512BW-NEXT:    movb $112, %cl
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm6 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [5,9,0,1,5,9,0,1]
; AVX512BW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm3, %zmm5
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <5,9,13,u,u,u,2,6>
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm4, %zmm7
; AVX512BW-NEXT:    movb $56, %cl
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm7 {%k1}
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [10,0,2,6,10,0,2,6]
; AVX512BW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm3, %zmm5
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <2,6,u,u,u,11,15,3>
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm2, %zmm3
; AVX512BW-NEXT:    movb $28, %cl
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512BW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX512BW-NEXT:    vmovdqa %ymm0, 192(%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <4 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <4 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <4 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <4 x i64>, ptr %in.vecptr6, align 64
  %1 = shufflevector <4 x i64> %in.vec0, <4 x i64> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i64> %in.vec2, <4 x i64> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <4 x i64> %in.vec4, <4 x i64> %in.vec5, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = shufflevector <8 x i64> %1, <8 x i64> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %5 = shufflevector <4 x i64> %in.vec6, <4 x i64> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <8 x i64> %3, <8 x i64> %5, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %7 = shufflevector <12 x i64> %6, <12 x i64> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <16 x i64> %4, <16 x i64> %7, <28 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27>
  %interleaved.vec = shufflevector <28 x i64> %8, <28 x i64> poison, <28 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27>
  store <28 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride7_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride7_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $88, %rsp
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd (%rdi), %xmm2
; SSE-NEXT:    movapd 16(%rdi), %xmm5
; SSE-NEXT:    movapd 32(%rdi), %xmm10
; SSE-NEXT:    movapd (%rsi), %xmm3
; SSE-NEXT:    movapd 16(%rsi), %xmm6
; SSE-NEXT:    movapd (%rdx), %xmm4
; SSE-NEXT:    movapd 16(%rdx), %xmm8
; SSE-NEXT:    movapd (%rcx), %xmm7
; SSE-NEXT:    movapd 16(%rcx), %xmm11
; SSE-NEXT:    movapd (%r8), %xmm9
; SSE-NEXT:    movapd 16(%r8), %xmm15
; SSE-NEXT:    movapd (%r9), %xmm12
; SSE-NEXT:    movapd 16(%r9), %xmm13
; SSE-NEXT:    movapd (%rax), %xmm0
; SSE-NEXT:    movapd 16(%rax), %xmm1
; SSE-NEXT:    movapd %xmm2, %xmm14
; SSE-NEXT:    unpcklpd {{.*#+}} xmm14 = xmm14[0],xmm3[0]
; SSE-NEXT:    movapd %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm0[0],xmm2[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm4 = xmm4[0],xmm7[0]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm9[1]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm9 = xmm9[0],xmm12[0]
; SSE-NEXT:    movapd %xmm9, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm5, %xmm14
; SSE-NEXT:    unpcklpd {{.*#+}} xmm14 = xmm14[0],xmm6[0]
; SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm1[0],xmm5[1]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm8[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm8 = xmm8[0],xmm11[0]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm15[1]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm15 = xmm15[0],xmm13[0]
; SSE-NEXT:    movapd %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm1[1]
; SSE-NEXT:    movapd 32(%rsi), %xmm12
; SSE-NEXT:    movapd %xmm10, %xmm15
; SSE-NEXT:    unpcklpd {{.*#+}} xmm15 = xmm15[0],xmm12[0]
; SSE-NEXT:    movapd 32(%rax), %xmm3
; SSE-NEXT:    movsd {{.*#+}} xmm10 = xmm3[0],xmm10[1]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rdx), %xmm11
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm11[1]
; SSE-NEXT:    movapd 32(%rcx), %xmm7
; SSE-NEXT:    unpcklpd {{.*#+}} xmm11 = xmm11[0],xmm7[0]
; SSE-NEXT:    movapd 32(%r8), %xmm9
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm9[1]
; SSE-NEXT:    movapd 32(%r9), %xmm5
; SSE-NEXT:    unpcklpd {{.*#+}} xmm9 = xmm9[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-NEXT:    movapd 48(%rdi), %xmm6
; SSE-NEXT:    movapd 48(%rsi), %xmm4
; SSE-NEXT:    movapd %xmm6, %xmm8
; SSE-NEXT:    unpcklpd {{.*#+}} xmm8 = xmm8[0],xmm4[0]
; SSE-NEXT:    movapd 48(%rax), %xmm10
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm10[0],xmm6[1]
; SSE-NEXT:    movapd 48(%rdx), %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    movapd 48(%rcx), %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm3 = xmm3[0],xmm1[0]
; SSE-NEXT:    movapd 48(%r8), %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movapd 48(%r9), %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm10[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm0, 432(%rax)
; SSE-NEXT:    movapd %xmm1, 416(%rax)
; SSE-NEXT:    movapd %xmm4, 400(%rax)
; SSE-NEXT:    movapd %xmm6, 384(%rax)
; SSE-NEXT:    movapd %xmm2, 368(%rax)
; SSE-NEXT:    movapd %xmm3, 352(%rax)
; SSE-NEXT:    movapd %xmm8, 336(%rax)
; SSE-NEXT:    movapd %xmm5, 320(%rax)
; SSE-NEXT:    movapd %xmm7, 304(%rax)
; SSE-NEXT:    movapd %xmm12, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movapd %xmm9, 256(%rax)
; SSE-NEXT:    movapd %xmm11, 240(%rax)
; SSE-NEXT:    movapd %xmm15, 224(%rax)
; SSE-NEXT:    movapd %xmm13, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movapd %xmm14, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $88, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride7_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    pushq %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm7
; AVX1-ONLY-NEXT:    vmovaps (%r9), %ymm3
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 16(%rax), %xmm0
; AVX1-ONLY-NEXT:    vmovapd 32(%rax), %xmm8
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm1[1],ymm2[3],ymm1[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 32(%r8), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm10
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm10[1],xmm6[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%rcx), %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm11[4,5,6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm12
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm9
; AVX1-ONLY-NEXT:    vmovapd 32(%r9), %xmm14
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm4[0],xmm14[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3,4,5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm10 = xmm11[0],xmm10[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rcx), %ymm10, %ymm11
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm10, %ymm6
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm11[1],ymm6[2],ymm11[2]
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%rcx), %ymm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm10
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm11 = xmm10[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0,1],ymm7[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm12
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm11[6,7]
; AVX1-ONLY-NEXT:    vmovaps 16(%rcx), %xmm13
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm11 = xmm13[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 16(%r8), %xmm15
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm15 = ymm3[1],ymm15[1],ymm3[3],ymm15[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm15[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm12 = xmm12[0],xmm9[0]
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm15
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm12, %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1],ymm0[2,3],ymm12[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm14[1],xmm8[1]
; AVX1-ONLY-NEXT:    vmovapd 32(%rdi), %ymm8
; AVX1-ONLY-NEXT:    vmovapd 32(%rsi), %ymm14
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm8[0],ymm14[0],ymm8[2],ymm14[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm8 = ymm0[0,1],ymm8[2,3]
; AVX1-ONLY-NEXT:    vmovapd 48(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm14 = ymm14[0,0,3,2]
; AVX1-ONLY-NEXT:    vmovapd 32(%rax), %ymm1
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm1[2,3],ymm14[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm14[0],ymm0[1],ymm14[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovapd 32(%r8), %ymm14
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm14[0],mem[0],ymm14[2],mem[2]
; AVX1-ONLY-NEXT:    vmovapd 48(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovapd 48(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0,1],ymm14[2,3]
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm14
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm14 = ymm14[0],mem[0],ymm14[2],mem[2]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm9[1],xmm5[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm14[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm9[0],ymm3[0],ymm9[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovaps 16(%rdx), %xmm9
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm9[0],xmm13[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm9[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 56(%r9), %ymm9
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm9[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm15[0],xmm10[0]
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm9 = xmm9[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps %xmm9, 16(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm1, (%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 128(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 96(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm4, 352(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm2, 384(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm8, 320(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm12, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 192(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 64(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm6, 224(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 416(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    popq %rax
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride7_vf8:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm7
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm5
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %ymm10
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovaps 16(%rax), %xmm0
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm12
; AVX2-ONLY-NEXT:    vmovaps 48(%rax), %xmm13
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm4[1],ymm7[1],ymm4[3],ymm7[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm15
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %xmm6
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm11 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm11[1],xmm6[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm14[4,5,6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],mem[0],ymm3[2],mem[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm11 = ymm10[0],mem[0],ymm10[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm11[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm4[0],ymm7[0],ymm4[2],ymm7[2]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm7 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm7[1],xmm2[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm11
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm15 = xmm15[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm15, %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm15[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm15 = ymm8[1],ymm9[1],ymm8[3],ymm9[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm15[0,1,2,3,4,5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm13[0,1],ymm10[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm13
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rcx), %ymm13, %ymm13
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm11, %ymm15
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm15[0],ymm13[0],ymm15[2],ymm13[2]
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm15
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm8[0],ymm9[0],ymm8[2],ymm9[2]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm9 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm9[1],xmm12[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm9 = mem[0,0]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%rcx), %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm5[0,1,2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1],ymm12[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vmovaps (%r8), %ymm12
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm5[0],mem[0],ymm5[2],mem[2]
; AVX2-ONLY-NEXT:    vmovaps (%r9), %ymm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm12[0],ymm0[0],ymm12[2],ymm0[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm5[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%rcx), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%r9), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm5 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm5
; AVX2-ONLY-NEXT:    vbroadcastsd 32(%rcx), %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm15[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm6, %ymm6
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm2, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1,2,3],ymm2[4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm12[1],ymm0[1],ymm12[3],ymm0[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%rcx), %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 320(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm13, (%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 384(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 256(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 96(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 224(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 416(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-ONLY-SLOW-LABEL: store_i64_stride7_vf8:
; AVX512F-ONLY-SLOW:       # %bb.0:
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r8), %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r10), %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [15,7,15,7,15,7,15,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [0,8,0,8,0,8,0,8]
; AVX512F-ONLY-SLOW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,0,14,6,5,0,14,6]
; AVX512F-ONLY-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm7, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [9,1,9,1,9,1,9,1]
; AVX512F-ONLY-SLOW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [4,12,0,5,4,12,0,5]
; AVX512F-ONLY-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm5, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [15,7,15,7]
; AVX512F-ONLY-SLOW-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    movb $24, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm7 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    movb $96, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm7 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [14,1,2,3,4,5,6,15]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm7, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,0,1,0,8,0,1]
; AVX512F-ONLY-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rdx), %xmm7
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm7 = xmm7[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512F-ONLY-SLOW-NEXT:    movb $12, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm7, %zmm0, %zmm6 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, (%r10), %zmm8, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    movb $112, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,13,6,7,0,13,6,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512F-ONLY-SLOW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [6,14,6,14]
; AVX512F-ONLY-SLOW-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm9[0,1,2,3],zmm8[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $-61, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [11,3,11,3,11,3,11,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [2,10,0,3,2,10,0,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%r9), %ymm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%r8), %ymm12
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm13 = ymm12[0],ymm7[0],ymm12[2],ymm7[2]
; AVX512F-ONLY-SLOW-NEXT:    movb $28, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm9 {%k2} = zmm13[0,1,2,3],zmm4[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [1,0,10,2,1,0,10,2]
; AVX512F-ONLY-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm14
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = mem[0,1,2,3],ymm14[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $6, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm14, %zmm0, %zmm13 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [4,9,0,3,4,9,0,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm10, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    movb $56, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm13 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [13,5,13,5,13,5,13,5]
; AVX512F-ONLY-SLOW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [3,0,12,4,3,0,12,4]
; AVX512F-ONLY-SLOW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm10, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm10 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,1,12,7,0,1,12,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm11, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    movb $120, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm2 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    movb $48, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm14 {%k1} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm12[1],ymm7[1],ymm12[3],ymm7[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $14, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm14 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, 256(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, 64(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, 128(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, 320(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, 384(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, 192(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vzeroupper
; AVX512F-ONLY-SLOW-NEXT:    retq
;
; AVX512F-ONLY-FAST-LABEL: store_i64_stride7_vf8:
; AVX512F-ONLY-FAST:       # %bb.0:
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r8), %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r9), %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r10), %zmm4
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [15,7,15,7,15,7,15,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [0,8,0,8,0,8,0,8]
; AVX512F-ONLY-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm7, %zmm6, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,0,14,6,5,0,14,6]
; AVX512F-ONLY-FAST-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm6, %zmm7, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [9,1,9,1,9,1,9,1]
; AVX512F-ONLY-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm7, %zmm6, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [4,12,0,5,4,12,0,5]
; AVX512F-ONLY-FAST-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm7, %zmm6, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm5, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [15,7,15,7]
; AVX512F-ONLY-FAST-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512F-ONLY-FAST-NEXT:    movb $24, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm7 {%k1}
; AVX512F-ONLY-FAST-NEXT:    movb $96, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm7 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [14,1,2,3,4,5,6,15]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm7, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,0,1,0,8,0,1]
; AVX512F-ONLY-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%rdx), %xmm7
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm7 = xmm7[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512F-ONLY-FAST-NEXT:    movb $12, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm7, %zmm0, %zmm6 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, (%r10), %zmm8, %zmm7
; AVX512F-ONLY-FAST-NEXT:    movb $112, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,13,6,7,0,13,6,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512F-ONLY-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [6,14,6,14]
; AVX512F-ONLY-FAST-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm9[0,1,2,3],zmm8[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    movb $-61, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,0,12,4,3,0,12,4]
; AVX512F-ONLY-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm3, %zmm7
; AVX512F-ONLY-FAST-NEXT:    movb $48, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm7 {%k2} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%r9), %ymm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%r8), %ymm12
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <1,3,7,u>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %ymm9, %ymm12, %ymm13
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    movb $14, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm13, %zmm0, %zmm7 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [11,3,11,3,11,3,11,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [2,10,0,3,2,10,0,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm14 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm12[0],ymm9[0],ymm12[2],ymm9[2]
; AVX512F-ONLY-FAST-NEXT:    movb $28, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k2} = zmm9[0,1,2,3],zmm4[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [1,0,10,2,1,0,10,2]
; AVX512F-ONLY-FAST-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm1, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm12
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm12 = mem[0,1,2,3],ymm12[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    movb $6, %cl
; AVX512F-ONLY-FAST-NEXT:    kmovw %ecx, %k2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm12, %zmm0, %zmm9 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [4,9,0,3,4,9,0,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm10, %zmm12
; AVX512F-ONLY-FAST-NEXT:    movb $56, %cl
; AVX512F-ONLY-FAST-NEXT:    kmovw %ecx, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm9 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [13,5,13,5,13,5,13,5]
; AVX512F-ONLY-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm10, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm10, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,1,12,7,0,1,12,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm11, %zmm1
; AVX512F-ONLY-FAST-NEXT:    movb $120, %cl
; AVX512F-ONLY-FAST-NEXT:    kmovw %ecx, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, 256(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, 128(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, 192(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, 320(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, 384(%rax)
; AVX512F-ONLY-FAST-NEXT:    vzeroupper
; AVX512F-ONLY-FAST-NEXT:    retq
;
; AVX512DQ-SLOW-LABEL: store_i64_stride7_vf8:
; AVX512DQ-SLOW:       # %bb.0:
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r8), %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r10), %zmm4
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [5,0,14,6,5,0,14,6]
; AVX512DQ-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm7, %zmm8, %zmm5
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,13,6,7,0,13,6,7]
; AVX512DQ-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm6
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [6,14,6,14,6,14,6,14]
; AVX512DQ-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm5
; AVX512DQ-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [6,14,6,14]
; AVX512DQ-SLOW-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm9
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm9[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    movb $-61, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm5 {%k1}
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm9 = [11,3,11,3,11,3,11,3]
; AVX512DQ-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm9
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [2,10,0,3,2,10,0,3]
; AVX512DQ-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512DQ-SLOW-NEXT:    movb $96, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm6 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa (%r9), %ymm9
; AVX512DQ-SLOW-NEXT:    vmovdqa (%r8), %ymm10
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm11 = ymm10[0],ymm9[0],ymm10[2],ymm9[2]
; AVX512DQ-SLOW-NEXT:    movb $28, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k2
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm6 {%k2} = zmm11[0,1,2,3],zmm4[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm11 = [15,7,15,7,15,7,15,7]
; AVX512DQ-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [9,1,9,1,9,1,9,1]
; AVX512DQ-SLOW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm12
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [0,8,0,8,0,8,0,8]
; AVX512DQ-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm13
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [4,12,0,5,4,12,0,5]
; AVX512DQ-SLOW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm14
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm11, %zmm7
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm11
; AVX512DQ-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [15,7,15,7]
; AVX512DQ-SLOW-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm8
; AVX512DQ-SLOW-NEXT:    movb $24, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm8 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [14,1,2,3,4,5,6,15]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm4, %zmm8, %zmm7
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,0,10,2,1,0,10,2]
; AVX512DQ-SLOW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm8
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm11
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = mem[0,1,2,3],ymm11[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    movb $6, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k2
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm8 {%k2}
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [4,9,0,3,4,9,0,3]
; AVX512DQ-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm4, %zmm12, %zmm11
; AVX512DQ-SLOW-NEXT:    movb $56, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm8 {%k2}
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [0,8,0,1,0,8,0,1]
; AVX512DQ-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm11
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rdx), %xmm12
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm12 = xmm12[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512DQ-SLOW-NEXT:    movb $12, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm12, %zmm0, %zmm11 {%k2}
; AVX512DQ-SLOW-NEXT:    movb $112, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, (%r10), %zmm13, %zmm11 {%k2}
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [13,5,13,5,13,5,13,5]
; AVX512DQ-SLOW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [3,0,12,4,3,0,12,4]
; AVX512DQ-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm13
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm12, %zmm2
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,1,12,7,0,1,12,7]
; AVX512DQ-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm4, %zmm14, %zmm2
; AVX512DQ-SLOW-NEXT:    movb $120, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm2 {%k1}
; AVX512DQ-SLOW-NEXT:    movb $48, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm13 {%k1} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm10[1],ymm9[1],ymm10[3],ymm9[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    movb $14, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm13 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, 256(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, 192(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512DQ-SLOW-NEXT:    vzeroupper
; AVX512DQ-SLOW-NEXT:    retq
;
; AVX512DQ-FAST-LABEL: store_i64_stride7_vf8:
; AVX512DQ-FAST:       # %bb.0:
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r8), %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r10), %zmm4
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [5,0,14,6,5,0,14,6]
; AVX512DQ-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm7, %zmm8, %zmm5
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,13,6,7,0,13,6,7]
; AVX512DQ-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm4, %zmm5, %zmm6
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [6,14,6,14,6,14,6,14]
; AVX512DQ-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm5
; AVX512DQ-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [6,14,6,14]
; AVX512DQ-FAST-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm9
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm9[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQ-FAST-NEXT:    movb $-61, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, %zmm5 {%k1}
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [3,0,12,4,3,0,12,4]
; AVX512DQ-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm2, %zmm3, %zmm6
; AVX512DQ-FAST-NEXT:    movb $48, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k1
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm6 {%k1} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; AVX512DQ-FAST-NEXT:    vmovdqa (%r9), %ymm10
; AVX512DQ-FAST-NEXT:    vmovdqa (%r8), %ymm11
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <1,3,7,u>
; AVX512DQ-FAST-NEXT:    vpermi2q %ymm10, %ymm11, %ymm9
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-FAST-NEXT:    movb $14, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k1
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm6 {%k1}
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [11,3,11,3,11,3,11,3]
; AVX512DQ-FAST-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [2,10,0,3,2,10,0,3]
; AVX512DQ-FAST-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm9
; AVX512DQ-FAST-NEXT:    movb $96, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, %zmm9 {%k1}
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm10 = ymm11[0],ymm10[0],ymm11[2],ymm10[2]
; AVX512DQ-FAST-NEXT:    movb $28, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k2
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm9 {%k2} = zmm10[0,1,2,3],zmm4[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [15,7,15,7,15,7,15,7]
; AVX512DQ-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm11 = [9,1,9,1,9,1,9,1]
; AVX512DQ-FAST-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm8, %zmm7, %zmm11
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [0,8,0,8,0,8,0,8]
; AVX512DQ-FAST-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm8, %zmm7, %zmm12
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [4,12,0,5,4,12,0,5]
; AVX512DQ-FAST-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm8, %zmm7, %zmm13
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm8, %zmm10, %zmm7
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm10
; AVX512DQ-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [15,7,15,7]
; AVX512DQ-FAST-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm8
; AVX512DQ-FAST-NEXT:    movb $24, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [14,1,2,3,4,5,6,15]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm4, %zmm8, %zmm7
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,0,10,2,1,0,10,2]
; AVX512DQ-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm0, %zmm1, %zmm8
; AVX512DQ-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm10
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = mem[0,1,2,3],ymm10[4,5,6,7]
; AVX512DQ-FAST-NEXT:    movb $6, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k2
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm10, %zmm0, %zmm8 {%k2}
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [4,9,0,3,4,9,0,3]
; AVX512DQ-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm4, %zmm11, %zmm10
; AVX512DQ-FAST-NEXT:    movb $56, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k2}
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [0,8,0,1,0,8,0,1]
; AVX512DQ-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqa (%rdx), %xmm11
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm11[0],mem[0]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQ-FAST-NEXT:    movb $12, %cl
; AVX512DQ-FAST-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm10 {%k2}
; AVX512DQ-FAST-NEXT:    movb $112, %cl
; AVX512DQ-FAST-NEXT:    kmovw %ecx, %k2
; AVX512DQ-FAST-NEXT:    vinserti64x2 $3, (%r10), %zmm12, %zmm10 {%k2}
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm11 = [13,5,13,5,13,5,13,5]
; AVX512DQ-FAST-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm11, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm11, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,1,12,7,0,1,12,7]
; AVX512DQ-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm4, %zmm13, %zmm1
; AVX512DQ-FAST-NEXT:    movb $120, %cl
; AVX512DQ-FAST-NEXT:    kmovw %ecx, %k1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, 256(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm10, (%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, 128(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, 192(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512DQ-FAST-NEXT:    vzeroupper
; AVX512DQ-FAST-NEXT:    retq
;
; AVX512BW-ONLY-SLOW-LABEL: store_i64_stride7_vf8:
; AVX512BW-ONLY-SLOW:       # %bb.0:
; AVX512BW-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%r8), %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%r10), %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [15,7,15,7,15,7,15,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [0,8,0,8,0,8,0,8]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,0,14,6,5,0,14,6]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm7, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [9,1,9,1,9,1,9,1]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [4,12,0,5,4,12,0,5]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm5, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [15,7,15,7]
; AVX512BW-ONLY-SLOW-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    movb $24, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm7 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    movb $96, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm7 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [14,1,2,3,4,5,6,15]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm7, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,0,1,0,8,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa (%rdx), %xmm7
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm7 = xmm7[0],mem[0]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512BW-ONLY-SLOW-NEXT:    movb $12, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm7, %zmm0, %zmm6 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $3, (%r10), %zmm8, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    movb $112, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,13,6,7,0,13,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [6,14,6,14]
; AVX512BW-ONLY-SLOW-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm9[0,1,2,3],zmm8[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    movb $-61, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [11,3,11,3,11,3,11,3]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [2,10,0,3,2,10,0,3]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm9 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa (%r9), %ymm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa (%r8), %ymm12
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm13 = ymm12[0],ymm7[0],ymm12[2],ymm7[2]
; AVX512BW-ONLY-SLOW-NEXT:    movb $28, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm9 {%k2} = zmm13[0,1,2,3],zmm4[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [1,0,10,2,1,0,10,2]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm14
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = mem[0,1,2,3],ymm14[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    movb $6, %cl
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %ecx, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm14, %zmm0, %zmm13 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [4,9,0,3,4,9,0,3]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm10, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    movb $56, %cl
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %ecx, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm13 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [13,5,13,5,13,5,13,5]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [3,0,12,4,3,0,12,4]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm10, %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm10 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,1,12,7,0,1,12,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm11, %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    movb $120, %cl
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm2 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    movb $48, %cl
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm14 {%k1} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; AVX512BW-ONLY-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm12[1],ymm7[1],ymm12[3],ymm7[3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-SLOW-NEXT:    movb $14, %cl
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm14 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, 256(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, 64(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, 128(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, 320(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, 384(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, 192(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vzeroupper
; AVX512BW-ONLY-SLOW-NEXT:    retq
;
; AVX512BW-ONLY-FAST-LABEL: store_i64_stride7_vf8:
; AVX512BW-ONLY-FAST:       # %bb.0:
; AVX512BW-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%r8), %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%r9), %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%r10), %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [15,7,15,7,15,7,15,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [0,8,0,8,0,8,0,8]
; AVX512BW-ONLY-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm7, %zmm6, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,0,14,6,5,0,14,6]
; AVX512BW-ONLY-FAST-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm6, %zmm7, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [9,1,9,1,9,1,9,1]
; AVX512BW-ONLY-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm7, %zmm6, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [4,12,0,5,4,12,0,5]
; AVX512BW-ONLY-FAST-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm7, %zmm6, %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm5, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [15,7,15,7]
; AVX512BW-ONLY-FAST-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    movb $24, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm7 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    movb $96, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm7 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [14,1,2,3,4,5,6,15]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm7, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,0,1,0,8,0,1]
; AVX512BW-ONLY-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa (%rdx), %xmm7
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm7 = xmm7[0],mem[0]
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm7, %ymm0, %ymm7
; AVX512BW-ONLY-FAST-NEXT:    movb $12, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm7, %zmm0, %zmm6 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $3, (%r10), %zmm8, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    movb $112, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,13,6,7,0,13,6,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512BW-ONLY-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [6,14,6,14]
; AVX512BW-ONLY-FAST-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm9[0,1,2,3],zmm8[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    movb $-61, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [3,0,12,4,3,0,12,4]
; AVX512BW-ONLY-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm3, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    movb $48, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm7 {%k2} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa (%r9), %ymm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa (%r8), %ymm12
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm13 = <1,3,7,u>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %ymm9, %ymm12, %ymm13
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-FAST-NEXT:    movb $14, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm13, %zmm0, %zmm7 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [11,3,11,3,11,3,11,3]
; AVX512BW-ONLY-FAST-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [2,10,0,3,2,10,0,3]
; AVX512BW-ONLY-FAST-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm14 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm9 = ymm12[0],ymm9[0],ymm12[2],ymm9[2]
; AVX512BW-ONLY-FAST-NEXT:    movb $28, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k2} = zmm9[0,1,2,3],zmm4[2,3,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [1,0,10,2,1,0,10,2]
; AVX512BW-ONLY-FAST-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm1, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm12
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm12 = mem[0,1,2,3],ymm12[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    movb $6, %cl
; AVX512BW-ONLY-FAST-NEXT:    kmovd %ecx, %k2
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm12, %zmm0, %zmm9 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [4,9,0,3,4,9,0,3]
; AVX512BW-ONLY-FAST-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm10, %zmm12
; AVX512BW-ONLY-FAST-NEXT:    movb $56, %cl
; AVX512BW-ONLY-FAST-NEXT:    kmovd %ecx, %k2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm9 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [13,5,13,5,13,5,13,5]
; AVX512BW-ONLY-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm10, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm10, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,1,12,7,0,1,12,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm11, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    movb $120, %cl
; AVX512BW-ONLY-FAST-NEXT:    kmovd %ecx, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, 256(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, 128(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, 192(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, 320(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, 384(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vzeroupper
; AVX512BW-ONLY-FAST-NEXT:    retq
;
; AVX512DQBW-SLOW-LABEL: store_i64_stride7_vf8:
; AVX512DQBW-SLOW:       # %bb.0:
; AVX512DQBW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%r8), %zmm7
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%r10), %zmm4
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [5,0,14,6,5,0,14,6]
; AVX512DQBW-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm7, %zmm8, %zmm5
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,13,6,7,0,13,6,7]
; AVX512DQBW-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm4, %zmm5, %zmm6
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [6,14,6,14,6,14,6,14]
; AVX512DQBW-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm5
; AVX512DQBW-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [6,14,6,14]
; AVX512DQBW-SLOW-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm9
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm9[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    movb $-61, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm5 {%k1}
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm9 = [11,3,11,3,11,3,11,3]
; AVX512DQBW-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm9
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [2,10,0,3,2,10,0,3]
; AVX512DQBW-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512DQBW-SLOW-NEXT:    movb $96, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm6 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqa (%r9), %ymm9
; AVX512DQBW-SLOW-NEXT:    vmovdqa (%r8), %ymm10
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm11 = ymm10[0],ymm9[0],ymm10[2],ymm9[2]
; AVX512DQBW-SLOW-NEXT:    movb $28, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k2
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm6 {%k2} = zmm11[0,1,2,3],zmm4[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm11 = [15,7,15,7,15,7,15,7]
; AVX512DQBW-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [9,1,9,1,9,1,9,1]
; AVX512DQBW-SLOW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm12
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [0,8,0,8,0,8,0,8]
; AVX512DQBW-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm13
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [4,12,0,5,4,12,0,5]
; AVX512DQBW-SLOW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm14
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm8, %zmm11, %zmm7
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm11
; AVX512DQBW-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [15,7,15,7]
; AVX512DQBW-SLOW-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm8
; AVX512DQBW-SLOW-NEXT:    movb $24, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm8 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [14,1,2,3,4,5,6,15]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm4, %zmm8, %zmm7
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,0,10,2,1,0,10,2]
; AVX512DQBW-SLOW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm8
; AVX512DQBW-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm11
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm11 = mem[0,1,2,3],ymm11[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    movb $6, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k2
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm8 {%k2}
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [4,9,0,3,4,9,0,3]
; AVX512DQBW-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm4, %zmm12, %zmm11
; AVX512DQBW-SLOW-NEXT:    movb $56, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm8 {%k2}
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [0,8,0,1,0,8,0,1]
; AVX512DQBW-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqa (%rdx), %xmm12
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm12 = xmm12[0],mem[0]
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX512DQBW-SLOW-NEXT:    movb $12, %cl
; AVX512DQBW-SLOW-NEXT:    kmovd %ecx, %k2
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm12, %zmm0, %zmm11 {%k2}
; AVX512DQBW-SLOW-NEXT:    movb $112, %cl
; AVX512DQBW-SLOW-NEXT:    kmovd %ecx, %k2
; AVX512DQBW-SLOW-NEXT:    vinserti64x2 $3, (%r10), %zmm13, %zmm11 {%k2}
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [13,5,13,5,13,5,13,5]
; AVX512DQBW-SLOW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [3,0,12,4,3,0,12,4]
; AVX512DQBW-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm13
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm12, %zmm2
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,1,12,7,0,1,12,7]
; AVX512DQBW-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm4, %zmm14, %zmm2
; AVX512DQBW-SLOW-NEXT:    movb $120, %cl
; AVX512DQBW-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm2 {%k1}
; AVX512DQBW-SLOW-NEXT:    movb $48, %cl
; AVX512DQBW-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm13 {%k1} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; AVX512DQBW-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm10[1],ymm9[1],ymm10[3],ymm9[3]
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-SLOW-NEXT:    movb $14, %cl
; AVX512DQBW-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm13 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, 256(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, (%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, 192(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512DQBW-SLOW-NEXT:    vzeroupper
; AVX512DQBW-SLOW-NEXT:    retq
;
; AVX512DQBW-FAST-LABEL: store_i64_stride7_vf8:
; AVX512DQBW-FAST:       # %bb.0:
; AVX512DQBW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%r8), %zmm7
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%r10), %zmm4
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [5,0,14,6,5,0,14,6]
; AVX512DQBW-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm7, %zmm8, %zmm5
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,13,6,7,0,13,6,7]
; AVX512DQBW-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm4, %zmm5, %zmm6
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [6,14,6,14,6,14,6,14]
; AVX512DQBW-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm5
; AVX512DQBW-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm9 = [6,14,6,14]
; AVX512DQBW-FAST-NEXT:    # ymm9 = mem[0,1,0,1]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm9
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm9[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    movb $-61, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm5 {%k1}
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [3,0,12,4,3,0,12,4]
; AVX512DQBW-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm2, %zmm3, %zmm6
; AVX512DQBW-FAST-NEXT:    movb $48, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k1
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm6 {%k1} = zmm0[0],zmm1[0],zmm0[2],zmm1[2],zmm0[4],zmm1[4],zmm0[6],zmm1[6]
; AVX512DQBW-FAST-NEXT:    vmovdqa (%r9), %ymm10
; AVX512DQBW-FAST-NEXT:    vmovdqa (%r8), %ymm11
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm9 = <1,3,7,u>
; AVX512DQBW-FAST-NEXT:    vpermi2q %ymm10, %ymm11, %ymm9
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-FAST-NEXT:    movb $14, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k1
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm6 {%k1}
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [11,3,11,3,11,3,11,3]
; AVX512DQBW-FAST-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm12
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [2,10,0,3,2,10,0,3]
; AVX512DQBW-FAST-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm9
; AVX512DQBW-FAST-NEXT:    movb $96, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm9 {%k1}
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm10 = ymm11[0],ymm10[0],ymm11[2],ymm10[2]
; AVX512DQBW-FAST-NEXT:    movb $28, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k2
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm9 {%k2} = zmm10[0,1,2,3],zmm4[2,3,0,1]
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [15,7,15,7,15,7,15,7]
; AVX512DQBW-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm11 = [9,1,9,1,9,1,9,1]
; AVX512DQBW-FAST-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm8, %zmm7, %zmm11
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [0,8,0,8,0,8,0,8]
; AVX512DQBW-FAST-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm8, %zmm7, %zmm12
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm13 = [4,12,0,5,4,12,0,5]
; AVX512DQBW-FAST-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm8, %zmm7, %zmm13
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm8, %zmm10, %zmm7
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm10
; AVX512DQBW-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [15,7,15,7]
; AVX512DQBW-FAST-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm8
; AVX512DQBW-FAST-NEXT:    movb $24, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [14,1,2,3,4,5,6,15]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm4, %zmm8, %zmm7
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,0,10,2,1,0,10,2]
; AVX512DQBW-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm0, %zmm1, %zmm8
; AVX512DQBW-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm10
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm10 = mem[0,1,2,3],ymm10[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    movb $6, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k2
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm10, %zmm0, %zmm8 {%k2}
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [4,9,0,3,4,9,0,3]
; AVX512DQBW-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm4, %zmm11, %zmm10
; AVX512DQBW-FAST-NEXT:    movb $56, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm8 {%k2}
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [0,8,0,1,0,8,0,1]
; AVX512DQBW-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm10
; AVX512DQBW-FAST-NEXT:    vmovdqa (%rdx), %xmm11
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm11[0],mem[0]
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQBW-FAST-NEXT:    movb $12, %cl
; AVX512DQBW-FAST-NEXT:    kmovd %ecx, %k2
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm10 {%k2}
; AVX512DQBW-FAST-NEXT:    movb $112, %cl
; AVX512DQBW-FAST-NEXT:    kmovd %ecx, %k2
; AVX512DQBW-FAST-NEXT:    vinserti64x2 $3, (%r10), %zmm12, %zmm10 {%k2}
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm11 = [13,5,13,5,13,5,13,5]
; AVX512DQBW-FAST-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm11, %zmm2
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm11, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k1}
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,1,12,7,0,1,12,7]
; AVX512DQBW-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm4, %zmm13, %zmm1
; AVX512DQBW-FAST-NEXT:    movb $120, %cl
; AVX512DQBW-FAST-NEXT:    kmovd %ecx, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, 256(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, (%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm8, 64(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm7, 384(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm9, 128(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm6, 192(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512DQBW-FAST-NEXT:    vzeroupper
; AVX512DQBW-FAST-NEXT:    retq
  %in.vec0 = load <8 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <8 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <8 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <8 x i64>, ptr %in.vecptr6, align 64
  %1 = shufflevector <8 x i64> %in.vec0, <8 x i64> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i64> %in.vec2, <8 x i64> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <8 x i64> %in.vec4, <8 x i64> %in.vec5, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <16 x i64> %1, <16 x i64> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %5 = shufflevector <8 x i64> %in.vec6, <8 x i64> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <16 x i64> %3, <16 x i64> %5, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %7 = shufflevector <24 x i64> %6, <24 x i64> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <32 x i64> %4, <32 x i64> %7, <56 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55>
  %interleaved.vec = shufflevector <56 x i64> %8, <56 x i64> poison, <56 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 40, i32 48, i32 1, i32 9, i32 17, i32 25, i32 33, i32 41, i32 49, i32 2, i32 10, i32 18, i32 26, i32 34, i32 42, i32 50, i32 3, i32 11, i32 19, i32 27, i32 35, i32 43, i32 51, i32 4, i32 12, i32 20, i32 28, i32 36, i32 44, i32 52, i32 5, i32 13, i32 21, i32 29, i32 37, i32 45, i32 53, i32 6, i32 14, i32 22, i32 30, i32 38, i32 46, i32 54, i32 7, i32 15, i32 23, i32 31, i32 39, i32 47, i32 55>
  store <56 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride7_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride7_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $536, %rsp # imm = 0x218
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd (%rdi), %xmm2
; SSE-NEXT:    movapd 16(%rdi), %xmm3
; SSE-NEXT:    movapd 32(%rdi), %xmm6
; SSE-NEXT:    movapd (%rsi), %xmm4
; SSE-NEXT:    movapd 16(%rsi), %xmm7
; SSE-NEXT:    movapd (%rdx), %xmm5
; SSE-NEXT:    movapd 16(%rdx), %xmm8
; SSE-NEXT:    movapd (%rcx), %xmm9
; SSE-NEXT:    movapd 16(%rcx), %xmm11
; SSE-NEXT:    movapd (%r8), %xmm10
; SSE-NEXT:    movapd 16(%r8), %xmm12
; SSE-NEXT:    movapd (%r9), %xmm13
; SSE-NEXT:    movapd 16(%r9), %xmm15
; SSE-NEXT:    movapd (%rax), %xmm0
; SSE-NEXT:    movapd 16(%rax), %xmm1
; SSE-NEXT:    movapd %xmm2, %xmm14
; SSE-NEXT:    unpcklpd {{.*#+}} xmm14 = xmm14[0],xmm4[0]
; SSE-NEXT:    movapd %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm0[0],xmm2[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm5[1]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm5 = xmm5[0],xmm9[0]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm10[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm10 = xmm10[0],xmm13[0]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movapd %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm3, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm7[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm1[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm8[1]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm8 = xmm8[0],xmm11[0]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm12[1]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm12 = xmm12[0],xmm15[0]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm1[1]
; SSE-NEXT:    movapd %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rsi), %xmm1
; SSE-NEXT:    movapd %xmm6, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm0[0],xmm6[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rdx), %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rcx), %xmm3
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rdi), %xmm1
; SSE-NEXT:    movapd 48(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rdi), %xmm1
; SSE-NEXT:    movapd 64(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdi), %xmm1
; SSE-NEXT:    movapd 80(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rcx), %xmm14
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm14[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm1[1]
; SSE-NEXT:    movapd 80(%r9), %xmm13
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm13[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movapd 96(%rdi), %xmm15
; SSE-NEXT:    movapd 96(%rsi), %xmm12
; SSE-NEXT:    movapd %xmm15, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm12[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rax), %xmm3
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm3[0],xmm15[1]
; SSE-NEXT:    movapd 96(%rdx), %xmm11
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm11[1]
; SSE-NEXT:    movapd 96(%rcx), %xmm7
; SSE-NEXT:    unpcklpd {{.*#+}} xmm11 = xmm11[0],xmm7[0]
; SSE-NEXT:    movapd 96(%r8), %xmm9
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm9[1]
; SSE-NEXT:    movapd 96(%r9), %xmm5
; SSE-NEXT:    unpcklpd {{.*#+}} xmm9 = xmm9[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-NEXT:    movapd 112(%rdi), %xmm6
; SSE-NEXT:    movapd 112(%rsi), %xmm4
; SSE-NEXT:    movapd %xmm6, %xmm8
; SSE-NEXT:    unpcklpd {{.*#+}} xmm8 = xmm8[0],xmm4[0]
; SSE-NEXT:    movapd 112(%rax), %xmm10
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm10[0],xmm6[1]
; SSE-NEXT:    movapd 112(%rdx), %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    movapd 112(%rcx), %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm3 = xmm3[0],xmm1[0]
; SSE-NEXT:    movapd 112(%r8), %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movapd 112(%r9), %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm10[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm0, 880(%rax)
; SSE-NEXT:    movapd %xmm1, 864(%rax)
; SSE-NEXT:    movapd %xmm4, 848(%rax)
; SSE-NEXT:    movapd %xmm6, 832(%rax)
; SSE-NEXT:    movapd %xmm2, 816(%rax)
; SSE-NEXT:    movapd %xmm3, 800(%rax)
; SSE-NEXT:    movapd %xmm8, 784(%rax)
; SSE-NEXT:    movapd %xmm5, 768(%rax)
; SSE-NEXT:    movapd %xmm7, 752(%rax)
; SSE-NEXT:    movapd %xmm12, 736(%rax)
; SSE-NEXT:    movapd %xmm15, 720(%rax)
; SSE-NEXT:    movapd %xmm9, 704(%rax)
; SSE-NEXT:    movapd %xmm11, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rax)
; SSE-NEXT:    movapd %xmm13, 656(%rax)
; SSE-NEXT:    movapd %xmm14, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $536, %rsp # imm = 0x218
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride7_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $520, %rsp # imm = 0x208
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm5
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%r9), %ymm6
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm7
; AVX1-ONLY-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 16(%rax), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm5[1],ymm1[1],ymm5[3],ymm1[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 16(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 16(%r8), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm6[1],ymm1[1],ymm6[3],ymm1[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rcx), %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %xmm12
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm11
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm11[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %ymm10
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm10[1],ymm0[1],ymm10[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %ymm9
; AVX1-ONLY-NEXT:    vmovaps 48(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm9[1],ymm0[1],ymm9[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rcx), %xmm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm7[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %xmm8
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm0[0],xmm8[0]
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 64(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vbroadcastsd 72(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm15
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm14 = xmm15[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm14[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %ymm5
; AVX1-ONLY-NEXT:    vmovaps 80(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm5[1],ymm0[1],ymm5[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 80(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %ymm4
; AVX1-ONLY-NEXT:    vmovaps 80(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm4[1],ymm0[1],ymm4[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 80(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm13 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm13[0,1],ymm14[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm13
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm14
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm14[0],xmm13[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%rcx), %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm2[1],ymm0[2],ymm2[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %xmm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm14 = xmm2[0],mem[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%rax), %ymm14, %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm14[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm13[1],xmm1[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 104(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 16(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm10[0],ymm0[2],ymm10[2]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm11[1],xmm12[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm9[0],ymm0[2],ymm9[2]
; AVX1-ONLY-NEXT:    vmovaps 48(%rdx), %xmm9
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm9[0],xmm7[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm5[0],ymm0[2],ymm5[2]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm8[1],xmm6[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovaps 80(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 96(%rdi), %ymm3
; AVX1-ONLY-NEXT:    vmovapd 96(%rsi), %ymm4
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovddup {{.*#+}} xmm6 = mem[0,0]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vmovapd 112(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[0,0,3,2]
; AVX1-ONLY-NEXT:    vmovapd 96(%rax), %ymm8
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm8[2,3],ymm4[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0],ymm6[1],ymm4[2],ymm6[3]
; AVX1-ONLY-NEXT:    vmovapd 112(%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovapd 112(%rdx), %xmm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm9 = xmm9[0],xmm6[0]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm9 = ymm9[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 112(%r9), %ymm10
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm9 = ymm9[0,1,2],ymm10[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 120(%r9), %ymm10
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0,1],ymm10[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0],ymm8[1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0,1,2],ymm8[3]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm8 = xmm8[0],xmm15[0]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm10 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm10 = xmm10[0],mem[0]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %xmm11
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm11 = xmm11[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm12
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm12 = xmm12[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps %xmm12, 16(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm10, (%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm11, 464(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm8, 448(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm4, 832(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm3, 768(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 544(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 352(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 320(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 128(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm13, 96(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm6, 864(%rax)
; AVX1-ONLY-NEXT:    vmovapd %ymm9, 800(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm14, 736(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    addq $520, %rsp # imm = 0x208
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride7_vf16:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $520, %rsp # imm = 0x208
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %ymm7
; AVX2-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm12
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm4
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm10
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %ymm15
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %ymm13
; AVX2-ONLY-NEXT:    vmovaps 16(%rax), %xmm3
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm0
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm2[1],ymm4[1],ymm2[3],ymm4[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm5[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm5
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm5[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm6, %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %xmm6
; AVX2-ONLY-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm6[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%rcx), %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 48(%rax), %xmm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm12[1],ymm10[1],ymm12[3],ymm10[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm7[1],ymm15[1],ymm7[3],ymm15[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm5 = ymm3[0,2,3,3]
; AVX2-ONLY-NEXT:    vmovaps 64(%rdx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovaps 80(%rax), %xmm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1],ymm5[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %xmm5
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm5[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 96(%rax), %ymm6, %ymm6
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %xmm7
; AVX2-ONLY-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm6 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 104(%rcx), %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm11[1],ymm9[1],ymm11[3],ymm9[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[0,2,3,3]
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %ymm6
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vmovaps 112(%rax), %xmm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1],ymm5[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm5
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rcx), %ymm5, %ymm5
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm14
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm14, %ymm6
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm6[0],ymm5[0],ymm6[2],ymm5[2]
; AVX2-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%rcx), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm1[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm6 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1],ymm5[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm7
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],ymm4[0],ymm2[2],ymm4[2]
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm8
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm4 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm4[1],xmm8[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2]
; AVX2-ONLY-NEXT:    vmovaps (%r8), %ymm5
; AVX2-ONLY-NEXT:    vmovaps (%r9), %ymm4
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm2[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm12[0],ymm10[0],ymm12[2],ymm10[2]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm2[1],xmm0[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm13[0],mem[0],ymm13[2],mem[2]
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %ymm6
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %ymm12
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm6[0],ymm12[0],ymm6[2],ymm12[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %xmm10
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm10, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vbroadcastsd 72(%rcx), %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %xmm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm15[0],ymm0[2],ymm15[2]
; AVX2-ONLY-NEXT:    vmovaps 64(%rax), %xmm1
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm13 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm13 = xmm13[1],xmm1[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm13[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm3[0],mem[0],ymm3[2],mem[2]
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %ymm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm3[0],ymm0[0],ymm3[2],ymm0[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm13[2,3],ymm15[2,3]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm11[0],ymm9[0],ymm11[2],ymm9[2]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm11 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm11[0,1,2,3],ymm9[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 120(%rcx), %ymm11
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 120(%r9), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm15[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 96(%rax), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1],ymm15[2,3],ymm9[4,5,6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm7 = xmm7[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm7, %ymm7
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm8, %ymm8
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm8[4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm5[1],ymm4[1],ymm5[3],ymm4[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%rcx), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm4[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm4, %ymm4 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd 32(%rcx), %ymm8
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm4[0,1,2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm6[1],ymm12[1],ymm6[3],ymm12[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%rcx), %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm6[0,1],ymm4[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm2, %ymm2
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 88(%rcx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd 96(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],mem[0],ymm3[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 112(%r9), %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 800(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 768(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm13, 576(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 544(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 512(%rax)
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 448(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 352(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 320(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 128(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 96(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 64(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, (%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 832(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 736(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 704(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 672(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 480(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 416(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 224(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 192(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 32(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 864(%rax)
; AVX2-ONLY-NEXT:    addq $520, %rsp # imm = 0x208
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-ONLY-SLOW-LABEL: store_i64_stride7_vf16:
; AVX512F-ONLY-SLOW:       # %bb.0:
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [6,14,6,14,6,14,6,14]
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [6,14,6,14]
; AVX512F-ONLY-SLOW-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm14 = [15,7,15,7]
; AVX512F-ONLY-SLOW-NEXT:    # ymm14 = mem[0,1,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm14, %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm2, %zmm6, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm3, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm15[0,1,2,3],zmm11[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $64, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm19 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r8), %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rax), %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rax), %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [0,8,0,1,0,8,0,1]
; AVX512F-ONLY-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm24 = [0,8,0,8,0,8,0,8]
; AVX512F-ONLY-SLOW-NEXT:    # zmm24 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm24, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm10, %zmm24
; AVX512F-ONLY-SLOW-NEXT:    movb $96, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k1
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [4,12,0,5,4,12,0,5]
; AVX512F-ONLY-SLOW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm17 = [15,7,15,7,15,7,15,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm17, %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm17, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    movb $24, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm9, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, %zmm14 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <u,1,2,3,4,15,u,u>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm10, %zmm14, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm20, %zmm15, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,1,12,7,0,1,12,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm23, %zmm29, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm30 = [11,3,11,3,11,3,11,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm30, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [2,10,0,3,2,10,0,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm17, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm14 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [9,1,9,1,9,1,9,1]
; AVX512F-ONLY-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm31 = [5,0,14,6,5,0,14,6]
; AVX512F-ONLY-SLOW-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm16, %zmm21, %zmm31
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm21, %zmm16, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm13, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%r9), %ymm21
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm20, %zmm13, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,1,2,3,4,5,15,u>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm28, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <13,u,2,3,4,5,6,14>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm19, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%r8), %ymm19
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm20 = ymm19[0],ymm21[0],ymm19[2],ymm21[2]
; AVX512F-ONLY-SLOW-NEXT:    movb $28, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k3} = zmm20[0,1,2,3],zmm23[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [6,13,14,7,6,13,14,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm26, %zmm22, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,13,6,7,0,13,6,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm22, %zmm31, %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %ymm31
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm22, %zmm29, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r8), %ymm29
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm0, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm5, %zmm8, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm17 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm30 = ymm29[0],ymm31[0],ymm29[2],ymm31[2]
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k3} = zmm30[0,1,2,3],zmm22[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [4,9,0,3,4,9,0,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm22, %zmm30, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [13,5,13,5,13,5,13,5]
; AVX512F-ONLY-SLOW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm23, %zmm30, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm30 = [14,1,2,3,4,5,6,15]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm23, %zmm13, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = [0,13,2,3,4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm23, %zmm28, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm22, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm5, %zmm8, %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,0,12,4,3,0,12,4]
; AVX512F-ONLY-SLOW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm28, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm22, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm8, %zmm28, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm11, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm2, %zmm6, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [1,0,10,2,1,0,10,2]
; AVX512F-ONLY-SLOW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm28, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    movb $48, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm4 {%k3} = zmm6[0],zmm2[0],zmm6[2],zmm2[2],zmm6[4],zmm2[4],zmm6[6],zmm2[6]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm22, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [6,14,6,14]
; AVX512F-ONLY-SLOW-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm8, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm8, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm5 {%k3} = zmm8[0],zmm7[0],zmm8[2],zmm7[2],zmm8[4],zmm7[4],zmm8[6],zmm7[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    movb $12, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm1 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, (%rax), %zmm25, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    movb $112, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm2
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm11 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, 64(%rax), %zmm24, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm11 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm23, %zmm6 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    movb $120, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm10 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 72(%rcx), %ymm2
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = mem[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $6, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm0 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    movb $56, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm0 {%k5}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm27, %zmm2 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    movb $-31, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm2 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm12[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $-61, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm2 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm22 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm22, %zmm15 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm28 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm28 {%k5}
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm19[1],ymm21[1],ymm19[3],ymm21[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $14, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm4 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm29[1],ymm31[1],ymm29[3],ymm31[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm5 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, 64(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, 128(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, 256(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, 320(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, 512(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, 576(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, 704(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, 448(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, 640(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, 768(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, 832(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vzeroupper
; AVX512F-ONLY-SLOW-NEXT:    retq
;
; AVX512F-ONLY-FAST-LABEL: store_i64_stride7_vf16:
; AVX512F-ONLY-FAST:       # %bb.0:
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rsi), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm31
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%r8), %zmm30
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm20 = [6,14,6,14,6,14,6,14]
; AVX512F-ONLY-FAST-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm31, %zmm20, %zmm16
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} ymm21 = [6,14,6,14]
; AVX512F-ONLY-FAST-NEXT:    # ymm21 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm17
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm21, %zmm17
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r8), %zmm12
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%r9), %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r9), %zmm15
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rax), %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rax), %zmm10
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,8,0,1,0,8,0,1]
; AVX512F-ONLY-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm7, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdx), %xmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rdx), %xmm19
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm18 = xmm18[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm18, %ymm0, %ymm18
; AVX512F-ONLY-FAST-NEXT:    movb $12, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k1
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm18, %zmm0, %zmm6 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm18 = [0,8,0,8,0,8,0,8]
; AVX512F-ONLY-FAST-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm15, %zmm18, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, (%rax), %zmm22, %zmm22
; AVX512F-ONLY-FAST-NEXT:    movb $112, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm22, %zmm6 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm19 = xmm19[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm19, %ymm0, %ymm19
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm19, %zmm0, %zmm7 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm9, %zmm30, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, 64(%rax), %zmm18, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm7 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [13,5,13,5,13,5,13,5]
; AVX512F-ONLY-FAST-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm31, %zmm22, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm22, %zmm23
; AVX512F-ONLY-FAST-NEXT:    movb $96, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm23 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [4,12,0,5,4,12,0,5]
; AVX512F-ONLY-FAST-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm19, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm24 = [0,1,12,7,0,1,12,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm24 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm10, %zmm24, %zmm18
; AVX512F-ONLY-FAST-NEXT:    movb $120, %sil
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [15,7,15,7,15,7,15,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm25
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm15, %zmm26, %zmm25
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [6,13,14,7,6,13,14,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm25, %zmm13, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm29
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm26, %zmm29
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} ymm27 = [15,7,15,7]
; AVX512F-ONLY-FAST-NEXT:    # ymm27 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm25
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm27, %zmm25
; AVX512F-ONLY-FAST-NEXT:    movb $24, %dil
; AVX512F-ONLY-FAST-NEXT:    kmovw %edi, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, %zmm25 {%k2}
; AVX512F-ONLY-FAST-NEXT:    movb $-31, %dil
; AVX512F-ONLY-FAST-NEXT:    kmovw %edi, %k3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, %zmm25 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,0,14,6,5,0,14,6]
; AVX512F-ONLY-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm12, %zmm15, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,13,6,7,0,13,6,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm13, %zmm28, %zmm29
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm14, %zmm1, %zmm20
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm20 = zmm21[0,1,2,3],zmm20[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    movb $-61, %dil
; AVX512F-ONLY-FAST-NEXT:    kmovw %edi, %k3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, %zmm20 {%k3}
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, %zmm18 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [3,0,12,4,3,0,12,4]
; AVX512F-ONLY-FAST-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm23, %zmm21
; AVX512F-ONLY-FAST-NEXT:    movb $48, %sil
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm22, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, %zmm22 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm15, %zmm12, %zmm19
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm24, %zmm19
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm22, %zmm19 {%k3}
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm21 {%k3} = zmm2[0],zmm3[0],zmm2[2],zmm3[2],zmm2[4],zmm3[4],zmm2[6],zmm3[6]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r9), %ymm22
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%r9), %ymm24
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%r8), %ymm28
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,3,7,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %ymm28, %ymm8
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %ymm24, %ymm5, %ymm8
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    movb $14, %sil
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm14, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm23 {%k3} = zmm11[0],zmm0[0],zmm11[2],zmm0[2],zmm11[4],zmm0[4],zmm11[6],zmm0[6]
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm21 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%r8), %ymm8
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %ymm22, %ymm8, %ymm5
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm23 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm28[0],ymm24[0],ymm28[2],ymm24[2]
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm16 = zmm17[0,1,2,3],zmm16[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm17 = [11,3,11,3,11,3,11,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm24 = [2,10,0,3,2,10,0,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm24 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm24, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm31, %zmm24, %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm24
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm17, %zmm24
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm24, %zmm14 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm17
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, %zmm1 {%k1}
; AVX512F-ONLY-FAST-NEXT:    movb $28, %al
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm5[0,1,2,3],zmm10[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [1,0,10,2,1,0,10,2]
; AVX512F-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm5, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm5, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm8[0],ymm22[0],ymm8[2],ymm22[2]
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k1} = zmm5[0,1,2,3],zmm13[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 72(%rcx), %ymm5
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    movb $6, %al
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [9,1,9,1,9,1,9,1]
; AVX512F-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm15, %zmm5, %zmm12
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm5, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [4,9,0,3,4,9,0,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm5, %zmm12
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm10, %zmm5, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm5
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm0 {%k1}
; AVX512F-ONLY-FAST-NEXT:    movb $64, %al
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, %zmm16 {%k1}
; AVX512F-ONLY-FAST-NEXT:    movb $56, %al
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm11 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm0 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm31, %zmm26, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm27, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,1,2,3,4,15,u,u>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm30, %zmm2, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <u,1,2,3,4,5,15,u>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm9, %zmm3, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <13,u,2,3,4,5,6,14>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm9, %zmm16, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [14,1,2,3,4,5,6,15]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm10, %zmm2, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,13,2,3,4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm10, %zmm3, %zmm2
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, 192(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm19, 256(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm20, 320(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm25, 384(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, 512(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, 576(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm21, 640(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, 704(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, 448(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, 768(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512F-ONLY-FAST-NEXT:    vzeroupper
; AVX512F-ONLY-FAST-NEXT:    retq
;
; AVX512DQ-SLOW-LABEL: store_i64_stride7_vf16:
; AVX512DQ-SLOW:       # %bb.0:
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm12
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm10
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [6,14,6,14,6,14,6,14]
; AVX512DQ-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm11
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512DQ-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [6,14,6,14]
; AVX512DQ-SLOW-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512DQ-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm14 = [15,7,15,7]
; AVX512DQ-SLOW-NEXT:    # ymm14 = mem[0,1,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm14, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm2, %zmm6, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm15
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm3, %zmm15
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm15[0,1,2,3],zmm11[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    movb $64, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm19 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r8), %zmm15
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm20
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r9), %zmm21
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rax), %zmm22
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rax), %zmm23
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm17 = [0,8,0,8,0,8,0,8]
; AVX512DQ-SLOW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm24
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm17, %zmm24
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [13,5,13,5,13,5,13,5]
; AVX512DQ-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    movb $96, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k1
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [4,12,0,5,4,12,0,5]
; AVX512DQ-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm25
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm20, %zmm10, %zmm17
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm18 = [15,7,15,7,15,7,15,7]
; AVX512DQ-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm26
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm18, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm27
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm18, %zmm27
; AVX512DQ-SLOW-NEXT:    movb $24, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm1, %zmm9, %zmm18
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm14 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <u,1,2,3,4,15,u,u>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm10, %zmm14, %zmm28
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm20, %zmm11, %zmm10
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,1,12,7,0,1,12,7]
; AVX512DQ-SLOW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm23, %zmm29, %zmm10
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm30 = [11,3,11,3,11,3,11,3]
; AVX512DQ-SLOW-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm30, %zmm13
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [2,10,0,3,2,10,0,3]
; AVX512DQ-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm14
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm18, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm14 {%k1}
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [9,1,9,1,9,1,9,1]
; AVX512DQ-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm31 = [5,0,14,6,5,0,14,6]
; AVX512DQ-SLOW-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm15, %zmm21, %zmm31
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm21, %zmm15, %zmm11
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm13, %zmm15
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%r9), %ymm21
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm20, %zmm13, %zmm25
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,1,2,3,4,5,15,u>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm20, %zmm28, %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <13,u,2,3,4,5,6,14>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm20, %zmm19, %zmm28
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%r8), %ymm19
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm20 = ymm19[0],ymm21[0],ymm19[2],ymm21[2]
; AVX512DQ-SLOW-NEXT:    movb $28, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k3
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k3} = zmm20[0,1,2,3],zmm23[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [6,13,14,7,6,13,14,7]
; AVX512DQ-SLOW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm26, %zmm22, %zmm20
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,13,6,7,0,13,6,7]
; AVX512DQ-SLOW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm22, %zmm31, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r9), %ymm31
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm22, %zmm29, %zmm11
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r8), %ymm29
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm3
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm12, %zmm0, %zmm30
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm5, %zmm8, %zmm18
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm18 {%k1}
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm30 = ymm29[0],ymm31[0],ymm29[2],ymm31[2]
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm18 {%k3} = zmm30[0,1,2,3],zmm22[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [4,9,0,3,4,9,0,3]
; AVX512DQ-SLOW-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm22, %zmm30, %zmm15
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm22
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm16, %zmm22
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm23, %zmm30, %zmm25
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm30 = [14,1,2,3,4,5,6,15]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm23, %zmm13, %zmm30
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = [0,13,2,3,4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm23, %zmm28, %zmm13
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [1,0,10,2,1,0,10,2]
; AVX512DQ-SLOW-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm5, %zmm8, %zmm12
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,0,12,4,3,0,12,4]
; AVX512DQ-SLOW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm9, %zmm28, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm16, %zmm9
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm28, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm23, %zmm8
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [0,8,0,1,0,8,0,1]
; AVX512DQ-SLOW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm28, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm2, %zmm6, %zmm28
; AVX512DQ-SLOW-NEXT:    movb $48, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k3
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm7 {%k3} = zmm6[0],zmm2[0],zmm6[2],zmm2[2],zmm6[4],zmm2[4],zmm6[6],zmm2[6]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm6
; AVX512DQ-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [6,14,6,14]
; AVX512DQ-SLOW-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm0, %zmm4, %zmm3
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm0, %zmm4, %zmm16
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm4, %zmm0, %zmm23
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm5 {%k3} = zmm4[0],zmm0[0],zmm4[2],zmm0[2],zmm4[4],zmm0[4],zmm4[6],zmm0[6]
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-SLOW-NEXT:    movb $12, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k3
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm1 {%k3}
; AVX512DQ-SLOW-NEXT:    movb $112, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k4
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, (%rax), %zmm24, %zmm1 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm22, %zmm6 {%k1}
; AVX512DQ-SLOW-NEXT:    movb $120, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm10 {%k5}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 72(%rcx), %ymm2
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = mem[0,1,2,3],ymm2[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    movb $6, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k6
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm8 {%k6}
; AVX512DQ-SLOW-NEXT:    movb $56, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k7
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm8 {%k7}
; AVX512DQ-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm2
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm28 {%k3}
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, 64(%rax), %zmm17, %zmm28 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm27, %zmm0 {%k2}
; AVX512DQ-SLOW-NEXT:    movb $-31, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm0 {%k2}
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm12[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    movb $-61, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm2 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm16 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm11 {%k5}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm3
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm23 {%k6}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm23 {%k7}
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm19[1],ymm21[1],ymm19[3],ymm21[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    movb $14, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm7 {%k1}
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm29[1],ymm31[1],ymm29[3],ymm31[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm5 {%k1}
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm23, 64(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm18, 128(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, 256(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, 320(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, 384(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm28, 448(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, 512(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, 576(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm7, 640(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm10, 704(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, 768(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm30, 832(%rax)
; AVX512DQ-SLOW-NEXT:    vzeroupper
; AVX512DQ-SLOW-NEXT:    retq
;
; AVX512DQ-FAST-LABEL: store_i64_stride7_vf16:
; AVX512DQ-FAST:       # %bb.0:
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rsi), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm31
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%r8), %zmm30
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [6,14,6,14,6,14,6,14]
; AVX512DQ-FAST-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm31, %zmm19, %zmm16
; AVX512DQ-FAST-NEXT:    vbroadcasti64x2 {{.*#+}} ymm20 = [6,14,6,14]
; AVX512DQ-FAST-NEXT:    # ymm20 = mem[0,1,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm20, %zmm18
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r8), %zmm12
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%r9), %zmm9
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r9), %zmm15
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rax), %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rax), %zmm10
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,8,0,1,0,8,0,1]
; AVX512DQ-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm11, %zmm6
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm8, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdx), %xmm17
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rdx), %xmm24
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm17 = xmm17[0],mem[0]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm17, %ymm0, %ymm17
; AVX512DQ-FAST-NEXT:    movb $12, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k2
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm17, %zmm0, %zmm6 {%k2}
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [0,8,0,8,0,8,0,8]
; AVX512DQ-FAST-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, %zmm17
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm15, %zmm25, %zmm17
; AVX512DQ-FAST-NEXT:    movb $112, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k3
; AVX512DQ-FAST-NEXT:    vinserti64x2 $3, (%rax), %zmm17, %zmm6 {%k3}
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm21 = [13,5,13,5,13,5,13,5]
; AVX512DQ-FAST-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm17
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm31, %zmm21, %zmm17
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm22
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm21, %zmm22
; AVX512DQ-FAST-NEXT:    movb $96, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm17, %zmm22 {%k1}
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [4,12,0,5,4,12,0,5]
; AVX512DQ-FAST-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm9, %zmm30, %zmm25
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm30, %zmm23
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm9, %zmm17, %zmm23
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [0,1,12,7,0,1,12,7]
; AVX512DQ-FAST-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm10, %zmm27, %zmm23
; AVX512DQ-FAST-NEXT:    movb $120, %sil
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm24 = xmm24[0],mem[0]
; AVX512DQ-FAST-NEXT:    vinserti32x4 $1, %xmm24, %ymm0, %ymm24
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm24, %zmm0, %zmm8 {%k2}
; AVX512DQ-FAST-NEXT:    vinserti64x2 $3, 64(%rax), %zmm25, %zmm8 {%k3}
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [15,7,15,7,15,7,15,7]
; AVX512DQ-FAST-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, %zmm24
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm15, %zmm25, %zmm24
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [6,13,14,7,6,13,14,7]
; AVX512DQ-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm24, %zmm13, %zmm28
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm29
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm14, %zmm25, %zmm29
; AVX512DQ-FAST-NEXT:    vbroadcasti64x2 {{.*#+}} ymm26 = [15,7,15,7]
; AVX512DQ-FAST-NEXT:    # ymm26 = mem[0,1,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm11, %zmm24
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm26, %zmm24
; AVX512DQ-FAST-NEXT:    movb $24, %dil
; AVX512DQ-FAST-NEXT:    kmovw %edi, %k2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm29, %zmm24 {%k2}
; AVX512DQ-FAST-NEXT:    movb $-31, %dil
; AVX512DQ-FAST-NEXT:    kmovw %edi, %k3
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm28, %zmm24 {%k3}
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,0,14,6,5,0,14,6]
; AVX512DQ-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm12, %zmm15, %zmm28
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,13,6,7,0,13,6,7]
; AVX512DQ-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm13, %zmm28, %zmm29
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm14, %zmm1, %zmm19
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm20
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm20[0,1,2,3],zmm19[4,5,6,7]
; AVX512DQ-FAST-NEXT:    movb $-61, %dil
; AVX512DQ-FAST-NEXT:    kmovw %edi, %k3
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm29, %zmm19 {%k3}
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k3
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm22, %zmm23 {%k3}
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm22 = [3,0,12,4,3,0,12,4]
; AVX512DQ-FAST-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm31, %zmm20
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm22, %zmm20
; AVX512DQ-FAST-NEXT:    movb $48, %sil
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm28
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm14, %zmm21, %zmm28
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm21
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm28, %zmm21 {%k1}
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm15, %zmm12, %zmm17
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm13, %zmm27, %zmm17
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm21, %zmm17 {%k3}
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k3
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm20 {%k3} = zmm2[0],zmm3[0],zmm2[2],zmm3[2],zmm2[4],zmm3[4],zmm2[6],zmm3[6]
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r9), %ymm21
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%r9), %ymm27
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%r8), %ymm28
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,3,7,7]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %ymm28, %ymm7
; AVX512DQ-FAST-NEXT:    vpermt2q %ymm27, %ymm5, %ymm7
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-FAST-NEXT:    movb $14, %sil
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm1, %zmm14, %zmm22
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm22 {%k3} = zmm11[0],zmm0[0],zmm11[2],zmm0[2],zmm11[4],zmm0[4],zmm11[6],zmm0[6]
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k3
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm7, %zmm0, %zmm20 {%k3}
; AVX512DQ-FAST-NEXT:    vmovdqa (%r8), %ymm7
; AVX512DQ-FAST-NEXT:    vpermi2q %ymm21, %ymm7, %ymm5
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm22 {%k3}
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm28[0],ymm27[0],ymm28[2],ymm27[2]
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm16 = zmm18[0,1,2,3],zmm16[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm18 = [11,3,11,3,11,3,11,3]
; AVX512DQ-FAST-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [2,10,0,3,2,10,0,3]
; AVX512DQ-FAST-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm14, %zmm27, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm31, %zmm27, %zmm14
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm18, %zmm27
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm27, %zmm14 {%k1}
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm18
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm18, %zmm1 {%k1}
; AVX512DQ-FAST-NEXT:    movb $28, %al
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k1
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm5[0,1,2,3],zmm10[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [1,0,10,2,1,0,10,2]
; AVX512DQ-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm11, %zmm5, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm11
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm2, %zmm5, %zmm11
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm7[0],ymm21[0],ymm7[2],ymm21[2]
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k1} = zmm5[0,1,2,3],zmm13[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vpbroadcastq 72(%rcx), %ymm5
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQ-FAST-NEXT:    movb $6, %al
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k1
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [9,1,9,1,9,1,9,1]
; AVX512DQ-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm15, %zmm5, %zmm12
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm30, %zmm7
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm9, %zmm5, %zmm7
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [4,9,0,3,4,9,0,3]
; AVX512DQ-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm13, %zmm5, %zmm12
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm10, %zmm5, %zmm7
; AVX512DQ-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm5
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm0 {%k1}
; AVX512DQ-FAST-NEXT:    movb $64, %al
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm30, %zmm16 {%k1}
; AVX512DQ-FAST-NEXT:    movb $56, %al
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm7, %zmm11 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, %zmm0 {%k1}
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm31, %zmm25, %zmm4
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm26, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k2}
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,1,2,3,4,15,u,u>
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm30, %zmm2, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <u,1,2,3,4,5,15,u>
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm9, %zmm3, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <13,u,2,3,4,5,6,14>
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm9, %zmm16, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [14,1,2,3,4,5,6,15]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm10, %zmm2, %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,13,2,3,4,5,6,7]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm10, %zmm3, %zmm2
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm22, 192(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm17, 256(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm24, 384(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, 448(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm11, 512(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm14, 576(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm20, 640(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm23, 704(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, 768(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512DQ-FAST-NEXT:    vzeroupper
; AVX512DQ-FAST-NEXT:    retq
;
; AVX512BW-ONLY-SLOW-LABEL: store_i64_stride7_vf16:
; AVX512BW-ONLY-SLOW:       # %bb.0:
; AVX512BW-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [6,14,6,14,6,14,6,14]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [6,14,6,14]
; AVX512BW-ONLY-SLOW-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm14 = [15,7,15,7]
; AVX512BW-ONLY-SLOW-NEXT:    # ymm14 = mem[0,1,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm12
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm14, %zmm12
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm2, %zmm6, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm3, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm15[0,1,2,3],zmm11[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    movb $64, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm19 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%r8), %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rax), %zmm22
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rax), %zmm23
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [0,8,0,1,0,8,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm24 = [0,8,0,8,0,8,0,8]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm24 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm25
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm24, %zmm25
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm10, %zmm24
; AVX512BW-ONLY-SLOW-NEXT:    movb $96, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [4,12,0,5,4,12,0,5]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm17 = [15,7,15,7,15,7,15,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm26
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm17, %zmm26
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm27
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm17, %zmm27
; AVX512BW-ONLY-SLOW-NEXT:    movb $24, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm9, %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, %zmm14 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <u,1,2,3,4,15,u,u>
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm10, %zmm14, %zmm28
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm20, %zmm15, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,1,12,7,0,1,12,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm23, %zmm29, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm30 = [11,3,11,3,11,3,11,3]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm30, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [2,10,0,3,2,10,0,3]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm17, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm14 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [9,1,9,1,9,1,9,1]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm31 = [5,0,14,6,5,0,14,6]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm16, %zmm21, %zmm31
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm21, %zmm16, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm13, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%r9), %ymm21
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm20, %zmm13, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,1,2,3,4,5,15,u>
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm28, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <13,u,2,3,4,5,6,14>
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm19, %zmm28
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%r8), %ymm19
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm20 = ymm19[0],ymm21[0],ymm19[2],ymm21[2]
; AVX512BW-ONLY-SLOW-NEXT:    movb $28, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k3} = zmm20[0,1,2,3],zmm23[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [6,13,14,7,6,13,14,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm26, %zmm22, %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,13,6,7,0,13,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm22, %zmm31, %zmm26
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %ymm31
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm22, %zmm29, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%r8), %ymm29
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm0, %zmm30
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm5, %zmm8, %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm17 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm30 = ymm29[0],ymm31[0],ymm29[2],ymm31[2]
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm17 {%k3} = zmm30[0,1,2,3],zmm22[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [4,9,0,3,4,9,0,3]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm22, %zmm30, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [13,5,13,5,13,5,13,5]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm23, %zmm30, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm30 = [14,1,2,3,4,5,6,15]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm23, %zmm13, %zmm30
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = [0,13,2,3,4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm23, %zmm28, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm23
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm22, %zmm23
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm12
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm5, %zmm8, %zmm12
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,0,12,4,3,0,12,4]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm28, %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm22, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm8, %zmm28, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm11, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm2, %zmm6, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [1,0,10,2,1,0,10,2]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm28, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    movb $48, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm4 {%k3} = zmm6[0],zmm2[0],zmm6[2],zmm2[2],zmm6[4],zmm2[4],zmm6[6],zmm2[6]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm22, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [6,14,6,14]
; AVX512BW-ONLY-SLOW-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm8, %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm7, %zmm8, %zmm22
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm8, %zmm7, %zmm28
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm5 {%k3} = zmm8[0],zmm7[0],zmm8[2],zmm7[2],zmm8[4],zmm7[4],zmm8[6],zmm7[6]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-ONLY-SLOW-NEXT:    movb $12, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm1 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $3, (%rax), %zmm25, %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    movb $112, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm11 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $3, 64(%rax), %zmm24, %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm11 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm23, %zmm6 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    movb $120, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm10 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vpbroadcastq 72(%rcx), %ymm2
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = mem[0,1,2,3],ymm2[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    movb $6, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k4
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm0 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    movb $56, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm0 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm27, %zmm2 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    movb $-31, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm2 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm12[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    movb $-61, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm2 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm22 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm22, %zmm15 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm3
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm28 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm28 {%k5}
; AVX512BW-ONLY-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm19[1],ymm21[1],ymm19[3],ymm21[3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-SLOW-NEXT:    movb $14, %cl
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm4 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm29[1],ymm31[1],ymm29[3],ymm31[3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm5 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, 64(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, 128(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, 256(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, 320(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, 384(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, 512(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, 576(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, 704(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, 448(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, 640(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, 768(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, 832(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vzeroupper
; AVX512BW-ONLY-SLOW-NEXT:    retq
;
; AVX512BW-ONLY-FAST-LABEL: store_i64_stride7_vf16:
; AVX512BW-ONLY-FAST:       # %bb.0:
; AVX512BW-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rsi), %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm31
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%r8), %zmm30
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm20 = [6,14,6,14,6,14,6,14]
; AVX512BW-ONLY-FAST-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm31, %zmm20, %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} ymm21 = [6,14,6,14]
; AVX512BW-ONLY-FAST-NEXT:    # ymm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm21, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%r8), %zmm12
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%r9), %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%r9), %zmm15
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rax), %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rax), %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,8,0,1,0,8,0,1]
; AVX512BW-ONLY-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm7, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rdx), %xmm18
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rdx), %xmm19
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm18 = xmm18[0],mem[0]
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm18, %ymm0, %ymm18
; AVX512BW-ONLY-FAST-NEXT:    movb $12, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k1
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm18, %zmm0, %zmm6 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm18 = [0,8,0,8,0,8,0,8]
; AVX512BW-ONLY-FAST-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm22
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm15, %zmm18, %zmm22
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $3, (%rax), %zmm22, %zmm22
; AVX512BW-ONLY-FAST-NEXT:    movb $112, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm22, %zmm6 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm19 = xmm19[0],mem[0]
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $1, %xmm19, %ymm0, %ymm19
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm19, %zmm0, %zmm7 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm9, %zmm30, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $3, 64(%rax), %zmm18, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm7 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [13,5,13,5,13,5,13,5]
; AVX512BW-ONLY-FAST-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm31, %zmm22, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm23
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm22, %zmm23
; AVX512BW-ONLY-FAST-NEXT:    movb $96, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm23 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [4,12,0,5,4,12,0,5]
; AVX512BW-ONLY-FAST-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm19, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm24 = [0,1,12,7,0,1,12,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm24 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm10, %zmm24, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    movb $120, %sil
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [15,7,15,7,15,7,15,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm25
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm15, %zmm26, %zmm25
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [6,13,14,7,6,13,14,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm25, %zmm13, %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm29
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm26, %zmm29
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} ymm27 = [15,7,15,7]
; AVX512BW-ONLY-FAST-NEXT:    # ymm27 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm25
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm27, %zmm25
; AVX512BW-ONLY-FAST-NEXT:    movb $24, %dil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %edi, %k2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, %zmm25 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    movb $-31, %dil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %edi, %k3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, %zmm25 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,0,14,6,5,0,14,6]
; AVX512BW-ONLY-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm12, %zmm15, %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,13,6,7,0,13,6,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm13, %zmm28, %zmm29
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm14, %zmm1, %zmm20
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm20 = zmm21[0,1,2,3],zmm20[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    movb $-61, %dil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %edi, %k3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, %zmm20 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, %zmm18 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [3,0,12,4,3,0,12,4]
; AVX512BW-ONLY-FAST-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm23, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    movb $48, %sil
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm22, %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm22
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, %zmm22 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm15, %zmm12, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm24, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm22, %zmm19 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm21 {%k3} = zmm2[0],zmm3[0],zmm2[2],zmm3[2],zmm2[4],zmm3[4],zmm2[6],zmm3[6]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%r9), %ymm22
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%r9), %ymm24
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%r8), %ymm28
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,3,7,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %ymm28, %ymm8
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %ymm24, %ymm5, %ymm8
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-FAST-NEXT:    movb $14, %sil
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm14, %zmm23
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm23 {%k3} = zmm11[0],zmm0[0],zmm11[2],zmm0[2],zmm11[4],zmm0[4],zmm11[6],zmm0[6]
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm21 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa (%r8), %ymm8
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %ymm22, %ymm8, %ymm5
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm23 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm28[0],ymm24[0],ymm28[2],ymm24[2]
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm16 = zmm17[0,1,2,3],zmm16[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm17 = [11,3,11,3,11,3,11,3]
; AVX512BW-ONLY-FAST-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm24 = [2,10,0,3,2,10,0,3]
; AVX512BW-ONLY-FAST-NEXT:    # zmm24 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm24, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm31, %zmm24, %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm24
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm17, %zmm24
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm24, %zmm14 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, %zmm1 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    movb $28, %al
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm5[0,1,2,3],zmm10[2,3,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [1,0,10,2,1,0,10,2]
; AVX512BW-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm5, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm5, %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm8[0],ymm22[0],ymm8[2],ymm22[2]
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k1} = zmm5[0,1,2,3],zmm13[2,3,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vpbroadcastq 72(%rcx), %ymm5
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    movb $6, %al
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [9,1,9,1,9,1,9,1]
; AVX512BW-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm15, %zmm5, %zmm12
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm5, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [4,9,0,3,4,9,0,3]
; AVX512BW-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm5, %zmm12
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm10, %zmm5, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm5
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm0 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    movb $64, %al
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, %zmm16 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    movb $56, %al
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm11 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm0 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm31, %zmm26, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm27, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k2}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,1,2,3,4,15,u,u>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm30, %zmm2, %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <u,1,2,3,4,5,15,u>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm9, %zmm3, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <13,u,2,3,4,5,6,14>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm9, %zmm16, %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [14,1,2,3,4,5,6,15]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm10, %zmm2, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,13,2,3,4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm10, %zmm3, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, 192(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm19, 256(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm20, 320(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm25, 384(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, 512(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, 576(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm21, 640(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, 704(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, 448(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, 768(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vzeroupper
; AVX512BW-ONLY-FAST-NEXT:    retq
;
; AVX512DQBW-SLOW-LABEL: store_i64_stride7_vf16:
; AVX512DQBW-SLOW:       # %bb.0:
; AVX512DQBW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm12
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm10
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [6,14,6,14,6,14,6,14]
; AVX512DQBW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm11
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm4
; AVX512DQBW-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [6,14,6,14]
; AVX512DQBW-SLOW-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm13
; AVX512DQBW-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm14 = [15,7,15,7]
; AVX512DQBW-SLOW-NEXT:    # ymm14 = mem[0,1,0,1]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm12, %zmm14, %zmm7
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm2, %zmm6, %zmm14
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm15
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm2, %zmm3, %zmm15
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm15[0,1,2,3],zmm11[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    movb $64, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm19 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%r8), %zmm15
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm20
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%r9), %zmm21
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rax), %zmm22
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rax), %zmm23
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm17 = [0,8,0,8,0,8,0,8]
; AVX512DQBW-SLOW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm24
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm17, %zmm24
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [13,5,13,5,13,5,13,5]
; AVX512DQBW-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    movb $96, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k1
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm11 = [4,12,0,5,4,12,0,5]
; AVX512DQBW-SLOW-NEXT:    # zmm11 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm25
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm20, %zmm10, %zmm17
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm18 = [15,7,15,7,15,7,15,7]
; AVX512DQBW-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm26
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm18, %zmm26
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm27
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm18, %zmm27
; AVX512DQBW-SLOW-NEXT:    movb $24, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm1, %zmm9, %zmm18
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm14 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <u,1,2,3,4,15,u,u>
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm10, %zmm14, %zmm28
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm20, %zmm11, %zmm10
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,1,12,7,0,1,12,7]
; AVX512DQBW-SLOW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm23, %zmm29, %zmm10
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm30 = [11,3,11,3,11,3,11,3]
; AVX512DQBW-SLOW-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm2, %zmm30, %zmm13
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [2,10,0,3,2,10,0,3]
; AVX512DQBW-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm14
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm18, %zmm14
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm14 {%k1}
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm13 = [9,1,9,1,9,1,9,1]
; AVX512DQBW-SLOW-NEXT:    # zmm13 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm31 = [5,0,14,6,5,0,14,6]
; AVX512DQBW-SLOW-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm15, %zmm21, %zmm31
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm21, %zmm15, %zmm11
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm13, %zmm15
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%r9), %ymm21
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm20, %zmm13, %zmm25
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,1,2,3,4,5,15,u>
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm20, %zmm28, %zmm13
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <13,u,2,3,4,5,6,14>
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm20, %zmm19, %zmm28
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%r8), %ymm19
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm20 = ymm19[0],ymm21[0],ymm19[2],ymm21[2]
; AVX512DQBW-SLOW-NEXT:    movb $28, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k3
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k3} = zmm20[0,1,2,3],zmm23[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [6,13,14,7,6,13,14,7]
; AVX512DQBW-SLOW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm26, %zmm22, %zmm20
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,13,6,7,0,13,6,7]
; AVX512DQBW-SLOW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm22, %zmm31, %zmm26
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%r9), %ymm31
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm22, %zmm29, %zmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%r8), %ymm29
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm3
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm12, %zmm0, %zmm30
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm5, %zmm8, %zmm18
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm18 {%k1}
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm30 = ymm29[0],ymm31[0],ymm29[2],ymm31[2]
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm18 {%k3} = zmm30[0,1,2,3],zmm22[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [4,9,0,3,4,9,0,3]
; AVX512DQBW-SLOW-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm22, %zmm30, %zmm15
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm22
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm16, %zmm22
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm23, %zmm30, %zmm25
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm30 = [14,1,2,3,4,5,6,15]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm23, %zmm13, %zmm30
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = [0,13,2,3,4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm23, %zmm28, %zmm13
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm23 = [1,0,10,2,1,0,10,2]
; AVX512DQBW-SLOW-NEXT:    # zmm23 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm12
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm5, %zmm8, %zmm12
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [3,0,12,4,3,0,12,4]
; AVX512DQBW-SLOW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm9, %zmm28, %zmm7
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm16, %zmm9
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm8, %zmm28, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm23, %zmm8
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [0,8,0,1,0,8,0,1]
; AVX512DQBW-SLOW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm28, %zmm1
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm2, %zmm6, %zmm28
; AVX512DQBW-SLOW-NEXT:    movb $48, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k3
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm7 {%k3} = zmm6[0],zmm2[0],zmm6[2],zmm2[2],zmm6[4],zmm2[4],zmm6[6],zmm2[6]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm6
; AVX512DQBW-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm3 = [6,14,6,14]
; AVX512DQBW-SLOW-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm0, %zmm4, %zmm3
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm0, %zmm4, %zmm16
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm4, %zmm0, %zmm23
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm5 {%k3} = zmm4[0],zmm0[0],zmm4[2],zmm0[2],zmm4[4],zmm0[4],zmm4[6],zmm0[6]
; AVX512DQBW-SLOW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQBW-SLOW-NEXT:    movb $12, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k3
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm1 {%k3}
; AVX512DQBW-SLOW-NEXT:    movb $112, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k4
; AVX512DQBW-SLOW-NEXT:    vinserti64x2 $3, (%rax), %zmm24, %zmm1 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm22, %zmm6 {%k1}
; AVX512DQBW-SLOW-NEXT:    movb $120, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm10 {%k5}
; AVX512DQBW-SLOW-NEXT:    vpbroadcastq 72(%rcx), %ymm2
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm2 = mem[0,1,2,3],ymm2[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    movb $6, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k6
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm8 {%k6}
; AVX512DQBW-SLOW-NEXT:    movb $56, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k7
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm8 {%k7}
; AVX512DQBW-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm2
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm28 {%k3}
; AVX512DQBW-SLOW-NEXT:    vinserti64x2 $3, 64(%rax), %zmm17, %zmm28 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm27, %zmm0 {%k2}
; AVX512DQBW-SLOW-NEXT:    movb $-31, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm0 {%k2}
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm2 = zmm3[0,1,2,3],zmm12[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    movb $-61, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm2 {%k2}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm16 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm11 {%k5}
; AVX512DQBW-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm3
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm23 {%k6}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm23 {%k7}
; AVX512DQBW-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm19[1],ymm21[1],ymm19[3],ymm21[3]
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-SLOW-NEXT:    movb $14, %cl
; AVX512DQBW-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm7 {%k1}
; AVX512DQBW-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm3 = ymm29[1],ymm31[1],ymm29[3],ymm31[3]
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,3,3]
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm5 {%k1}
; AVX512DQBW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm23, 64(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm18, 128(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm5, 192(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, 256(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, 320(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, 384(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm28, 448(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, 512(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm14, 576(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm7, 640(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, 704(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, (%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, 768(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm30, 832(%rax)
; AVX512DQBW-SLOW-NEXT:    vzeroupper
; AVX512DQBW-SLOW-NEXT:    retq
;
; AVX512DQBW-FAST-LABEL: store_i64_stride7_vf16:
; AVX512DQBW-FAST:       # %bb.0:
; AVX512DQBW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rsi), %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rdx), %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm31
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%r8), %zmm30
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [6,14,6,14,6,14,6,14]
; AVX512DQBW-FAST-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm16
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm31, %zmm19, %zmm16
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x2 {{.*#+}} ymm20 = [6,14,6,14]
; AVX512DQBW-FAST-NEXT:    # ymm20 = mem[0,1,0,1]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm20, %zmm18
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%r8), %zmm12
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%r9), %zmm9
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%r9), %zmm15
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rax), %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rax), %zmm10
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,8,0,1,0,8,0,1]
; AVX512DQBW-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm6
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm8, %zmm6
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rdx), %xmm17
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rdx), %xmm24
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm17 = xmm17[0],mem[0]
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $1, %xmm17, %ymm0, %ymm17
; AVX512DQBW-FAST-NEXT:    movb $12, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k2
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm17, %zmm0, %zmm6 {%k2}
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [0,8,0,8,0,8,0,8]
; AVX512DQBW-FAST-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm17
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm15, %zmm25, %zmm17
; AVX512DQBW-FAST-NEXT:    movb $112, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k3
; AVX512DQBW-FAST-NEXT:    vinserti64x2 $3, (%rax), %zmm17, %zmm6 {%k3}
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm21 = [13,5,13,5,13,5,13,5]
; AVX512DQBW-FAST-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm17
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm31, %zmm21, %zmm17
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm22
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm21, %zmm22
; AVX512DQBW-FAST-NEXT:    movb $96, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm17, %zmm22 {%k1}
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [4,12,0,5,4,12,0,5]
; AVX512DQBW-FAST-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm9, %zmm30, %zmm25
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm30, %zmm23
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm9, %zmm17, %zmm23
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [0,1,12,7,0,1,12,7]
; AVX512DQBW-FAST-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm10, %zmm27, %zmm23
; AVX512DQBW-FAST-NEXT:    movb $120, %sil
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm24 = xmm24[0],mem[0]
; AVX512DQBW-FAST-NEXT:    vinserti32x4 $1, %xmm24, %ymm0, %ymm24
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm24, %zmm0, %zmm8 {%k2}
; AVX512DQBW-FAST-NEXT:    vinserti64x2 $3, 64(%rax), %zmm25, %zmm8 {%k3}
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [15,7,15,7,15,7,15,7]
; AVX512DQBW-FAST-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm24
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm15, %zmm25, %zmm24
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [6,13,14,7,6,13,14,7]
; AVX512DQBW-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm24, %zmm13, %zmm28
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm29
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm14, %zmm25, %zmm29
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x2 {{.*#+}} ymm26 = [15,7,15,7]
; AVX512DQBW-FAST-NEXT:    # ymm26 = mem[0,1,0,1]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm24
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm26, %zmm24
; AVX512DQBW-FAST-NEXT:    movb $24, %dil
; AVX512DQBW-FAST-NEXT:    kmovd %edi, %k2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm29, %zmm24 {%k2}
; AVX512DQBW-FAST-NEXT:    movb $-31, %dil
; AVX512DQBW-FAST-NEXT:    kmovd %edi, %k3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm28, %zmm24 {%k3}
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,0,14,6,5,0,14,6]
; AVX512DQBW-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm12, %zmm15, %zmm28
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,13,6,7,0,13,6,7]
; AVX512DQBW-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm13, %zmm28, %zmm29
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm14, %zmm1, %zmm19
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm20
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm20[0,1,2,3],zmm19[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    movb $-61, %dil
; AVX512DQBW-FAST-NEXT:    kmovd %edi, %k3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm29, %zmm19 {%k3}
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm22, %zmm23 {%k3}
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm22 = [3,0,12,4,3,0,12,4]
; AVX512DQBW-FAST-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm31, %zmm20
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm22, %zmm20
; AVX512DQBW-FAST-NEXT:    movb $48, %sil
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm28
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm14, %zmm21, %zmm28
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm21
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm28, %zmm21 {%k1}
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm15, %zmm12, %zmm17
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm13, %zmm27, %zmm17
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm21, %zmm17 {%k3}
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k3
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm20 {%k3} = zmm2[0],zmm3[0],zmm2[2],zmm3[2],zmm2[4],zmm3[4],zmm2[6],zmm3[6]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%r9), %ymm21
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%r9), %ymm27
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%r8), %ymm28
; AVX512DQBW-FAST-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,3,7,7]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %ymm28, %ymm7
; AVX512DQBW-FAST-NEXT:    vpermt2q %ymm27, %ymm5, %ymm7
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-FAST-NEXT:    movb $14, %sil
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm1, %zmm14, %zmm22
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm22 {%k3} = zmm11[0],zmm0[0],zmm11[2],zmm0[2],zmm11[4],zmm0[4],zmm11[6],zmm0[6]
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k3
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm7, %zmm0, %zmm20 {%k3}
; AVX512DQBW-FAST-NEXT:    vmovdqa (%r8), %ymm7
; AVX512DQBW-FAST-NEXT:    vpermi2q %ymm21, %ymm7, %ymm5
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm22 {%k3}
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm28[0],ymm27[0],ymm28[2],ymm27[2]
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm16 = zmm18[0,1,2,3],zmm16[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm18 = [11,3,11,3,11,3,11,3]
; AVX512DQBW-FAST-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [2,10,0,3,2,10,0,3]
; AVX512DQBW-FAST-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm14, %zmm27, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm14
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm31, %zmm27, %zmm14
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm18, %zmm27
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm27, %zmm14 {%k1}
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm0, %zmm11, %zmm18
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm18, %zmm1 {%k1}
; AVX512DQBW-FAST-NEXT:    movb $28, %al
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k1} = zmm5[0,1,2,3],zmm10[2,3,0,1]
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [1,0,10,2,1,0,10,2]
; AVX512DQBW-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm11, %zmm5, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm11
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm2, %zmm5, %zmm11
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm7[0],ymm21[0],ymm7[2],ymm21[2]
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k1} = zmm5[0,1,2,3],zmm13[2,3,0,1]
; AVX512DQBW-FAST-NEXT:    vpbroadcastq 72(%rcx), %ymm5
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    movb $6, %al
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [9,1,9,1,9,1,9,1]
; AVX512DQBW-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm15, %zmm5, %zmm12
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm30, %zmm7
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm9, %zmm5, %zmm7
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [4,9,0,3,4,9,0,3]
; AVX512DQBW-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm13, %zmm5, %zmm12
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm10, %zmm5, %zmm7
; AVX512DQBW-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm5
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm0 {%k1}
; AVX512DQBW-FAST-NEXT:    movb $64, %al
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm30, %zmm16 {%k1}
; AVX512DQBW-FAST-NEXT:    movb $56, %al
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm11 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm0 {%k1}
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm31, %zmm25, %zmm4
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm26, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k2}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,1,2,3,4,15,u,u>
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm30, %zmm2, %zmm3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <u,1,2,3,4,5,15,u>
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm9, %zmm3, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <13,u,2,3,4,5,6,14>
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm9, %zmm16, %zmm3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [14,1,2,3,4,5,6,15]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm10, %zmm2, %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,13,2,3,4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm10, %zmm3, %zmm2
; AVX512DQBW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, 64(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm22, 192(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm17, 256(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm24, 384(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm8, 448(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, 512(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm14, 576(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm20, 640(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm23, 704(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm6, (%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, 768(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, 832(%rax)
; AVX512DQBW-FAST-NEXT:    vzeroupper
; AVX512DQBW-FAST-NEXT:    retq
  %in.vec0 = load <16 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <16 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <16 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <16 x i64>, ptr %in.vecptr6, align 64
  %1 = shufflevector <16 x i64> %in.vec0, <16 x i64> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i64> %in.vec2, <16 x i64> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <16 x i64> %in.vec4, <16 x i64> %in.vec5, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = shufflevector <32 x i64> %1, <32 x i64> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %5 = shufflevector <16 x i64> %in.vec6, <16 x i64> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <32 x i64> %3, <32 x i64> %5, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %7 = shufflevector <48 x i64> %6, <48 x i64> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <64 x i64> %4, <64 x i64> %7, <112 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111>
  %interleaved.vec = shufflevector <112 x i64> %8, <112 x i64> poison, <112 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 80, i32 96, i32 1, i32 17, i32 33, i32 49, i32 65, i32 81, i32 97, i32 2, i32 18, i32 34, i32 50, i32 66, i32 82, i32 98, i32 3, i32 19, i32 35, i32 51, i32 67, i32 83, i32 99, i32 4, i32 20, i32 36, i32 52, i32 68, i32 84, i32 100, i32 5, i32 21, i32 37, i32 53, i32 69, i32 85, i32 101, i32 6, i32 22, i32 38, i32 54, i32 70, i32 86, i32 102, i32 7, i32 23, i32 39, i32 55, i32 71, i32 87, i32 103, i32 8, i32 24, i32 40, i32 56, i32 72, i32 88, i32 104, i32 9, i32 25, i32 41, i32 57, i32 73, i32 89, i32 105, i32 10, i32 26, i32 42, i32 58, i32 74, i32 90, i32 106, i32 11, i32 27, i32 43, i32 59, i32 75, i32 91, i32 107, i32 12, i32 28, i32 44, i32 60, i32 76, i32 92, i32 108, i32 13, i32 29, i32 45, i32 61, i32 77, i32 93, i32 109, i32 14, i32 30, i32 46, i32 62, i32 78, i32 94, i32 110, i32 15, i32 31, i32 47, i32 63, i32 79, i32 95, i32 111>
  store <112 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride7_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride7_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1432, %rsp # imm = 0x598
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd (%rdi), %xmm2
; SSE-NEXT:    movapd 16(%rdi), %xmm3
; SSE-NEXT:    movapd 32(%rdi), %xmm4
; SSE-NEXT:    movapd (%rsi), %xmm5
; SSE-NEXT:    movapd 16(%rsi), %xmm6
; SSE-NEXT:    movapd (%rdx), %xmm7
; SSE-NEXT:    movapd 16(%rdx), %xmm8
; SSE-NEXT:    movapd (%rcx), %xmm9
; SSE-NEXT:    movapd 16(%rcx), %xmm10
; SSE-NEXT:    movapd (%r8), %xmm11
; SSE-NEXT:    movapd 16(%r8), %xmm12
; SSE-NEXT:    movapd (%r9), %xmm13
; SSE-NEXT:    movapd 16(%r9), %xmm14
; SSE-NEXT:    movapd (%rax), %xmm0
; SSE-NEXT:    movapd 16(%rax), %xmm1
; SSE-NEXT:    movapd %xmm2, %xmm15
; SSE-NEXT:    unpcklpd {{.*#+}} xmm15 = xmm15[0],xmm5[0]
; SSE-NEXT:    movapd %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm0[0],xmm2[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm7[1]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm7 = xmm7[0],xmm9[0]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm11[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm11 = xmm11[0],xmm13[0]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movapd %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm3, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm6[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm1[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm8[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm8 = xmm8[0],xmm10[0]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm12[1]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm12 = xmm12[0],xmm14[0]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm1[1]
; SSE-NEXT:    movapd %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rsi), %xmm1
; SSE-NEXT:    movapd %xmm4, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm0[0],xmm4[1]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rdx), %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rcx), %xmm3
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rdi), %xmm1
; SSE-NEXT:    movapd 48(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rdi), %xmm1
; SSE-NEXT:    movapd 64(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdi), %xmm1
; SSE-NEXT:    movapd 80(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rdi), %xmm1
; SSE-NEXT:    movapd 96(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rdi), %xmm1
; SSE-NEXT:    movapd 112(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rdi), %xmm1
; SSE-NEXT:    movapd 128(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rdi), %xmm1
; SSE-NEXT:    movapd 144(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rdi), %xmm1
; SSE-NEXT:    movapd 160(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rdi), %xmm1
; SSE-NEXT:    movapd 176(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%rdi), %xmm1
; SSE-NEXT:    movapd 192(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%rdi), %xmm1
; SSE-NEXT:    movapd 208(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%rcx), %xmm14
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm14[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm1[1]
; SSE-NEXT:    movapd 208(%r9), %xmm13
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm13[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movapd 224(%rdi), %xmm15
; SSE-NEXT:    movapd 224(%rsi), %xmm12
; SSE-NEXT:    movapd %xmm15, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm12[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 224(%rax), %xmm3
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm3[0],xmm15[1]
; SSE-NEXT:    movapd 224(%rdx), %xmm11
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm11[1]
; SSE-NEXT:    movapd 224(%rcx), %xmm7
; SSE-NEXT:    unpcklpd {{.*#+}} xmm11 = xmm11[0],xmm7[0]
; SSE-NEXT:    movapd 224(%r8), %xmm9
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm9[1]
; SSE-NEXT:    movapd 224(%r9), %xmm5
; SSE-NEXT:    unpcklpd {{.*#+}} xmm9 = xmm9[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-NEXT:    movapd 240(%rdi), %xmm6
; SSE-NEXT:    movapd 240(%rsi), %xmm4
; SSE-NEXT:    movapd %xmm6, %xmm8
; SSE-NEXT:    unpcklpd {{.*#+}} xmm8 = xmm8[0],xmm4[0]
; SSE-NEXT:    movapd 240(%rax), %xmm10
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm10[0],xmm6[1]
; SSE-NEXT:    movapd 240(%rdx), %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    movapd 240(%rcx), %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm3 = xmm3[0],xmm1[0]
; SSE-NEXT:    movapd 240(%r8), %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movapd 240(%r9), %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm10[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm0, 1776(%rax)
; SSE-NEXT:    movapd %xmm1, 1760(%rax)
; SSE-NEXT:    movapd %xmm4, 1744(%rax)
; SSE-NEXT:    movapd %xmm6, 1728(%rax)
; SSE-NEXT:    movapd %xmm2, 1712(%rax)
; SSE-NEXT:    movapd %xmm3, 1696(%rax)
; SSE-NEXT:    movapd %xmm8, 1680(%rax)
; SSE-NEXT:    movapd %xmm5, 1664(%rax)
; SSE-NEXT:    movapd %xmm7, 1648(%rax)
; SSE-NEXT:    movapd %xmm12, 1632(%rax)
; SSE-NEXT:    movapd %xmm15, 1616(%rax)
; SSE-NEXT:    movapd %xmm9, 1600(%rax)
; SSE-NEXT:    movapd %xmm11, 1584(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1568(%rax)
; SSE-NEXT:    movapd %xmm13, 1552(%rax)
; SSE-NEXT:    movapd %xmm14, 1536(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1520(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1504(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1488(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1472(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1456(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1440(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1424(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1408(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1392(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1376(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1360(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1344(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1328(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1312(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1296(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1280(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1072(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $1432, %rsp # imm = 0x598
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride7_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $1320, %rsp # imm = 0x528
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm3
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm5
; AVX1-ONLY-NEXT:    vmovaps (%r9), %ymm4
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm6
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm7
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm8 = xmm7[0],xmm6[0]
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm8, %ymm9
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm10
; AVX1-ONLY-NEXT:    vmovaps 16(%rax), %xmm11
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %xmm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm8, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2,3],ymm8[4,5],ymm9[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%rcx), %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm2[0,1,2,3],ymm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm9 = xmm9[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1],ymm8[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1,2,3,4,5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm1[0],ymm3[2],ymm1[2]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],xmm10[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovaps 16(%rcx), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 16(%rdx), %xmm6
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm6[0],xmm5[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm11[0,1],ymm1[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm5[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 16(%r8), %xmm2
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm4[1],ymm2[1],ymm4[3],ymm2[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rcx), %ymm3, %ymm4
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %xmm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2],ymm4[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm4[0],xmm3[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %ymm2
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm5[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%rcx), %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %ymm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm3[1],xmm0[1]
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %ymm3
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],ymm5[0],ymm2[2],ymm5[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovaps 48(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm5[1],ymm1[1],ymm5[3],ymm1[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rax), %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%r8), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 64(%rax), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vbroadcastsd 72(%rcx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm11
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm5 = xmm11[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %ymm3
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %ymm0
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %ymm1
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovaps 80(%rcx), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 80(%rdx), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovaps 80(%rax), %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%rcx), %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %xmm3
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm3[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps 96(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 104(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm2[1],xmm6[1]
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %ymm0
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %ymm1
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovaps 112(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 112(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 112(%rax), %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 128(%r8), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 128(%rax), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vbroadcastsd 136(%rcx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %xmm13
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm5 = xmm13[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %ymm3
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%r8), %ymm0
; AVX1-ONLY-NEXT:    vmovaps 128(%r9), %ymm1
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovaps 144(%rcx), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 144(%rdx), %xmm5
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm5[0],xmm4[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovaps 144(%rax), %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rcx), %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 160(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps 160(%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 160(%r8), %xmm3
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm3[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps 160(%rax), %xmm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 168(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm2[1],xmm6[1]
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%r8), %ymm0
; AVX1-ONLY-NEXT:    vmovaps 160(%r9), %ymm1
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovaps 176(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 176(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 176(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 176(%rax), %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 176(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 192(%r8), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %xmm9
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm2, %ymm4
; AVX1-ONLY-NEXT:    vmovaps 192(%rax), %xmm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm4[2,3],ymm2[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rdx), %ymm4
; AVX1-ONLY-NEXT:    vbroadcastsd 200(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %xmm8
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm7 = xmm8[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm6[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %ymm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm5[0],ymm1[2],ymm5[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 208(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 208(%rdx), %xmm6
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm6[0],xmm3[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm6[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 208(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm5[1],ymm1[1],ymm5[3],ymm1[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vmovaps 208(%rax), %xmm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm1[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm4[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%rcx), %ymm5, %ymm6
; AVX1-ONLY-NEXT:    vmovaps 224(%rdx), %xmm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm7 = ymm5[0],ymm6[1],ymm5[2],ymm6[2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vmovddup {{.*#+}} xmm5 = mem[0,0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm5[2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 224(%r8), %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%rax), %ymm2, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm5[0,1],ymm4[2,3],ymm5[4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 232(%rcx), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%r8), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovapd 224(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovapd 224(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-ONLY-NEXT:    vmovddup {{.*#+}} xmm15 = mem[0,0]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm15[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovapd 240(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm15 = ymm15[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0,0,3,2]
; AVX1-ONLY-NEXT:    vmovapd 224(%rax), %ymm0
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm15[1],ymm1[2],ymm15[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 216(%r9), %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm15[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 240(%rcx), %xmm15
; AVX1-ONLY-NEXT:    vmovapd 240(%rdx), %xmm14
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm14 = xmm14[0],xmm15[0]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm14[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 240(%r9), %ymm14
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0,1,2],ymm14[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm14 = xmm15[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 248(%r9), %ymm15
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm14 = ymm14[0,1],ymm15[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0],ymm0[1],ymm4[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm14[0,1,2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm13 = xmm12[0],xmm13[0]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm14 = xmm10[0],xmm11[0]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm8 = xmm9[0],xmm8[0]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm9, %xmm9 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm9 = xmm9[0],mem[0]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 128(%rdx), %xmm15
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm15 = xmm15[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %xmm12
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm12 = xmm12[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps 192(%rdx), %xmm11
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm11 = xmm11[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm10
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm10 = xmm10[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps %xmm10, 16(%rsi)
; AVX1-ONLY-NEXT:    vmovaps %xmm9, (%rsi)
; AVX1-ONLY-NEXT:    vmovaps %xmm11, 1360(%rsi)
; AVX1-ONLY-NEXT:    vmovaps %xmm8, 1344(%rsi)
; AVX1-ONLY-NEXT:    vmovaps %xmm12, 464(%rsi)
; AVX1-ONLY-NEXT:    vmovaps %xmm14, 448(%rsi)
; AVX1-ONLY-NEXT:    vmovaps %xmm15, 912(%rsi)
; AVX1-ONLY-NEXT:    vmovaps %xmm13, 896(%rsi)
; AVX1-ONLY-NEXT:    vmovapd %ymm0, 1760(%rsi)
; AVX1-ONLY-NEXT:    vmovapd %ymm1, 1728(%rsi)
; AVX1-ONLY-NEXT:    vmovapd %ymm2, 1696(%rsi)
; AVX1-ONLY-NEXT:    vmovapd %ymm4, 1664(%rsi)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 1632(%rsi)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 1600(%rsi)
; AVX1-ONLY-NEXT:    vmovapd %ymm7, 1568(%rsi)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 1536(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1504(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1472(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1440(%rsi)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1408(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1376(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1312(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1280(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1248(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1216(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1184(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1152(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1120(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1088(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1056(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1024(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 992(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 960(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 928(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 864(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 832(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 800(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 768(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 736(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 704(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 640(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 608(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 544(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 512(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rsi)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rsi)
; AVX1-ONLY-NEXT:    addq $1320, %rsp # imm = 0x528
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride7_vf32:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $1672, %rsp # imm = 0x688
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-ONLY-NEXT:    vmovaps (%r8), %ymm7
; AVX2-ONLY-NEXT:    vmovups %ymm7, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%r9), %ymm8
; AVX2-ONLY-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm3
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rcx), %ymm3, %ymm3
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vmovaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm4, %ymm4
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm4[0],ymm3[0],ymm4[2],ymm3[2]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%rcx), %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm5
; AVX2-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm4
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm10
; AVX2-ONLY-NEXT:    vmovaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 16(%rax), %xmm5
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm6 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],xmm10[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm7[0],ymm8[0],ymm7[2],ymm8[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm2[0],mem[0],ymm2[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm6[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm3
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm4[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 48(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vbroadcastsd 72(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %ymm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm4[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 80(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %xmm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vmovaps 96(%rax), %xmm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 104(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 112(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 128(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, 128(%rdx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vbroadcastsd 136(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 128(%r8), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rax), %xmm13
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm13[1]
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%r8), %ymm12
; AVX2-ONLY-NEXT:    vmovaps 128(%r9), %ymm11
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm12[0],ymm11[0],ymm12[2],ymm11[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm4[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 144(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%r8), %xmm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vmovaps 160(%rax), %xmm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %xmm9
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rdx), %xmm8
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm8[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 168(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 160(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 160(%r8), %ymm7
; AVX2-ONLY-NEXT:    vmovaps 160(%r9), %ymm6
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm7[0],ymm6[0],ymm7[2],ymm6[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 176(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 192(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vinsertf128 $1, 192(%rdx), %ymm5, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vbroadcastsd 200(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 192(%r8), %xmm3
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %ymm10
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm4[0],ymm10[0],ymm4[2],ymm10[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm15[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],mem[0],ymm1[2],mem[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm15 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm15[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm4[1],ymm10[1],ymm4[3],ymm10[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 208(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 224(%r8), %ymm4
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm4[0,1],ymm0[0,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm10[0,1],ymm1[2,3],ymm10[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 224(%rax), %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm10[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm10 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm10 = xmm10[1],xmm1[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 232(%rcx), %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm15[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 224(%r8), %ymm0, %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rsi), %ymm10
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm15 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm0[0],ymm10[0],ymm0[2],ymm10[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1,2,3],ymm14[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm10[1],ymm0[3],ymm10[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm10 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vmovaps 224(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 240(%rax), %xmm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm14[0,1],ymm10[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm10 = xmm10[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm14[4,5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm10 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm10 = ymm10[1],mem[1],ymm10[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm14[0,1],ymm10[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm10 = xmm10[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd 32(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm10 = ymm10[1],mem[1],ymm10[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm14[0,1],ymm10[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm10 = xmm10[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm14[4,5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm10, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm10 = ymm10[1],mem[1],ymm10[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 88(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm14[0,1],ymm10[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm10 = xmm10[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd 96(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm10[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm10 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm10 = ymm10[1],mem[1],ymm10[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 120(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm14[0,1],ymm10[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm14 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm13, %ymm13
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1,2,3],ymm13[4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm12[1],ymm11[1],ymm12[3],ymm11[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 152(%rcx), %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0,1],ymm11[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm9 = xmm9[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm9, %ymm8
; AVX2-ONLY-NEXT:    vbroadcastsd 160(%rcx), %ymm9
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm9[6,7]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm7[1],ymm6[1],ymm7[3],ymm6[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 184(%rcx), %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm3[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm2, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 216(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 216(%r9), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm5, %ymm1
; AVX2-ONLY-NEXT:    vbroadcastsd 224(%rcx), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm4[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 240(%r9), %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 248(%rcx), %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 248(%r9), %ymm5
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 224(%rax), %ymm5
; AVX2-ONLY-NEXT:    vblendps $243, {{[-0-9]+}}(%r{{[sb]}}p), %ymm5, %ymm7 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm7 = mem[0,1],ymm5[2,3],mem[4,5,6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 1760(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 1728(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1696(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 1664(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1632(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1600(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 1568(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 1536(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1504(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1472(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1440(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1408(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 1376(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1344(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 1312(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1280(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1248(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1216(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1184(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1152(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 1120(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 1088(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1056(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1024(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 992(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 960(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm13, 928(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 896(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 864(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 832(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 800(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 768(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 736(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 704(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm15, 672(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 640(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 608(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 576(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 544(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 512(%rcx)
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 480(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 416(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 224(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-ONLY-NEXT:    addq $1672, %rsp # imm = 0x688
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-ONLY-SLOW-LABEL: store_i64_stride7_vf32:
; AVX512F-ONLY-SLOW:       # %bb.0:
; AVX512F-ONLY-SLOW-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rax), %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rax), %zmm6
; AVX512F-ONLY-SLOW-NEXT:    movb $96, %r10b
; AVX512F-ONLY-SLOW-NEXT:    kmovw %r10d, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [9,1,9,1,9,1,9,1]
; AVX512F-ONLY-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm5, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [4,9,0,3,4,9,0,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm7, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [11,3,11,3,11,3,11,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm7, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [2,10,0,3,2,10,0,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm16, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm7 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %ymm17
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %ymm17, (%rsp) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%r9), %ymm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %ymm16, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%r8), %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%r8), %ymm19
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %ymm19, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm1[0],ymm17[0],ymm1[2],ymm17[2]
; AVX512F-ONLY-SLOW-NEXT:    movb $28, %r10b
; AVX512F-ONLY-SLOW-NEXT:    kmovw %r10d, %k2
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm7 {%k2} = zmm1[0,1,2,3],zmm5[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [4,12,0,5,4,12,0,5]
; AVX512F-ONLY-SLOW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm17, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,1,12,7,0,1,12,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm2, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [5,0,14,6,5,0,14,6]
; AVX512F-ONLY-SLOW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm21, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,13,6,7,0,13,6,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm1, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm31 = [15,7,15,7,15,7,15,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm22, %zmm31, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [6,13,14,7,6,13,14,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm18, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm20, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm19[0],ymm16[0],ymm19[2],ymm16[2]
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm5 {%k2} = zmm0[0,1,2,3],zmm6[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm19
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm19, %zmm15, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm11, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm19, %zmm17, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm2, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm19, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm21, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm19, %zmm31, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rsi), %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm25, %zmm18, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdx), %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rcx), %zmm29
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm20, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rax), %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 128(%r9), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%r8), %ymm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %ymm16, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm16[0],ymm0[0],ymm16[2],ymm0[2]
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm6 {%k2} = zmm0[0,1,2,3],zmm18[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%r9), %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm0, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm2, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm6, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm1, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm15, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm5, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm31, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [13,5,13,5,13,5,13,5]
; AVX512F-ONLY-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [6,14,6,14,6,14,6,14]
; AVX512F-ONLY-SLOW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm26, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm31, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [3,0,12,4,3,0,12,4]
; AVX512F-ONLY-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm0, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm26, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm31, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm13, %zmm0, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rdx), %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm26, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm6, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm29, %zmm30, %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm24
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm31, %zmm24
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm30, %zmm0, %zmm29
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm17, %zmm0, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm17, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm31, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm6, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    movb $48, %r10b
; AVX512F-ONLY-SLOW-NEXT:    kmovw %r10d, %k3
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [1,0,10,2,1,0,10,2]
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm31
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm8, %zmm3, %zmm31
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm2 {%k3} = zmm8[0],zmm10[0],zmm8[2],zmm10[2],zmm8[4],zmm10[4],zmm8[6],zmm10[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm19
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [0,8,0,1,0,8,0,1]
; AVX512F-ONLY-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm5, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [6,14,6,14]
; AVX512F-ONLY-SLOW-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm1, %zmm19
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} ymm20 = [15,7,15,7]
; AVX512F-ONLY-SLOW-NEXT:    # ymm20 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm20, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm3, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm21 {%k3} = zmm12[0],zmm9[0],zmm12[2],zmm9[2],zmm12[4],zmm9[4],zmm12[6],zmm9[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm5, %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm6, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm1, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm20, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm3, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm11, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm11, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm29 {%k3} = zmm11[0],zmm25[0],zmm11[2],zmm25[2],zmm11[4],zmm25[4],zmm11[6],zmm25[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm25, %zmm5, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm25, %zmm20, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm18 {%k3} = zmm14[0],zmm0[0],zmm14[2],zmm0[2],zmm14[4],zmm0[4],zmm14[6],zmm0[6]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm14, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm14, %zmm0, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm14, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm20, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rdx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    movb $12, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm30 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [0,8,0,8,0,8,0,8]
; AVX512F-ONLY-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm20 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, (%rax), %zmm20, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    movb $112, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm30 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdx), %xmm20
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm20 = xmm20[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm20
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm20, %zmm0, %zmm12 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm20 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, 64(%rax), %zmm20, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm12 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdx), %xmm20
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm20 = xmm20[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm20
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm20, %zmm0, %zmm11 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm20 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, 128(%rax), %zmm20, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm11 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rdx), %xmm20
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm20 = xmm20[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm20
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm20, %zmm0, %zmm5 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%r8), %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%r9), %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm20, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, 192(%rax), %zmm0, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    movb $120, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm19, %zmm19 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # zmm19 = zmm19[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $-61, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, %zmm2 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm23, %zmm6 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm23 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm23 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    movb $24, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm16, %zmm2 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # zmm2 = zmm16[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm1[0,1,2,3],zmm26[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    movb $-31, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm9 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm4
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = mem[0,1,2,3],ymm4[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $6, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm31 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 72(%rcx), %ymm4
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = mem[0,1,2,3],ymm4[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm8 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 136(%rcx), %ymm4
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = mem[0,1,2,3],ymm4[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm10 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 200(%rcx), %ymm4
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = mem[0,1,2,3],ymm4[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm3 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    movb $56, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm20, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rax), %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm27, %zmm15 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm22, %zmm6 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # zmm6 = zmm22[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <0,11,u,u,4,5,6,7>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm18, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm18 = <0,1,11,u,4,5,6,7>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm16, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%r8), %ymm16
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm16 = ymm16[0],mem[0],ymm16[2],mem[2]
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k2} = zmm16[0,1,2,3],zmm4[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, %zmm14 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq (%rsp), %ymm0, %ymm16 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm16 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm16[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $14, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm16 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm21 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512F-ONLY-SLOW-NEXT:    movb $64, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm6 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    movb $8, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm18 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm29 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = <12,u,u,3,4,5,6,13>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm15, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <u,1,2,3,4,15,u,u>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm14, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <0,12,u,3,4,5,6,7>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm0, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = <13,u,2,3,4,5,6,14>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm6, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <u,1,2,3,4,5,15,u>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm15, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm15 = [0,1,12,3,4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm14, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [0,13,2,3,4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm0, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [14,1,2,3,4,5,6,15]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm6, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm22, 1472(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, 1408(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, 1280(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, 1216(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm23, 1152(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm1, 1024(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, 960(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, 832(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, 768(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, 704(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm1, 576(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, 512(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, 384(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm1, 256(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm1, 128(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm31, 64(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, 1344(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, 1088(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, 896(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm21, 640(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, 448(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, 192(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, (%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, 1728(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, 1664(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, 1600(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, 1536(%rax)
; AVX512F-ONLY-SLOW-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512F-ONLY-SLOW-NEXT:    vzeroupper
; AVX512F-ONLY-SLOW-NEXT:    retq
;
; AVX512F-ONLY-FAST-LABEL: store_i64_stride7_vf32:
; AVX512F-ONLY-FAST:       # %bb.0:
; AVX512F-ONLY-FAST-NEXT:    subq $2024, %rsp # imm = 0x7E8
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rsi), %zmm11
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdx), %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rcx), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm17
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r8), %zmm24
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r9), %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rax), %zmm4
; AVX512F-ONLY-FAST-NEXT:    movb $96, %r10b
; AVX512F-ONLY-FAST-NEXT:    kmovw %r10d, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [9,1,9,1,9,1,9,1]
; AVX512F-ONLY-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm24, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm12
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,9,0,3,4,9,0,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [11,3,11,3,11,3,11,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm1, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [2,10,0,3,2,10,0,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm16
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%r9), %ymm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 64(%r9), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%r9), %ymm26
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r8), %ymm19
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%r8), %ymm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%r8), %ymm20
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm19[0],ymm1[0],ymm19[2],ymm1[2]
; AVX512F-ONLY-FAST-NEXT:    movb $28, %r10b
; AVX512F-ONLY-FAST-NEXT:    kmovw %r10d, %k2
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm10 {%k2} = zmm3[0,1,2,3],zmm4[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm28 = [1,3,7,7]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %ymm1, %ymm28, %ymm19
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %ymm19, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [4,12,0,5,4,12,0,5]
; AVX512F-ONLY-FAST-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm24, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm19, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [0,1,12,7,0,1,12,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm27, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [5,0,14,6,5,0,14,6]
; AVX512F-ONLY-FAST-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm24, %zmm21, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,13,6,7,0,13,6,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm29, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [15,7,15,7,15,7,15,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm25, %zmm24
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm31 = [6,13,14,7,6,13,14,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm24, %zmm31, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm18[0],ymm0[0],ymm18[2],ymm0[2]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %ymm0, %ymm28, %ymm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %ymm18, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm20[0],ymm26[0],ymm20[2],ymm26[2]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %ymm26, %ymm28, %ymm20
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %ymm20, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm14, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm16, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rax), %zmm14
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm4 {%k2} = zmm1[0,1,2,3],zmm14[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%r9), %zmm23
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm23, %zmm12, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm15, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm23, %zmm19, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm27, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm21, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm29, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm23, %zmm25, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm31, %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm28
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rsi), %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm10, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rdx), %zmm16
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rcx), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, %zmm26
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm18, %zmm26
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rax), %zmm12
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm26 {%k2} = zmm3[0,1,2,3],zmm12[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%r8), %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%r9), %zmm20
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm1, %zmm19
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm27, %zmm19
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm20, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm29, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm9, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm15, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm25, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm31, %zmm12
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm31 = [3,0,12,4,3,0,12,4]
; AVX512F-ONLY-FAST-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm31, %zmm27
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [13,5,13,5,13,5,13,5]
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [6,14,6,14,6,14,6,14]
; AVX512F-ONLY-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm10, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm25, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    movb $48, %r10b
; AVX512F-ONLY-FAST-NEXT:    kmovw %r10d, %k3
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,8,0,1,0,8,0,1]
; AVX512F-ONLY-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm29, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [1,0,10,2,1,0,10,2]
; AVX512F-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm5, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm27 {%k3} = zmm1[0],zmm11[0],zmm1[2],zmm11[2],zmm1[4],zmm11[4],zmm1[6],zmm11[6]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm3, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [6,14,6,14]
; AVX512F-ONLY-FAST-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm6, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [15,7,15,7]
; AVX512F-ONLY-FAST-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm2, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, %zmm19
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm8, %zmm31, %zmm19
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm10, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm25, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm17
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm29, %zmm17
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm5, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm19 {%k3} = zmm7[0],zmm13[0],zmm7[2],zmm13[2],zmm7[4],zmm13[4],zmm7[6],zmm13[6]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm3, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm6, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm2, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rdx), %zmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm10, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm18, %zmm31, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm18, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm25, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm16, %zmm0, %zmm31
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm16, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, %zmm30
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm25, %zmm16
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm3, %zmm30
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm6, %zmm24
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm3, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, %zmm25
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm29, %zmm25
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm28, %zmm5, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm31 {%k3} = zmm28[0],zmm4[0],zmm28[2],zmm4[2],zmm28[4],zmm4[4],zmm28[6],zmm4[6]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm28, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm28, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} ymm22 = [15,7,15,7]
; AVX512F-ONLY-FAST-NEXT:    # ymm22 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm22, %zmm28
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm13 {%k3} = zmm1[0],zmm0[0],zmm1[2],zmm0[2],zmm1[4],zmm0[4],zmm1[6],zmm0[6]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm1, %zmm29
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm1, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%rdx), %xmm0
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-ONLY-FAST-NEXT:    movb $12, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm21 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [0,8,0,8,0,8,0,8]
; AVX512F-ONLY-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm4 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, (%rax), %zmm4, %zmm4
; AVX512F-ONLY-FAST-NEXT:    movb $112, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm21 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 64(%rdx), %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm17 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm23, %zmm0, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, 64(%rax), %zmm4, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm17 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 128(%rdx), %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm25 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm0, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, 128(%rax), %zmm4, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm25 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 192(%rdx), %xmm4
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm29 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%r8), %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%r9), %zmm20
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm4, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, 192(%rax), %zmm0, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    movb $14, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm27 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512F-ONLY-FAST-NEXT:    movb $120, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm22 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm19 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm31 {%k3}
; AVX512F-ONLY-FAST-NEXT:    movb $-61, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k5}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm8 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, %zmm3 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm30 {%k4}
; AVX512F-ONLY-FAST-NEXT:    movb $24, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm3 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm3 {%k5}
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm6 = zmm6[0,1,2,3],zmm10[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm6 {%k5}
; AVX512F-ONLY-FAST-NEXT:    movb $-31, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm9 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, %zmm28 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm28 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm8
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = mem[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    movb $6, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm15 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 72(%rcx), %ymm8
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = mem[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm11 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 136(%rcx), %ymm8
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = mem[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm2 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 200(%rcx), %ymm8
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = mem[0,1,2,3],ymm8[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm5 {%k4}
; AVX512F-ONLY-FAST-NEXT:    movb $56, %cl
; AVX512F-ONLY-FAST-NEXT:    kmovw %ecx, %k4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm15 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm11 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm2 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm4, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rax), %zmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm8, %zmm10, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm5 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm7 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm14 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm24, %zmm9 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # zmm9 = zmm24[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <0,11,u,u,4,5,6,7>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm13, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <0,1,11,u,4,5,6,7>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm10, %zmm12
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 192(%r8), %ymm10
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm10 = ymm10[0],mem[0],ymm10[2],mem[2]
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k2} = zmm10[0,1,2,3],zmm8[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    movb $64, %al
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm9 {%k1}
; AVX512F-ONLY-FAST-NEXT:    movb $8, %al
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm12 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm1 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <12,u,u,3,4,5,6,13>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm7, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,1,2,3,4,15,u,u>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm1, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <0,12,u,3,4,5,6,7>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm10, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <13,u,2,3,4,5,6,14>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm9, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,1,2,3,4,5,15,u>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm7, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,1,12,3,4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm8, %zmm1, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,13,2,3,4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm8, %zmm4, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [14,1,2,3,4,5,6,15]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm8, %zmm9, %zmm4
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, 1472(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, 1408(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, 1280(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, 1216(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, 1152(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, 1088(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm26, 1024(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, 960(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, 832(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, 768(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm2, 704(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm19, 640(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm2, 576(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, 512(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm2, 384(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, 320(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm22, 256(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm27, 192(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm15, 64(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, 1344(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm25, 896(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, 448(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm21, (%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, 1728(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, 1664(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, 1600(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, 1536(%rax)
; AVX512F-ONLY-FAST-NEXT:    addq $2024, %rsp # imm = 0x7E8
; AVX512F-ONLY-FAST-NEXT:    vzeroupper
; AVX512F-ONLY-FAST-NEXT:    retq
;
; AVX512DQ-SLOW-LABEL: store_i64_stride7_vf32:
; AVX512DQ-SLOW:       # %bb.0:
; AVX512DQ-SLOW-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm11
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm12
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm24
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rax), %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rax), %zmm6
; AVX512DQ-SLOW-NEXT:    movb $96, %r10b
; AVX512DQ-SLOW-NEXT:    kmovw %r10d, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [9,1,9,1,9,1,9,1]
; AVX512DQ-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [4,9,0,3,4,9,0,3]
; AVX512DQ-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm15
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [11,3,11,3,11,3,11,3]
; AVX512DQ-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm5, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm18
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [2,10,0,3,2,10,0,3]
; AVX512DQ-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm16, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm20
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r9), %ymm16
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %ymm16, (%rsp) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%r9), %ymm17
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %ymm17, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa (%r8), %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%r8), %ymm19
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %ymm19, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm1[0],ymm16[0],ymm1[2],ymm16[2]
; AVX512DQ-SLOW-NEXT:    movb $28, %r10b
; AVX512DQ-SLOW-NEXT:    kmovw %r10d, %k2
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm5 {%k2} = zmm1[0,1,2,3],zmm3[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [4,12,0,5,4,12,0,5]
; AVX512DQ-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm5
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,1,12,7,0,1,12,7]
; AVX512DQ-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm22 = [5,0,14,6,5,0,14,6]
; AVX512DQ-SLOW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm23
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm21
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm23
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,6,7,0,13,6,7]
; AVX512DQ-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm23
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm29 = [15,7,15,7,15,7,15,7]
; AVX512DQ-SLOW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [6,13,14,7,6,13,14,7]
; AVX512DQ-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm3, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm10, %zmm18, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm24, %zmm20, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm19[0],ymm17[0],ymm19[2],ymm17[2]
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm5 {%k2} = zmm0[0,1,2,3],zmm6[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm21
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm14, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm19
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm15, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm17
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm16, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm2, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm3, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rsi), %zmm31
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm31, %zmm18, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rdx), %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rcx), %zmm28
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm15
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm28, %zmm20, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rax), %zmm20
; AVX512DQ-SLOW-NEXT:    vmovdqa 128(%r9), %ymm0
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%r8), %ymm18
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %ymm18, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm18[0],ymm0[0],ymm18[2],ymm0[2]
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm6 {%k2} = zmm0[0,1,2,3],zmm20[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%r9), %zmm6
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm6, %zmm0, %zmm16
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm20, %zmm1, %zmm16
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm0, %zmm6, %zmm22
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm20, %zmm2, %zmm22
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm19, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm20, %zmm17, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm29, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm3, %zmm20
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [13,5,13,5,13,5,13,5]
; AVX512DQ-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [6,14,6,14,6,14,6,14]
; AVX512DQ-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm29, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [3,0,12,4,3,0,12,4]
; AVX512DQ-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm13, %zmm0, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm24, %zmm6, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm27
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm24, %zmm2, %zmm27
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm30
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm24, %zmm29, %zmm30
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm0, %zmm24
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rdx), %zmm16
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm3
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm2, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm21
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm28, %zmm6, %zmm21
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm28, %zmm5, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm23
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm28, %zmm29, %zmm23
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm0, %zmm28
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm16, %zmm0, %zmm20
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm1, %zmm16, %zmm15
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm29, %zmm16
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm6, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    movb $48, %r10b
; AVX512DQ-SLOW-NEXT:    kmovw %r10d, %k3
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [1,0,10,2,1,0,10,2]
; AVX512DQ-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm19
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm9, %zmm5, %zmm19
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm4 {%k3} = zmm9[0],zmm12[0],zmm9[2],zmm12[2],zmm9[4],zmm12[4],zmm9[6],zmm12[6]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm17
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm29
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm4 = [0,8,0,1,0,8,0,1]
; AVX512DQ-SLOW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm4, %zmm29
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm6, %zmm3
; AVX512DQ-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [6,14,6,14]
; AVX512DQ-SLOW-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm2, %zmm8
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x2 {{.*#+}} ymm22 = [15,7,15,7]
; AVX512DQ-SLOW-NEXT:    # ymm22 = mem[0,1,0,1]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm22, %zmm17
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm15
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm11, %zmm5, %zmm15
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm24 {%k3} = zmm11[0],zmm10[0],zmm11[2],zmm10[2],zmm11[4],zmm10[4],zmm11[6],zmm10[6]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm9
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm10, %zmm4, %zmm11
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm10, %zmm2, %zmm7
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm10, %zmm22, %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm25
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm25
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm18
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm18
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm13
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm14, %zmm5, %zmm13
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm31, %zmm14, %zmm6
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm31, %zmm14, %zmm2
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm28 {%k3} = zmm14[0],zmm31[0],zmm14[2],zmm31[2],zmm14[4],zmm31[4],zmm14[6],zmm31[6]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm12
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm31, %zmm4, %zmm14
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm31, %zmm22, %zmm12
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm20 {%k3} = zmm10[0],zmm0[0],zmm10[2],zmm0[2],zmm10[4],zmm0[4],zmm10[6],zmm0[6]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm0, %zmm10, %zmm4
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm10, %zmm0, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm0, %zmm10, %zmm31
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512DQ-SLOW-NEXT:    movb $120, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k3}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm22 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # zmm22 = zmm8[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    movb $-61, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm1 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k3}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm6 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k3}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    movb $24, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k3}
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm7[0,1,2,3],zmm27[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k4}
; AVX512DQ-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm2, %zmm2 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # zmm2 = zmm2[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k4}
; AVX512DQ-SLOW-NEXT:    movb $-31, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm9 {%k3}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm23, %zmm12 {%k3}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rdx), %xmm3
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512DQ-SLOW-NEXT:    movb $12, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k4
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm29 {%k4}
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [0,8,0,8,0,8,0,8]
; AVX512DQ-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm0 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm6
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm11 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa 128(%rdx), %xmm6
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm14 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa 192(%rdx), %xmm6
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm4 {%k4}
; AVX512DQ-SLOW-NEXT:    movb $112, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k4
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, (%rax), %zmm0, %zmm29 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm0 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, 64(%rax), %zmm0, %zmm11 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm0 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, 128(%rax), %zmm0, %zmm14 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%r8), %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%r9), %zmm7
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm3
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, 192(%rax), %zmm3, %zmm4 {%k4}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm3
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    movb $6, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k4
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm19 {%k4}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 72(%rcx), %ymm3
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm15 {%k4}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 136(%rcx), %ymm3
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm13 {%k4}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 200(%rcx), %ymm3
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm5 {%k4}
; AVX512DQ-SLOW-NEXT:    movb $56, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rax), %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm8, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm0 {%k1}
; AVX512DQ-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm25, %zmm8 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # zmm8 = zmm25[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm21 = <0,11,u,u,4,5,6,7>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm6, %zmm20, %zmm21
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm20 = <0,1,11,u,4,5,6,7>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm7, %zmm21, %zmm20
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%r8), %ymm21
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm21 = ymm21[0],mem[0],ymm21[2],mem[2]
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k2} = zmm21[0,1,2,3],zmm3[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm21
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm10 {%k3}
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq (%rsp), %ymm0, %ymm16 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm16 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm16[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    movb $14, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm23 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm23 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm24 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-SLOW-NEXT:    movb $64, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm8 {%k2}
; AVX512DQ-SLOW-NEXT:    movb $8, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm20 {%k2}
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm28 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = <12,u,u,3,4,5,6,13>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm6, %zmm18, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <u,1,2,3,4,15,u,u>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm6, %zmm10, %zmm16
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <0,12,u,3,4,5,6,7>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm7, %zmm0, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = <13,u,2,3,4,5,6,14>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm7, %zmm8, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,1,2,3,4,5,15,u>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm7, %zmm16, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,1,12,3,4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm6, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,13,2,3,4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm0, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [14,1,2,3,4,5,6,15]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm8, %zmm0
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, 1472(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, 1408(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, 1344(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, 1280(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, 1216(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm2, 1152(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm28, 1088(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm2, 1024(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, 960(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, 896(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, 832(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, 768(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm26, 704(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm24, 640(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm1, 576(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm15, 512(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, 448(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm17, 384(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm22, 320(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm1, 256(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm23, 192(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm1, 128(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm19, 64(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm29, (%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, 1728(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, 1664(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm7, 1600(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm20, 1536(%rax)
; AVX512DQ-SLOW-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512DQ-SLOW-NEXT:    vzeroupper
; AVX512DQ-SLOW-NEXT:    retq
;
; AVX512DQ-FAST-LABEL: store_i64_stride7_vf32:
; AVX512DQ-FAST:       # %bb.0:
; AVX512DQ-FAST-NEXT:    subq $2024, %rsp # imm = 0x7E8
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm11
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm17
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm15
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdx), %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm19
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r8), %zmm30
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r9), %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rax), %zmm7
; AVX512DQ-FAST-NEXT:    movb $96, %r10b
; AVX512DQ-FAST-NEXT:    kmovw %r10d, %k1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [9,1,9,1,9,1,9,1]
; AVX512DQ-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,9,0,3,4,9,0,3]
; AVX512DQ-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm7, %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [11,3,11,3,11,3,11,3]
; AVX512DQ-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm12
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [2,10,0,3,2,10,0,3]
; AVX512DQ-FAST-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm14, %zmm2, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqa (%r9), %ymm1
; AVX512DQ-FAST-NEXT:    vmovdqa 64(%r9), %ymm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%r9), %ymm25
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r8), %ymm16
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%r8), %ymm18
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%r8), %ymm20
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm16[0],ymm1[0],ymm16[2],ymm1[2]
; AVX512DQ-FAST-NEXT:    movb $28, %r10b
; AVX512DQ-FAST-NEXT:    kmovw %r10d, %k2
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm8 {%k2} = zmm2[0,1,2,3],zmm7[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm27 = [1,3,7,7]
; AVX512DQ-FAST-NEXT:    vpermt2q %ymm1, %ymm27, %ymm16
; AVX512DQ-FAST-NEXT:    vmovdqu64 %ymm16, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [4,12,0,5,4,12,0,5]
; AVX512DQ-FAST-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm16, %zmm1
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,1,12,7,0,1,12,7]
; AVX512DQ-FAST-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm7, %zmm26, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [5,0,14,6,5,0,14,6]
; AVX512DQ-FAST-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm30, %zmm21, %zmm1
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [0,13,6,7,0,13,6,7]
; AVX512DQ-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm7, %zmm28, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm24 = [15,7,15,7,15,7,15,7]
; AVX512DQ-FAST-NEXT:    # zmm24 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm24, %zmm30
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [6,13,14,7,6,13,14,7]
; AVX512DQ-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm30, %zmm29, %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm18[0],ymm0[0],ymm18[2],ymm0[2]
; AVX512DQ-FAST-NEXT:    vpermt2q %ymm0, %ymm27, %ymm18
; AVX512DQ-FAST-NEXT:    vmovdqu64 %ymm18, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm20[0],ymm25[0],ymm20[2],ymm25[2]
; AVX512DQ-FAST-NEXT:    vpermt2q %ymm25, %ymm27, %ymm20
; AVX512DQ-FAST-NEXT:    vmovdqu64 %ymm20, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm11, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm17, %zmm12, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm19, %zmm13, %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rax), %zmm13
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm4 {%k2} = zmm1[0,1,2,3],zmm13[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%r8), %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%r9), %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm9, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm13, %zmm10, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm16, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm13, %zmm26, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm21, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm13, %zmm28, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm24, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm29, %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm30
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rsi), %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm8, %zmm12, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rdx), %zmm23
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rcx), %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm7, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm7, %zmm20
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rax), %zmm12
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm2 {%k2} = zmm0[0,1,2,3],zmm12[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%r9), %zmm1
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm16
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm12, %zmm26, %zmm16
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm0, %zmm1, %zmm21
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm12, %zmm28, %zmm21
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm2, %zmm9, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm12, %zmm10, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm2, %zmm24, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm29, %zmm12
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [3,0,12,4,3,0,12,4]
; AVX512DQ-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm14, %zmm26
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm29, %zmm26
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [13,5,13,5,13,5,13,5]
; AVX512DQ-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm14, %zmm1, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [6,14,6,14,6,14,6,14]
; AVX512DQ-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm14, %zmm10, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm14, %zmm24, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    movb $48, %r10b
; AVX512DQ-FAST-NEXT:    kmovw %r10d, %k3
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,8,0,1,0,8,0,1]
; AVX512DQ-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm18
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm7, %zmm18
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [1,0,10,2,1,0,10,2]
; AVX512DQ-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm28
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm6, %zmm28
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm26 {%k3} = zmm5[0],zmm3[0],zmm5[2],zmm3[2],zmm5[4],zmm3[4],zmm5[6],zmm3[6]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm9
; AVX512DQ-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [6,14,6,14]
; AVX512DQ-FAST-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm25
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm5, %zmm25
; AVX512DQ-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [15,7,15,7]
; AVX512DQ-FAST-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm19, %zmm16
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm15, %zmm29, %zmm16
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm15, %zmm27
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm19, %zmm1, %zmm27
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm15, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm19, %zmm10, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm19, %zmm24, %zmm15
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm11, %zmm19
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm17, %zmm7, %zmm19
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm17, %zmm14
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm11, %zmm6, %zmm14
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm16 {%k3} = zmm11[0],zmm17[0],zmm11[2],zmm17[2],zmm11[4],zmm17[4],zmm11[6],zmm17[6]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm17, %zmm1, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm11, %zmm21
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm17, %zmm5, %zmm21
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm17, %zmm2, %zmm11
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rdx), %zmm15
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm10, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm15, %zmm29, %zmm17
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm0, %zmm15, %zmm20
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm24, %zmm15
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm23, %zmm4, %zmm29
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm4, %zmm23, %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm23, %zmm31
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm24, %zmm23
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm1, %zmm31
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm22
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm5, %zmm22
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm1, %zmm11
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm30, %zmm24
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm8, %zmm7, %zmm24
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, %zmm4
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm30, %zmm6, %zmm4
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm29 {%k3} = zmm30[0],zmm8[0],zmm30[2],zmm8[2],zmm30[4],zmm8[4],zmm30[6],zmm8[6]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm8, %zmm30, %zmm1
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm8, %zmm30, %zmm5
; AVX512DQ-FAST-NEXT:    vbroadcasti64x2 {{.*#+}} ymm20 = [15,7,15,7]
; AVX512DQ-FAST-NEXT:    # ymm20 = mem[0,1,0,1]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm8, %zmm20, %zmm30
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm17 {%k3} = zmm2[0],zmm0[0],zmm2[2],zmm0[2],zmm2[4],zmm0[4],zmm2[6],zmm0[6]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm0, %zmm2, %zmm7
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm2, %zmm0, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm0, %zmm2, %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm20, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-FAST-NEXT:    movb $14, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k3
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm26 {%k3}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512DQ-FAST-NEXT:    movb $120, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k4
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm25, %zmm0 # 64-byte Folded Reload
; AVX512DQ-FAST-NEXT:    # zmm0 = zmm25[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm16 {%k3}
; AVX512DQ-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm29 {%k3}
; AVX512DQ-FAST-NEXT:    movb $-61, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k5
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, %zmm0 {%k5}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm27, %zmm3 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm20 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm31, %zmm1 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm25 {%k4}
; AVX512DQ-FAST-NEXT:    movb $24, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k3
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm8 {%k3}
; AVX512DQ-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm21, %zmm1 # 64-byte Folded Reload
; AVX512DQ-FAST-NEXT:    # zmm1 = zmm21[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k5}
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm5[0,1,2,3],zmm10[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm3 {%k5}
; AVX512DQ-FAST-NEXT:    movb $-31, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k4
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm8 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, %zmm27
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, %zmm5 {%k3}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, %zmm5 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm31
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm23, %zmm30 {%k3}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, %zmm30 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-FAST-NEXT:    movb $12, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k4
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm18 {%k4}
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [0,8,0,8,0,8,0,8]
; AVX512DQ-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm5, %zmm9 # 64-byte Folded Reload
; AVX512DQ-FAST-NEXT:    vmovdqa 64(%rdx), %xmm8
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm8 = xmm8[0],mem[0]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm19 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqa 128(%rdx), %xmm8
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm8 = xmm8[0],mem[0]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm24 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqa 192(%rdx), %xmm8
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm8 = xmm8[0],mem[0]
; AVX512DQ-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm7 {%k4}
; AVX512DQ-FAST-NEXT:    movb $112, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k4
; AVX512DQ-FAST-NEXT:    vinserti64x2 $3, (%rax), %zmm9, %zmm18 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm5, %zmm8 # 64-byte Folded Reload
; AVX512DQ-FAST-NEXT:    vinserti64x2 $3, 64(%rax), %zmm8, %zmm19 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm5, %zmm8 # 64-byte Folded Reload
; AVX512DQ-FAST-NEXT:    vinserti64x2 $3, 128(%rax), %zmm8, %zmm24 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%r8), %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%r9), %zmm9
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm9, %zmm8, %zmm5
; AVX512DQ-FAST-NEXT:    vinserti64x2 $3, 192(%rax), %zmm5, %zmm7 {%k4}
; AVX512DQ-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm5
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQ-FAST-NEXT:    movb $6, %sil
; AVX512DQ-FAST-NEXT:    kmovw %esi, %k4
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm28 {%k4}
; AVX512DQ-FAST-NEXT:    vpbroadcastq 72(%rcx), %ymm5
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm14 {%k4}
; AVX512DQ-FAST-NEXT:    vpbroadcastq 136(%rcx), %ymm5
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm4 {%k4}
; AVX512DQ-FAST-NEXT:    vpbroadcastq 200(%rcx), %ymm5
; AVX512DQ-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm6 {%k4}
; AVX512DQ-FAST-NEXT:    movb $56, %cl
; AVX512DQ-FAST-NEXT:    kmovw %ecx, %k4
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm28 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm14 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm4 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm9, %zmm8, %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rax), %zmm5
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm12, %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm10, %zmm6 {%k4}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm10, %zmm11 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm10, %zmm21 {%k1}
; AVX512DQ-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm22, %zmm10 # 64-byte Folded Reload
; AVX512DQ-FAST-NEXT:    # zmm10 = zmm22[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <0,11,u,u,4,5,6,7>
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm8, %zmm17, %zmm12
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <0,1,11,u,4,5,6,7>
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm9, %zmm12, %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqa 192(%r8), %ymm12
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm12 = ymm12[0],mem[0],ymm12[2],mem[2]
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm21 {%k2} = zmm12[0,1,2,3],zmm5[2,3,0,1]
; AVX512DQ-FAST-NEXT:    movb $64, %al
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, %zmm10 {%k1}
; AVX512DQ-FAST-NEXT:    movb $8, %al
; AVX512DQ-FAST-NEXT:    kmovw %eax, %k1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm13 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm15, %zmm2 {%k3}
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <12,u,u,3,4,5,6,13>
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm8, %zmm11, %zmm12
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,1,2,3,4,15,u,u>
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm8, %zmm2, %zmm11
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <0,12,u,3,4,5,6,7>
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm9, %zmm12, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <13,u,2,3,4,5,6,14>
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm9, %zmm10, %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,1,2,3,4,5,15,u>
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm9, %zmm11, %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [0,1,12,3,4,5,6,7]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm5, %zmm2, %zmm9
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,13,2,3,4,5,6,7]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm5, %zmm8, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [14,1,2,3,4,5,6,15]
; AVX512DQ-FAST-NEXT:    vpermi2q %zmm5, %zmm10, %zmm8
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm21, 1472(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, 1408(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm7, 1344(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm30, 1280(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, 1216(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm25, 1152(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm29, 1088(%rax)
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovaps %zmm3, 1024(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, 960(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm24, 896(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm31, 832(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, 768(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm20, 704(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm16, 640(%rax)
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovaps %zmm1, 576(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm14, 512(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm19, 448(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm27, 384(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, 320(%rax)
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm26, 192(%rax)
; AVX512DQ-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm28, 64(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm18, (%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, 1728(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, 1664(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, 1600(%rax)
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm13, 1536(%rax)
; AVX512DQ-FAST-NEXT:    addq $2024, %rsp # imm = 0x7E8
; AVX512DQ-FAST-NEXT:    vzeroupper
; AVX512DQ-FAST-NEXT:    retq
;
; AVX512BW-ONLY-SLOW-LABEL: store_i64_stride7_vf32:
; AVX512BW-ONLY-SLOW:       # %bb.0:
; AVX512BW-ONLY-SLOW-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512BW-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm12
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%rax), %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rax), %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    movb $96, %r10b
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %r10d, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [9,1,9,1,9,1,9,1]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm5, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [4,9,0,3,4,9,0,3]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm7, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [11,3,11,3,11,3,11,3]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm7, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [2,10,0,3,2,10,0,3]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm16, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm7 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %ymm17
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %ymm17, (%rsp) # 32-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%r9), %ymm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %ymm16, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa (%r8), %ymm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%r8), %ymm19
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %ymm19, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm1[0],ymm17[0],ymm1[2],ymm17[2]
; AVX512BW-ONLY-SLOW-NEXT:    movb $28, %r10b
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %r10d, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm7 {%k2} = zmm1[0,1,2,3],zmm5[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [4,12,0,5,4,12,0,5]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm17, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,1,12,7,0,1,12,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm2, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [5,0,14,6,5,0,14,6]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm21, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,13,6,7,0,13,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm1, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm31 = [15,7,15,7,15,7,15,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm22, %zmm31, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [6,13,14,7,6,13,14,7]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm18, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm20, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm19[0],ymm16[0],ymm19[2],ymm16[2]
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm5 {%k2} = zmm0[0,1,2,3],zmm6[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm19
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm19, %zmm15, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm11, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm19, %zmm17, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm2, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm19, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm21, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm19, %zmm31, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 128(%rsi), %zmm25
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm25, %zmm18, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdx), %zmm30
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 128(%rcx), %zmm29
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm20, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 128(%rax), %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa 128(%r9), %ymm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 128(%r8), %ymm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %ymm16, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm16[0],ymm0[0],ymm16[2],ymm0[2]
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm6 {%k2} = zmm0[0,1,2,3],zmm18[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 128(%r9), %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm0, %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm2, %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm6, %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm1, %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm15, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm5, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm31, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [13,5,13,5,13,5,13,5]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [6,14,6,14,6,14,6,14]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm26, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm31, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [3,0,12,4,3,0,12,4]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm0, %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm28
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm28
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm26, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm31, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm13, %zmm0, %zmm21
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 192(%rdx), %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm26, %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm23
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm6, %zmm23
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm29, %zmm30, %zmm26
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm24
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm31, %zmm24
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm30, %zmm0, %zmm29
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm17, %zmm0, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm17, %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, %zmm27
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm31, %zmm17
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm6, %zmm27
; AVX512BW-ONLY-SLOW-NEXT:    movb $48, %r10b
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %r10d, %k3
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [1,0,10,2,1,0,10,2]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm31
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm8, %zmm3, %zmm31
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm2 {%k3} = zmm8[0],zmm10[0],zmm8[2],zmm10[2],zmm8[4],zmm10[4],zmm8[6],zmm10[6]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm19
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm30
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [0,8,0,1,0,8,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm5, %zmm30
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm1 = [6,14,6,14]
; AVX512BW-ONLY-SLOW-NEXT:    # ymm1 = mem[0,1,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm1, %zmm19
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} ymm20 = [15,7,15,7]
; AVX512BW-ONLY-SLOW-NEXT:    # ymm20 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm20, %zmm13
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm3, %zmm8
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm21 {%k3} = zmm12[0],zmm9[0],zmm12[2],zmm9[2],zmm12[4],zmm9[4],zmm12[6],zmm9[6]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm5, %zmm12
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm6, %zmm2
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm1, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm20, %zmm7
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm22
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm22
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm3, %zmm10
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm11, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm11, %zmm1
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm29 {%k3} = zmm11[0],zmm25[0],zmm11[2],zmm25[2],zmm11[4],zmm25[4],zmm11[6],zmm25[6]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm25, %zmm5, %zmm11
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm25, %zmm20, %zmm9
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm18 {%k3} = zmm14[0],zmm0[0],zmm14[2],zmm0[2],zmm14[4],zmm0[4],zmm14[6],zmm0[6]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm14, %zmm5
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm14, %zmm0, %zmm3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm14, %zmm25
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm20, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa (%rdx), %xmm0
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-ONLY-SLOW-NEXT:    movb $12, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm30 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [0,8,0,8,0,8,0,8]
; AVX512BW-ONLY-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm20 # 64-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $3, (%rax), %zmm20, %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    movb $112, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm30 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdx), %xmm20
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm20 = xmm20[0],mem[0]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm20
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm20, %zmm0, %zmm12 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm20 # 64-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $3, 64(%rax), %zmm20, %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm12 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdx), %xmm20
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm20 = xmm20[0],mem[0]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm20
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm20, %zmm0, %zmm11 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm20 # 64-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $3, 128(%rax), %zmm20, %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm11 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 192(%rdx), %xmm20
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm20 = xmm20[0],mem[0]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $1, %xmm20, %ymm0, %ymm20
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm20, %zmm0, %zmm5 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 192(%r8), %zmm20
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 192(%r9), %zmm25
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm20, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vinserti32x4 $3, 192(%rax), %zmm0, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    movb $120, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm19, %zmm19 # 64-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # zmm19 = zmm19[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    movb $-61, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, %zmm2 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm23, %zmm6 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm23 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm23 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    movb $24, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm16, %zmm2 # 64-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # zmm2 = zmm16[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm1[0,1,2,3],zmm26[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    movb $-31, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm9 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm4
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = mem[0,1,2,3],ymm4[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    movb $6, %sil
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %esi, %k4
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm31 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vpbroadcastq 72(%rcx), %ymm4
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = mem[0,1,2,3],ymm4[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm8 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vpbroadcastq 136(%rcx), %ymm4
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = mem[0,1,2,3],ymm4[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm10 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vpbroadcastq 200(%rcx), %ymm4
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm4 = mem[0,1,2,3],ymm4[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm3 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    movb $56, %cl
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %ecx, %k4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm20, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 192(%rax), %zmm4
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k4}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm27, %zmm15 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm22, %zmm6 # 64-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # zmm6 = zmm22[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <0,11,u,u,4,5,6,7>
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm18, %zmm16
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm18 = <0,1,11,u,4,5,6,7>
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm16, %zmm18
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 192(%r8), %ymm16
; AVX512BW-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm16 = ymm16[0],mem[0],ymm16[2],mem[2]
; AVX512BW-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k2} = zmm16[0,1,2,3],zmm4[2,3,0,1]
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm22
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, %zmm14 {%k3}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpunpckhqdq (%rsp), %ymm0, %ymm16 # 32-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # ymm16 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm16[0,2,3,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-SLOW-NEXT:    movb $14, %cl
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm16 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm21 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512BW-ONLY-SLOW-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512BW-ONLY-SLOW-NEXT:    movb $64, %cl
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %ecx, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm6 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    movb $8, %cl
; AVX512BW-ONLY-SLOW-NEXT:    kmovd %ecx, %k2
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm18 {%k2}
; AVX512BW-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512BW-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm29 {%k1}
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = <12,u,u,3,4,5,6,13>
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm15, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <u,1,2,3,4,15,u,u>
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm20, %zmm14, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <0,12,u,3,4,5,6,7>
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm0, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = <13,u,2,3,4,5,6,14>
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm6, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <u,1,2,3,4,5,15,u>
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm25, %zmm15, %zmm6
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm15 = [0,1,12,3,4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm14, %zmm15
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [0,13,2,3,4,5,6,7]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm0, %zmm14
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [14,1,2,3,4,5,6,15]
; AVX512BW-ONLY-SLOW-NEXT:    vpermi2q %zmm4, %zmm6, %zmm0
; AVX512BW-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm22, 1472(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, 1408(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, 1280(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, 1216(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm23, 1152(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovaps %zmm1, 1024(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, 960(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, 832(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, 768(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, 704(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovaps %zmm1, 576(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, 512(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, 384(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovaps %zmm1, 256(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-ONLY-SLOW-NEXT:    vmovaps %zmm1, 128(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm31, 64(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, 1344(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, 1088(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, 896(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm21, 640(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, 448(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, 192(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, (%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, 1728(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, 1664(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, 1600(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, 1536(%rax)
; AVX512BW-ONLY-SLOW-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512BW-ONLY-SLOW-NEXT:    vzeroupper
; AVX512BW-ONLY-SLOW-NEXT:    retq
;
; AVX512BW-ONLY-FAST-LABEL: store_i64_stride7_vf32:
; AVX512BW-ONLY-FAST:       # %bb.0:
; AVX512BW-ONLY-FAST-NEXT:    subq $2024, %rsp # imm = 0x7E8
; AVX512BW-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rsi), %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rdx), %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rcx), %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%r8), %zmm24
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%r9), %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%rax), %zmm4
; AVX512BW-ONLY-FAST-NEXT:    movb $96, %r10b
; AVX512BW-ONLY-FAST-NEXT:    kmovd %r10d, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [9,1,9,1,9,1,9,1]
; AVX512BW-ONLY-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm24, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm0, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm12
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,9,0,3,4,9,0,3]
; AVX512BW-ONLY-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm15
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [11,3,11,3,11,3,11,3]
; AVX512BW-ONLY-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm1, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [2,10,0,3,2,10,0,3]
; AVX512BW-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa (%r9), %ymm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 64(%r9), %ymm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 128(%r9), %ymm26
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 (%r8), %ymm19
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%r8), %ymm18
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 128(%r8), %ymm20
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm19[0],ymm1[0],ymm19[2],ymm1[2]
; AVX512BW-ONLY-FAST-NEXT:    movb $28, %r10b
; AVX512BW-ONLY-FAST-NEXT:    kmovd %r10d, %k2
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm10 {%k2} = zmm3[0,1,2,3],zmm4[2,3,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm28 = [1,3,7,7]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %ymm1, %ymm28, %ymm19
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %ymm19, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [4,12,0,5,4,12,0,5]
; AVX512BW-ONLY-FAST-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm24, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm19, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [0,1,12,7,0,1,12,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm27, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [5,0,14,6,5,0,14,6]
; AVX512BW-ONLY-FAST-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm24, %zmm21, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,13,6,7,0,13,6,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm29, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [15,7,15,7,15,7,15,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm25, %zmm24
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm31 = [6,13,14,7,6,13,14,7]
; AVX512BW-ONLY-FAST-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm24, %zmm31, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm18[0],ymm0[0],ymm18[2],ymm0[2]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %ymm0, %ymm28, %ymm18
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %ymm18, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm20[0],ymm26[0],ymm20[2],ymm26[2]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %ymm26, %ymm28, %ymm20
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %ymm20, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm14, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm16, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%rax), %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm4 {%k2} = zmm1[0,1,2,3],zmm14[2,3,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 64(%r9), %zmm23
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm23, %zmm12, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm15, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm23, %zmm19, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm27, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm21, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm29, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm23, %zmm25, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm31, %zmm14
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 128(%rsi), %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm10, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 128(%rdx), %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 128(%rcx), %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, %zmm26
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm18, %zmm26
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm22
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 128(%rax), %zmm12
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm26 {%k2} = zmm3[0,1,2,3],zmm12[2,3,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 128(%r8), %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 128(%r9), %zmm20
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm1, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm27, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm20, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm29, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm9, %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm15, %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm25, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm31, %zmm12
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm31 = [3,0,12,4,3,0,12,4]
; AVX512BW-ONLY-FAST-NEXT:    # zmm31 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm27
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm6, %zmm31, %zmm27
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [13,5,13,5,13,5,13,5]
; AVX512BW-ONLY-FAST-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [6,14,6,14,6,14,6,14]
; AVX512BW-ONLY-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm10, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm25, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    movb $48, %r10b
; AVX512BW-ONLY-FAST-NEXT:    kmovd %r10d, %k3
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [0,8,0,1,0,8,0,1]
; AVX512BW-ONLY-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm29, %zmm21
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [1,0,10,2,1,0,10,2]
; AVX512BW-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm15
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm5, %zmm15
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm27 {%k3} = zmm1[0],zmm11[0],zmm1[2],zmm11[2],zmm1[4],zmm11[4],zmm1[6],zmm11[6]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm3, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [6,14,6,14]
; AVX512BW-ONLY-FAST-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm6, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [15,7,15,7]
; AVX512BW-ONLY-FAST-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm2, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm8, %zmm31, %zmm19
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm3, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm10, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm25, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm29, %zmm17
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm5, %zmm11
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm19 {%k3} = zmm7[0],zmm13[0],zmm7[2],zmm13[2],zmm7[4],zmm13[4],zmm7[6],zmm13[6]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm3, %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm6, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm13, %zmm2, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 192(%rdx), %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm10, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm18, %zmm31, %zmm13
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm3, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm18, %zmm22
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm25, %zmm18
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm16, %zmm0, %zmm31
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm16, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, %zmm30
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm25, %zmm16
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm3, %zmm30
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm24
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm6, %zmm24
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm3, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, %zmm25
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm29, %zmm25
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm28, %zmm5, %zmm2
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm31 {%k3} = zmm28[0],zmm4[0],zmm28[2],zmm4[2],zmm28[4],zmm4[4],zmm28[6],zmm4[6]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm28, %zmm3
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm28, %zmm6
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} ymm22 = [15,7,15,7]
; AVX512BW-ONLY-FAST-NEXT:    # ymm22 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm22, %zmm28
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm13 {%k3} = zmm1[0],zmm0[0],zmm1[2],zmm0[2],zmm1[4],zmm0[4],zmm1[6],zmm0[6]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm1, %zmm29
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm5
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm1, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa (%rdx), %xmm0
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512BW-ONLY-FAST-NEXT:    movb $12, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm21 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [0,8,0,8,0,8,0,8]
; AVX512BW-ONLY-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm4 # 64-byte Folded Reload
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $3, (%rax), %zmm4, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    movb $112, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm21 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 64(%rdx), %xmm4
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm17 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm23, %zmm0, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $3, 64(%rax), %zmm4, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm17 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 128(%rdx), %xmm4
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm25 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm0, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $3, 128(%rax), %zmm4, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm25 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 192(%rdx), %xmm4
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX512BW-ONLY-FAST-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm4, %zmm0, %zmm29 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 192(%r8), %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 192(%r9), %zmm20
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm4, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vinserti32x4 $3, 192(%rax), %zmm0, %zmm0
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-FAST-NEXT:    movb $14, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm27 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    movb $120, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm22 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm22 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512BW-ONLY-FAST-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm19 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm31 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    movb $-61, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k5
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k5}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm8 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, %zmm3 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm30 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    movb $24, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k3
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm3 # 64-byte Folded Reload
; AVX512BW-ONLY-FAST-NEXT:    # zmm3 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm3 {%k5}
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm6 = zmm6[0,1,2,3],zmm10[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm6 {%k5}
; AVX512BW-ONLY-FAST-NEXT:    movb $-31, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, %zmm9 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm23
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, %zmm28 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm28 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm8
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = mem[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    movb $6, %sil
; AVX512BW-ONLY-FAST-NEXT:    kmovd %esi, %k4
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm15 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vpbroadcastq 72(%rcx), %ymm8
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = mem[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm11 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vpbroadcastq 136(%rcx), %ymm8
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = mem[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm2 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vpbroadcastq 200(%rcx), %ymm8
; AVX512BW-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = mem[0,1,2,3],ymm8[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm5 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    movb $56, %cl
; AVX512BW-ONLY-FAST-NEXT:    kmovd %ecx, %k4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm15 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm11 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm2 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm4, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 192(%rax), %zmm8
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vpermt2q %zmm8, %zmm10, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm5 {%k4}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm7 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm14 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm24, %zmm9 # 64-byte Folded Reload
; AVX512BW-ONLY-FAST-NEXT:    # zmm9 = zmm24[0,1,2,3],mem[4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <0,11,u,u,4,5,6,7>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm13, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <0,1,11,u,4,5,6,7>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm10, %zmm12
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa 192(%r8), %ymm10
; AVX512BW-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm10 = ymm10[0],mem[0],ymm10[2],mem[2]
; AVX512BW-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k2} = zmm10[0,1,2,3],zmm8[2,3,0,1]
; AVX512BW-ONLY-FAST-NEXT:    movb $64, %al
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm9 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    movb $8, %al
; AVX512BW-ONLY-FAST-NEXT:    kmovd %eax, %k1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm12 {%k1}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm1 {%k3}
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <12,u,u,3,4,5,6,13>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm7, %zmm10
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,1,2,3,4,15,u,u>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm4, %zmm1, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <0,12,u,3,4,5,6,7>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm10, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <13,u,2,3,4,5,6,14>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm9, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,1,2,3,4,5,15,u>
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm20, %zmm7, %zmm9
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,1,12,3,4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm8, %zmm1, %zmm7
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,13,2,3,4,5,6,7]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm8, %zmm4, %zmm1
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [14,1,2,3,4,5,6,15]
; AVX512BW-ONLY-FAST-NEXT:    vpermi2q %zmm8, %zmm9, %zmm4
; AVX512BW-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, 1472(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, 1408(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, 1280(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, 1216(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, 1152(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, 1088(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm26, 1024(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, 960(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm23, 832(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, 768(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovaps %zmm2, 704(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm19, 640(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovaps %zmm2, 576(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, 512(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovaps %zmm2, 384(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, 320(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm22, 256(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm27, 192(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-ONLY-FAST-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm15, 64(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, 1344(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm25, 896(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, 448(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm21, (%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, 1728(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, 1664(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, 1600(%rax)
; AVX512BW-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, 1536(%rax)
; AVX512BW-ONLY-FAST-NEXT:    addq $2024, %rsp # imm = 0x7E8
; AVX512BW-ONLY-FAST-NEXT:    vzeroupper
; AVX512BW-ONLY-FAST-NEXT:    retq
;
; AVX512DQBW-SLOW-LABEL: store_i64_stride7_vf32:
; AVX512DQBW-SLOW:       # %bb.0:
; AVX512DQBW-SLOW-NEXT:    subq $2120, %rsp # imm = 0x848
; AVX512DQBW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm9
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm11
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm12
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm10
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm8
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm13
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm24
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%r9), %zmm2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%rax), %zmm3
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%rax), %zmm6
; AVX512DQBW-SLOW-NEXT:    movb $96, %r10b
; AVX512DQBW-SLOW-NEXT:    kmovd %r10d, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [9,1,9,1,9,1,9,1]
; AVX512DQBW-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [4,9,0,3,4,9,0,3]
; AVX512DQBW-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm15
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [11,3,11,3,11,3,11,3]
; AVX512DQBW-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm1
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm12, %zmm5, %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm18
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [2,10,0,3,2,10,0,3]
; AVX512DQBW-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm16, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm20
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 (%r9), %ymm16
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %ymm16, (%rsp) # 32-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%r9), %ymm17
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %ymm17, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa (%r8), %ymm1
; AVX512DQBW-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%r8), %ymm19
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %ymm19, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm1[0],ymm16[0],ymm1[2],ymm16[2]
; AVX512DQBW-SLOW-NEXT:    movb $28, %r10b
; AVX512DQBW-SLOW-NEXT:    kmovd %r10d, %k2
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm5 {%k2} = zmm1[0,1,2,3],zmm3[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [4,12,0,5,4,12,0,5]
; AVX512DQBW-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm5
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,1,12,7,0,1,12,7]
; AVX512DQBW-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm22 = [5,0,14,6,5,0,14,6]
; AVX512DQBW-SLOW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm23
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm21
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm23
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,13,6,7,0,13,6,7]
; AVX512DQBW-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm23
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm29 = [15,7,15,7,15,7,15,7]
; AVX512DQBW-SLOW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [6,13,14,7,6,13,14,7]
; AVX512DQBW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm3, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm10, %zmm18, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm24, %zmm20, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm19[0],ymm17[0],ymm19[2],ymm17[2]
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm5 {%k2} = zmm0[0,1,2,3],zmm6[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm21
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm14, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm19
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm15, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm17
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm16, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm5
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm2, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm21, %zmm29, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm3, %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm14
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 128(%rsi), %zmm31
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm31, %zmm18, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 128(%rdx), %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 128(%rcx), %zmm28
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm15
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm28, %zmm20, %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 128(%rax), %zmm20
; AVX512DQBW-SLOW-NEXT:    vmovdqa 128(%r9), %ymm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 128(%r8), %ymm18
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %ymm18, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm18[0],ymm0[0],ymm18[2],ymm0[2]
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm6 {%k2} = zmm0[0,1,2,3],zmm20[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 128(%r9), %zmm6
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm6, %zmm0, %zmm16
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm20, %zmm1, %zmm16
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm0, %zmm6, %zmm22
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm20, %zmm2, %zmm22
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm19, %zmm1
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm20, %zmm17, %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm6, %zmm29, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm3, %zmm20
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm6 = [13,5,13,5,13,5,13,5]
; AVX512DQBW-SLOW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [6,14,6,14,6,14,6,14]
; AVX512DQBW-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm4, %zmm29, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [3,0,12,4,3,0,12,4]
; AVX512DQBW-SLOW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm13, %zmm0, %zmm4
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm24, %zmm6, %zmm26
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm27
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm24, %zmm2, %zmm27
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm30
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm24, %zmm29, %zmm30
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm8, %zmm0, %zmm24
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 192(%rdx), %zmm16
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm3
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm2, %zmm3
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm21
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm28, %zmm6, %zmm21
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm28, %zmm5, %zmm2
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm23
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm28, %zmm29, %zmm23
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm5, %zmm0, %zmm28
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm16, %zmm0, %zmm20
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm1, %zmm16, %zmm15
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm0
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm29, %zmm16
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm1, %zmm6, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    movb $48, %r10b
; AVX512DQBW-SLOW-NEXT:    kmovd %r10d, %k3
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm5 = [1,0,10,2,1,0,10,2]
; AVX512DQBW-SLOW-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm19
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm9, %zmm5, %zmm19
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm4 {%k3} = zmm9[0],zmm12[0],zmm9[2],zmm12[2],zmm9[4],zmm12[4],zmm9[6],zmm12[6]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm8
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm17
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm29
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm4 = [0,8,0,1,0,8,0,1]
; AVX512DQBW-SLOW-NEXT:    # zmm4 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm12, %zmm4, %zmm29
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm12, %zmm6, %zmm3
; AVX512DQBW-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [6,14,6,14]
; AVX512DQBW-SLOW-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm12, %zmm2, %zmm8
; AVX512DQBW-SLOW-NEXT:    vbroadcasti64x2 {{.*#+}} ymm22 = [15,7,15,7]
; AVX512DQBW-SLOW-NEXT:    # ymm22 = mem[0,1,0,1]
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm12, %zmm22, %zmm17
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm15
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm11, %zmm5, %zmm15
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm24 {%k3} = zmm11[0],zmm10[0],zmm11[2],zmm10[2],zmm11[4],zmm10[4],zmm11[6],zmm10[6]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm1
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm7
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm9
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm10, %zmm4, %zmm11
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm1
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm10, %zmm2, %zmm7
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm10, %zmm22, %zmm9
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm10
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm25
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm25
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm10, %zmm18
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm6, %zmm18
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm13
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm14, %zmm5, %zmm13
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm31, %zmm14, %zmm6
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm31, %zmm14, %zmm2
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm28 {%k3} = zmm14[0],zmm31[0],zmm14[2],zmm31[2],zmm14[4],zmm31[4],zmm14[6],zmm31[6]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm12
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm31, %zmm4, %zmm14
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm31, %zmm22, %zmm12
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm20 {%k3} = zmm10[0],zmm0[0],zmm10[2],zmm0[2],zmm10[4],zmm0[4],zmm10[6],zmm0[6]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm0, %zmm10, %zmm4
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm10, %zmm0, %zmm5
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm0, %zmm10, %zmm31
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm10
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512DQBW-SLOW-NEXT:    movb $120, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k3
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k3}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm22 # 64-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # zmm22 = zmm8[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    movb $-61, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k4
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm1 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm26 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k3}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm6 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k3}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-SLOW-NEXT:    movb $24, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k3
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k3}
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm1 = zmm7[0,1,2,3],zmm27[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k4}
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm2, %zmm2 # 64-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # zmm2 = zmm2[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k4}
; AVX512DQBW-SLOW-NEXT:    movb $-31, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k4
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm9 {%k3}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm23, %zmm12 {%k3}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqa (%rdx), %xmm3
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],mem[0]
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512DQBW-SLOW-NEXT:    movb $12, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k4
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm29 {%k4}
; AVX512DQBW-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm3 = [0,8,0,8,0,8,0,8]
; AVX512DQBW-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm0 # 64-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm6
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm11 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqa 128(%rdx), %xmm6
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm14 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqa 192(%rdx), %xmm6
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQBW-SLOW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm4 {%k4}
; AVX512DQBW-SLOW-NEXT:    movb $112, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k4
; AVX512DQBW-SLOW-NEXT:    vinserti64x2 $3, (%rax), %zmm0, %zmm29 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm0 # 64-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    vinserti64x2 $3, 64(%rax), %zmm0, %zmm11 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm0 # 64-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    vinserti64x2 $3, 128(%rax), %zmm0, %zmm14 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 192(%r8), %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 192(%r9), %zmm7
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm3
; AVX512DQBW-SLOW-NEXT:    vinserti64x2 $3, 192(%rax), %zmm3, %zmm4 {%k4}
; AVX512DQBW-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm3
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    movb $6, %sil
; AVX512DQBW-SLOW-NEXT:    kmovd %esi, %k4
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm19 {%k4}
; AVX512DQBW-SLOW-NEXT:    vpbroadcastq 72(%rcx), %ymm3
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm15 {%k4}
; AVX512DQBW-SLOW-NEXT:    vpbroadcastq 136(%rcx), %ymm3
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm13 {%k4}
; AVX512DQBW-SLOW-NEXT:    vpbroadcastq 200(%rcx), %ymm3
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm3 = mem[0,1,2,3],ymm3[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm5 {%k4}
; AVX512DQBW-SLOW-NEXT:    movb $56, %cl
; AVX512DQBW-SLOW-NEXT:    kmovd %ecx, %k4
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm7, %zmm6, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 192(%rax), %zmm3
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpermt2q %zmm3, %zmm8, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k4}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm0 {%k1}
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm25, %zmm8 # 64-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # zmm8 = zmm25[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm21 = <0,11,u,u,4,5,6,7>
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm6, %zmm20, %zmm21
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm20 = <0,1,11,u,4,5,6,7>
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm7, %zmm21, %zmm20
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 192(%r8), %ymm21
; AVX512DQBW-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm21 = ymm21[0],mem[0],ymm21[2],mem[2]
; AVX512DQBW-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k2} = zmm21[0,1,2,3],zmm3[2,3,0,1]
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm21
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm16, %zmm10 {%k3}
; AVX512DQBW-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpunpckhqdq (%rsp), %ymm0, %ymm16 # 32-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # ymm16 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm16[0,2,3,3]
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-SLOW-NEXT:    movb $14, %cl
; AVX512DQBW-SLOW-NEXT:    kmovd %ecx, %k1
; AVX512DQBW-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm23 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm23 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm24 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQBW-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512DQBW-SLOW-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQBW-SLOW-NEXT:    movb $64, %cl
; AVX512DQBW-SLOW-NEXT:    kmovd %ecx, %k2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm8 {%k2}
; AVX512DQBW-SLOW-NEXT:    movb $8, %cl
; AVX512DQBW-SLOW-NEXT:    kmovd %ecx, %k2
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm20 {%k2}
; AVX512DQBW-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512DQBW-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm28 {%k1}
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = <12,u,u,3,4,5,6,13>
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm6, %zmm18, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <u,1,2,3,4,15,u,u>
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm6, %zmm10, %zmm16
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <0,12,u,3,4,5,6,7>
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm7, %zmm0, %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = <13,u,2,3,4,5,6,14>
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm7, %zmm8, %zmm0
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,1,2,3,4,5,15,u>
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm7, %zmm16, %zmm8
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [0,1,12,3,4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm3, %zmm6, %zmm7
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,13,2,3,4,5,6,7]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm3, %zmm0, %zmm6
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [14,1,2,3,4,5,6,15]
; AVX512DQBW-SLOW-NEXT:    vpermi2q %zmm3, %zmm8, %zmm0
; AVX512DQBW-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm21, 1472(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm5, 1408(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm4, 1344(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm12, 1280(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm2, 1216(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovaps %zmm2, 1152(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm28, 1088(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovaps %zmm2, 1024(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm13, 960(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm14, 896(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm9, 832(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm1, 768(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm26, 704(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm24, 640(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovaps %zmm1, 576(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm15, 512(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm11, 448(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm17, 384(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm22, 320(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovaps %zmm1, 256(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm23, 192(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-SLOW-NEXT:    vmovaps %zmm1, 128(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm19, 64(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm29, (%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm0, 1728(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm6, 1664(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm7, 1600(%rax)
; AVX512DQBW-SLOW-NEXT:    vmovdqa64 %zmm20, 1536(%rax)
; AVX512DQBW-SLOW-NEXT:    addq $2120, %rsp # imm = 0x848
; AVX512DQBW-SLOW-NEXT:    vzeroupper
; AVX512DQBW-SLOW-NEXT:    retq
;
; AVX512DQBW-FAST-LABEL: store_i64_stride7_vf32:
; AVX512DQBW-FAST:       # %bb.0:
; AVX512DQBW-FAST-NEXT:    subq $2024, %rsp # imm = 0x7E8
; AVX512DQBW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm17
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm15
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rdx), %zmm6
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm19
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%r8), %zmm30
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%r9), %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%rax), %zmm7
; AVX512DQBW-FAST-NEXT:    movb $96, %r10b
; AVX512DQBW-FAST-NEXT:    kmovd %r10d, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [9,1,9,1,9,1,9,1]
; AVX512DQBW-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm0, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,9,0,3,4,9,0,3]
; AVX512DQBW-FAST-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm7, %zmm0, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [11,3,11,3,11,3,11,3]
; AVX512DQBW-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm12
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [2,10,0,3,2,10,0,3]
; AVX512DQBW-FAST-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm14, %zmm2, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512DQBW-FAST-NEXT:    vmovdqa (%r9), %ymm1
; AVX512DQBW-FAST-NEXT:    vmovdqa 64(%r9), %ymm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 128(%r9), %ymm25
; AVX512DQBW-FAST-NEXT:    vmovdqa64 (%r8), %ymm16
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%r8), %ymm18
; AVX512DQBW-FAST-NEXT:    vmovdqa64 128(%r8), %ymm20
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm16[0],ymm1[0],ymm16[2],ymm1[2]
; AVX512DQBW-FAST-NEXT:    movb $28, %r10b
; AVX512DQBW-FAST-NEXT:    kmovd %r10d, %k2
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm8 {%k2} = zmm2[0,1,2,3],zmm7[2,3,0,1]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} ymm27 = [1,3,7,7]
; AVX512DQBW-FAST-NEXT:    vpermt2q %ymm1, %ymm27, %ymm16
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %ymm16, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [4,12,0,5,4,12,0,5]
; AVX512DQBW-FAST-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm16, %zmm1
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm26 = [0,1,12,7,0,1,12,7]
; AVX512DQBW-FAST-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm7, %zmm26, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [5,0,14,6,5,0,14,6]
; AVX512DQBW-FAST-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm30, %zmm21, %zmm1
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [0,13,6,7,0,13,6,7]
; AVX512DQBW-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm7, %zmm28, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm24 = [15,7,15,7,15,7,15,7]
; AVX512DQBW-FAST-NEXT:    # zmm24 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm24, %zmm30
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [6,13,14,7,6,13,14,7]
; AVX512DQBW-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm30, %zmm29, %zmm7
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm18[0],ymm0[0],ymm18[2],ymm0[2]
; AVX512DQBW-FAST-NEXT:    vpermt2q %ymm0, %ymm27, %ymm18
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %ymm18, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm20[0],ymm25[0],ymm20[2],ymm25[2]
; AVX512DQBW-FAST-NEXT:    vpermt2q %ymm25, %ymm27, %ymm20
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %ymm20, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm17, %zmm12, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm19, %zmm13, %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%rax), %zmm13
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm4 {%k2} = zmm1[0,1,2,3],zmm13[2,3,0,1]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%r8), %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 64(%r9), %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm9, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm13, %zmm10, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm16, %zmm2
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm13, %zmm26, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm21, %zmm2
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm13, %zmm28, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm24, %zmm1
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm1, %zmm29, %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm30
; AVX512DQBW-FAST-NEXT:    vmovdqa64 128(%rsi), %zmm8
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm8, %zmm12, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 128(%rdx), %zmm23
; AVX512DQBW-FAST-NEXT:    vmovdqa64 128(%rcx), %zmm4
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm23, %zmm2
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm7, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm7, %zmm20
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 128(%rax), %zmm12
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm2 {%k2} = zmm0[0,1,2,3],zmm12[2,3,0,1]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 128(%r9), %zmm1
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm1, %zmm0, %zmm16
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm12, %zmm26, %zmm16
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm0, %zmm1, %zmm21
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm12, %zmm28, %zmm21
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm2, %zmm9, %zmm1
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm12, %zmm10, %zmm1
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm2, %zmm24, %zmm0
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm29, %zmm12
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [3,0,12,4,3,0,12,4]
; AVX512DQBW-FAST-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm14, %zmm26
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm6, %zmm29, %zmm26
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [13,5,13,5,13,5,13,5]
; AVX512DQBW-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm14, %zmm1, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [6,14,6,14,6,14,6,14]
; AVX512DQBW-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm6, %zmm0
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm14, %zmm10, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm14, %zmm24, %zmm6
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    movb $48, %r10b
; AVX512DQBW-FAST-NEXT:    kmovd %r10d, %k3
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm7 = [0,8,0,1,0,8,0,1]
; AVX512DQBW-FAST-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm18
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm7, %zmm18
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [1,0,10,2,1,0,10,2]
; AVX512DQBW-FAST-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm28
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm6, %zmm28
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm26 {%k3} = zmm5[0],zmm3[0],zmm5[2],zmm3[2],zmm5[4],zmm3[4],zmm5[6],zmm3[6]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm9
; AVX512DQBW-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [6,14,6,14]
; AVX512DQBW-FAST-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm25
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm5, %zmm25
; AVX512DQBW-FAST-NEXT:    vbroadcasti128 {{.*#+}} ymm2 = [15,7,15,7]
; AVX512DQBW-FAST-NEXT:    # ymm2 = mem[0,1,0,1]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm19, %zmm16
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm15, %zmm29, %zmm16
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm27
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm19, %zmm1, %zmm27
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm0
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm19, %zmm10, %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm19, %zmm24, %zmm15
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm19
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm17, %zmm7, %zmm19
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm17, %zmm14
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm11, %zmm6, %zmm14
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm16 {%k3} = zmm11[0],zmm17[0],zmm11[2],zmm17[2],zmm11[4],zmm17[4],zmm11[6],zmm17[6]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm17, %zmm1, %zmm3
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm11, %zmm21
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm17, %zmm5, %zmm21
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm17, %zmm2, %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 192(%rdx), %zmm15
; AVX512DQBW-FAST-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm10, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm15, %zmm29, %zmm17
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm0, %zmm15, %zmm20
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm24, %zmm15
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm23, %zmm4, %zmm29
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm4, %zmm23, %zmm10
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm23, %zmm31
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm24, %zmm23
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm4, %zmm1, %zmm31
; AVX512DQBW-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm22
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm5, %zmm22
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, %zmm11
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm1, %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm30, %zmm24
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm8, %zmm7, %zmm24
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm4
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm30, %zmm6, %zmm4
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm29 {%k3} = zmm30[0],zmm8[0],zmm30[2],zmm8[2],zmm30[4],zmm8[4],zmm30[6],zmm8[6]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm8, %zmm30, %zmm1
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm8, %zmm30, %zmm5
; AVX512DQBW-FAST-NEXT:    vbroadcasti64x2 {{.*#+}} ymm20 = [15,7,15,7]
; AVX512DQBW-FAST-NEXT:    # ymm20 = mem[0,1,0,1]
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm8, %zmm20, %zmm30
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm17 {%k3} = zmm2[0],zmm0[0],zmm2[2],zmm0[2],zmm2[4],zmm0[4],zmm2[6],zmm0[6]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm0, %zmm2, %zmm7
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm2, %zmm0, %zmm6
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm0, %zmm2, %zmm8
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm0, %zmm20, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-FAST-NEXT:    movb $14, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k3
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm26 {%k3}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k1}
; AVX512DQBW-FAST-NEXT:    movb $120, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k4
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQBW-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm25, %zmm0 # 64-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    # zmm0 = zmm25[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm16 {%k3}
; AVX512DQBW-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm29 {%k3}
; AVX512DQBW-FAST-NEXT:    movb $-61, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k5
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm0 {%k5}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm27, %zmm3 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm20 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm31, %zmm1 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm25 {%k4}
; AVX512DQBW-FAST-NEXT:    movb $24, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k3
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, %zmm8 {%k3}
; AVX512DQBW-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm21, %zmm1 # 64-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    # zmm1 = zmm21[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k5}
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm5[0,1,2,3],zmm10[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm3 {%k5}
; AVX512DQBW-FAST-NEXT:    movb $-31, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k4
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm8 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm27
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm5 {%k3}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm13, %zmm5 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm31
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm23, %zmm30 {%k3}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm12, %zmm30 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQBW-FAST-NEXT:    movb $12, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k4
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm18 {%k4}
; AVX512DQBW-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [0,8,0,8,0,8,0,8]
; AVX512DQBW-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm5, %zmm9 # 64-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa 64(%rdx), %xmm8
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm8 = xmm8[0],mem[0]
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm19 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqa 128(%rdx), %xmm8
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm8 = xmm8[0],mem[0]
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm24 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqa 192(%rdx), %xmm8
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm8 = xmm8[0],mem[0]
; AVX512DQBW-FAST-NEXT:    vinserti128 $1, %xmm8, %ymm0, %ymm8
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm7 {%k4}
; AVX512DQBW-FAST-NEXT:    movb $112, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k4
; AVX512DQBW-FAST-NEXT:    vinserti64x2 $3, (%rax), %zmm9, %zmm18 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm5, %zmm8 # 64-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    vinserti64x2 $3, 64(%rax), %zmm8, %zmm19 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm5, %zmm8 # 64-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    vinserti64x2 $3, 128(%rax), %zmm8, %zmm24 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 192(%r8), %zmm8
; AVX512DQBW-FAST-NEXT:    vmovdqa64 192(%r9), %zmm9
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm9, %zmm8, %zmm5
; AVX512DQBW-FAST-NEXT:    vinserti64x2 $3, 192(%rax), %zmm5, %zmm7 {%k4}
; AVX512DQBW-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm5
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    movb $6, %sil
; AVX512DQBW-FAST-NEXT:    kmovd %esi, %k4
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm28 {%k4}
; AVX512DQBW-FAST-NEXT:    vpbroadcastq 72(%rcx), %ymm5
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm14 {%k4}
; AVX512DQBW-FAST-NEXT:    vpbroadcastq 136(%rcx), %ymm5
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm4 {%k4}
; AVX512DQBW-FAST-NEXT:    vpbroadcastq 200(%rcx), %ymm5
; AVX512DQBW-FAST-NEXT:    vpblendd {{.*#+}} ymm5 = mem[0,1,2,3],ymm5[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm6 {%k4}
; AVX512DQBW-FAST-NEXT:    movb $56, %cl
; AVX512DQBW-FAST-NEXT:    kmovd %ecx, %k4
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm28 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm14 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm4 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm9, %zmm8, %zmm10
; AVX512DQBW-FAST-NEXT:    vmovdqa64 192(%rax), %zmm5
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vpermt2q %zmm5, %zmm12, %zmm10
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm6 {%k4}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm11 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm10, %zmm21 {%k1}
; AVX512DQBW-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm22, %zmm10 # 64-byte Folded Reload
; AVX512DQBW-FAST-NEXT:    # zmm10 = zmm22[0,1,2,3],mem[4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <0,11,u,u,4,5,6,7>
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm8, %zmm17, %zmm12
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <0,1,11,u,4,5,6,7>
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm9, %zmm12, %zmm13
; AVX512DQBW-FAST-NEXT:    vmovdqa 192(%r8), %ymm12
; AVX512DQBW-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm12 = ymm12[0],mem[0],ymm12[2],mem[2]
; AVX512DQBW-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm21 {%k2} = zmm12[0,1,2,3],zmm5[2,3,0,1]
; AVX512DQBW-FAST-NEXT:    movb $64, %al
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm8, %zmm10 {%k1}
; AVX512DQBW-FAST-NEXT:    movb $8, %al
; AVX512DQBW-FAST-NEXT:    kmovd %eax, %k1
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm5, %zmm13 {%k1}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm15, %zmm2 {%k3}
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <12,u,u,3,4,5,6,13>
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm8, %zmm11, %zmm12
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,1,2,3,4,15,u,u>
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm8, %zmm2, %zmm11
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <0,12,u,3,4,5,6,7>
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm9, %zmm12, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <13,u,2,3,4,5,6,14>
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm9, %zmm10, %zmm8
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,1,2,3,4,5,15,u>
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm9, %zmm11, %zmm10
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = [0,1,12,3,4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm5, %zmm2, %zmm9
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,13,2,3,4,5,6,7]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm5, %zmm8, %zmm2
; AVX512DQBW-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [14,1,2,3,4,5,6,15]
; AVX512DQBW-FAST-NEXT:    vpermi2q %zmm5, %zmm10, %zmm8
; AVX512DQBW-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm21, 1472(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm6, 1408(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm7, 1344(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm30, 1280(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm3, 1216(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm25, 1152(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm29, 1088(%rax)
; AVX512DQBW-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovaps %zmm3, 1024(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm4, 960(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm24, 896(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm31, 832(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm1, 768(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm20, 704(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm16, 640(%rax)
; AVX512DQBW-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovaps %zmm1, 576(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm14, 512(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm19, 448(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm27, 384(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm0, 320(%rax)
; AVX512DQBW-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm26, 192(%rax)
; AVX512DQBW-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQBW-FAST-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm28, 64(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm18, (%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm8, 1728(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm2, 1664(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm9, 1600(%rax)
; AVX512DQBW-FAST-NEXT:    vmovdqa64 %zmm13, 1536(%rax)
; AVX512DQBW-FAST-NEXT:    addq $2024, %rsp # imm = 0x7E8
; AVX512DQBW-FAST-NEXT:    vzeroupper
; AVX512DQBW-FAST-NEXT:    retq
  %in.vec0 = load <32 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <32 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <32 x i64>, ptr %in.vecptr5, align 64
  %in.vec6 = load <32 x i64>, ptr %in.vecptr6, align 64
  %1 = shufflevector <32 x i64> %in.vec0, <32 x i64> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i64> %in.vec2, <32 x i64> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <32 x i64> %in.vec4, <32 x i64> %in.vec5, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = shufflevector <64 x i64> %1, <64 x i64> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %5 = shufflevector <32 x i64> %in.vec6, <32 x i64> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <64 x i64> %3, <64 x i64> %5, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %7 = shufflevector <96 x i64> %6, <96 x i64> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %8 = shufflevector <128 x i64> %4, <128 x i64> %7, <224 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223>
  %interleaved.vec = shufflevector <224 x i64> %8, <224 x i64> poison, <224 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 160, i32 192, i32 1, i32 33, i32 65, i32 97, i32 129, i32 161, i32 193, i32 2, i32 34, i32 66, i32 98, i32 130, i32 162, i32 194, i32 3, i32 35, i32 67, i32 99, i32 131, i32 163, i32 195, i32 4, i32 36, i32 68, i32 100, i32 132, i32 164, i32 196, i32 5, i32 37, i32 69, i32 101, i32 133, i32 165, i32 197, i32 6, i32 38, i32 70, i32 102, i32 134, i32 166, i32 198, i32 7, i32 39, i32 71, i32 103, i32 135, i32 167, i32 199, i32 8, i32 40, i32 72, i32 104, i32 136, i32 168, i32 200, i32 9, i32 41, i32 73, i32 105, i32 137, i32 169, i32 201, i32 10, i32 42, i32 74, i32 106, i32 138, i32 170, i32 202, i32 11, i32 43, i32 75, i32 107, i32 139, i32 171, i32 203, i32 12, i32 44, i32 76, i32 108, i32 140, i32 172, i32 204, i32 13, i32 45, i32 77, i32 109, i32 141, i32 173, i32 205, i32 14, i32 46, i32 78, i32 110, i32 142, i32 174, i32 206, i32 15, i32 47, i32 79, i32 111, i32 143, i32 175, i32 207, i32 16, i32 48, i32 80, i32 112, i32 144, i32 176, i32 208, i32 17, i32 49, i32 81, i32 113, i32 145, i32 177, i32 209, i32 18, i32 50, i32 82, i32 114, i32 146, i32 178, i32 210, i32 19, i32 51, i32 83, i32 115, i32 147, i32 179, i32 211, i32 20, i32 52, i32 84, i32 116, i32 148, i32 180, i32 212, i32 21, i32 53, i32 85, i32 117, i32 149, i32 181, i32 213, i32 22, i32 54, i32 86, i32 118, i32 150, i32 182, i32 214, i32 23, i32 55, i32 87, i32 119, i32 151, i32 183, i32 215, i32 24, i32 56, i32 88, i32 120, i32 152, i32 184, i32 216, i32 25, i32 57, i32 89, i32 121, i32 153, i32 185, i32 217, i32 26, i32 58, i32 90, i32 122, i32 154, i32 186, i32 218, i32 27, i32 59, i32 91, i32 123, i32 155, i32 187, i32 219, i32 28, i32 60, i32 92, i32 124, i32 156, i32 188, i32 220, i32 29, i32 61, i32 93, i32 125, i32 157, i32 189, i32 221, i32 30, i32 62, i32 94, i32 126, i32 158, i32 190, i32 222, i32 31, i32 63, i32 95, i32 127, i32 159, i32 191, i32 223>
  store <224 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride7_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride7_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $3224, %rsp # imm = 0xC98
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd (%rdi), %xmm2
; SSE-NEXT:    movapd 16(%rdi), %xmm3
; SSE-NEXT:    movapd 32(%rdi), %xmm4
; SSE-NEXT:    movapd (%rsi), %xmm5
; SSE-NEXT:    movapd 16(%rsi), %xmm6
; SSE-NEXT:    movapd (%rdx), %xmm7
; SSE-NEXT:    movapd 16(%rdx), %xmm8
; SSE-NEXT:    movapd (%rcx), %xmm9
; SSE-NEXT:    movapd 16(%rcx), %xmm10
; SSE-NEXT:    movapd 16(%r8), %xmm12
; SSE-NEXT:    movapd (%r8), %xmm11
; SSE-NEXT:    movapd 16(%r9), %xmm14
; SSE-NEXT:    movapd (%r9), %xmm13
; SSE-NEXT:    movapd 16(%rax), %xmm0
; SSE-NEXT:    movapd (%rax), %xmm1
; SSE-NEXT:    movapd %xmm2, %xmm15
; SSE-NEXT:    unpcklpd {{.*#+}} xmm15 = xmm15[0],xmm5[0]
; SSE-NEXT:    movapd %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm2 = xmm1[0],xmm2[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm7[1]
; SSE-NEXT:    movapd %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm7 = xmm7[0],xmm9[0]
; SSE-NEXT:    movapd %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm11[1]
; SSE-NEXT:    movapd %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm11 = xmm11[0],xmm13[0]
; SSE-NEXT:    movapd %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm1[1]
; SSE-NEXT:    movapd %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd %xmm3, %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm6[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movsd {{.*#+}} xmm3 = xmm0[0],xmm3[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm8[1]
; SSE-NEXT:    movapd %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm8 = xmm8[0],xmm10[0]
; SSE-NEXT:    movapd %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm12[1]
; SSE-NEXT:    movapd %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklpd {{.*#+}} xmm12 = xmm12[0],xmm14[0]
; SSE-NEXT:    movapd %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm0[1]
; SSE-NEXT:    movapd %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rsi), %xmm1
; SSE-NEXT:    movapd %xmm4, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm4 = xmm0[0],xmm4[1]
; SSE-NEXT:    movapd %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rdx), %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%rcx), %xmm3
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    movapd %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 32(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rdi), %xmm1
; SSE-NEXT:    movapd 48(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 48(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rdi), %xmm1
; SSE-NEXT:    movapd 64(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 64(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdi), %xmm1
; SSE-NEXT:    movapd 80(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 80(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rdi), %xmm1
; SSE-NEXT:    movapd 96(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 96(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rdi), %xmm1
; SSE-NEXT:    movapd 112(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 112(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rdi), %xmm1
; SSE-NEXT:    movapd 128(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 128(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rdi), %xmm1
; SSE-NEXT:    movapd 144(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 144(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rdi), %xmm1
; SSE-NEXT:    movapd 160(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 160(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rdi), %xmm1
; SSE-NEXT:    movapd 176(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 176(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%rdi), %xmm1
; SSE-NEXT:    movapd 192(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 192(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%rdi), %xmm1
; SSE-NEXT:    movapd 208(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 208(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 224(%rdi), %xmm1
; SSE-NEXT:    movapd 224(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 224(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 224(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 224(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 224(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 224(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rdi), %xmm1
; SSE-NEXT:    movapd 240(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 240(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rdi), %xmm1
; SSE-NEXT:    movapd 256(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 256(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%rdi), %xmm1
; SSE-NEXT:    movapd 272(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 272(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rdi), %xmm1
; SSE-NEXT:    movapd 288(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 288(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rdi), %xmm1
; SSE-NEXT:    movapd 304(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 304(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rdi), %xmm1
; SSE-NEXT:    movapd 320(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 320(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rdi), %xmm1
; SSE-NEXT:    movapd 336(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 336(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%rdi), %xmm1
; SSE-NEXT:    movapd 352(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 352(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rdi), %xmm1
; SSE-NEXT:    movapd 368(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 368(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%rdi), %xmm1
; SSE-NEXT:    movapd 384(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 384(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rdi), %xmm1
; SSE-NEXT:    movapd 400(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 400(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rdi), %xmm1
; SSE-NEXT:    movapd 416(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 416(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 432(%rdi), %xmm1
; SSE-NEXT:    movapd 432(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 432(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 432(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 432(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 432(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 432(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%rdi), %xmm1
; SSE-NEXT:    movapd 448(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%rcx), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 448(%r9), %xmm2
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movapd %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 464(%rdi), %xmm1
; SSE-NEXT:    movapd 464(%rsi), %xmm2
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 464(%rax), %xmm0
; SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 464(%rdx), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movapd %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 464(%rcx), %xmm14
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm14[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 464(%r8), %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm1[1]
; SSE-NEXT:    movapd 464(%r9), %xmm13
; SSE-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm13[0]
; SSE-NEXT:    movapd %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movapd 480(%rdi), %xmm15
; SSE-NEXT:    movapd 480(%rsi), %xmm12
; SSE-NEXT:    movapd %xmm15, %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm0 = xmm0[0],xmm12[0]
; SSE-NEXT:    movapd %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movapd 480(%rax), %xmm3
; SSE-NEXT:    movsd {{.*#+}} xmm15 = xmm3[0],xmm15[1]
; SSE-NEXT:    movapd 480(%rdx), %xmm11
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm11[1]
; SSE-NEXT:    movapd 480(%rcx), %xmm7
; SSE-NEXT:    unpcklpd {{.*#+}} xmm11 = xmm11[0],xmm7[0]
; SSE-NEXT:    movapd 480(%r8), %xmm9
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm9[1]
; SSE-NEXT:    movapd 480(%r9), %xmm5
; SSE-NEXT:    unpcklpd {{.*#+}} xmm9 = xmm9[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm3[1]
; SSE-NEXT:    movapd 496(%rdi), %xmm6
; SSE-NEXT:    movapd 496(%rsi), %xmm4
; SSE-NEXT:    movapd %xmm6, %xmm8
; SSE-NEXT:    unpcklpd {{.*#+}} xmm8 = xmm8[0],xmm4[0]
; SSE-NEXT:    movapd 496(%rax), %xmm10
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm10[0],xmm6[1]
; SSE-NEXT:    movapd 496(%rdx), %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm3[1]
; SSE-NEXT:    movapd 496(%rcx), %xmm1
; SSE-NEXT:    unpcklpd {{.*#+}} xmm3 = xmm3[0],xmm1[0]
; SSE-NEXT:    movapd 496(%r8), %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movapd 496(%r9), %xmm0
; SSE-NEXT:    unpcklpd {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm10[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movapd %xmm0, 3568(%rax)
; SSE-NEXT:    movapd %xmm1, 3552(%rax)
; SSE-NEXT:    movapd %xmm4, 3536(%rax)
; SSE-NEXT:    movapd %xmm6, 3520(%rax)
; SSE-NEXT:    movapd %xmm2, 3504(%rax)
; SSE-NEXT:    movapd %xmm3, 3488(%rax)
; SSE-NEXT:    movapd %xmm8, 3472(%rax)
; SSE-NEXT:    movapd %xmm5, 3456(%rax)
; SSE-NEXT:    movapd %xmm7, 3440(%rax)
; SSE-NEXT:    movapd %xmm12, 3424(%rax)
; SSE-NEXT:    movapd %xmm15, 3408(%rax)
; SSE-NEXT:    movapd %xmm9, 3392(%rax)
; SSE-NEXT:    movapd %xmm11, 3376(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3360(%rax)
; SSE-NEXT:    movapd %xmm13, 3344(%rax)
; SSE-NEXT:    movapd %xmm14, 3328(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3312(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3296(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3280(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3264(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3248(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3232(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3216(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3200(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3184(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3168(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3152(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3136(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3120(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3104(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3088(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3072(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3056(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3040(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3024(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 3008(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2992(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2976(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2960(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2944(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2928(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2912(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2896(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2096(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2080(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2064(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2048(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2032(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2016(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2000(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1984(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1968(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1952(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1936(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1920(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1904(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1888(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1872(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1856(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1840(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1824(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1808(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1792(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1776(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1760(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1744(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1728(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1712(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1696(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1680(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1664(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1648(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1632(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1616(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1600(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1584(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1568(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1552(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1536(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1520(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1504(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1488(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1472(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1456(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1440(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1424(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1408(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1392(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1376(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1360(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1344(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1328(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1312(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1296(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1280(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1072(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $3224, %rsp # imm = 0xC98
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i64_stride7_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $3832, %rsp # imm = 0xEF8
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm4
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%r9), %ymm5
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm6
; AVX1-ONLY-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vbroadcastsd 8(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 16(%rax), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm4[1],ymm2[1],ymm4[3],ymm2[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 16(%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vmovaps 16(%r8), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm5[1],ymm1[1],ymm5[3],ymm1[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 32(%rcx), %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %xmm5
; AVX1-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm3[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 40(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 64(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vbroadcastsd 72(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 80(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 80(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 96(%rcx), %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm3[0]
; AVX1-ONLY-NEXT:    vmovaps 96(%rax), %xmm5
; AVX1-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 104(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 112(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 112(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 128(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vbroadcastsd 136(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 144(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%r9), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 144(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 160(%rcx), %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 160(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps 160(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%r8), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm3[0]
; AVX1-ONLY-NEXT:    vmovaps 160(%rax), %xmm5
; AVX1-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 168(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 176(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 176(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%r9), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 176(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 176(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 192(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vbroadcastsd 200(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 208(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 208(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%r9), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 208(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 208(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 224(%rcx), %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 224(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps 224(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%r8), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm3[0]
; AVX1-ONLY-NEXT:    vmovaps 224(%rax), %xmm5
; AVX1-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 232(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 240(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 240(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%r9), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 240(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 240(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 256(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 256(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vmovaps 256(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 256(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 256(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vbroadcastsd 264(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 256(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 256(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 272(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 272(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 256(%r9), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 272(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 272(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 288(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 288(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 288(%rcx), %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 288(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps 288(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, (%rsp) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 288(%r8), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm3[0]
; AVX1-ONLY-NEXT:    vmovaps 288(%rax), %xmm5
; AVX1-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 296(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 288(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 304(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 304(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 288(%r9), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 304(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 304(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%r9), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vmovaps 320(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 320(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vbroadcastsd 328(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 320(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 336(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],ymm0[1],ymm2[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 336(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%r9), %ymm1
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 336(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 336(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 352(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 352(%rcx), %ymm2, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 352(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovaps 352(%r9), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%r8), %xmm2
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm2[0],xmm3[0]
; AVX1-ONLY-NEXT:    vmovaps 352(%rax), %xmm5
; AVX1-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 360(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%rsi), %ymm15
; AVX1-ONLY-NEXT:    vmovaps 368(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm15[1],ymm0[1],ymm15[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 368(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%r9), %ymm14
; AVX1-ONLY-NEXT:    vmovaps 368(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm14[1],ymm0[1],ymm14[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 368(%rcx), %xmm12
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm12[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 384(%r9), %xmm13
; AVX1-ONLY-NEXT:    vmovaps 384(%r8), %xmm0
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm0[0],xmm13[0]
; AVX1-ONLY-NEXT:    vmovaps 384(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 384(%rax), %xmm10
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 384(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vbroadcastsd 392(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 384(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 384(%rsi), %ymm9
; AVX1-ONLY-NEXT:    vmovaps 400(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm9[1],ymm0[1],ymm9[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 400(%rax), %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 384(%r9), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 400(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm8[1],ymm0[1],ymm8[3],ymm0[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX1-ONLY-NEXT:    vmovaps 400(%rcx), %xmm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm7[2,3,2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 416(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 416(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm0[0],xmm3[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 416(%rcx), %ymm1, %ymm5
; AVX1-ONLY-NEXT:    vmovaps 416(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm5[1],ymm1[2],ymm5[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vmovapd 416(%r9), %xmm6
; AVX1-ONLY-NEXT:    vmovapd 416(%r8), %xmm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],xmm6[0]
; AVX1-ONLY-NEXT:    vmovapd 416(%rax), %xmm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm3[1],xmm2[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 424(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 448(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 456(%rcx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 448(%rdx), %ymm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, 448(%r8), %ymm5, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 480(%rsi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 480(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm11[0],xmm2[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 480(%rcx), %ymm1, %ymm3
; AVX1-ONLY-NEXT:    vmovaps 480(%rdx), %xmm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 488(%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vinsertf128 $1, 480(%r8), %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 16(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 48(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 80(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 112(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 144(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 176(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 208(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 240(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 256(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 272(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 288(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps (%rsp), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 288(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 304(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 320(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX1-ONLY-NEXT:    # ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovaps 336(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[0],mem[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm15[0],ymm0[2],ymm15[2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 352(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm14[0],ymm0[2],ymm14[2]
; AVX1-ONLY-NEXT:    vmovaps 368(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm1[0],xmm12[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 384(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm9[0],ymm0[2],ymm9[2]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm13[1],xmm10[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 384(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm8[0],ymm0[2],ymm8[2]
; AVX1-ONLY-NEXT:    vmovaps 400(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm1[0],xmm7[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm6[1],xmm4[1]
; AVX1-ONLY-NEXT:    vmovapd 416(%rdi), %ymm1
; AVX1-ONLY-NEXT:    vmovapd 416(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 416(%r8), %ymm0
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX1-ONLY-NEXT:    vmovapd 432(%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovapd 432(%rdx), %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm6[0]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 432(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0,0,3,2]
; AVX1-ONLY-NEXT:    vmovapd 416(%rax), %ymm1
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm2[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0],ymm0[1],ymm2[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX1-ONLY-NEXT:    vmovaps 448(%rdi), %xmm15
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 448(%r8), %ymm13
; AVX1-ONLY-NEXT:    vinsertf128 $1, 448(%rax), %ymm13, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 448(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovapd 448(%rsi), %ymm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX1-ONLY-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm9 = ymm3[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vmovapd 464(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0,0,3,2]
; AVX1-ONLY-NEXT:    vmovapd 448(%rax), %ymm4
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm4[2,3],ymm2[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0],ymm0[1],ymm2[2],ymm0[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovapd 480(%r8), %ymm0
; AVX1-ONLY-NEXT:    vinsertf128 $1, 480(%rax), %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 480(%rdi), %ymm2
; AVX1-ONLY-NEXT:    vmovapd 480(%rsi), %ymm3
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX1-ONLY-NEXT:    vmovddup {{.*#+}} xmm5 = mem[0,0]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm2 = ymm5[0,1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovapd 496(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0,1],mem[2,3]
; AVX1-ONLY-NEXT:    vshufpd {{.*#+}} ymm3 = ymm3[0,0,3,2]
; AVX1-ONLY-NEXT:    vmovapd 480(%rax), %ymm11
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm11[2,3],ymm3[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0],ymm5[1],ymm3[2],ymm5[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm6[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 440(%r9), %ymm6
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm6[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm3[0,1,2],ymm1[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 464(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovapd 464(%rdx), %xmm3
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm3[0],xmm1[0]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1],ymm13[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 464(%r9), %ymm6
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm3[0,1,2],ymm6[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 472(%r9), %ymm3
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm3 = ymm9[0],ymm4[1],ymm9[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1,2],ymm4[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovapd 496(%rcx), %xmm1
; AVX1-ONLY-NEXT:    vmovapd 496(%rdx), %xmm4
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm4[0],xmm1[0]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm4[0,1],ymm0[2,3]
; AVX1-ONLY-NEXT:    vbroadcastsd 496(%r9), %ymm4
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm4[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],mem[1]
; AVX1-ONLY-NEXT:    vbroadcastsd 504(%r9), %ymm1
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm1 = ymm2[0],ymm11[1],ymm2[2,3]
; AVX1-ONLY-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm11[3]
; AVX1-ONLY-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm5 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm5 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm4 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm4 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm11 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm11 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm2 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm2 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm15 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm15 = xmm15[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm1 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm1 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-ONLY-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps 256(%rdx), %xmm14
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm14 = xmm14[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps 128(%rdx), %xmm10
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm10 = xmm10[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %xmm12
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm12 = xmm12[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps 192(%rdx), %xmm13
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm13 = xmm13[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps 320(%rdx), %xmm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm9 = xmm9[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps 448(%rdx), %xmm8
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm8 = xmm8[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps 384(%rdx), %xmm7
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm7 = xmm7[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm6
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX1-ONLY-NEXT:    vmovaps %xmm6, 16(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm0, (%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm7, 2704(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm1, 2688(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm8, 3152(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm15, 3136(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm9, 2256(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm2, 2240(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm13, 1360(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm3, 1344(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm12, 464(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm11, 448(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm10, 912(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm4, 896(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm14, 1808(%rax)
; AVX1-ONLY-NEXT:    vmovaps %xmm5, 1792(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3520(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3456(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3392(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3296(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3232(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3168(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3072(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3040(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3008(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2816(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2784(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2592(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2560(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2368(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2336(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2144(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2112(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1920(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1888(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1696(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1440(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3552(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3488(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3424(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3360(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3328(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3264(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3200(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 3104(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2976(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2944(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2912(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2880(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2848(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2752(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2720(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2656(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2624(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2528(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2496(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2464(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2432(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2400(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2304(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2272(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2208(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2176(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2080(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2048(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2016(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1984(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1952(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1856(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1824(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1728(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1632(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1600(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1568(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1536(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1312(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1120(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    addq $3832, %rsp # imm = 0xEF8
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i64_stride7_vf64:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $3896, %rsp # imm = 0xF38
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-ONLY-NEXT:    vmovaps (%r8), %ymm5
; AVX2-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%r9), %ymm6
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm3
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rcx), %ymm3, %ymm3
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-ONLY-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%rdx), %ymm4, %ymm4
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm4[0],ymm3[0],ymm4[2],ymm3[2]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX2-ONLY-NEXT:    vbroadcastsd 8(%rcx), %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm4
; AVX2-ONLY-NEXT:    vmovaps %xmm4, (%rsp) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm8
; AVX2-ONLY-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm4 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm4[1],xmm8[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm5[0],ymm6[0],ymm5[2],ymm6[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],mem[0],ymm2[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 16(%rax), %xmm3
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm4
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm1[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 40(%rcx), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm4[1]
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 48(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, 64(%rdx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vbroadcastsd 72(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %ymm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm4[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 80(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %xmm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vmovaps 96(%rax), %xmm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 104(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 112(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 128(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, 128(%rdx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vbroadcastsd 136(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 128(%r8), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%r8), %ymm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm4[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 144(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%r8), %xmm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vmovaps 160(%rax), %xmm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rdx), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 168(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 160(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 160(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 176(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 192(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, 192(%rdx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vbroadcastsd 200(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 192(%r8), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm4[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 208(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%r8), %xmm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vmovaps 224(%rax), %xmm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rdx), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 232(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 224(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 224(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 224(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 240(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 256(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, 256(%rdx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vbroadcastsd 264(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 256(%r8), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 256(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 256(%rsi), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%r8), %ymm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 256(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm4[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 272(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%r8), %xmm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vmovaps 288(%rax), %xmm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vmovaps 288(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%rdx), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm3[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 296(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 288(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 288(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 288(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 288(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 304(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 320(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 320(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, 320(%rdx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vbroadcastsd 328(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 320(%r8), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%rax), %xmm9
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm9[1]
; AVX2-ONLY-NEXT:    vmovaps 320(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 320(%rsi), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%r8), %ymm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 320(%r9), %ymm7
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm7[0],ymm1[2],ymm7[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm4[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 336(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%r8), %xmm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vmovaps 352(%rax), %xmm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vmovaps 352(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%rdx), %xmm5
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm5[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 360(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 352(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 352(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 352(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 352(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[2],ymm4[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 368(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 384(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 384(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, 384(%rdx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vbroadcastsd 392(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 384(%r8), %xmm2
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%rax), %xmm15
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm15[1]
; AVX2-ONLY-NEXT:    vmovaps 384(%rdi), %ymm2
; AVX2-ONLY-NEXT:    vmovaps 384(%rsi), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%r8), %ymm1
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 384(%r9), %ymm14
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm1[0],ymm14[0],ymm1[2],ymm14[2]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm4[2,3],ymm1[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 400(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 416(%r8), %xmm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vmovaps 416(%rax), %xmm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vmovaps 416(%rdi), %xmm12
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 416(%rdx), %xmm13
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm13[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 424(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 416(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovaps 416(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 416(%r8), %ymm0
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],mem[0],ymm0[2],mem[2]
; AVX2-ONLY-NEXT:    vmovaps 416(%rdx), %ymm3
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm3[0],mem[0],ymm3[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm4[2,3],ymm0[2,3]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovaps 432(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 448(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, 448(%rcx), %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 448(%rdi), %xmm1
; AVX2-ONLY-NEXT:    vinsertf128 $1, 448(%rdx), %ymm1, %ymm1
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 448(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 448(%r8), %ymm10
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm10[0,1],ymm0[0,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 448(%rax), %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 448(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vbroadcastsd 456(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 448(%r8), %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 448(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vmovaps 464(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 480(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovaps 480(%r8), %ymm11
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm11[0,1],ymm0[0,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 480(%rax), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 480(%rdx), %xmm8
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm8[1]
; AVX2-ONLY-NEXT:    vbroadcastsd 488(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vinsertf128 $1, 480(%r8), %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 480(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vmovaps 480(%rdx), %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vmovaps 496(%rax), %xmm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 24(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd 32(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 56(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 88(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd 96(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 120(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 152(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd 160(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 184(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 216(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd 224(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 248(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 280(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd 288(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 312(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm9, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm7[1],ymm0[3],ymm7[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 344(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vbroadcastsd 352(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 376(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    vbroadcastsd %xmm15, %ymm15
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm0[0,1,2,3],ymm15[4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm15 = ymm0[1],ymm14[1],ymm0[3],ymm14[3]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,2,3,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 408(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm14[0,1],ymm15[2,3,4,5,6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm14 = xmm12[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm14, %ymm13
; AVX2-ONLY-NEXT:    vbroadcastsd 416(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 440(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm14 = xmm14[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 440(%r9), %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm14[0,1,2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],mem[0],ymm2[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm10[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 464(%r9), %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 472(%rcx), %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 472(%r9), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm14[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 448(%rax), %ymm14
; AVX2-ONLY-NEXT:    vblendps $243, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm1 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm1 = mem[0,1],ymm14[2,3],mem[4,5,6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vmovaps 480(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} xmm14 = xmm14[0],mem[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm14, %ymm8
; AVX2-ONLY-NEXT:    vbroadcastsd 480(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm6[0],mem[0],ymm6[2],mem[2]
; AVX2-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm6[2,3],ymm11[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 496(%r9), %ymm11
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd 504(%rcx), %ymm11
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0,1],mem[2,3]
; AVX2-ONLY-NEXT:    vbroadcastsd 504(%r9), %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm14[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 480(%rax), %ymm14
; AVX2-ONLY-NEXT:    vblendps $243, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14, %ymm0 # 32-byte Folded Reload
; AVX2-ONLY-NEXT:    # ymm0 = mem[0,1],ymm14[2,3],mem[4,5,6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],ymm14[6,7]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 3552(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 3520(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 3488(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3456(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3424(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3392(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 3360(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 3328(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3296(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, 3264(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 3232(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3200(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3168(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3136(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm12, 3104(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3072(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3040(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 3008(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2976(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2944(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm13, 2912(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm15, 2880(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2848(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2816(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2784(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2752(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 2720(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2688(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm4, 2656(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2624(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2592(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2560(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2528(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2496(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 2464(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 2432(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2400(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2368(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2336(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2304(%rcx)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 2272(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2240(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2208(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2176(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2144(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2112(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2080(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2048(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2016(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1984(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1952(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1920(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1888(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1856(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1824(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1792(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1760(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1728(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1696(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1664(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1632(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1600(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1568(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1536(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1504(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1472(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1440(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1408(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1376(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1344(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1312(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1280(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1248(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1216(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1184(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1152(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1120(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1088(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1056(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1024(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 992(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 960(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 928(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 896(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 864(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 832(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 800(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 768(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 736(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 704(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 672(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 640(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 608(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 576(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 544(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 512(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 480(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 416(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 224(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-ONLY-NEXT:    addq $3896, %rsp # imm = 0xF38
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-ONLY-SLOW-LABEL: store_i64_stride7_vf64:
; AVX512F-ONLY-SLOW:       # %bb.0:
; AVX512F-ONLY-SLOW-NEXT:    subq $6408, %rsp # imm = 0x1908
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm29
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm12, (%rsp) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [11,3,11,3,11,3,11,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [2,10,0,3,2,10,0,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    movb $96, %r10b
; AVX512F-ONLY-SLOW-NEXT:    kmovw %r10d, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%r9), %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 (%rax), %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%rax), %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [9,1,9,1,9,1,9,1]
; AVX512F-ONLY-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm16, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [4,9,0,3,4,9,0,3]
; AVX512F-ONLY-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm7, %zmm14, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm19, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm2 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%r9), %ymm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 64(%r9), %ymm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%r8), %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 64(%r8), %ymm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm1[0],ymm10[0],ymm1[2],ymm10[2]
; AVX512F-ONLY-SLOW-NEXT:    movb $28, %r10b
; AVX512F-ONLY-SLOW-NEXT:    kmovw %r10d, %k2
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm2 {%k2} = zmm1[0,1,2,3],zmm6[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm22 = [4,12,0,5,4,12,0,5]
; AVX512F-ONLY-SLOW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm22, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,1,12,7,0,1,12,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm3, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [5,0,14,6,5,0,14,6]
; AVX512F-ONLY-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,13,6,7,0,13,6,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [15,7,15,7,15,7,15,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm10, %zmm7, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [6,13,14,7,6,13,14,7]
; AVX512F-ONLY-SLOW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm10, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm14, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm17, %zmm19, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm13[0],ymm11[0],ymm13[2],ymm11[2]
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k2} = zmm0[0,1,2,3],zmm8[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm16, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm8, %zmm15, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm22, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm8, %zmm3, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm23, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm8, %zmm9, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm7, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm10, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rsi), %zmm24
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm24, %zmm14, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rdx), %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rcx), %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm19, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%rax), %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 128(%r9), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 128(%r8), %ymm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm8[0],ymm0[0],ymm8[2],ymm0[2]
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k2} = zmm0[0,1,2,3],zmm11[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 128(%r9), %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm8, %zmm16, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm15, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm8, %zmm22, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm3, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm23, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm9, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm8, %zmm7, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm10, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rsi), %zmm31
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm31, %zmm14, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rdx), %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rcx), %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm19, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm8 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%rax), %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 192(%r9), %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 192(%r8), %ymm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm11[0],ymm1[0],ymm11[2],ymm1[2]
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm8 {%k2} = zmm1[0,1,2,3],zmm25[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%r8), %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 192(%r9), %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm16, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm25, %zmm15, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm22, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm25, %zmm3, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm23, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm25, %zmm13, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm7, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm10, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 256(%rdi), %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 256(%rsi), %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm28, %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 256(%rdx), %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 256(%rcx), %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm27, %zmm19, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm8 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 256(%rax), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 256(%r9), %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 256(%r8), %ymm25
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %ymm25, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm25[0],ymm1[0],ymm25[2],ymm1[2]
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm8 {%k2} = zmm1[0,1,2,3],zmm0[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 256(%r8), %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 256(%r9), %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm16, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm15, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm22, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm3, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm23, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm13, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm7, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm10, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 320(%rdi), %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 320(%rsi), %zmm12
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm2, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 320(%rdx), %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 320(%rcx), %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm19, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm11 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 320(%rax), %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 320(%r9), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 320(%r8), %ymm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm11 {%k2} = zmm1[0,1,2,3],zmm2[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 320(%r8), %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 320(%r9), %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm16, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm25, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm22, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm3, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm23, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm8, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm7, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm10, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm17 = [13,5,13,5,13,5,13,5]
; AVX512F-ONLY-SLOW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm17, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [6,14,6,14,6,14,6,14]
; AVX512F-ONLY-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [3,0,12,4,3,0,12,4]
; AVX512F-ONLY-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm21, %zmm1, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm17, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm4, %zmm7, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm17, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm2, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm7, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm30, %zmm1, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm17, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm2, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm9, %zmm7, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm1, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm27, %zmm17, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm27, %zmm2, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm27, %zmm7, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm20, %zmm1, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm17, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm2, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm18, %zmm7, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm13, %zmm1, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 448(%rdx), %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm19, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 384(%rdx), %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 384(%rcx), %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm13, %zmm6, %zmm19
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm13, %zmm17, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm13, %zmm6, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm13, %zmm7, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm13
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm11, %zmm1, %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm17, %zmm18
; AVX512F-ONLY-SLOW-NEXT:    movb $48, %r10b
; AVX512F-ONLY-SLOW-NEXT:    kmovw %r10d, %k3
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [1,0,10,2,1,0,10,2]
; AVX512F-ONLY-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm3 {%k3} = zmm0[0],zmm5[0],zmm0[2],zmm5[2],zmm0[4],zmm5[4],zmm0[6],zmm5[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,8,0,1,0,8,0,1]
; AVX512F-ONLY-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm2, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm17, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm8 = [6,14,6,14]
; AVX512F-ONLY-SLOW-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm8, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [15,7,15,7]
; AVX512F-ONLY-SLOW-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm5, %zmm7, %zmm10
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm4 {%k3} = zmm29[0],zmm0[0],zmm29[2],zmm0[2],zmm29[4],zmm0[4],zmm29[6],zmm0[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm19
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm29
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm29, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm17, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm8, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm19
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm26, %zmm1, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm16 {%k3} = zmm26[0],zmm24[0],zmm26[2],zmm24[2],zmm26[4],zmm24[4],zmm26[6],zmm24[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm26, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm24, %zmm2, %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm24, %zmm17, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm24, %zmm8, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm24, %zmm7, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm23 {%k3} = zmm29[0],zmm31[0],zmm29[2],zmm31[2],zmm29[4],zmm31[4],zmm29[6],zmm31[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm29
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm29, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm17, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm8, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm20
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, %zmm31
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm1, %zmm31
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm27 {%k3} = zmm14[0],zmm28[0],zmm14[2],zmm28[2],zmm14[4],zmm28[4],zmm14[6],zmm28[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm29
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm28, %zmm2, %zmm29
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm28, %zmm17, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm28, %zmm8, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm28, %zmm7, %zmm26
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm15, %zmm1, %zmm28
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm22 {%k3} = zmm15[0],zmm12[0],zmm15[2],zmm12[2],zmm15[4],zmm12[4],zmm15[6],zmm12[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm24
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm2, %zmm25
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm17, %zmm27
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm8, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm12, %zmm7, %zmm24
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm16, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm8, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm17, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 384(%rdi), %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 384(%rsi), %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm22, %zmm1, %zmm23
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm14, %zmm22, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm14, %zmm22, %zmm17
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm14, %zmm22, %zmm8
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm13 {%k3} = zmm22[0],zmm14[0],zmm22[2],zmm14[2],zmm22[4],zmm14[4],zmm22[6],zmm14[6]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm22, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm2, %zmm22
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm14, %zmm7, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm6 {%k3} = zmm5[0],zmm0[0],zmm5[2],zmm0[2],zmm5[4],zmm0[4],zmm5[6],zmm0[6]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm5, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm5, %zmm0, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm9 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm3[0,1,2,3],zmm21[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 448(%r8), %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,11,u,u,4,5,6,7>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm6, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 448(%r9), %zmm6
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <0,1,11,u,4,5,6,7>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm7, %zmm12
; AVX512F-ONLY-SLOW-NEXT:    movb $4, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,2,10,u,5,6,7>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm9, %zmm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm4 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <12,u,u,3,4,5,6,13>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm4, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <0,12,u,3,4,5,6,7>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm9, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm9 = [0,8,0,8,0,8,0,8]
; AVX512F-ONLY-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm18 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm14 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm14 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm14 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm14 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm14 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    movb $24, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm16 {%k5}
; AVX512F-ONLY-SLOW-NEXT:    movb $6, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 456(%rcx), %ymm14
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm14 = mem[0,1,2,3],ymm14[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm14, %zmm0, %zmm1 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <0,1,2,9,u,u,6,7>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm14
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm5 {%k5}
; AVX512F-ONLY-SLOW-NEXT:    movb $64, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,1,2,3,4,15,u,u>
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 384(%r8), %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 384(%r9), %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm3, %zmm9
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm3, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm1, %zmm3, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    movb $12, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 448(%rdx), %xmm3
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm2 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $2, 448(%r8), %zmm2, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <0,1,2,3,4,8,u,7>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm2, %zmm3
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <u,1,2,3,4,5,15,u>
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm1, %zmm2, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <0,1,2,3,9,u,6,7>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm14, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <13,u,2,3,4,5,6,14>
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm6, %zmm0, %zmm11
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm6, %zmm2, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 448(%rax), %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,1,2,3,10,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm7, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,1,12,3,4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm4, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 384(%rax), %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm4, %zmm15
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 384(%r9), %ymm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 384(%r8), %ymm7
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm7[0],ymm4[0],ymm7[2],ymm4[2]
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm6 {%k2} = zmm4[0,1,2,3],zmm2[2,3,0,1]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm4, %zmm21
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm4, %zmm30
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,2,3,4,5,8,7]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm3, %zmm4
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [14,1,2,3,4,5,6,15]
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm2, %zmm3, %zmm16
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,1,2,3,4,9,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,13,2,3,4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vpermi2q %zmm0, %zmm11, %zmm1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vpermt2q %zmm0, %zmm3, %zmm5
; AVX512F-ONLY-SLOW-NEXT:    movb $8, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k5}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k5}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k5}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k5}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k5}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k5}
; AVX512F-ONLY-SLOW-NEXT:    movb $-31, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa (%rdx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm1 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm2 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 128(%rdx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm3 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 192(%rdx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm4 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 256(%rdx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm29 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 320(%rdx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm25 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa 384(%rdx), %xmm0
; AVX512F-ONLY-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX512F-ONLY-SLOW-NEXT:    vinserti128 $1, %xmm0, %ymm0, %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm22 {%k4}
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, (%rax), %zmm18, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    movb $112, %sil
; AVX512F-ONLY-SLOW-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, 64(%rax), %zmm0, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, 128(%rax), %zmm0, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, 192(%rax), %zmm0, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, 256(%rax), %zmm0, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, 320(%rax), %zmm0, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vinserti32x4 $3, 384(%rax), %zmm9, %zmm0
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm1 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 72(%rcx), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm3 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 136(%rcx), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 (%rsp), %zmm4 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm4 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 200(%rcx), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm2 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 264(%rcx), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm31 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 328(%rcx), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm28 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    vpbroadcastq 392(%rcx), %ymm0
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm23 {%k3}
; AVX512F-ONLY-SLOW-NEXT:    movb $56, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm4, (%rsp) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm28 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm23 {%k2}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    movb $120, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm20 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm19 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # zmm19 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm14 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm15 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm18 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm11 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm27, %zmm9 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, %zmm21 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    movb $-61, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm19 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm12 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm10 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # zmm10 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm10 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm3 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # zmm3 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm3 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm4 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # zmm4 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm4 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm6 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # zmm6 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm7 # 64-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # zmm7 = zmm8[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm7 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm8 = ymm8[1],mem[1],ymm8[3],mem[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    movb $14, %cl
; AVX512F-ONLY-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm17 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm8 = ymm8[1],mem[1],ymm8[3],mem[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm27 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm8 = ymm8[1],mem[1],ymm8[3],mem[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm30 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm30 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm8 = ymm8[1],mem[1],ymm8[3],mem[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm2 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm8 = ymm8[1],mem[1],ymm8[3],mem[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm8 = ymm8[1],mem[1],ymm8[3],mem[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm0 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm8 # 32-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm8, %ymm8 # 32-byte Folded Reload
; AVX512F-ONLY-SLOW-NEXT:    # ymm8 = ymm8[1],mem[1],ymm8[3],mem[3]
; AVX512F-ONLY-SLOW-NEXT:    vpermq {{.*#+}} ymm8 = ymm8[0,2,3,3]
; AVX512F-ONLY-SLOW-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-SLOW-NEXT:    vinserti64x4 $0, %ymm8, %zmm0, %zmm13 {%k1}
; AVX512F-ONLY-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm7, 3008(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm21, 2944(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm13, 2880(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm7, 2816(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm23, 2752(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm22, 2688(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm24, 2624(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm6, 2560(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm9, 2496(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm0, 2432(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm6, 2368(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm28, 2304(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm25, 2240(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm26, 2176(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm4, 2112(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm11, 2048(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm1, 1984(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm4, 1920(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm31, 1856(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm29, 1792(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 1728(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm3, 1664(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm18, 1600(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm2, 1536(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm3, 1472(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 1408(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 1344(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 1280(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm10, 1216(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm15, 1152(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm30, 1088(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm2, 1024(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 960(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 896(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm12, 768(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm14, 704(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm27, 640(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm1, 576(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 512(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm20, 256(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm17, 192(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, (%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm5, 3520(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 3456(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 3392(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 3328(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 3264(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 3200(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovdqa64 %zmm16, 3072(%rax)
; AVX512F-ONLY-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-SLOW-NEXT:    vmovaps %zmm0, 3136(%rax)
; AVX512F-ONLY-SLOW-NEXT:    addq $6408, %rsp # imm = 0x1908
; AVX512F-ONLY-SLOW-NEXT:    vzeroupper
; AVX512F-ONLY-SLOW-NEXT:    retq
;
; AVX512F-ONLY-FAST-LABEL: store_i64_stride7_vf64:
; AVX512F-ONLY-FAST:       # %bb.0:
; AVX512F-ONLY-FAST-NEXT:    subq $6568, %rsp # imm = 0x19A8
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdi), %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm15
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rsi), %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rcx), %zmm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm17
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [11,3,11,3,11,3,11,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm21 = [2,10,0,3,2,10,0,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    movb $96, %r10b
; AVX512F-ONLY-FAST-NEXT:    kmovw %r10d, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r9), %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%rax), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%rax), %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [9,1,9,1,9,1,9,1]
; AVX512F-ONLY-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm1, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm12
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [4,9,0,3,4,9,0,3]
; AVX512F-ONLY-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm9, %zmm5, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm10, %zmm21, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%r9), %ymm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 64(%r9), %ymm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 (%r8), %ymm27
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%r8), %ymm25
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm27[0],ymm1[0],ymm27[2],ymm1[2]
; AVX512F-ONLY-FAST-NEXT:    movb $28, %r10b
; AVX512F-ONLY-FAST-NEXT:    kmovw %r10d, %k2
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm2 {%k2} = zmm1[0,1,2,3],zmm3[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [4,12,0,5,4,12,0,5]
; AVX512F-ONLY-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm8, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,1,12,7,0,1,12,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm2, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [5,0,14,6,5,0,14,6]
; AVX512F-ONLY-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm20
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm19
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,13,6,7,0,13,6,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm28 = [15,7,15,7,15,7,15,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm28, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [6,13,14,7,6,13,14,7]
; AVX512F-ONLY-FAST-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm16, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm15, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm5, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm21, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm25[0],ymm6[0],ymm25[2],ymm6[2]
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k2} = zmm0[0,1,2,3],zmm4[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 64(%r9), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm12, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm11, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm8, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm9, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm19, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm7, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm28, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm16, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rsi), %zmm24
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm24, %zmm5, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rdx), %zmm31
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rcx), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm21, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%rax), %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 128(%r9), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 128(%r8), %ymm3
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm3[0],ymm0[0],ymm3[2],ymm0[2]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %ymm3, %ymm23
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k2} = zmm0[0,1,2,3],zmm4[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 128(%r9), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm12, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm26
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm11, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm8, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm9, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm19, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm7, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm28, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm16, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rsi), %zmm17
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm5, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rdx), %zmm29
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rcx), %zmm20
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm21, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%rax), %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%r9), %ymm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 192(%r8), %ymm14
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm14[0],ymm18[0],ymm14[2],ymm18[2]
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm3 {%k2} = zmm1[0,1,2,3],zmm5[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%r8), %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 192(%r9), %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm12, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm11, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm8, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm2, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm19, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm15, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm28, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm16, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 256(%rdi), %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 256(%rsi), %zmm11
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm7, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 256(%rdx), %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 256(%rcx), %zmm12
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm21, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm5 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 256(%rax), %zmm30
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 256(%r9), %ymm10
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 256(%r8), %ymm19
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm19[0],ymm10[0],ymm19[2],ymm10[2]
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm5 {%k2} = zmm3[0,1,2,3],zmm30[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 256(%r8), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 256(%r9), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm26, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm26, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm30, %zmm22, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm22, %zmm26
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm8, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm30, %zmm2, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm9, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm15, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm30, %zmm15, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm28, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm16, %zmm30
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 320(%rdi), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 320(%rsi), %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm7, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 320(%rdx), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 320(%rcx), %zmm7
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm21, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 320(%rax), %zmm15
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 320(%r9), %ymm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 320(%r8), %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm2 {%k2} = zmm4[0,1,2,3],zmm15[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 320(%r8), %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 320(%r9), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm6, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm15, %zmm26, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm8, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm15, %zmm13, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm9, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm15, %zmm22, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm28, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm4, %zmm16, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [1,3,7,7]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q (%rsp), %ymm2, %ymm27 # 32-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %ymm27, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm25 # 32-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %ymm25, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm23 # 32-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %ymm23, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %ymm18, %ymm2, %ymm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqu %ymm14, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %ymm10, %ymm2, %ymm19
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %ymm19, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %ymm3, %ymm2, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 384(%r9), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 384(%r8), %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %ymm0, %ymm2, %ymm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm19 = [3,0,12,4,3,0,12,4]
; AVX512F-ONLY-FAST-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm19, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [13,5,13,5,13,5,13,5]
; AVX512F-ONLY-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm10, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [6,14,6,14,6,14,6,14]
; AVX512F-ONLY-FAST-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm26, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm28, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    movb $48, %r10b
; AVX512F-ONLY-FAST-NEXT:    kmovw %r10d, %k3
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [0,8,0,1,0,8,0,1]
; AVX512F-ONLY-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm8, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm15 = [1,0,10,2,1,0,10,2]
; AVX512F-ONLY-FAST-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm15, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm2 {%k3} = zmm3[0],zmm0[0],zmm3[2],zmm0[2],zmm3[4],zmm0[4],zmm3[6],zmm0[6]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm10, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} ymm23 = [6,14,6,14]
; AVX512F-ONLY-FAST-NEXT:    # ymm23 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm23, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} ymm27 = [15,7,15,7]
; AVX512F-ONLY-FAST-NEXT:    # ymm27 = mem[0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm27, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm19, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm10, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm26, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm28, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm8, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm3, %zmm15, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm1 {%k3} = zmm3[0],zmm0[0],zmm3[2],zmm0[2],zmm3[4],zmm0[4],zmm3[6],zmm0[6]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm10, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm23, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm27, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm31, %zmm19, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm10, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm26, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm28, %zmm31
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm24, %zmm8, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm15, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm1 {%k3} = zmm2[0],zmm24[0],zmm2[2],zmm24[2],zmm2[4],zmm24[4],zmm2[6],zmm24[6]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm24, %zmm10, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm24, %zmm23, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm24, %zmm27, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm20, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm29, %zmm19, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm10, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm26, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm20, %zmm28, %zmm29
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm29, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm8, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm15, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm1 {%k3} = zmm2[0],zmm17[0],zmm2[2],zmm17[2],zmm2[4],zmm17[4],zmm2[6],zmm17[6]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm10, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm23, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm17, %zmm27, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm19, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm10, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm26, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm12, %zmm28, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm31
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm8, %zmm31
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm30
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm15, %zmm30
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm0 {%k3} = zmm2[0],zmm11[0],zmm2[2],zmm11[2],zmm2[4],zmm11[4],zmm2[6],zmm11[6]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm10, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm23, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm27, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm25
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm19, %zmm25
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm10, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm26, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm28, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm29
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm8, %zmm29
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm24
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm15, %zmm24
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm25 {%k3} = zmm0[0],zmm5[0],zmm0[2],zmm5[2],zmm0[4],zmm5[4],zmm0[6],zmm5[6]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm10, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm23, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm27, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 448(%rdx), %zmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm2, %zmm14
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm26, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm18, %zmm19, %zmm21
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm16
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm10, %zmm16
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm28, %zmm18
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 384(%rdx), %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 384(%rcx), %zmm5
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm5, %zmm3, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm3, %zmm5, %zmm19
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm5, %zmm3, %zmm26
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm28, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm5, %zmm10, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 448(%rdi), %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm1, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm23, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm10, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 384(%rdi), %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 384(%rsi), %zmm11
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm8, %zmm22
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, %zmm20
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm7, %zmm15, %zmm20
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm11, %zmm7, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm19 {%k3} = zmm7[0],zmm11[0],zmm7[2],zmm11[2],zmm7[4],zmm11[4],zmm7[6],zmm11[6]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm11, %zmm7, %zmm10
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm11, %zmm7, %zmm23
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm27, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm21 {%k3} = zmm6[0],zmm0[0],zmm6[2],zmm0[2],zmm6[4],zmm0[4],zmm6[6],zmm0[6]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm0, %zmm6, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm6, %zmm0, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm0, %zmm27, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm14 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm0 = zmm2[0,1,2,3],zmm9[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 448(%r8), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <0,11,u,u,4,5,6,7>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm21, %zmm5
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 448(%r9), %zmm11
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <0,1,11,u,4,5,6,7>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm11, %zmm5, %zmm28
; AVX512F-ONLY-FAST-NEXT:    movb $4, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm14 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <0,1,2,10,u,5,6,7>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm11, %zmm14, %zmm13
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, %zmm4 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <12,u,u,3,4,5,6,13>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm4, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <0,12,u,3,4,5,6,7>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm11, %zmm9, %zmm12
; AVX512F-ONLY-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm9 = [0,8,0,8,0,8,0,8]
; AVX512F-ONLY-FAST-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm1 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm1 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm1 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm1 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm21 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm1 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    movb $24, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k4
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm7 {%k4}
; AVX512F-ONLY-FAST-NEXT:    movb $6, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k5
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 456(%rcx), %ymm1
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm1 = mem[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm15 {%k5}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <0,1,2,9,u,u,6,7>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm15, %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, %zmm6 {%k4}
; AVX512F-ONLY-FAST-NEXT:    movb $64, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <u,1,2,3,4,15,u,u>
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm14, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 384(%r8), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm14, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 384(%r9), %zmm14
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm14, %zmm2, %zmm9
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm14, %zmm2, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm14, %zmm2, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm14, %zmm4
; AVX512F-ONLY-FAST-NEXT:    movb $12, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 448(%rdx), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm8 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $2, 448(%r8), %zmm8, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <0,1,2,3,4,8,u,7>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm11, %zmm2, %zmm8
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <u,1,2,3,4,5,15,u>
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm14, %zmm2, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <0,1,2,3,9,u,6,7>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm11, %zmm1, %zmm16
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm27 = <13,u,2,3,4,5,6,14>
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm11, %zmm0, %zmm27
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm11, %zmm2, %zmm6
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 8(%rcx), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 (%rsp), %zmm14 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm14 {%k5}
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 72(%rcx), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm11 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm11 {%k5}
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 136(%rcx), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm17 {%k5}
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 200(%rcx), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm5 {%k5}
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 264(%rcx), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm30 {%k5}
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 328(%rcx), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm24 {%k5}
; AVX512F-ONLY-FAST-NEXT:    vpbroadcastq 392(%rcx), %ymm0
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm0 = mem[0,1,2,3],ymm0[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm20 {%k5}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 448(%rax), %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,1,2,3,10,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm13, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,1,12,3,4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm12, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 384(%rax), %zmm1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm0, %zmm3
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm12
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm3 {%k2} = zmm0[0,1,2,3],zmm1[2,3,0,1]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm0, %zmm15
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm0, %zmm4
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,1,2,3,4,5,8,7]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm8, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [14,1,2,3,4,5,6,15]
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,1,2,3,4,9,6,7]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm16, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [0,13,2,3,4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vpermi2q %zmm2, %zmm27, %zmm0
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vpermt2q %zmm2, %zmm3, %zmm6
; AVX512F-ONLY-FAST-NEXT:    movb $8, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k4}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k4}
; AVX512F-ONLY-FAST-NEXT:    movb $-31, %sil
; AVX512F-ONLY-FAST-NEXT:    kmovw %esi, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm0 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 64(%rdx), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm1 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 128(%rdx), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm3 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 192(%rdx), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm4 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 256(%rdx), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm31 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 320(%rdx), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm29 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa 384(%rdx), %xmm2
; AVX512F-ONLY-FAST-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512F-ONLY-FAST-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm22 {%k3}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, (%rax), %zmm2, %zmm2
; AVX512F-ONLY-FAST-NEXT:    movb $112, %cl
; AVX512F-ONLY-FAST-NEXT:    kmovw %ecx, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, 64(%rax), %zmm0, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm1 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, 128(%rax), %zmm0, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, 192(%rax), %zmm0, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm4 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, 256(%rax), %zmm21, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, 320(%rax), %zmm0, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm29 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vinserti32x4 $3, 384(%rax), %zmm9, %zmm2
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm22 {%k2}
; AVX512F-ONLY-FAST-NEXT:    movb $56, %cl
; AVX512F-ONLY-FAST-NEXT:    kmovw %ecx, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm14 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm14, (%rsp) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm17 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, %zmm20 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    movb $14, %cl
; AVX512F-ONLY-FAST-NEXT:    kmovw %ecx, %k2
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm0 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm21 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm18 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm17 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm15 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm25 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vpblendd {{.*#+}} ymm2 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512F-ONLY-FAST-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm19 {%k2}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k1}
; AVX512F-ONLY-FAST-NEXT:    movb $120, %al
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, %zmm16 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm14 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # zmm14 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, %zmm13 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm12 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, %zmm1 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm0 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm27 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm10, %zmm27 {%k1}
; AVX512F-ONLY-FAST-NEXT:    movb $-61, %al
; AVX512F-ONLY-FAST-NEXT:    kmovw %eax, %k1
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, %zmm14 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm3, %zmm3 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # zmm3 = zmm3[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm3 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm5 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # zmm5 = zmm4[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm4, %zmm4 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # zmm4 = zmm4[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm8, %zmm8 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # zmm8 = zmm8[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, %zmm8 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm9 # 64-byte Folded Reload
; AVX512F-ONLY-FAST-NEXT:    # zmm9 = zmm9[0,1,2,3],mem[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm10, %zmm9 {%k1}
; AVX512F-ONLY-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm11 = zmm23[0,1,2,3],zmm26[4,5,6,7]
; AVX512F-ONLY-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm10, %zmm11 {%k1}
; AVX512F-ONLY-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm11, 3008(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm27, 2944(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm19, 2880(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm10, 2816(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm20, 2752(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm22, 2688(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm10, 2624(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm9, 2560(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm0, 2496(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm25, 2432(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm9, 2368(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm24, 2304(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm29, 2240(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 2176(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm8, 2112(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm1, 2048(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm15, 1984(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm8, 1920(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm30, 1856(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm31, 1792(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 1728(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm4, 1664(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm2, 1600(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm17, 1536(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm4, 1472(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 1408(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 1344(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 1280(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm5, 1216(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm12, 1152(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm18, 1088(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm4, 1024(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 960(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 896(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm3, 768(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm13, 704(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm21, 640(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm3, 576(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 512(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm14, 320(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm16, 256(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 192(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm2, 128(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, (%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm6, 3520(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 3456(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 3392(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm28, 3328(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 3264(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 3200(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovdqa64 %zmm7, 3072(%rax)
; AVX512F-ONLY-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-ONLY-FAST-NEXT:    vmovaps %zmm0, 3136(%rax)
; AVX512F-ONLY-FAST-NEXT:    addq $6568, %rsp # imm = 0x19A8
; AVX512F-ONLY-FAST-NEXT:    vzeroupper
; AVX512F-ONLY-FAST-NEXT:    retq
;
; AVX512DQ-SLOW-LABEL: store_i64_stride7_vf64:
; AVX512DQ-SLOW:       # %bb.0:
; AVX512DQ-SLOW-NEXT:    subq $6536, %rsp # imm = 0x1988
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rdi), %zmm12
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rsi), %zmm19
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rsi), %zmm24
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rdx), %zmm21
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rcx), %zmm17
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [11,3,11,3,11,3,11,3]
; AVX512DQ-SLOW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [2,10,0,3,2,10,0,3]
; AVX512DQ-SLOW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    movb $96, %r10b
; AVX512DQ-SLOW-NEXT:    kmovw %r10d, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%r9), %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqa64 (%rax), %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%rax), %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [9,1,9,1,9,1,9,1]
; AVX512DQ-SLOW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm9, %zmm15, %zmm2
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [4,9,0,3,4,9,0,3]
; AVX512DQ-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm19, %zmm22, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm2
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm18, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm2 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa (%r9), %ymm10
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa 64(%r9), %ymm11
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa (%r8), %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa 64(%r8), %ymm13
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm1[0],ymm10[0],ymm1[2],ymm10[2]
; AVX512DQ-SLOW-NEXT:    movb $28, %r10b
; AVX512DQ-SLOW-NEXT:    kmovw %r10d, %k2
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm2 {%k2} = zmm1[0,1,2,3],zmm6[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [4,12,0,5,4,12,0,5]
; AVX512DQ-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm9, %zmm2, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm20
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [0,1,12,7,0,1,12,7]
; AVX512DQ-SLOW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm16, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [5,0,14,6,5,0,14,6]
; AVX512DQ-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm23
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,13,6,7,0,13,6,7]
; AVX512DQ-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [15,7,15,7,15,7,15,7]
; AVX512DQ-SLOW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm10, %zmm7, %zmm0
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [6,13,14,7,6,13,14,7]
; AVX512DQ-SLOW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm10, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm24, %zmm22, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm17, %zmm18, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm13[0],ymm11[0],ymm13[2],ymm11[2]
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k2} = zmm0[0,1,2,3],zmm8[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 64(%r9), %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm15, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm14, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm2
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm20, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm16, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm23, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm9, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm7, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm10, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rdi), %zmm25
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rsi), %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm22, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rdx), %zmm31
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rcx), %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm18, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%rax), %zmm11
; AVX512DQ-SLOW-NEXT:    vmovdqa 128(%r9), %ymm0
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa 128(%r8), %ymm8
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm8[0],ymm0[0],ymm8[2],ymm0[2]
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k2} = zmm0[0,1,2,3],zmm11[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 128(%r9), %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm15, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm11, %zmm14, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm20, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm11, %zmm16, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm23, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm11, %zmm9, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm7, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm10, %zmm11
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rdi), %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rsi), %zmm29
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm29, %zmm22, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rdx), %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rcx), %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm8
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm9, %zmm18, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm8 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%rax), %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqa 192(%r9), %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa 192(%r8), %ymm11
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm11[0],ymm1[0],ymm11[2],ymm1[2]
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm8 {%k2} = zmm1[0,1,2,3],zmm26[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%r8), %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 192(%r9), %zmm27
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm27, %zmm15, %zmm8
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm26, %zmm14, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm8
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm27, %zmm20, %zmm8
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm26, %zmm16, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm27, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm23, %zmm8
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm26, %zmm13, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm27, %zmm7, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm10, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 256(%rdi), %zmm24
; AVX512DQ-SLOW-NEXT:    vmovdqa64 256(%rsi), %zmm30
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm30, %zmm22, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 256(%rdx), %zmm20
; AVX512DQ-SLOW-NEXT:    vmovdqa64 256(%rcx), %zmm27
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm26
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm27, %zmm18, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm26 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 256(%rax), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa 256(%r9), %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 256(%r8), %ymm28
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %ymm28, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm28[0],ymm1[0],ymm28[2],ymm1[2]
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm26 {%k2} = zmm1[0,1,2,3],zmm0[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 256(%r8), %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 256(%r9), %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm26
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm15, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm14, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm28
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm2, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm16, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm23, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm11
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm13, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm7, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm10, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 320(%rdi), %zmm12
; AVX512DQ-SLOW-NEXT:    vmovdqa64 320(%rsi), %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm22, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 320(%rdx), %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 320(%rcx), %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm14
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm26, %zmm18, %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm14 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 320(%rax), %zmm17
; AVX512DQ-SLOW-NEXT:    vmovdqa 320(%r9), %ymm0
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa 320(%r8), %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm14 {%k2} = zmm1[0,1,2,3],zmm17[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 320(%r8), %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 320(%r9), %zmm14
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm14, %zmm15, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm17, %zmm28, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm14, %zmm2, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm17, %zmm16, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm23, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm17, %zmm11, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm14, %zmm7, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm10, %zmm17
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm17 = [13,5,13,5,13,5,13,5]
; AVX512DQ-SLOW-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm17, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [6,14,6,14,6,14,6,14]
; AVX512DQ-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [3,0,12,4,3,0,12,4]
; AVX512DQ-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm21, %zmm1, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm17, %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm2, %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm10
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm7, %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm17, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm2, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm7, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm31, %zmm1, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm15
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm9, %zmm17, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm9, %zmm2, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm9, %zmm7, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm1, %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm27, %zmm17, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm27, %zmm2, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm20, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm27, %zmm7, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm20, %zmm1, %zmm27
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm26, %zmm17, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm26, %zmm2, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm0
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm26, %zmm7, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm13, %zmm1, %zmm26
; AVX512DQ-SLOW-NEXT:    vmovdqa64 448(%rdx), %zmm11
; AVX512DQ-SLOW-NEXT:    vmovdqa64 448(%rcx), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm9
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm18, %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm21
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm21
; AVX512DQ-SLOW-NEXT:    vmovdqa64 384(%rdx), %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 384(%rcx), %zmm20
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm20, %zmm6, %zmm18
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm20, %zmm17, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm20, %zmm6, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm2
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm20, %zmm7, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm20
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm6
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm11, %zmm1, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm18
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm11
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm17, %zmm18
; AVX512DQ-SLOW-NEXT:    movb $48, %r10b
; AVX512DQ-SLOW-NEXT:    kmovw %r10d, %k3
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [1,0,10,2,1,0,10,2]
; AVX512DQ-SLOW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm19, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm19, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm3 {%k3} = zmm0[0],zmm19[0],zmm0[2],zmm19[2],zmm0[4],zmm19[4],zmm0[6],zmm19[6]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm19
; AVX512DQ-SLOW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,8,0,1,0,8,0,1]
; AVX512DQ-SLOW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm2, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm17, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm14 = [6,14,6,14]
; AVX512DQ-SLOW-NEXT:    # ymm14 = mem[0,1,0,1]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm14, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [15,7,15,7]
; AVX512DQ-SLOW-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm5, %zmm7, %zmm19
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm4 {%k3} = zmm0[0],zmm3[0],zmm0[2],zmm3[2],zmm0[4],zmm3[4],zmm0[6],zmm3[6]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm13
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm2, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm17, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm14, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm7, %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm25, %zmm1, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm15 {%k3} = zmm25[0],zmm0[0],zmm25[2],zmm0[2],zmm25[4],zmm0[4],zmm25[6],zmm0[6]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm25, %zmm5
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm25
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm17, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm14, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm10 {%k3} = zmm29[0],zmm0[0],zmm29[2],zmm0[2],zmm29[4],zmm0[4],zmm29[6],zmm0[6]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm23
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm29
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm29, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm17, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm14, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm23
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm30, %zmm31
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm24, %zmm1, %zmm31
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm27 {%k3} = zmm24[0],zmm30[0],zmm24[2],zmm30[2],zmm24[4],zmm30[4],zmm24[6],zmm30[6]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm27, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm27
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm24, %zmm28
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm30, %zmm2, %zmm28
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm30, %zmm17, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm30, %zmm14, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm30, %zmm7, %zmm27
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm30
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm1, %zmm30
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm26 {%k3} = zmm12[0],zmm8[0],zmm12[2],zmm8[2],zmm12[4],zmm8[4],zmm12[6],zmm8[6]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm29
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm25
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm26
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm2, %zmm26
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm17, %zmm29
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm14, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm8, %zmm7, %zmm25
; AVX512DQ-SLOW-NEXT:    vmovdqa64 448(%rdi), %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm15
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm22, %zmm15
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm3
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm14, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, %zmm4
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm17, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 384(%rdi), %zmm12
; AVX512DQ-SLOW-NEXT:    vmovdqa64 384(%rsi), %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, %zmm24
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm12, %zmm1, %zmm24
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm13, %zmm12, %zmm22
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm13, %zmm12, %zmm17
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm13, %zmm12, %zmm14
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm20 {%k3} = zmm12[0],zmm13[0],zmm12[2],zmm13[2],zmm12[4],zmm13[4],zmm12[6],zmm13[6]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm16
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, %zmm22
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm13, %zmm2, %zmm22
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm13, %zmm7, %zmm16
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} zmm6 {%k3} = zmm5[0],zmm0[0],zmm5[2],zmm0[2],zmm5[4],zmm0[4],zmm5[6],zmm0[6]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm0, %zmm5, %zmm2
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm5, %zmm0, %zmm1
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm0, %zmm7, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm15, %zmm9 {%k1}
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm8 = zmm3[0,1,2,3],zmm21[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 448(%r8), %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,11,u,u,4,5,6,7>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm6, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqa64 448(%r9), %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <0,1,11,u,4,5,6,7>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm6, %zmm7, %zmm10
; AVX512DQ-SLOW-NEXT:    movb $4, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k3}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <0,1,2,10,u,5,6,7>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm6, %zmm9, %zmm7
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm4 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <12,u,u,3,4,5,6,13>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm4, %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <0,12,u,3,4,5,6,7>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm6, %zmm9, %zmm4
; AVX512DQ-SLOW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm9 = [0,8,0,8,0,8,0,8]
; AVX512DQ-SLOW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm15 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm0 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm0 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm12 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm0 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %zmm9, %zmm0 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    movb $24, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k5
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k5}
; AVX512DQ-SLOW-NEXT:    movb $6, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k3
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 456(%rcx), %ymm13
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm13 = mem[0,1,2,3],ymm13[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm13, %zmm0, %zmm1 {%k3}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <0,1,2,9,u,u,6,7>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm13
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, %zmm5 {%k5}
; AVX512DQ-SLOW-NEXT:    movb $64, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k4
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm8 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,1,2,3,4,15,u,u>
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 384(%r8), %zmm3
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm16
; AVX512DQ-SLOW-NEXT:    vmovdqa64 384(%r9), %zmm1
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm1, %zmm3, %zmm9
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm1, %zmm3, %zmm18
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm1, %zmm3, %zmm21
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm3, %zmm1, %zmm0
; AVX512DQ-SLOW-NEXT:    movb $12, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k4
; AVX512DQ-SLOW-NEXT:    vmovdqa 448(%rdx), %xmm3
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm0, %ymm3
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm3, %zmm0, %zmm2 {%k4}
; AVX512DQ-SLOW-NEXT:    vinserti32x4 $2, 448(%r8), %zmm2, %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <0,1,2,3,4,8,u,7>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm6, %zmm2, %zmm3
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <u,1,2,3,4,5,15,u>
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm1, %zmm2, %zmm16
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <0,1,2,3,9,u,6,7>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm6, %zmm13, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <13,u,2,3,4,5,6,14>
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm6, %zmm8, %zmm11
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm6, %zmm2, %zmm5
; AVX512DQ-SLOW-NEXT:    vmovdqa64 448(%rax), %zmm2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,1,2,3,10,5,6,7]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm2, %zmm7, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,1,12,3,4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm2, %zmm4, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 384(%rax), %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm18
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm8 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa 384(%r9), %ymm13
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa 384(%r8), %ymm6
; AVX512DQ-SLOW-NEXT:    vmovdqu %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm6 = ymm6[0],ymm13[0],ymm6[2],ymm13[2]
; AVX512DQ-SLOW-NEXT:    vshufi64x2 {{.*#+}} zmm8 {%k2} = zmm6[0,1,2,3],zmm4[2,3,0,1]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm21
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, %zmm8
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = [0,1,2,3,4,5,8,7]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm6
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [14,1,2,3,4,5,6,15]
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm4, %zmm3, %zmm16
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,2,3,4,9,6,7]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm2, %zmm1, %zmm4
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = [0,13,2,3,4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vpermi2q %zmm2, %zmm11, %zmm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vpermt2q %zmm2, %zmm3, %zmm5
; AVX512DQ-SLOW-NEXT:    movb $8, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm10 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm19 {%k5}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm2 {%k5}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k5}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k5}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k5}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm25 {%k5}
; AVX512DQ-SLOW-NEXT:    movb $-31, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm19 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm2 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm23 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm25 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm2 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa 64(%rdx), %xmm1
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm3 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa 128(%rdx), %xmm1
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm4 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa 192(%rdx), %xmm1
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm6 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa 256(%rdx), %xmm1
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm28 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa 320(%rdx), %xmm1
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm26 {%k4}
; AVX512DQ-SLOW-NEXT:    vmovdqa 384(%rdx), %xmm1
; AVX512DQ-SLOW-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX512DQ-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm22 {%k4}
; AVX512DQ-SLOW-NEXT:    movb $112, %sil
; AVX512DQ-SLOW-NEXT:    kmovw %esi, %k2
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, (%rax), %zmm15, %zmm2 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, 64(%rax), %zmm1, %zmm3 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, 128(%rax), %zmm1, %zmm4 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, 192(%rax), %zmm12, %zmm6 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, 256(%rax), %zmm1, %zmm28 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, 320(%rax), %zmm1, %zmm26 {%k2}
; AVX512DQ-SLOW-NEXT:    vinserti64x2 $3, 384(%rax), %zmm9, %zmm22 {%k2}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 8(%rcx), %ymm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = mem[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm2 {%k3}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 72(%rcx), %ymm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = mem[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm4 {%k3}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 136(%rcx), %ymm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = mem[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm6 {%k3}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 200(%rcx), %ymm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = mem[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 (%rsp), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm3 {%k3}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 264(%rcx), %ymm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = mem[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm31 {%k3}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 328(%rcx), %ymm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = mem[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm30 {%k3}
; AVX512DQ-SLOW-NEXT:    vpbroadcastq 392(%rcx), %ymm1
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm1 = mem[0,1,2,3],ymm1[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm1, %zmm0, %zmm24 {%k3}
; AVX512DQ-SLOW-NEXT:    movb $56, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k2
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm2 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm3, (%rsp) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm31 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm30 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm18, %zmm24 {%k2}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm2 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm3 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm4 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm7 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm6 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm29 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, %zmm17 {%k1}
; AVX512DQ-SLOW-NEXT:    movb $120, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm23 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm23 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm21 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # zmm21 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm19 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm18 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm13 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm12 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm29, %zmm10 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm17, %zmm8 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-SLOW-NEXT:    movb $-61, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, %zmm21 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm15 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # zmm15 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, %zmm15 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm11 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # zmm11 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, %zmm11 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm4 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # zmm4 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, %zmm4 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm6 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # zmm6 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm7, %zmm6 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm7 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # zmm7 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm8 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, %zmm7 {%k1}
; AVX512DQ-SLOW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm14, %zmm8 # 64-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # zmm8 = zmm14[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm9 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm9 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm9 = ymm9[1],mem[1],ymm9[3],mem[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    movb $14, %cl
; AVX512DQ-SLOW-NEXT:    kmovw %ecx, %k1
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm17 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm9 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm9 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm14 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm9 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm9 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm29 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm9 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm9 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm3 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm9 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm9 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm2 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm9 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm9 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm9 = ymm9[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm9, %zmm0, %zmm1 {%k1}
; AVX512DQ-SLOW-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX512DQ-SLOW-NEXT:    vpunpckhqdq {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX512DQ-SLOW-NEXT:    # ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,3,3]
; AVX512DQ-SLOW-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX512DQ-SLOW-NEXT:    vinserti64x4 $0, %ymm0, %zmm0, %zmm20 {%k1}
; AVX512DQ-SLOW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm8, 3008(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 2944(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm20, 2880(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 2816(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm24, 2752(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm22, 2688(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm25, 2624(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm7, 2560(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm10, 2496(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm1, 2432(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 2368(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm30, 2304(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm26, 2240(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm27, 2176(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm6, 2112(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm12, 2048(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm2, 1984(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 1920(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm31, 1856(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm28, 1792(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 1728(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm4, 1664(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm13, 1600(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm3, 1536(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 1472(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 1408(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 1344(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 1280(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm11, 1216(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm18, 1152(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm29, 1088(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 1024(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 960(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 896(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm15, 768(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm19, 704(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm14, 640(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 576(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 512(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm21, 320(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm23, 256(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm17, 192(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, (%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm5, 3520(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 3456(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 3392(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 3328(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 3264(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 3200(%rax)
; AVX512DQ-SLOW-NEXT:    vmovdqa64 %zmm16, 3072(%rax)
; AVX512DQ-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-SLOW-NEXT:    vmovaps %zmm0, 3136(%rax)
; AVX512DQ-SLOW-NEXT:    addq $6536, %rsp # imm = 0x1988
; AVX512DQ-SLOW-NEXT:    vzeroupper
; AVX512DQ-SLOW-NEXT:    retq
;
; AVX512DQ-FAST-LABEL: store_i64_stride7_vf64:
; AVX512DQ-FAST:       # %bb.0:
; AVX512DQ-FAST-NEXT:    subq $6568, %rsp # imm = 0x19A8
; AVX512DQ-FAST-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdi), %zmm7
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rdi), %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rsi), %zmm13
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rdx), %zmm18
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rcx), %zmm9
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rcx), %zmm16
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm5 = [11,3,11,3,11,3,11,3]
; AVX512DQ-FAST-NEXT:    # zmm5 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm12 = [2,10,0,3,2,10,0,3]
; AVX512DQ-FAST-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    movb $96, %r10b
; AVX512DQ-FAST-NEXT:    kmovw %r10d, %k1
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r9), %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%rax), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%rax), %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [9,1,9,1,9,1,9,1]
; AVX512DQ-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm1, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm17
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [4,9,0,3,4,9,0,3]
; AVX512DQ-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm15
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm13, %zmm5, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm8, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm9, %zmm12, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa (%r9), %ymm1
; AVX512DQ-FAST-NEXT:    vmovdqu %ymm1, (%rsp) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa 64(%r9), %ymm8
; AVX512DQ-FAST-NEXT:    vmovdqu %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 (%r8), %ymm29
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%r8), %ymm27
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm29[0],ymm1[0],ymm29[2],ymm1[2]
; AVX512DQ-FAST-NEXT:    movb $28, %r10b
; AVX512DQ-FAST-NEXT:    kmovw %r10d, %k2
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm2 {%k2} = zmm1[0,1,2,3],zmm3[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm30 = [4,12,0,5,4,12,0,5]
; AVX512DQ-FAST-NEXT:    # zmm30 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm30, %zmm1
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [0,1,12,7,0,1,12,7]
; AVX512DQ-FAST-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm2, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm9
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [5,0,14,6,5,0,14,6]
; AVX512DQ-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, %zmm23
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm1, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm22
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,13,6,7,0,13,6,7]
; AVX512DQ-FAST-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm1, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm6
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [15,7,15,7,15,7,15,7]
; AVX512DQ-FAST-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm23, %zmm25, %zmm0
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm14 = [6,13,14,7,6,13,14,7]
; AVX512DQ-FAST-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm14, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm10, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm11, %zmm5, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm12, %zmm11
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm16, %zmm12, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm27[0],ymm8[0],ymm27[2],ymm8[2]
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k2} = zmm0[0,1,2,3],zmm4[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%r8), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 64(%r9), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm17, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm15, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm30, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm9, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm22, %zmm8
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm6, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm25, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm14, %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rdi), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rsi), %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm5, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rdx), %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rcx), %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm2, %zmm12, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%rax), %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%r9), %ymm28
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%r8), %ymm23
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm0 = ymm23[0],ymm28[0],ymm23[2],ymm28[2]
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm1 {%k2} = zmm0[0,1,2,3],zmm4[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 128(%r9), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm17, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm17, %zmm7
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm15, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm30, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm9, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, %zmm17
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm22, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm6, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm25, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm14, %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rsi), %zmm16
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm16, %zmm5, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rdx), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rcx), %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm12, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%rax), %zmm5
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%r9), %ymm24
; AVX512DQ-FAST-NEXT:    vmovdqa 192(%r8), %ymm13
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm1 = ymm13[0],ymm24[0],ymm13[2],ymm24[2]
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm3 {%k2} = zmm1[0,1,2,3],zmm5[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%r8), %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 192(%r9), %zmm21
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm7, %zmm4
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm21, %zmm7, %zmm3
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm15, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm3
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm21, %zmm30, %zmm3
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm9, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm21, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm22, %zmm3
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm6, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm21, %zmm25, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm14, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 256(%rdi), %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 256(%rsi), %zmm19
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm19, %zmm10, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 256(%rdx), %zmm21
; AVX512DQ-FAST-NEXT:    vmovdqa64 256(%rcx), %zmm20
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm21, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm20, %zmm12, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 256(%rax), %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa 256(%r9), %ymm12
; AVX512DQ-FAST-NEXT:    vmovdqa64 256(%r8), %ymm22
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm22[0],ymm12[0],ymm22[2],ymm12[2]
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k2} = zmm3[0,1,2,3],zmm1[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 256(%r8), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 256(%r9), %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm2, %zmm7, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm2, %zmm9
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm15, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm15, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm9, %zmm30, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm17, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm8, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm6, %zmm15
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm6, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm9, %zmm25, %zmm3
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm14, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 320(%rdi), %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 320(%rsi), %zmm6
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm6, %zmm10, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqa64 320(%rdx), %zmm31
; AVX512DQ-FAST-NEXT:    vmovdqa64 320(%rcx), %zmm5
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm31, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm5, %zmm11, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512DQ-FAST-NEXT:    vmovdqa64 320(%rax), %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqa 320(%r9), %ymm3
; AVX512DQ-FAST-NEXT:    vmovdqa 320(%r8), %ymm1
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm4 = ymm1[0],ymm3[0],ymm1[2],ymm3[2]
; AVX512DQ-FAST-NEXT:    vshufi64x2 {{.*#+}} zmm0 {%k2} = zmm4[0,1,2,3],zmm10[2,3,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 320(%r8), %zmm4
; AVX512DQ-FAST-NEXT:    vmovdqa64 320(%r9), %zmm9
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm9, %zmm7, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm10, %zmm2, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm9, %zmm30, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm10, %zmm17, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm8, %zmm0
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm10, %zmm15, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm9, %zmm25, %zmm4
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm4, %zmm14, %zmm10
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [1,3,7,7]
; AVX512DQ-FAST-NEXT:    vpermt2q (%rsp), %ymm2, %ymm29 # 32-byte Folded Reload
; AVX512DQ-FAST-NEXT:    vmovdqu64 %ymm29, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm27 # 32-byte Folded Reload
; AVX512DQ-FAST-NEXT:    vmovdqu64 %ymm27, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %ymm28, %ymm2, %ymm23
; AVX512DQ-FAST-NEXT:    vmovdqu64 %ymm23, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %ymm24, %ymm2, %ymm13
; AVX512DQ-FAST-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %ymm12, %ymm2, %ymm22
; AVX512DQ-FAST-NEXT:    vmovdqu64 %ymm22, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %ymm3, %ymm2, %ymm1
; AVX512DQ-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa 384(%r9), %ymm0
; AVX512DQ-FAST-NEXT:    vmovdqa 384(%r8), %ymm1
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} ymm3 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %ymm0, %ymm2, %ymm1
; AVX512DQ-FAST-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [3,0,12,4,3,0,12,4]
; AVX512DQ-FAST-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm18, %zmm2
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [13,5,13,5,13,5,13,5]
; AVX512DQ-FAST-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm8, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti32x4 {{.*#+}} zmm26 = [6,14,6,14,6,14,6,14]
; AVX512DQ-FAST-NEXT:    # zmm26 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm3
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm26, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm1, %zmm25, %zmm0
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    movb $48, %r10b
; AVX512DQ-FAST-NEXT:    kmovw %r10d, %k3
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm10 = [0,8,0,1,0,8,0,1]
; AVX512DQ-FAST-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm10, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x4 {{.*#+}} zmm17 = [1,0,10,2,1,0,10,2]
; AVX512DQ-FAST-NEXT:    # zmm17 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm17, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, (%rsp) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm2 {%k3} = zmm3[0],zmm0[0],zmm3[2],zmm0[2],zmm3[4],zmm0[4],zmm3[6],zmm0[6]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm8, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x2 {{.*#+}} ymm23 = [6,14,6,14]
; AVX512DQ-FAST-NEXT:    # ymm23 = mem[0,1,0,1]
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm23, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vbroadcasti64x2 {{.*#+}} ymm28 = [15,7,15,7]
; AVX512DQ-FAST-NEXT:    # ymm28 = mem[0,1,0,1]
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm28, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm18, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm8, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm26, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm25, %zmm3
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm10, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm3, %zmm17, %zmm2
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vpunpcklqdq {{.*#+}} zmm1 {%k3} = zmm3[0],zmm0[0],zmm3[2],zmm0[2],zmm3[4],zmm0[4],zmm3[6],zmm0[6]
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1
; AVX512DQ-FAST-NEXT:    vpermt2q %zmm0, %zmm8, %zmm1
; AVX512DQ-FAST-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FAST-NEXT:    vmovdqa64 %zmm3, %zmm1