/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.daycounters;

import org.jquantlib.daycounters.AbstractDayCounter;
import org.jquantlib.util.Date;

public class Thirty360
extends AbstractDayCounter {
    private static final Thirty360 THIRTY360_US = new Thirty360(Convention.USA);
    private static final Thirty360 THIRTY360_EU = new Thirty360(Convention.EUROPEAN);
    private static final Thirty360 THIRTY360_IT = new Thirty360(Convention.ITALIAN);
    private final Thirty360Abstraction delegate;

    public static final Thirty360 getDayCounter() {
        return Thirty360.getDayCounter(Convention.BOND_BASIS);
    }

    public static final Thirty360 getDayCounter(Convention c) {
        switch (c) {
            case USA: 
            case BOND_BASIS: {
                return THIRTY360_US;
            }
            case EUROPEAN: 
            case EURO_BOND_BASIS: {
                return THIRTY360_EU;
            }
            case ITALIAN: {
                return THIRTY360_IT;
            }
        }
        throw new IllegalArgumentException();
    }

    private Thirty360(Convention c) {
        switch (c) {
            case USA: 
            case BOND_BASIS: {
                this.delegate = new US();
                break;
            }
            case EUROPEAN: 
            case EURO_BOND_BASIS: {
                this.delegate = new EU();
                break;
            }
            case ITALIAN: {
                this.delegate = new IT();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final int compute(int dd1, int dd2, int mm1, int mm2, int yy1, int yy2) {
        return 360 * (yy2 - yy1) + 30 * (mm2 - mm1 - 1) + Math.max(0, 30 - dd1) + Math.min(30, dd2);
    }

    @Override
    public final String name() {
        return this.delegate.getName();
    }

    @Override
    public final int dayCount(Date d1, Date d2) {
        int dd1 = d1.getDayOfMonth();
        int dd2 = d2.getDayOfMonth();
        int mm1 = d1.getMonth();
        int mm2 = d2.getMonth();
        int yy1 = d1.getYear();
        int yy2 = d2.getYear();
        return this.delegate.getDayCount(dd1, dd2, mm1, mm2, yy1, yy2);
    }

    @Override
    public final double yearFraction(Date dateStart, Date dateEnd, Date refPeriodStart, Date refPeriodEnd) {
        return (double)this.dayCount(dateStart, dateEnd) / 360.0;
    }

    @Override
    public final double yearFraction(Date dateStart, Date dateEnd) {
        return (double)this.dayCount(dateStart, dateEnd) / 360.0;
    }

    private final class IT
    implements Thirty360Abstraction {
        private IT() {
        }

        @Override
        public final String getName() {
            return "30/360 (Italian)";
        }

        @Override
        public final int getDayCount(int dd1, int dd2, int mm1, int mm2, int yy1, int yy2) {
            if (mm1 == 2 && dd1 > 27) {
                dd1 = 30;
            }
            if (mm2 == 2 && dd2 > 27) {
                dd2 = 30;
            }
            return Thirty360.this.compute(dd1, dd2, mm1, mm2, yy1, yy2);
        }
    }

    private final class EU
    implements Thirty360Abstraction {
        private EU() {
        }

        @Override
        public final String getName() {
            return "30E/360 (Eurobond Basis)";
        }

        @Override
        public final int getDayCount(int dd1, int dd2, int mm1, int mm2, int yy1, int yy2) {
            return Thirty360.this.compute(dd1, dd2, mm1, mm2, yy1, yy2);
        }
    }

    private final class US
    implements Thirty360Abstraction {
        private US() {
        }

        @Override
        public final String getName() {
            return "30/360 (Bond Basis)";
        }

        @Override
        public final int getDayCount(int dd1, int dd2, int mm1, int mm2, int yy1, int yy2) {
            if (dd2 == 31 && dd1 < 30) {
                dd2 = 1;
                ++mm2;
            }
            return Thirty360.this.compute(dd1, dd2, mm1, mm2, yy1, yy2);
        }
    }

    private static interface Thirty360Abstraction {
        public String getName();

        public int getDayCount(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static enum Convention {
        USA,
        BOND_BASIS,
        EUROPEAN,
        EURO_BOND_BASIS,
        ITALIAN;

    }
}

