/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.Constants;
import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.distributions.GammaFunction;

public class GammaDistribution
implements UnaryFunctionDouble {
    private double a_;

    public GammaDistribution(double a) {
        this.a_ = a;
        if (this.a_ < 0.0) {
            throw new ArithmeticException("invalid parameter for gamma distribution");
        }
    }

    @Override
    public double evaluate(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        GammaFunction gf = new GammaFunction();
        double gln = gf.logValue(this.a_);
        if (x < this.a_ + 1.0) {
            double del;
            double ap = this.a_;
            double sum = del = 1.0 / this.a_;
            for (int n = 1; n <= 100; ++n) {
                sum += (del *= x / (ap += 1.0));
                if (!(Math.abs(del) < Math.abs(sum) * 3.0E-7)) continue;
                return sum * Math.exp(-x + this.a_ * Math.log(x) - gln);
            }
        } else {
            double d;
            double b = x + 1.0 - this.a_;
            double c = Double.MAX_VALUE;
            double h = d = 1.0 / b;
            for (int n = 1; n <= 100; ++n) {
                double an = -1.0 * (double)n * ((double)n - this.a_);
                if (Math.abs(d = an * d + (b += 2.0)) < Constants.QL_EPSILON) {
                    d = Constants.QL_EPSILON;
                }
                if (Math.abs(c = b + an / c) < Constants.QL_EPSILON) {
                    c = Constants.QL_EPSILON;
                }
                d = 1.0 / d;
                double del = d * c;
                h *= del;
                if (!(Math.abs(del - 1.0) < Constants.QL_EPSILON)) continue;
                return h * Math.exp(-x + this.a_ * Math.log(x) - gln);
            }
        }
        throw new ArithmeticException("too few iterations");
    }
}

