/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.math.UnaryFunctionDouble;
import org.jquantlib.math.integrals.TrapezoidIntegral;

public class SimpsonIntegral
extends TrapezoidIntegral {
    public SimpsonIntegral(double accuracy) {
        super(accuracy);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    public SimpsonIntegral(double accuracy, int maxIterations) {
        super(accuracy, TrapezoidIntegral.Method.Default, maxIterations);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    @Override
    protected TrapezoidIntegral.Method getMethod() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double integrate(UnaryFunctionDouble f, double a, double b) {
        double I;
        int N = 1;
        double adjI = I = (f.evaluate(a) + f.evaluate(b)) * (b - a) / 2.0;
        int i = 1;
        do {
            double newI = this.defaultIteration(f, a, b, I, N);
            N *= 2;
            double newAdjI = (4.0 * newI - I) / 3.0;
            if (Math.abs(adjI - newAdjI) <= this.getAbsoluteAccuracy() && i > 5) {
                return newAdjI;
            }
            I = newI;
            adjI = newAdjI;
        } while (++i < this.getMaxEvaluations());
        throw new ArithmeticException("max number of iterations reached");
    }
}

