/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import java.util.List;
import org.jquantlib.math.Array;
import org.jquantlib.methods.finitedifferences.BoundaryCondition;
import org.jquantlib.methods.finitedifferences.Operator;

public class MixedScheme<T extends Operator> {
    private T L;
    private T I;
    private T explicitPart;
    private T implicitPart;
    private double dt;
    private double theta;
    private List<BoundaryCondition<T>> bcs;

    public MixedScheme(T op, double theta, List<BoundaryCondition<T>> bcs2) {
        this.L = op;
        this.I = op.identity(op.size());
        this.theta = theta;
        this.bcs = bcs2;
    }

    public Array step(Array a, double t) {
        int i;
        for (i = 0; i < this.bcs.size(); ++i) {
            this.bcs.get(i).setTime(t);
        }
        if (this.theta != 1.0) {
            if (this.L.isTimeDependent()) {
                this.L.setTime(t);
                this.explicitPart = this.I.subtract(this.L.multiply((1.0 - this.theta) * this.dt));
            }
            for (i = 0; i < this.bcs.size(); ++i) {
                this.bcs.get(i).applyBeforeApplying(this.explicitPart);
            }
            a = this.explicitPart.applyTo(a);
            for (i = 0; i < this.bcs.size(); ++i) {
                this.bcs.get(i).applyAfterApplying(a);
            }
        }
        if (this.theta != 0.0) {
            if (this.L.isTimeDependent()) {
                this.L.setTime(t - this.dt);
                this.implicitPart = this.I.add(this.L.multiply(this.theta * this.dt));
            }
            for (i = 0; i < this.bcs.size(); ++i) {
                this.bcs.get(i).applyBeforeSolving(this.implicitPart, a);
            }
            a = this.implicitPart.solveFor(a);
            for (i = 0; i < this.bcs.size(); ++i) {
                this.bcs.get(i).applyAfterSolving(a);
            }
        }
        return a;
    }

    public void setStep(double dt) {
        this.dt = dt;
        if (this.theta != 1.0) {
            this.explicitPart = this.I.subtract(this.L.multiply((1.0 - this.theta) * dt));
        }
        if (this.theta != 0.0) {
            this.implicitPart = this.I.add(this.L.multiply(this.theta * dt));
        }
    }
}

