/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PeriodParser {
    private static final Logger logger = LoggerFactory.getLogger(PeriodParser.class);

    public static Period parse(String str) {
        TimeUnit units = null;
        int index = -1;
        index = str.indexOf(100);
        if (index > 0 || (index = str.indexOf(68)) > 0) {
            units = TimeUnit.DAYS;
            PeriodParser.enforceUnit(index, str, units);
        } else {
            index = str.indexOf(119);
            if (index > 0 || (index = str.indexOf(87)) > 0) {
                units = TimeUnit.WEEKS;
                PeriodParser.enforceUnit(index, str, units);
            } else {
                index = str.indexOf(109);
                if (index > 0 || (index = str.indexOf(77)) > 0) {
                    units = TimeUnit.MONTHS;
                    PeriodParser.enforceUnit(index, str, units);
                } else {
                    index = str.indexOf(121);
                    if (index > 0 || (index = str.indexOf(89)) > 0) {
                        units = TimeUnit.YEARS;
                        PeriodParser.enforceUnit(index, str, units);
                    }
                }
            }
        }
        String length = str.substring(0, index).trim();
        return new Period(Integer.parseInt(length), units);
    }

    private static void enforceUnit(int index, String str, TimeUnit units) {
        String unitStr = str.substring(index);
        if (unitStr.length() == 0) {
            return;
        }
        if (!unitStr.equalsIgnoreCase(units.toString())) {
            throw new IllegalStateException("Unable to convert to period :" + str);
        }
    }
}

