/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;
import org.apache.cxf.jaxrs.sse.SseEventSinkImpl;

public class SseBroadcasterImpl
implements SseBroadcaster {
    private final Set<SseEventSink> subscribers = new CopyOnWriteArraySet<SseEventSink>();
    private final Set<Consumer<SseEventSink>> closers = new CopyOnWriteArraySet<Consumer<SseEventSink>>();
    private final Set<BiConsumer<SseEventSink, Throwable>> exceptioners = new CopyOnWriteArraySet<BiConsumer<SseEventSink, Throwable>>();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public void register(final SseEventSink sink) {
        this.assertNotClosed();
        SseEventSinkImpl sinkImpl = (SseEventSinkImpl)sink;
        AsyncContext ctx = sinkImpl.getAsyncContext();
        ctx.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent asyncEvent) throws IOException {
                SseBroadcasterImpl.this.subscribers.remove(sink);
            }

            public void onTimeout(AsyncEvent asyncEvent) throws IOException {
                SseBroadcasterImpl.this.subscribers.remove(sink);
            }

            public void onError(AsyncEvent asyncEvent) throws IOException {
                SseBroadcasterImpl.this.subscribers.remove(sink);
            }

            public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
            }
        });
        this.subscribers.add(sink);
    }

    public CompletionStage<?> broadcast(OutboundSseEvent event) {
        this.assertNotClosed();
        ArrayList futures = new ArrayList();
        for (SseEventSink sink : this.subscribers) {
            try {
                futures.add(sink.send(event).toCompletableFuture());
            }
            catch (Exception ex) {
                this.exceptioners.forEach(exceptioner -> exceptioner.accept(sink, ex));
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public void onClose(Consumer<SseEventSink> subscriber) {
        this.assertNotClosed();
        this.closers.add(subscriber);
    }

    public void onError(BiConsumer<SseEventSink, Throwable> exceptioner) {
        this.assertNotClosed();
        this.exceptioners.add(exceptioner);
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.subscribers.forEach(subscriber -> {
                subscriber.close();
                this.closers.forEach(closer -> closer.accept(subscriber));
            });
        }
    }

    private void assertNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("The SSE broadcaster is already closed");
        }
    }
}

