/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import org.jboss.resteasy.cdi.i18n.LogMessages;
import org.jboss.resteasy.cdi.i18n.Messages;
import org.jboss.resteasy.core.PropertyInjectorImpl;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;
import org.jboss.resteasy.util.GetRestful;

public class JaxrsInjectionTarget<T>
implements InjectionTarget<T> {
    private InjectionTarget<T> delegate;
    private Class<T> clazz;
    private PropertyInjector propertyInjector;
    private GeneralValidatorCDI validator;

    public JaxrsInjectionTarget(InjectionTarget<T> delegate, Class<T> clazz) {
        this.delegate = delegate;
        this.clazz = clazz;
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        this.delegate.inject(instance, ctx);
        if (this.propertyInjector == null) {
            this.propertyInjector = this.getPropertyInjector();
        }
        HttpRequest request = (HttpRequest)ResteasyContext.getContextData(HttpRequest.class);
        HttpResponse response = (HttpResponse)ResteasyContext.getContextData(HttpResponse.class);
        if (request != null && response != null) {
            this.propertyInjector.inject(request, response, instance, false);
        } else {
            this.propertyInjector.inject(instance, false);
        }
        if (request != null) {
            this.validate(request, instance);
        } else {
            LogMessages.LOGGER.debug(Messages.MESSAGES.skippingValidationOutsideResteasyContext());
        }
    }

    public void postConstruct(T instance) {
        this.delegate.postConstruct(instance);
    }

    public void preDestroy(T instance) {
        this.delegate.preDestroy(instance);
    }

    public void dispose(T instance) {
        this.delegate.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.delegate.getInjectionPoints();
    }

    public T produce(CreationalContext<T> ctx) {
        return (T)this.delegate.produce(ctx);
    }

    private PropertyInjector getPropertyInjector() {
        return new PropertyInjectorImpl(this.clazz, ResteasyProviderFactory.getInstance());
    }

    private void validate(HttpRequest request, T instance) {
        if (GetRestful.isRootResource(this.clazz)) {
            ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
            ContextResolver resolver = providerFactory.getContextResolver(GeneralValidatorCDI.class, MediaType.WILDCARD_TYPE);
            if (resolver != null) {
                this.validator = (GeneralValidatorCDI)providerFactory.getContextResolver(GeneralValidatorCDI.class, MediaType.WILDCARD_TYPE).getContext(null);
            }
            if (this.validator != null && this.validator.isValidatableFromCDI(this.clazz)) {
                this.validator.validate(request, instance, new Class[0]);
                this.validator.checkViolationsfromCDI(request);
            }
        }
    }
}

